// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.glue.JobArgs;
import com.pulumi.aws.glue.inputs.JobState;
import com.pulumi.aws.glue.outputs.JobCommand;
import com.pulumi.aws.glue.outputs.JobExecutionProperty;
import com.pulumi.aws.glue.outputs.JobNotificationProperty;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Double;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Glue Job resource.
 * 
 * &gt; Glue functionality, such as monitoring and logging of jobs, is typically managed with the `default_arguments` argument. See the [Special Parameters Used by AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html) topic in the Glue developer guide for additional information.
 * 
 * ## Example Usage
 * ### Python Job
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Job(&#34;example&#34;, JobArgs.builder()        
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format(&#34;s3://%s/example.py&#34;, aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Ray Job
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Job(&#34;example&#34;, JobArgs.builder()        
 *             .roleArn(aws_iam_role.example().arn())
 *             .glueVersion(&#34;4.0&#34;)
 *             .workerType(&#34;Z.2X&#34;)
 *             .command(JobCommandArgs.builder()
 *                 .name(&#34;glueray&#34;)
 *                 .pythonVersion(&#34;3.9&#34;)
 *                 .runtime(&#34;Ray2.4&#34;)
 *                 .scriptLocation(String.format(&#34;s3://%s/example.py&#34;, aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Scala Job
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Job(&#34;example&#34;, JobArgs.builder()        
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format(&#34;s3://%s/example.scala&#34;, aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .defaultArguments(Map.of(&#34;--job-language&#34;, &#34;scala&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Streaming Job
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Job(&#34;example&#34;, JobArgs.builder()        
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .name(&#34;gluestreaming&#34;)
 *                 .scriptLocation(String.format(&#34;s3://%s/example.script&#34;, aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Enabling CloudWatch Logs and Metrics
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup(&#34;exampleLogGroup&#34;, LogGroupArgs.builder()        
 *             .retentionInDays(14)
 *             .build());
 * 
 *         var exampleJob = new Job(&#34;exampleJob&#34;, JobArgs.builder()        
 *             .defaultArguments(Map.ofEntries(
 *                 Map.entry(&#34;--continuous-log-logGroup&#34;, exampleLogGroup.name()),
 *                 Map.entry(&#34;--enable-continuous-cloudwatch-log&#34;, &#34;true&#34;),
 *                 Map.entry(&#34;--enable-continuous-log-filter&#34;, &#34;true&#34;),
 *                 Map.entry(&#34;--enable-metrics&#34;, &#34;&#34;)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Glue Jobs using `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:glue/job:Job MyJob MyJob
 * ```
 * 
 */
@ResourceType(type="aws:glue/job:Job")
public class Job extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of Glue Job
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of Glue Job
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The command of the job. Defined below.
     * 
     */
    @Export(name="command", refs={JobCommand.class}, tree="[0]")
    private Output<JobCommand> command;

    /**
     * @return The command of the job. Defined below.
     * 
     */
    public Output<JobCommand> command() {
        return this.command;
    }
    /**
     * The list of connections used for this job.
     * 
     */
    @Export(name="connections", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> connections;

    /**
     * @return The list of connections used for this job.
     * 
     */
    public Output<Optional<List<String>>> connections() {
        return Codegen.optional(this.connections);
    }
    /**
     * The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     * 
     */
    @Export(name="defaultArguments", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> defaultArguments;

    /**
     * @return The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     * 
     */
    public Output<Optional<Map<String,String>>> defaultArguments() {
        return Codegen.optional(this.defaultArguments);
    }
    /**
     * Description of the job.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the job.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
     * 
     */
    @Export(name="executionClass", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> executionClass;

    /**
     * @return Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
     * 
     */
    public Output<Optional<String>> executionClass() {
        return Codegen.optional(this.executionClass);
    }
    /**
     * Execution property of the job. Defined below.
     * 
     */
    @Export(name="executionProperty", refs={JobExecutionProperty.class}, tree="[0]")
    private Output<JobExecutionProperty> executionProperty;

    /**
     * @return Execution property of the job. Defined below.
     * 
     */
    public Output<JobExecutionProperty> executionProperty() {
        return this.executionProperty;
    }
    /**
     * The version of glue to use, for example &#34;1.0&#34;. Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     * 
     */
    @Export(name="glueVersion", refs={String.class}, tree="[0]")
    private Output<String> glueVersion;

    /**
     * @return The version of glue to use, for example &#34;1.0&#34;. Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     * 
     */
    public Output<String> glueVersion() {
        return this.glueVersion;
    }
    /**
     * The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
     * 
     */
    @Export(name="maxCapacity", refs={Double.class}, tree="[0]")
    private Output<Double> maxCapacity;

    /**
     * @return The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
     * 
     */
    public Output<Double> maxCapacity() {
        return this.maxCapacity;
    }
    /**
     * The maximum number of times to retry this job if it fails.
     * 
     */
    @Export(name="maxRetries", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> maxRetries;

    /**
     * @return The maximum number of times to retry this job if it fails.
     * 
     */
    public Output<Optional<Integer>> maxRetries() {
        return Codegen.optional(this.maxRetries);
    }
    /**
     * The name you assign to this job. It must be unique in your account.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name you assign to this job. It must be unique in your account.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Non-overridable arguments for this job, specified as name-value pairs.
     * 
     */
    @Export(name="nonOverridableArguments", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> nonOverridableArguments;

    /**
     * @return Non-overridable arguments for this job, specified as name-value pairs.
     * 
     */
    public Output<Optional<Map<String,String>>> nonOverridableArguments() {
        return Codegen.optional(this.nonOverridableArguments);
    }
    /**
     * Notification property of the job. Defined below.
     * 
     */
    @Export(name="notificationProperty", refs={JobNotificationProperty.class}, tree="[0]")
    private Output<JobNotificationProperty> notificationProperty;

    /**
     * @return Notification property of the job. Defined below.
     * 
     */
    public Output<JobNotificationProperty> notificationProperty() {
        return this.notificationProperty;
    }
    /**
     * The number of workers of a defined workerType that are allocated when a job runs.
     * 
     */
    @Export(name="numberOfWorkers", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> numberOfWorkers;

    /**
     * @return The number of workers of a defined workerType that are allocated when a job runs.
     * 
     */
    public Output<Optional<Integer>> numberOfWorkers() {
        return Codegen.optional(this.numberOfWorkers);
    }
    /**
     * The ARN of the IAM role associated with this job.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return The ARN of the IAM role associated with this job.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }
    /**
     * The name of the Security Configuration to be associated with the job.
     * 
     */
    @Export(name="securityConfiguration", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> securityConfiguration;

    /**
     * @return The name of the Security Configuration to be associated with the job.
     * 
     */
    public Output<Optional<String>> securityConfiguration() {
        return Codegen.optional(this.securityConfiguration);
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
     * 
     */
    @Export(name="timeout", refs={Integer.class}, tree="[0]")
    private Output<Integer> timeout;

    /**
     * @return The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
     * 
     */
    public Output<Integer> timeout() {
        return this.timeout;
    }
    /**
     * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
     * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
     * 
     */
    @Export(name="workerType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> workerType;

    /**
     * @return The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
     * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
     * 
     */
    public Output<Optional<String>> workerType() {
        return Codegen.optional(this.workerType);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Job(String name) {
        this(name, JobArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Job(String name, JobArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Job(String name, JobArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/job:Job", name, args == null ? JobArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Job(String name, Output<String> id, @Nullable JobState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/job:Job", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Job get(String name, Output<String> id, @Nullable JobState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Job(name, id, state, options);
    }
}
