// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DevEndpointArgs extends com.pulumi.resources.ResourceArgs {

    public static final DevEndpointArgs Empty = new DevEndpointArgs();

    /**
     * A map of arguments used to configure the endpoint.
     * 
     */
    @Import(name="arguments")
    private @Nullable Output<Map<String,String>> arguments;

    /**
     * @return A map of arguments used to configure the endpoint.
     * 
     */
    public Optional<Output<Map<String,String>>> arguments() {
        return Optional.ofNullable(this.arguments);
    }

    /**
     * Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     * 
     */
    @Import(name="extraJarsS3Path")
    private @Nullable Output<String> extraJarsS3Path;

    /**
     * @return Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     * 
     */
    public Optional<Output<String>> extraJarsS3Path() {
        return Optional.ofNullable(this.extraJarsS3Path);
    }

    /**
     * Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     * 
     */
    @Import(name="extraPythonLibsS3Path")
    private @Nullable Output<String> extraPythonLibsS3Path;

    /**
     * @return Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     * 
     */
    public Optional<Output<String>> extraPythonLibsS3Path() {
        return Optional.ofNullable(this.extraPythonLibsS3Path);
    }

    /**
     * Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     * 
     */
    @Import(name="glueVersion")
    private @Nullable Output<String> glueVersion;

    /**
     * @return Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     * 
     */
    public Optional<Output<String>> glueVersion() {
        return Optional.ofNullable(this.glueVersion);
    }

    /**
     * The name of this endpoint. It must be unique in your account.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of this endpoint. It must be unique in your account.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     * 
     */
    @Import(name="numberOfNodes")
    private @Nullable Output<Integer> numberOfNodes;

    /**
     * @return The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     * 
     */
    public Optional<Output<Integer>> numberOfNodes() {
        return Optional.ofNullable(this.numberOfNodes);
    }

    /**
     * The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     * 
     */
    @Import(name="numberOfWorkers")
    private @Nullable Output<Integer> numberOfWorkers;

    /**
     * @return The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     * 
     */
    public Optional<Output<Integer>> numberOfWorkers() {
        return Optional.ofNullable(this.numberOfWorkers);
    }

    /**
     * The public key to be used by this endpoint for authentication.
     * 
     */
    @Import(name="publicKey")
    private @Nullable Output<String> publicKey;

    /**
     * @return The public key to be used by this endpoint for authentication.
     * 
     */
    public Optional<Output<String>> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    /**
     * A list of public keys to be used by this endpoint for authentication.
     * 
     */
    @Import(name="publicKeys")
    private @Nullable Output<List<String>> publicKeys;

    /**
     * @return A list of public keys to be used by this endpoint for authentication.
     * 
     */
    public Optional<Output<List<String>>> publicKeys() {
        return Optional.ofNullable(this.publicKeys);
    }

    /**
     * The IAM role for this endpoint.
     * 
     */
    @Import(name="roleArn", required=true)
    private Output<String> roleArn;

    /**
     * @return The IAM role for this endpoint.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     * The name of the Security Configuration structure to be used with this endpoint.
     * 
     */
    @Import(name="securityConfiguration")
    private @Nullable Output<String> securityConfiguration;

    /**
     * @return The name of the Security Configuration structure to be used with this endpoint.
     * 
     */
    public Optional<Output<String>> securityConfiguration() {
        return Optional.ofNullable(this.securityConfiguration);
    }

    /**
     * Security group IDs for the security groups to be used by this endpoint.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return Security group IDs for the security groups to be used by this endpoint.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * The subnet ID for the new endpoint to use.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return The subnet ID for the new endpoint to use.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     * 
     */
    @Import(name="workerType")
    private @Nullable Output<String> workerType;

    /**
     * @return The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     * 
     */
    public Optional<Output<String>> workerType() {
        return Optional.ofNullable(this.workerType);
    }

    private DevEndpointArgs() {}

    private DevEndpointArgs(DevEndpointArgs $) {
        this.arguments = $.arguments;
        this.extraJarsS3Path = $.extraJarsS3Path;
        this.extraPythonLibsS3Path = $.extraPythonLibsS3Path;
        this.glueVersion = $.glueVersion;
        this.name = $.name;
        this.numberOfNodes = $.numberOfNodes;
        this.numberOfWorkers = $.numberOfWorkers;
        this.publicKey = $.publicKey;
        this.publicKeys = $.publicKeys;
        this.roleArn = $.roleArn;
        this.securityConfiguration = $.securityConfiguration;
        this.securityGroupIds = $.securityGroupIds;
        this.subnetId = $.subnetId;
        this.tags = $.tags;
        this.workerType = $.workerType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DevEndpointArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DevEndpointArgs $;

        public Builder() {
            $ = new DevEndpointArgs();
        }

        public Builder(DevEndpointArgs defaults) {
            $ = new DevEndpointArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param arguments A map of arguments used to configure the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arguments(@Nullable Output<Map<String,String>> arguments) {
            $.arguments = arguments;
            return this;
        }

        /**
         * @param arguments A map of arguments used to configure the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arguments(Map<String,String> arguments) {
            return arguments(Output.of(arguments));
        }

        /**
         * @param extraJarsS3Path Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder extraJarsS3Path(@Nullable Output<String> extraJarsS3Path) {
            $.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        /**
         * @param extraJarsS3Path Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder extraJarsS3Path(String extraJarsS3Path) {
            return extraJarsS3Path(Output.of(extraJarsS3Path));
        }

        /**
         * @param extraPythonLibsS3Path Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
         * 
         * @return builder
         * 
         */
        public Builder extraPythonLibsS3Path(@Nullable Output<String> extraPythonLibsS3Path) {
            $.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        /**
         * @param extraPythonLibsS3Path Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
         * 
         * @return builder
         * 
         */
        public Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            return extraPythonLibsS3Path(Output.of(extraPythonLibsS3Path));
        }

        /**
         * @param glueVersion Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
         * 
         * @return builder
         * 
         */
        public Builder glueVersion(@Nullable Output<String> glueVersion) {
            $.glueVersion = glueVersion;
            return this;
        }

        /**
         * @param glueVersion Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
         * 
         * @return builder
         * 
         */
        public Builder glueVersion(String glueVersion) {
            return glueVersion(Output.of(glueVersion));
        }

        /**
         * @param name The name of this endpoint. It must be unique in your account.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of this endpoint. It must be unique in your account.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param numberOfNodes The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
         * 
         * @return builder
         * 
         */
        public Builder numberOfNodes(@Nullable Output<Integer> numberOfNodes) {
            $.numberOfNodes = numberOfNodes;
            return this;
        }

        /**
         * @param numberOfNodes The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
         * 
         * @return builder
         * 
         */
        public Builder numberOfNodes(Integer numberOfNodes) {
            return numberOfNodes(Output.of(numberOfNodes));
        }

        /**
         * @param numberOfWorkers The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
         * 
         * @return builder
         * 
         */
        public Builder numberOfWorkers(@Nullable Output<Integer> numberOfWorkers) {
            $.numberOfWorkers = numberOfWorkers;
            return this;
        }

        /**
         * @param numberOfWorkers The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
         * 
         * @return builder
         * 
         */
        public Builder numberOfWorkers(Integer numberOfWorkers) {
            return numberOfWorkers(Output.of(numberOfWorkers));
        }

        /**
         * @param publicKey The public key to be used by this endpoint for authentication.
         * 
         * @return builder
         * 
         */
        public Builder publicKey(@Nullable Output<String> publicKey) {
            $.publicKey = publicKey;
            return this;
        }

        /**
         * @param publicKey The public key to be used by this endpoint for authentication.
         * 
         * @return builder
         * 
         */
        public Builder publicKey(String publicKey) {
            return publicKey(Output.of(publicKey));
        }

        /**
         * @param publicKeys A list of public keys to be used by this endpoint for authentication.
         * 
         * @return builder
         * 
         */
        public Builder publicKeys(@Nullable Output<List<String>> publicKeys) {
            $.publicKeys = publicKeys;
            return this;
        }

        /**
         * @param publicKeys A list of public keys to be used by this endpoint for authentication.
         * 
         * @return builder
         * 
         */
        public Builder publicKeys(List<String> publicKeys) {
            return publicKeys(Output.of(publicKeys));
        }

        /**
         * @param publicKeys A list of public keys to be used by this endpoint for authentication.
         * 
         * @return builder
         * 
         */
        public Builder publicKeys(String... publicKeys) {
            return publicKeys(List.of(publicKeys));
        }

        /**
         * @param roleArn The IAM role for this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn The IAM role for this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param securityConfiguration The name of the Security Configuration structure to be used with this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder securityConfiguration(@Nullable Output<String> securityConfiguration) {
            $.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * @param securityConfiguration The name of the Security Configuration structure to be used with this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder securityConfiguration(String securityConfiguration) {
            return securityConfiguration(Output.of(securityConfiguration));
        }

        /**
         * @param securityGroupIds Security group IDs for the security groups to be used by this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds Security group IDs for the security groups to be used by this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds Security group IDs for the security groups to be used by this endpoint.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param subnetId The subnet ID for the new endpoint to use.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId The subnet ID for the new endpoint to use.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param workerType The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
         * 
         * @return builder
         * 
         */
        public Builder workerType(@Nullable Output<String> workerType) {
            $.workerType = workerType;
            return this;
        }

        /**
         * @param workerType The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
         * 
         * @return builder
         * 
         */
        public Builder workerType(String workerType) {
            return workerType(Output.of(workerType));
        }

        public DevEndpointArgs build() {
            $.roleArn = Objects.requireNonNull($.roleArn, "expected parameter 'roleArn' to be non-null");
            return $;
        }
    }

}
