// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.glue.DataQualityRulesetArgs;
import com.pulumi.aws.glue.inputs.DataQualityRulesetState;
import com.pulumi.aws.glue.outputs.DataQualityRulesetTargetTable;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Glue Data Quality Ruleset Resource. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/glue-data-quality.html) for a full explanation of the Glue Data Quality Ruleset functionality
 * 
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset(&#34;example&#34;, DataQualityRulesetArgs.builder()        
 *             .ruleset(&#34;Rules = [Completeness \&#34;colA\&#34; between 0.4 and 0.8]&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With description
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset(&#34;example&#34;, DataQualityRulesetArgs.builder()        
 *             .description(&#34;example&#34;)
 *             .ruleset(&#34;Rules = [Completeness \&#34;colA\&#34; between 0.4 and 0.8]&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With tags
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset(&#34;example&#34;, DataQualityRulesetArgs.builder()        
 *             .ruleset(&#34;Rules = [Completeness \&#34;colA\&#34; between 0.4 and 0.8]&#34;)
 *             .tags(Map.of(&#34;hello&#34;, &#34;world&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With target_table
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset(&#34;example&#34;, DataQualityRulesetArgs.builder()        
 *             .ruleset(&#34;Rules = [Completeness \&#34;colA\&#34; between 0.4 and 0.8]&#34;)
 *             .targetTable(DataQualityRulesetTargetTableArgs.builder()
 *                 .databaseName(aws_glue_catalog_database.example().name())
 *                 .tableName(aws_glue_catalog_table.example().name())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Glue Data Quality Ruleset using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:glue/dataQualityRuleset:DataQualityRuleset example exampleName
 * ```
 * 
 */
@ResourceType(type="aws:glue/dataQualityRuleset:DataQualityRuleset")
public class DataQualityRuleset extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Glue Data Quality Ruleset.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Glue Data Quality Ruleset.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The time and date that this data quality ruleset was created.
     * 
     */
    @Export(name="createdOn", refs={String.class}, tree="[0]")
    private Output<String> createdOn;

    /**
     * @return The time and date that this data quality ruleset was created.
     * 
     */
    public Output<String> createdOn() {
        return this.createdOn;
    }
    /**
     * Description of the data quality ruleset.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the data quality ruleset.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The time and date that this data quality ruleset was created.
     * 
     */
    @Export(name="lastModifiedOn", refs={String.class}, tree="[0]")
    private Output<String> lastModifiedOn;

    /**
     * @return The time and date that this data quality ruleset was created.
     * 
     */
    public Output<String> lastModifiedOn() {
        return this.lastModifiedOn;
    }
    /**
     * Name of the data quality ruleset.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the data quality ruleset.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
     * 
     */
    @Export(name="recommendationRunId", refs={String.class}, tree="[0]")
    private Output<String> recommendationRunId;

    /**
     * @return When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
     * 
     */
    public Output<String> recommendationRunId() {
        return this.recommendationRunId;
    }
    /**
     * A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     * 
     */
    @Export(name="ruleset", refs={String.class}, tree="[0]")
    private Output<String> ruleset;

    /**
     * @return A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     * 
     */
    public Output<String> ruleset() {
        return this.ruleset;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     * 
     */
    @Export(name="targetTable", refs={DataQualityRulesetTargetTable.class}, tree="[0]")
    private Output</* @Nullable */ DataQualityRulesetTargetTable> targetTable;

    /**
     * @return A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     * 
     */
    public Output<Optional<DataQualityRulesetTargetTable>> targetTable() {
        return Codegen.optional(this.targetTable);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DataQualityRuleset(String name) {
        this(name, DataQualityRulesetArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DataQualityRuleset(String name, DataQualityRulesetArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DataQualityRuleset(String name, DataQualityRulesetArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/dataQualityRuleset:DataQualityRuleset", name, args == null ? DataQualityRulesetArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DataQualityRuleset(String name, Output<String> id, @Nullable DataQualityRulesetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/dataQualityRuleset:DataQualityRuleset", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DataQualityRuleset get(String name, Output<String> id, @Nullable DataQualityRulesetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DataQualityRuleset(name, id, state, options);
    }
}
