// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.glue.ClassifierArgs;
import com.pulumi.aws.glue.inputs.ClassifierState;
import com.pulumi.aws.glue.outputs.ClassifierCsvClassifier;
import com.pulumi.aws.glue.outputs.ClassifierGrokClassifier;
import com.pulumi.aws.glue.outputs.ClassifierJsonClassifier;
import com.pulumi.aws.glue.outputs.ClassifierXmlClassifier;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Glue Classifier resource.
 * 
 * &gt; **NOTE:** It is only valid to create one type of classifier (csv, grok, JSON, or XML). Changing classifier types will recreate the classifier.
 * 
 * ## Example Usage
 * ### Csv Classifier
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Classifier(&#34;example&#34;, ClassifierArgs.builder()        
 *             .csvClassifier(ClassifierCsvClassifierArgs.builder()
 *                 .allowSingleColumn(false)
 *                 .containsHeader(&#34;PRESENT&#34;)
 *                 .delimiter(&#34;,&#34;)
 *                 .disableValueTrimming(false)
 *                 .headers(                
 *                     &#34;example1&#34;,
 *                     &#34;example2&#34;)
 *                 .quoteSymbol(&#34;&#39;&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Grok Classifier
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Classifier(&#34;example&#34;, ClassifierArgs.builder()        
 *             .grokClassifier(ClassifierGrokClassifierArgs.builder()
 *                 .classification(&#34;example&#34;)
 *                 .grokPattern(&#34;example&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### JSON Classifier
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Classifier(&#34;example&#34;, ClassifierArgs.builder()        
 *             .jsonClassifier(ClassifierJsonClassifierArgs.builder()
 *                 .jsonPath(&#34;example&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### XML Classifier
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Classifier(&#34;example&#34;, ClassifierArgs.builder()        
 *             .xmlClassifier(ClassifierXmlClassifierArgs.builder()
 *                 .classification(&#34;example&#34;)
 *                 .rowTag(&#34;example&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Glue Classifiers using their name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:glue/classifier:Classifier MyClassifier MyClassifier
 * ```
 * 
 */
@ResourceType(type="aws:glue/classifier:Classifier")
public class Classifier extends com.pulumi.resources.CustomResource {
    /**
     * A classifier for Csv content. Defined below.
     * 
     */
    @Export(name="csvClassifier", refs={ClassifierCsvClassifier.class}, tree="[0]")
    private Output</* @Nullable */ ClassifierCsvClassifier> csvClassifier;

    /**
     * @return A classifier for Csv content. Defined below.
     * 
     */
    public Output<Optional<ClassifierCsvClassifier>> csvClassifier() {
        return Codegen.optional(this.csvClassifier);
    }
    /**
     * A classifier that uses grok patterns. Defined below.
     * 
     */
    @Export(name="grokClassifier", refs={ClassifierGrokClassifier.class}, tree="[0]")
    private Output</* @Nullable */ ClassifierGrokClassifier> grokClassifier;

    /**
     * @return A classifier that uses grok patterns. Defined below.
     * 
     */
    public Output<Optional<ClassifierGrokClassifier>> grokClassifier() {
        return Codegen.optional(this.grokClassifier);
    }
    /**
     * A classifier for JSON content. Defined below.
     * 
     */
    @Export(name="jsonClassifier", refs={ClassifierJsonClassifier.class}, tree="[0]")
    private Output</* @Nullable */ ClassifierJsonClassifier> jsonClassifier;

    /**
     * @return A classifier for JSON content. Defined below.
     * 
     */
    public Output<Optional<ClassifierJsonClassifier>> jsonClassifier() {
        return Codegen.optional(this.jsonClassifier);
    }
    /**
     * The name of the classifier.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the classifier.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A classifier for XML content. Defined below.
     * 
     */
    @Export(name="xmlClassifier", refs={ClassifierXmlClassifier.class}, tree="[0]")
    private Output</* @Nullable */ ClassifierXmlClassifier> xmlClassifier;

    /**
     * @return A classifier for XML content. Defined below.
     * 
     */
    public Output<Optional<ClassifierXmlClassifier>> xmlClassifier() {
        return Codegen.optional(this.xmlClassifier);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Classifier(String name) {
        this(name, ClassifierArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Classifier(String name, @Nullable ClassifierArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Classifier(String name, @Nullable ClassifierArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/classifier:Classifier", name, args == null ? ClassifierArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Classifier(String name, Output<String> id, @Nullable ClassifierState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/classifier:Classifier", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Classifier get(String name, Output<String> id, @Nullable ClassifierState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Classifier(name, id, state, options);
    }
}
