// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputArgs;
import com.pulumi.aws.glue.inputs.CatalogTablePartitionIndexArgs;
import com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs;
import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
import com.pulumi.aws.glue.inputs.CatalogTableTargetTableArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CatalogTableArgs extends com.pulumi.resources.ResourceArgs {

    public static final CatalogTableArgs Empty = new CatalogTableArgs();

    /**
     * ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     * 
     */
    @Import(name="catalogId")
    private @Nullable Output<String> catalogId;

    /**
     * @return ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     * 
     */
    public Optional<Output<String>> catalogId() {
        return Optional.ofNullable(this.catalogId);
    }

    /**
     * Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * 
     * The follow arguments are optional:
     * 
     */
    @Import(name="databaseName", required=true)
    private Output<String> databaseName;

    /**
     * @return Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * 
     * The follow arguments are optional:
     * 
     */
    public Output<String> databaseName() {
        return this.databaseName;
    }

    /**
     * Description of the table.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the table.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Name of the table. For Hive compatibility, this must be entirely lowercase.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the table. For Hive compatibility, this must be entirely lowercase.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Configuration block for open table formats. See `open_table_format_input` below.
     * 
     */
    @Import(name="openTableFormatInput")
    private @Nullable Output<CatalogTableOpenTableFormatInputArgs> openTableFormatInput;

    /**
     * @return Configuration block for open table formats. See `open_table_format_input` below.
     * 
     */
    public Optional<Output<CatalogTableOpenTableFormatInputArgs>> openTableFormatInput() {
        return Optional.ofNullable(this.openTableFormatInput);
    }

    /**
     * Owner of the table.
     * 
     */
    @Import(name="owner")
    private @Nullable Output<String> owner;

    /**
     * @return Owner of the table.
     * 
     */
    public Optional<Output<String>> owner() {
        return Optional.ofNullable(this.owner);
    }

    /**
     * Properties associated with this table, as a list of key-value pairs.
     * 
     */
    @Import(name="parameters")
    private @Nullable Output<Map<String,String>> parameters;

    /**
     * @return Properties associated with this table, as a list of key-value pairs.
     * 
     */
    public Optional<Output<Map<String,String>>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    /**
     * Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     * 
     */
    @Import(name="partitionIndices")
    private @Nullable Output<List<CatalogTablePartitionIndexArgs>> partitionIndices;

    /**
     * @return Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     * 
     */
    public Optional<Output<List<CatalogTablePartitionIndexArgs>>> partitionIndices() {
        return Optional.ofNullable(this.partitionIndices);
    }

    /**
     * Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     * 
     */
    @Import(name="partitionKeys")
    private @Nullable Output<List<CatalogTablePartitionKeyArgs>> partitionKeys;

    /**
     * @return Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     * 
     */
    public Optional<Output<List<CatalogTablePartitionKeyArgs>>> partitionKeys() {
        return Optional.ofNullable(this.partitionKeys);
    }

    /**
     * Retention time for this table.
     * 
     */
    @Import(name="retention")
    private @Nullable Output<Integer> retention;

    /**
     * @return Retention time for this table.
     * 
     */
    public Optional<Output<Integer>> retention() {
        return Optional.ofNullable(this.retention);
    }

    /**
     * Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     * 
     */
    @Import(name="storageDescriptor")
    private @Nullable Output<CatalogTableStorageDescriptorArgs> storageDescriptor;

    /**
     * @return Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     * 
     */
    public Optional<Output<CatalogTableStorageDescriptorArgs>> storageDescriptor() {
        return Optional.ofNullable(this.storageDescriptor);
    }

    /**
     * Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     * 
     */
    @Import(name="tableType")
    private @Nullable Output<String> tableType;

    /**
     * @return Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     * 
     */
    public Optional<Output<String>> tableType() {
        return Optional.ofNullable(this.tableType);
    }

    /**
     * Configuration block of a target table for resource linking. See `target_table` below.
     * 
     */
    @Import(name="targetTable")
    private @Nullable Output<CatalogTableTargetTableArgs> targetTable;

    /**
     * @return Configuration block of a target table for resource linking. See `target_table` below.
     * 
     */
    public Optional<Output<CatalogTableTargetTableArgs>> targetTable() {
        return Optional.ofNullable(this.targetTable);
    }

    /**
     * If the table is a view, the expanded text of the view; otherwise null.
     * 
     */
    @Import(name="viewExpandedText")
    private @Nullable Output<String> viewExpandedText;

    /**
     * @return If the table is a view, the expanded text of the view; otherwise null.
     * 
     */
    public Optional<Output<String>> viewExpandedText() {
        return Optional.ofNullable(this.viewExpandedText);
    }

    /**
     * If the table is a view, the original text of the view; otherwise null.
     * 
     */
    @Import(name="viewOriginalText")
    private @Nullable Output<String> viewOriginalText;

    /**
     * @return If the table is a view, the original text of the view; otherwise null.
     * 
     */
    public Optional<Output<String>> viewOriginalText() {
        return Optional.ofNullable(this.viewOriginalText);
    }

    private CatalogTableArgs() {}

    private CatalogTableArgs(CatalogTableArgs $) {
        this.catalogId = $.catalogId;
        this.databaseName = $.databaseName;
        this.description = $.description;
        this.name = $.name;
        this.openTableFormatInput = $.openTableFormatInput;
        this.owner = $.owner;
        this.parameters = $.parameters;
        this.partitionIndices = $.partitionIndices;
        this.partitionKeys = $.partitionKeys;
        this.retention = $.retention;
        this.storageDescriptor = $.storageDescriptor;
        this.tableType = $.tableType;
        this.targetTable = $.targetTable;
        this.viewExpandedText = $.viewExpandedText;
        this.viewOriginalText = $.viewOriginalText;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CatalogTableArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CatalogTableArgs $;

        public Builder() {
            $ = new CatalogTableArgs();
        }

        public Builder(CatalogTableArgs defaults) {
            $ = new CatalogTableArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(@Nullable Output<String> catalogId) {
            $.catalogId = catalogId;
            return this;
        }

        /**
         * @param catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(String catalogId) {
            return catalogId(Output.of(catalogId));
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
         * 
         * The follow arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder databaseName(Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
         * 
         * The follow arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param description Description of the table.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the table.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param name Name of the table. For Hive compatibility, this must be entirely lowercase.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the table. For Hive compatibility, this must be entirely lowercase.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param openTableFormatInput Configuration block for open table formats. See `open_table_format_input` below.
         * 
         * @return builder
         * 
         */
        public Builder openTableFormatInput(@Nullable Output<CatalogTableOpenTableFormatInputArgs> openTableFormatInput) {
            $.openTableFormatInput = openTableFormatInput;
            return this;
        }

        /**
         * @param openTableFormatInput Configuration block for open table formats. See `open_table_format_input` below.
         * 
         * @return builder
         * 
         */
        public Builder openTableFormatInput(CatalogTableOpenTableFormatInputArgs openTableFormatInput) {
            return openTableFormatInput(Output.of(openTableFormatInput));
        }

        /**
         * @param owner Owner of the table.
         * 
         * @return builder
         * 
         */
        public Builder owner(@Nullable Output<String> owner) {
            $.owner = owner;
            return this;
        }

        /**
         * @param owner Owner of the table.
         * 
         * @return builder
         * 
         */
        public Builder owner(String owner) {
            return owner(Output.of(owner));
        }

        /**
         * @param parameters Properties associated with this table, as a list of key-value pairs.
         * 
         * @return builder
         * 
         */
        public Builder parameters(@Nullable Output<Map<String,String>> parameters) {
            $.parameters = parameters;
            return this;
        }

        /**
         * @param parameters Properties associated with this table, as a list of key-value pairs.
         * 
         * @return builder
         * 
         */
        public Builder parameters(Map<String,String> parameters) {
            return parameters(Output.of(parameters));
        }

        /**
         * @param partitionIndices Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
         * 
         * @return builder
         * 
         */
        public Builder partitionIndices(@Nullable Output<List<CatalogTablePartitionIndexArgs>> partitionIndices) {
            $.partitionIndices = partitionIndices;
            return this;
        }

        /**
         * @param partitionIndices Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
         * 
         * @return builder
         * 
         */
        public Builder partitionIndices(List<CatalogTablePartitionIndexArgs> partitionIndices) {
            return partitionIndices(Output.of(partitionIndices));
        }

        /**
         * @param partitionIndices Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
         * 
         * @return builder
         * 
         */
        public Builder partitionIndices(CatalogTablePartitionIndexArgs... partitionIndices) {
            return partitionIndices(List.of(partitionIndices));
        }

        /**
         * @param partitionKeys Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
         * 
         * @return builder
         * 
         */
        public Builder partitionKeys(@Nullable Output<List<CatalogTablePartitionKeyArgs>> partitionKeys) {
            $.partitionKeys = partitionKeys;
            return this;
        }

        /**
         * @param partitionKeys Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
         * 
         * @return builder
         * 
         */
        public Builder partitionKeys(List<CatalogTablePartitionKeyArgs> partitionKeys) {
            return partitionKeys(Output.of(partitionKeys));
        }

        /**
         * @param partitionKeys Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
         * 
         * @return builder
         * 
         */
        public Builder partitionKeys(CatalogTablePartitionKeyArgs... partitionKeys) {
            return partitionKeys(List.of(partitionKeys));
        }

        /**
         * @param retention Retention time for this table.
         * 
         * @return builder
         * 
         */
        public Builder retention(@Nullable Output<Integer> retention) {
            $.retention = retention;
            return this;
        }

        /**
         * @param retention Retention time for this table.
         * 
         * @return builder
         * 
         */
        public Builder retention(Integer retention) {
            return retention(Output.of(retention));
        }

        /**
         * @param storageDescriptor Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
         * 
         * @return builder
         * 
         */
        public Builder storageDescriptor(@Nullable Output<CatalogTableStorageDescriptorArgs> storageDescriptor) {
            $.storageDescriptor = storageDescriptor;
            return this;
        }

        /**
         * @param storageDescriptor Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
         * 
         * @return builder
         * 
         */
        public Builder storageDescriptor(CatalogTableStorageDescriptorArgs storageDescriptor) {
            return storageDescriptor(Output.of(storageDescriptor));
        }

        /**
         * @param tableType Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
         * 
         * @return builder
         * 
         */
        public Builder tableType(@Nullable Output<String> tableType) {
            $.tableType = tableType;
            return this;
        }

        /**
         * @param tableType Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
         * 
         * @return builder
         * 
         */
        public Builder tableType(String tableType) {
            return tableType(Output.of(tableType));
        }

        /**
         * @param targetTable Configuration block of a target table for resource linking. See `target_table` below.
         * 
         * @return builder
         * 
         */
        public Builder targetTable(@Nullable Output<CatalogTableTargetTableArgs> targetTable) {
            $.targetTable = targetTable;
            return this;
        }

        /**
         * @param targetTable Configuration block of a target table for resource linking. See `target_table` below.
         * 
         * @return builder
         * 
         */
        public Builder targetTable(CatalogTableTargetTableArgs targetTable) {
            return targetTable(Output.of(targetTable));
        }

        /**
         * @param viewExpandedText If the table is a view, the expanded text of the view; otherwise null.
         * 
         * @return builder
         * 
         */
        public Builder viewExpandedText(@Nullable Output<String> viewExpandedText) {
            $.viewExpandedText = viewExpandedText;
            return this;
        }

        /**
         * @param viewExpandedText If the table is a view, the expanded text of the view; otherwise null.
         * 
         * @return builder
         * 
         */
        public Builder viewExpandedText(String viewExpandedText) {
            return viewExpandedText(Output.of(viewExpandedText));
        }

        /**
         * @param viewOriginalText If the table is a view, the original text of the view; otherwise null.
         * 
         * @return builder
         * 
         */
        public Builder viewOriginalText(@Nullable Output<String> viewOriginalText) {
            $.viewOriginalText = viewOriginalText;
            return this;
        }

        /**
         * @param viewOriginalText If the table is a view, the original text of the view; otherwise null.
         * 
         * @return builder
         * 
         */
        public Builder viewOriginalText(String viewOriginalText) {
            return viewOriginalText(Output.of(viewOriginalText));
        }

        public CatalogTableArgs build() {
            $.databaseName = Objects.requireNonNull($.databaseName, "expected parameter 'databaseName' to be non-null");
            return $;
        }
    }

}
