// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.glue.CatalogDatabaseArgs;
import com.pulumi.aws.glue.inputs.CatalogDatabaseState;
import com.pulumi.aws.glue.outputs.CatalogDatabaseCreateTableDefaultPermission;
import com.pulumi.aws.glue.outputs.CatalogDatabaseTargetDatabase;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Glue Catalog Database Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogDatabase = new CatalogDatabase(&#34;awsGlueCatalogDatabase&#34;, CatalogDatabaseArgs.builder()        
 *             .name(&#34;MyCatalogDatabase&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Create Table Default Permissions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogDatabase = new CatalogDatabase(&#34;awsGlueCatalogDatabase&#34;, CatalogDatabaseArgs.builder()        
 *             .createTableDefaultPermissions(CatalogDatabaseCreateTableDefaultPermissionArgs.builder()
 *                 .permissions(&#34;SELECT&#34;)
 *                 .principal(CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs.builder()
 *                     .dataLakePrincipalIdentifier(&#34;IAM_ALLOWED_PRINCIPALS&#34;)
 *                     .build())
 *                 .build())
 *             .name(&#34;MyCatalogDatabase&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Glue Catalog Databases using the `catalog_id:name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * 
 * ```sh
 *  $ pulumi import aws:glue/catalogDatabase:CatalogDatabase database 123456789012:my_database
 * ```
 * 
 */
@ResourceType(type="aws:glue/catalogDatabase:CatalogDatabase")
public class CatalogDatabase extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Glue Catalog Database.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Glue Catalog Database.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     * 
     */
    @Export(name="catalogId", refs={String.class}, tree="[0]")
    private Output<String> catalogId;

    /**
     * @return ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     * 
     */
    public Output<String> catalogId() {
        return this.catalogId;
    }
    /**
     * Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     * 
     */
    @Export(name="createTableDefaultPermissions", refs={List.class,CatalogDatabaseCreateTableDefaultPermission.class}, tree="[0,1]")
    private Output<List<CatalogDatabaseCreateTableDefaultPermission>> createTableDefaultPermissions;

    /**
     * @return Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     * 
     */
    public Output<List<CatalogDatabaseCreateTableDefaultPermission>> createTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }
    /**
     * Description of the database.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the database.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Location of the database (for example, an HDFS path).
     * 
     */
    @Export(name="locationUri", refs={String.class}, tree="[0]")
    private Output<String> locationUri;

    /**
     * @return Location of the database (for example, an HDFS path).
     * 
     */
    public Output<String> locationUri() {
        return this.locationUri;
    }
    /**
     * Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * List of key-value pairs that define parameters and properties of the database.
     * 
     */
    @Export(name="parameters", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> parameters;

    /**
     * @return List of key-value pairs that define parameters and properties of the database.
     * 
     */
    public Output<Optional<Map<String,String>>> parameters() {
        return Codegen.optional(this.parameters);
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Configuration block for a target database for resource linking. See `target_database` below.
     * 
     */
    @Export(name="targetDatabase", refs={CatalogDatabaseTargetDatabase.class}, tree="[0]")
    private Output</* @Nullable */ CatalogDatabaseTargetDatabase> targetDatabase;

    /**
     * @return Configuration block for a target database for resource linking. See `target_database` below.
     * 
     */
    public Output<Optional<CatalogDatabaseTargetDatabase>> targetDatabase() {
        return Codegen.optional(this.targetDatabase);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CatalogDatabase(String name) {
        this(name, CatalogDatabaseArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CatalogDatabase(String name, @Nullable CatalogDatabaseArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CatalogDatabase(String name, @Nullable CatalogDatabaseArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/catalogDatabase:CatalogDatabase", name, args == null ? CatalogDatabaseArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private CatalogDatabase(String name, Output<String> id, @Nullable CatalogDatabaseState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/catalogDatabase:CatalogDatabase", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CatalogDatabase get(String name, Output<String> id, @Nullable CatalogDatabaseState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CatalogDatabase(name, id, state, options);
    }
}
