// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glacier;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VaultLockArgs extends com.pulumi.resources.ResourceArgs {

    public static final VaultLockArgs Empty = new VaultLockArgs();

    /**
     * Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
     * 
     */
    @Import(name="completeLock", required=true)
    private Output<Boolean> completeLock;

    /**
     * @return Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
     * 
     */
    public Output<Boolean> completeLock() {
        return this.completeLock;
    }

    /**
     * Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
     * 
     */
    @Import(name="ignoreDeletionError")
    private @Nullable Output<Boolean> ignoreDeletionError;

    /**
     * @return Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
     * 
     */
    public Optional<Output<Boolean>> ignoreDeletionError() {
        return Optional.ofNullable(this.ignoreDeletionError);
    }

    /**
     * JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
     * 
     */
    @Import(name="policy", required=true)
    private Output<String> policy;

    /**
     * @return JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }

    /**
     * The name of the Glacier Vault.
     * 
     */
    @Import(name="vaultName", required=true)
    private Output<String> vaultName;

    /**
     * @return The name of the Glacier Vault.
     * 
     */
    public Output<String> vaultName() {
        return this.vaultName;
    }

    private VaultLockArgs() {}

    private VaultLockArgs(VaultLockArgs $) {
        this.completeLock = $.completeLock;
        this.ignoreDeletionError = $.ignoreDeletionError;
        this.policy = $.policy;
        this.vaultName = $.vaultName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VaultLockArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VaultLockArgs $;

        public Builder() {
            $ = new VaultLockArgs();
        }

        public Builder(VaultLockArgs defaults) {
            $ = new VaultLockArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param completeLock Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
         * 
         * @return builder
         * 
         */
        public Builder completeLock(Output<Boolean> completeLock) {
            $.completeLock = completeLock;
            return this;
        }

        /**
         * @param completeLock Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
         * 
         * @return builder
         * 
         */
        public Builder completeLock(Boolean completeLock) {
            return completeLock(Output.of(completeLock));
        }

        /**
         * @param ignoreDeletionError Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
         * 
         * @return builder
         * 
         */
        public Builder ignoreDeletionError(@Nullable Output<Boolean> ignoreDeletionError) {
            $.ignoreDeletionError = ignoreDeletionError;
            return this;
        }

        /**
         * @param ignoreDeletionError Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
         * 
         * @return builder
         * 
         */
        public Builder ignoreDeletionError(Boolean ignoreDeletionError) {
            return ignoreDeletionError(Output.of(ignoreDeletionError));
        }

        /**
         * @param policy JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
         * 
         * @return builder
         * 
         */
        public Builder policy(Output<String> policy) {
            $.policy = policy;
            return this;
        }

        /**
         * @param policy JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
         * 
         * @return builder
         * 
         */
        public Builder policy(String policy) {
            return policy(Output.of(policy));
        }

        /**
         * @param vaultName The name of the Glacier Vault.
         * 
         * @return builder
         * 
         */
        public Builder vaultName(Output<String> vaultName) {
            $.vaultName = vaultName;
            return this;
        }

        /**
         * @param vaultName The name of the Glacier Vault.
         * 
         * @return builder
         * 
         */
        public Builder vaultName(String vaultName) {
            return vaultName(Output.of(vaultName));
        }

        public VaultLockArgs build() {
            $.completeLock = Objects.requireNonNull($.completeLock, "expected parameter 'completeLock' to be non-null");
            $.policy = Objects.requireNonNull($.policy, "expected parameter 'policy' to be non-null");
            $.vaultName = Objects.requireNonNull($.vaultName, "expected parameter 'vaultName' to be non-null");
            return $;
        }
    }

}
