// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.gamelift;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.gamelift.ScriptArgs;
import com.pulumi.aws.gamelift.inputs.ScriptState;
import com.pulumi.aws.gamelift.outputs.ScriptStorageLocation;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an GameLift Script resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Script;
 * import com.pulumi.aws.gamelift.ScriptArgs;
 * import com.pulumi.aws.gamelift.inputs.ScriptStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Script(&#34;example&#34;, ScriptArgs.builder()        
 *             .storageLocation(ScriptStorageLocationArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import GameLift Scripts using the ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:gamelift/script:Script example &lt;script-id&gt;
 * ```
 * 
 */
@ResourceType(type="aws:gamelift/script:Script")
public class Script extends com.pulumi.resources.CustomResource {
    /**
     * GameLift Script ARN.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return GameLift Script ARN.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Name of the script
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the script
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Information indicating where your game script files are stored. See below.
     * 
     */
    @Export(name="storageLocation", refs={ScriptStorageLocation.class}, tree="[0]")
    private Output<ScriptStorageLocation> storageLocation;

    /**
     * @return Information indicating where your game script files are stored. See below.
     * 
     */
    public Output<ScriptStorageLocation> storageLocation() {
        return this.storageLocation;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Version that is associated with this script.
     * 
     */
    @Export(name="version", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> version;

    /**
     * @return Version that is associated with this script.
     * 
     */
    public Output<Optional<String>> version() {
        return Codegen.optional(this.version);
    }
    /**
     * A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     * 
     */
    @Export(name="zipFile", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> zipFile;

    /**
     * @return A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     * 
     */
    public Output<Optional<String>> zipFile() {
        return Codegen.optional(this.zipFile);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Script(String name) {
        this(name, ScriptArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Script(String name, @Nullable ScriptArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Script(String name, @Nullable ScriptArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:gamelift/script:Script", name, args == null ? ScriptArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Script(String name, Output<String> id, @Nullable ScriptState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:gamelift/script:Script", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Script get(String name, Output<String> id, @Nullable ScriptState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Script(name, id, state, options);
    }
}
