// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.gamelift;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.gamelift.MatchmakingConfigurationArgs;
import com.pulumi.aws.gamelift.inputs.MatchmakingConfigurationState;
import com.pulumi.aws.gamelift.outputs.MatchmakingConfigurationGameProperty;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a GameLift Alias resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameSessionQueue;
 * import com.pulumi.aws.gamelift.GameSessionQueueArgs;
 * import com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs;
 * import com.pulumi.aws.gamelift.MatchmakingRuleSet;
 * import com.pulumi.aws.gamelift.MatchmakingRuleSetArgs;
 * import com.pulumi.aws.gamelift.MatchmakingConfiguration;
 * import com.pulumi.aws.gamelift.MatchmakingConfigurationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGameSessionQueue = new GameSessionQueue(&#34;exampleGameSessionQueue&#34;, GameSessionQueueArgs.builder()        
 *             .destinations()
 *             .playerLatencyPolicies(            
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(3)
 *                     .policyDurationSeconds(7)
 *                     .build(),
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(10)
 *                     .build())
 *             .timeoutInSeconds(25)
 *             .build());
 * 
 *         var exampleMatchmakingRuleSet = new MatchmakingRuleSet(&#34;exampleMatchmakingRuleSet&#34;, MatchmakingRuleSetArgs.builder()        
 *             .ruleSetBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;name&#34;, &#34;test&#34;),
 *                     jsonProperty(&#34;ruleLanguageVersion&#34;, &#34;1.0&#34;),
 *                     jsonProperty(&#34;teams&#34;, jsonArray(jsonObject(
 *                         jsonProperty(&#34;name&#34;, &#34;alpha&#34;),
 *                         jsonProperty(&#34;minPlayers&#34;, 1),
 *                         jsonProperty(&#34;maxPlayers&#34;, 5)
 *                     )))
 *                 )))
 *             .build());
 * 
 *         var exampleMatchmakingConfiguration = new MatchmakingConfiguration(&#34;exampleMatchmakingConfiguration&#34;, MatchmakingConfigurationArgs.builder()        
 *             .acceptanceRequired(false)
 *             .customEventData(&#34;pvp&#34;)
 *             .gameSessionData(&#34;game_session_data&#34;)
 *             .backfillMode(&#34;MANUAL&#34;)
 *             .requestTimeoutSeconds(30)
 *             .ruleSetName(aws_gamelift_matchmaking_rule_set.test().name())
 *             .gameSessionQueueArns(aws_gamelift_game_session_queue.test().arn())
 *             .tags(Map.of(&#34;key1&#34;, &#34;value1&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * GameLift Matchmaking Configurations can be imported using the ID, e.g.,
 * 
 * ```sh
 *  $ pulumi import aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration example &lt;matchmakingconfiguration-id&gt;
 * ```
 * 
 */
@ResourceType(type="aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration")
public class MatchmakingConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Specifies if the match that was created with this configuration must be accepted by matched players.
     * 
     */
    @Export(name="acceptanceRequired", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> acceptanceRequired;

    /**
     * @return Specifies if the match that was created with this configuration must be accepted by matched players.
     * 
     */
    public Output<Optional<Boolean>> acceptanceRequired() {
        return Codegen.optional(this.acceptanceRequired);
    }
    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     * 
     */
    @Export(name="acceptanceTimeoutSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> acceptanceTimeoutSeconds;

    /**
     * @return The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     * 
     */
    public Output<Optional<Integer>> acceptanceTimeoutSeconds() {
        return Codegen.optional(this.acceptanceTimeoutSeconds);
    }
    /**
     * The number of player slots in a match to keep open for future players.
     * 
     */
    @Export(name="additionalPlayerCount", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> additionalPlayerCount;

    /**
     * @return The number of player slots in a match to keep open for future players.
     * 
     */
    public Output<Optional<Integer>> additionalPlayerCount() {
        return Codegen.optional(this.additionalPlayerCount);
    }
    /**
     * Matchmaking Configuration ARN.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Matchmaking Configuration ARN.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The method used to backfill game sessions that are created with this matchmaking configuration.
     * 
     */
    @Export(name="backfillMode", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> backfillMode;

    /**
     * @return The method used to backfill game sessions that are created with this matchmaking configuration.
     * 
     */
    public Output<Optional<String>> backfillMode() {
        return Codegen.optional(this.backfillMode);
    }
    /**
     * The time when the Matchmaking Configuration was created.
     * 
     */
    @Export(name="creationTime", refs={String.class}, tree="[0]")
    private Output<String> creationTime;

    /**
     * @return The time when the Matchmaking Configuration was created.
     * 
     */
    public Output<String> creationTime() {
        return this.creationTime;
    }
    /**
     * Information to be added to all events related to this matchmaking configuration.
     * 
     */
    @Export(name="customEventData", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> customEventData;

    /**
     * @return Information to be added to all events related to this matchmaking configuration.
     * 
     */
    public Output<Optional<String>> customEventData() {
        return Codegen.optional(this.customEventData);
    }
    /**
     * A human-readable description of the matchmaking configuration.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A human-readable description of the matchmaking configuration.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     * 
     */
    @Export(name="flexMatchMode", refs={String.class}, tree="[0]")
    private Output<String> flexMatchMode;

    /**
     * @return Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     * 
     */
    public Output<String> flexMatchMode() {
        return this.flexMatchMode;
    }
    /**
     * One or more custom game properties. See below.
     * 
     */
    @Export(name="gameProperties", refs={List.class,MatchmakingConfigurationGameProperty.class}, tree="[0,1]")
    private Output</* @Nullable */ List<MatchmakingConfigurationGameProperty>> gameProperties;

    /**
     * @return One or more custom game properties. See below.
     * 
     */
    public Output<Optional<List<MatchmakingConfigurationGameProperty>>> gameProperties() {
        return Codegen.optional(this.gameProperties);
    }
    /**
     * A set of custom game session properties.
     * 
     */
    @Export(name="gameSessionData", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> gameSessionData;

    /**
     * @return A set of custom game session properties.
     * 
     */
    public Output<Optional<String>> gameSessionData() {
        return Codegen.optional(this.gameSessionData);
    }
    /**
     * The ARNs of the GameLift game session queue resources.
     * 
     */
    @Export(name="gameSessionQueueArns", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> gameSessionQueueArns;

    /**
     * @return The ARNs of the GameLift game session queue resources.
     * 
     */
    public Output<Optional<List<String>>> gameSessionQueueArns() {
        return Codegen.optional(this.gameSessionQueueArns);
    }
    /**
     * Name of the matchmaking configuration
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the matchmaking configuration
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications.
     * 
     */
    @Export(name="notificationTarget", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> notificationTarget;

    /**
     * @return An SNS topic ARN that is set up to receive matchmaking notifications.
     * 
     */
    public Output<Optional<String>> notificationTarget() {
        return Codegen.optional(this.notificationTarget);
    }
    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     * 
     */
    @Export(name="requestTimeoutSeconds", refs={Integer.class}, tree="[0]")
    private Output<Integer> requestTimeoutSeconds;

    /**
     * @return The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     * 
     */
    public Output<Integer> requestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }
    @Export(name="ruleSetArn", refs={String.class}, tree="[0]")
    private Output<String> ruleSetArn;

    public Output<String> ruleSetArn() {
        return this.ruleSetArn;
    }
    /**
     * A rule set names for the matchmaking rule set to use with this configuration.
     * 
     */
    @Export(name="ruleSetName", refs={String.class}, tree="[0]")
    private Output<String> ruleSetName;

    /**
     * @return A rule set names for the matchmaking rule set to use with this configuration.
     * 
     */
    public Output<String> ruleSetName() {
        return this.ruleSetName;
    }
    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MatchmakingConfiguration(String name) {
        this(name, MatchmakingConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MatchmakingConfiguration(String name, MatchmakingConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MatchmakingConfiguration(String name, MatchmakingConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration", name, args == null ? MatchmakingConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MatchmakingConfiguration(String name, Output<String> id, @Nullable MatchmakingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MatchmakingConfiguration get(String name, Output<String> id, @Nullable MatchmakingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MatchmakingConfiguration(name, id, state, options);
    }
}
