// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx.outputs;

import com.pulumi.aws.fsx.outputs.FileCacheDataRepositoryAssociationNf;
import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FileCacheDataRepositoryAssociation {
    private @Nullable String associationId;
    /**
     * @return The path to the S3 or NFS data repository that links to the cache.
     * 
     */
    private String dataRepositoryPath;
    /**
     * @return A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
     * 
     */
    private @Nullable List<String> dataRepositorySubdirectories;
    /**
     * @return The system-generated, unique ID of the cache.
     * 
     */
    private @Nullable String fileCacheId;
    /**
     * @return A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
     * 
     */
    private String fileCachePath;
    private @Nullable String fileSystemId;
    private @Nullable String fileSystemPath;
    private @Nullable Integer importedFileChunkSize;
    /**
     * @return (Optional) See the `nfs` configuration block.
     * 
     */
    private @Nullable List<FileCacheDataRepositoryAssociationNf> nfs;
    private @Nullable String resourceArn;
    /**
     * @return A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    private @Nullable Map<String,String> tags;

    private FileCacheDataRepositoryAssociation() {}
    public Optional<String> associationId() {
        return Optional.ofNullable(this.associationId);
    }
    /**
     * @return The path to the S3 or NFS data repository that links to the cache.
     * 
     */
    public String dataRepositoryPath() {
        return this.dataRepositoryPath;
    }
    /**
     * @return A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
     * 
     */
    public List<String> dataRepositorySubdirectories() {
        return this.dataRepositorySubdirectories == null ? List.of() : this.dataRepositorySubdirectories;
    }
    /**
     * @return The system-generated, unique ID of the cache.
     * 
     */
    public Optional<String> fileCacheId() {
        return Optional.ofNullable(this.fileCacheId);
    }
    /**
     * @return A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
     * 
     */
    public String fileCachePath() {
        return this.fileCachePath;
    }
    public Optional<String> fileSystemId() {
        return Optional.ofNullable(this.fileSystemId);
    }
    public Optional<String> fileSystemPath() {
        return Optional.ofNullable(this.fileSystemPath);
    }
    public Optional<Integer> importedFileChunkSize() {
        return Optional.ofNullable(this.importedFileChunkSize);
    }
    /**
     * @return (Optional) See the `nfs` configuration block.
     * 
     */
    public List<FileCacheDataRepositoryAssociationNf> nfs() {
        return this.nfs == null ? List.of() : this.nfs;
    }
    public Optional<String> resourceArn() {
        return Optional.ofNullable(this.resourceArn);
    }
    /**
     * @return A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Map<String,String> tags() {
        return this.tags == null ? Map.of() : this.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FileCacheDataRepositoryAssociation defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String associationId;
        private String dataRepositoryPath;
        private @Nullable List<String> dataRepositorySubdirectories;
        private @Nullable String fileCacheId;
        private String fileCachePath;
        private @Nullable String fileSystemId;
        private @Nullable String fileSystemPath;
        private @Nullable Integer importedFileChunkSize;
        private @Nullable List<FileCacheDataRepositoryAssociationNf> nfs;
        private @Nullable String resourceArn;
        private @Nullable Map<String,String> tags;
        public Builder() {}
        public Builder(FileCacheDataRepositoryAssociation defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.associationId = defaults.associationId;
    	      this.dataRepositoryPath = defaults.dataRepositoryPath;
    	      this.dataRepositorySubdirectories = defaults.dataRepositorySubdirectories;
    	      this.fileCacheId = defaults.fileCacheId;
    	      this.fileCachePath = defaults.fileCachePath;
    	      this.fileSystemId = defaults.fileSystemId;
    	      this.fileSystemPath = defaults.fileSystemPath;
    	      this.importedFileChunkSize = defaults.importedFileChunkSize;
    	      this.nfs = defaults.nfs;
    	      this.resourceArn = defaults.resourceArn;
    	      this.tags = defaults.tags;
        }

        @CustomType.Setter
        public Builder associationId(@Nullable String associationId) {
            this.associationId = associationId;
            return this;
        }
        @CustomType.Setter
        public Builder dataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = Objects.requireNonNull(dataRepositoryPath);
            return this;
        }
        @CustomType.Setter
        public Builder dataRepositorySubdirectories(@Nullable List<String> dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories = dataRepositorySubdirectories;
            return this;
        }
        public Builder dataRepositorySubdirectories(String... dataRepositorySubdirectories) {
            return dataRepositorySubdirectories(List.of(dataRepositorySubdirectories));
        }
        @CustomType.Setter
        public Builder fileCacheId(@Nullable String fileCacheId) {
            this.fileCacheId = fileCacheId;
            return this;
        }
        @CustomType.Setter
        public Builder fileCachePath(String fileCachePath) {
            this.fileCachePath = Objects.requireNonNull(fileCachePath);
            return this;
        }
        @CustomType.Setter
        public Builder fileSystemId(@Nullable String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }
        @CustomType.Setter
        public Builder fileSystemPath(@Nullable String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
            return this;
        }
        @CustomType.Setter
        public Builder importedFileChunkSize(@Nullable Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }
        @CustomType.Setter
        public Builder nfs(@Nullable List<FileCacheDataRepositoryAssociationNf> nfs) {
            this.nfs = nfs;
            return this;
        }
        public Builder nfs(FileCacheDataRepositoryAssociationNf... nfs) {
            return nfs(List.of(nfs));
        }
        @CustomType.Setter
        public Builder resourceArn(@Nullable String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }
        @CustomType.Setter
        public Builder tags(@Nullable Map<String,String> tags) {
            this.tags = tags;
            return this;
        }
        public FileCacheDataRepositoryAssociation build() {
            final var o = new FileCacheDataRepositoryAssociation();
            o.associationId = associationId;
            o.dataRepositoryPath = dataRepositoryPath;
            o.dataRepositorySubdirectories = dataRepositorySubdirectories;
            o.fileCacheId = fileCacheId;
            o.fileCachePath = fileCachePath;
            o.fileSystemId = fileSystemId;
            o.fileSystemPath = fileSystemPath;
            o.importedFileChunkSize = importedFileChunkSize;
            o.nfs = nfs;
            o.resourceArn = resourceArn;
            o.tags = tags;
            return o;
        }
    }
}
