// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx.inputs;

import com.pulumi.aws.fsx.inputs.WindowsFileSystemAuditLogConfigurationArgs;
import com.pulumi.aws.fsx.inputs.WindowsFileSystemDiskIopsConfigurationArgs;
import com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class WindowsFileSystemState extends com.pulumi.resources.ResourceArgs {

    public static final WindowsFileSystemState Empty = new WindowsFileSystemState();

    /**
     * The ID for an existing Microsoft Active Directory instance that the file system should join when it&#39;s created. Cannot be specified with `self_managed_active_directory`.
     * 
     */
    @Import(name="activeDirectoryId")
    private @Nullable Output<String> activeDirectoryId;

    /**
     * @return The ID for an existing Microsoft Active Directory instance that the file system should join when it&#39;s created. Cannot be specified with `self_managed_active_directory`.
     * 
     */
    public Optional<Output<String>> activeDirectoryId() {
        return Optional.ofNullable(this.activeDirectoryId);
    }

    /**
     * An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     * 
     */
    @Import(name="aliases")
    private @Nullable Output<List<String>> aliases;

    /**
     * @return An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     * 
     */
    public Optional<Output<List<String>>> aliases() {
        return Optional.ofNullable(this.aliases);
    }

    /**
     * Amazon Resource Name of the file system.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name of the file system.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     * 
     */
    @Import(name="auditLogConfiguration")
    private @Nullable Output<WindowsFileSystemAuditLogConfigurationArgs> auditLogConfiguration;

    /**
     * @return The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     * 
     */
    public Optional<Output<WindowsFileSystemAuditLogConfigurationArgs>> auditLogConfiguration() {
        return Optional.ofNullable(this.auditLogConfiguration);
    }

    /**
     * The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
     * 
     */
    @Import(name="automaticBackupRetentionDays")
    private @Nullable Output<Integer> automaticBackupRetentionDays;

    /**
     * @return The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
     * 
     */
    public Optional<Output<Integer>> automaticBackupRetentionDays() {
        return Optional.ofNullable(this.automaticBackupRetentionDays);
    }

    /**
     * The ID of the source backup to create the filesystem from.
     * 
     */
    @Import(name="backupId")
    private @Nullable Output<String> backupId;

    /**
     * @return The ID of the source backup to create the filesystem from.
     * 
     */
    public Optional<Output<String>> backupId() {
        return Optional.ofNullable(this.backupId);
    }

    /**
     * A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
     * 
     */
    @Import(name="copyTagsToBackups")
    private @Nullable Output<Boolean> copyTagsToBackups;

    /**
     * @return A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToBackups() {
        return Optional.ofNullable(this.copyTagsToBackups);
    }

    /**
     * The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
     * 
     */
    @Import(name="dailyAutomaticBackupStartTime")
    private @Nullable Output<String> dailyAutomaticBackupStartTime;

    /**
     * @return The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
     * 
     */
    public Optional<Output<String>> dailyAutomaticBackupStartTime() {
        return Optional.ofNullable(this.dailyAutomaticBackupStartTime);
    }

    /**
     * Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
     * 
     */
    @Import(name="deploymentType")
    private @Nullable Output<String> deploymentType;

    /**
     * @return Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
     * 
     */
    public Optional<Output<String>> deploymentType() {
        return Optional.ofNullable(this.deploymentType);
    }

    /**
     * The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     * 
     */
    @Import(name="diskIopsConfiguration")
    private @Nullable Output<WindowsFileSystemDiskIopsConfigurationArgs> diskIopsConfiguration;

    /**
     * @return The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     * 
     */
    public Optional<Output<WindowsFileSystemDiskIopsConfigurationArgs>> diskIopsConfiguration() {
        return Optional.ofNullable(this.diskIopsConfiguration);
    }

    /**
     * DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
     * 
     */
    @Import(name="dnsName")
    private @Nullable Output<String> dnsName;

    /**
     * @return DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
     * 
     */
    public Optional<Output<String>> dnsName() {
        return Optional.ofNullable(this.dnsName);
    }

    /**
     * ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Set of Elastic Network Interface identifiers from which the file system is accessible.
     * 
     */
    @Import(name="networkInterfaceIds")
    private @Nullable Output<List<String>> networkInterfaceIds;

    /**
     * @return Set of Elastic Network Interface identifiers from which the file system is accessible.
     * 
     */
    public Optional<Output<List<String>>> networkInterfaceIds() {
        return Optional.ofNullable(this.networkInterfaceIds);
    }

    /**
     * AWS account identifier that created the file system.
     * 
     */
    @Import(name="ownerId")
    private @Nullable Output<String> ownerId;

    /**
     * @return AWS account identifier that created the file system.
     * 
     */
    public Optional<Output<String>> ownerId() {
        return Optional.ofNullable(this.ownerId);
    }

    /**
     * The IP address of the primary, or preferred, file server.
     * 
     */
    @Import(name="preferredFileServerIp")
    private @Nullable Output<String> preferredFileServerIp;

    /**
     * @return The IP address of the primary, or preferred, file server.
     * 
     */
    public Optional<Output<String>> preferredFileServerIp() {
        return Optional.ofNullable(this.preferredFileServerIp);
    }

    /**
     * Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
     * 
     */
    @Import(name="preferredSubnetId")
    private @Nullable Output<String> preferredSubnetId;

    /**
     * @return Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
     * 
     */
    public Optional<Output<String>> preferredSubnetId() {
        return Optional.ofNullable(this.preferredSubnetId);
    }

    /**
     * For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
     * 
     */
    @Import(name="remoteAdministrationEndpoint")
    private @Nullable Output<String> remoteAdministrationEndpoint;

    /**
     * @return For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
     * 
     */
    public Optional<Output<String>> remoteAdministrationEndpoint() {
        return Optional.ofNullable(this.remoteAdministrationEndpoint);
    }

    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     * 
     */
    @Import(name="selfManagedActiveDirectory")
    private @Nullable Output<WindowsFileSystemSelfManagedActiveDirectoryArgs> selfManagedActiveDirectory;

    /**
     * @return Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     * 
     */
    public Optional<Output<WindowsFileSystemSelfManagedActiveDirectoryArgs>> selfManagedActiveDirectory() {
        return Optional.ofNullable(this.selfManagedActiveDirectory);
    }

    /**
     * When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     * 
     */
    @Import(name="skipFinalBackup")
    private @Nullable Output<Boolean> skipFinalBackup;

    /**
     * @return When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> skipFinalBackup() {
        return Optional.ofNullable(this.skipFinalBackup);
    }

    /**
     * Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
     * 
     */
    @Import(name="storageCapacity")
    private @Nullable Output<Integer> storageCapacity;

    /**
     * @return Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
     * 
     */
    public Optional<Output<Integer>> storageCapacity() {
        return Optional.ofNullable(this.storageCapacity);
    }

    /**
     * Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
     * 
     */
    @Import(name="storageType")
    private @Nullable Output<String> storageType;

    /**
     * @return Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
     * 
     */
    public Optional<Output<String>> storageType() {
        return Optional.ofNullable(this.storageType);
    }

    /**
     * A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<List<String>> subnetIds;

    /**
     * @return A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     * 
     */
    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="throughputCapacity")
    private @Nullable Output<Integer> throughputCapacity;

    /**
     * @return Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<Integer>> throughputCapacity() {
        return Optional.ofNullable(this.throughputCapacity);
    }

    /**
     * Identifier of the Virtual Private Cloud for the file system.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<String> vpcId;

    /**
     * @return Identifier of the Virtual Private Cloud for the file system.
     * 
     */
    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    /**
     * The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     * 
     */
    @Import(name="weeklyMaintenanceStartTime")
    private @Nullable Output<String> weeklyMaintenanceStartTime;

    /**
     * @return The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     * 
     */
    public Optional<Output<String>> weeklyMaintenanceStartTime() {
        return Optional.ofNullable(this.weeklyMaintenanceStartTime);
    }

    private WindowsFileSystemState() {}

    private WindowsFileSystemState(WindowsFileSystemState $) {
        this.activeDirectoryId = $.activeDirectoryId;
        this.aliases = $.aliases;
        this.arn = $.arn;
        this.auditLogConfiguration = $.auditLogConfiguration;
        this.automaticBackupRetentionDays = $.automaticBackupRetentionDays;
        this.backupId = $.backupId;
        this.copyTagsToBackups = $.copyTagsToBackups;
        this.dailyAutomaticBackupStartTime = $.dailyAutomaticBackupStartTime;
        this.deploymentType = $.deploymentType;
        this.diskIopsConfiguration = $.diskIopsConfiguration;
        this.dnsName = $.dnsName;
        this.kmsKeyId = $.kmsKeyId;
        this.networkInterfaceIds = $.networkInterfaceIds;
        this.ownerId = $.ownerId;
        this.preferredFileServerIp = $.preferredFileServerIp;
        this.preferredSubnetId = $.preferredSubnetId;
        this.remoteAdministrationEndpoint = $.remoteAdministrationEndpoint;
        this.securityGroupIds = $.securityGroupIds;
        this.selfManagedActiveDirectory = $.selfManagedActiveDirectory;
        this.skipFinalBackup = $.skipFinalBackup;
        this.storageCapacity = $.storageCapacity;
        this.storageType = $.storageType;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.throughputCapacity = $.throughputCapacity;
        this.vpcId = $.vpcId;
        this.weeklyMaintenanceStartTime = $.weeklyMaintenanceStartTime;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(WindowsFileSystemState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private WindowsFileSystemState $;

        public Builder() {
            $ = new WindowsFileSystemState();
        }

        public Builder(WindowsFileSystemState defaults) {
            $ = new WindowsFileSystemState(Objects.requireNonNull(defaults));
        }

        /**
         * @param activeDirectoryId The ID for an existing Microsoft Active Directory instance that the file system should join when it&#39;s created. Cannot be specified with `self_managed_active_directory`.
         * 
         * @return builder
         * 
         */
        public Builder activeDirectoryId(@Nullable Output<String> activeDirectoryId) {
            $.activeDirectoryId = activeDirectoryId;
            return this;
        }

        /**
         * @param activeDirectoryId The ID for an existing Microsoft Active Directory instance that the file system should join when it&#39;s created. Cannot be specified with `self_managed_active_directory`.
         * 
         * @return builder
         * 
         */
        public Builder activeDirectoryId(String activeDirectoryId) {
            return activeDirectoryId(Output.of(activeDirectoryId));
        }

        /**
         * @param aliases An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
         * 
         * @return builder
         * 
         */
        public Builder aliases(@Nullable Output<List<String>> aliases) {
            $.aliases = aliases;
            return this;
        }

        /**
         * @param aliases An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
         * 
         * @return builder
         * 
         */
        public Builder aliases(List<String> aliases) {
            return aliases(Output.of(aliases));
        }

        /**
         * @param aliases An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
         * 
         * @return builder
         * 
         */
        public Builder aliases(String... aliases) {
            return aliases(List.of(aliases));
        }

        /**
         * @param arn Amazon Resource Name of the file system.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name of the file system.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param auditLogConfiguration The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder auditLogConfiguration(@Nullable Output<WindowsFileSystemAuditLogConfigurationArgs> auditLogConfiguration) {
            $.auditLogConfiguration = auditLogConfiguration;
            return this;
        }

        /**
         * @param auditLogConfiguration The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder auditLogConfiguration(WindowsFileSystemAuditLogConfigurationArgs auditLogConfiguration) {
            return auditLogConfiguration(Output.of(auditLogConfiguration));
        }

        /**
         * @param automaticBackupRetentionDays The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
         * 
         * @return builder
         * 
         */
        public Builder automaticBackupRetentionDays(@Nullable Output<Integer> automaticBackupRetentionDays) {
            $.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        /**
         * @param automaticBackupRetentionDays The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
         * 
         * @return builder
         * 
         */
        public Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            return automaticBackupRetentionDays(Output.of(automaticBackupRetentionDays));
        }

        /**
         * @param backupId The ID of the source backup to create the filesystem from.
         * 
         * @return builder
         * 
         */
        public Builder backupId(@Nullable Output<String> backupId) {
            $.backupId = backupId;
            return this;
        }

        /**
         * @param backupId The ID of the source backup to create the filesystem from.
         * 
         * @return builder
         * 
         */
        public Builder backupId(String backupId) {
            return backupId(Output.of(backupId));
        }

        /**
         * @param copyTagsToBackups A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToBackups(@Nullable Output<Boolean> copyTagsToBackups) {
            $.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        /**
         * @param copyTagsToBackups A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            return copyTagsToBackups(Output.of(copyTagsToBackups));
        }

        /**
         * @param dailyAutomaticBackupStartTime The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
         * 
         * @return builder
         * 
         */
        public Builder dailyAutomaticBackupStartTime(@Nullable Output<String> dailyAutomaticBackupStartTime) {
            $.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        /**
         * @param dailyAutomaticBackupStartTime The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
         * 
         * @return builder
         * 
         */
        public Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            return dailyAutomaticBackupStartTime(Output.of(dailyAutomaticBackupStartTime));
        }

        /**
         * @param deploymentType Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder deploymentType(@Nullable Output<String> deploymentType) {
            $.deploymentType = deploymentType;
            return this;
        }

        /**
         * @param deploymentType Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder deploymentType(String deploymentType) {
            return deploymentType(Output.of(deploymentType));
        }

        /**
         * @param diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder diskIopsConfiguration(@Nullable Output<WindowsFileSystemDiskIopsConfigurationArgs> diskIopsConfiguration) {
            $.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        /**
         * @param diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder diskIopsConfiguration(WindowsFileSystemDiskIopsConfigurationArgs diskIopsConfiguration) {
            return diskIopsConfiguration(Output.of(diskIopsConfiguration));
        }

        /**
         * @param dnsName DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
         * 
         * @return builder
         * 
         */
        public Builder dnsName(@Nullable Output<String> dnsName) {
            $.dnsName = dnsName;
            return this;
        }

        /**
         * @param dnsName DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
         * 
         * @return builder
         * 
         */
        public Builder dnsName(String dnsName) {
            return dnsName(Output.of(dnsName));
        }

        /**
         * @param kmsKeyId ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param networkInterfaceIds Set of Elastic Network Interface identifiers from which the file system is accessible.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceIds(@Nullable Output<List<String>> networkInterfaceIds) {
            $.networkInterfaceIds = networkInterfaceIds;
            return this;
        }

        /**
         * @param networkInterfaceIds Set of Elastic Network Interface identifiers from which the file system is accessible.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceIds(List<String> networkInterfaceIds) {
            return networkInterfaceIds(Output.of(networkInterfaceIds));
        }

        /**
         * @param networkInterfaceIds Set of Elastic Network Interface identifiers from which the file system is accessible.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceIds(String... networkInterfaceIds) {
            return networkInterfaceIds(List.of(networkInterfaceIds));
        }

        /**
         * @param ownerId AWS account identifier that created the file system.
         * 
         * @return builder
         * 
         */
        public Builder ownerId(@Nullable Output<String> ownerId) {
            $.ownerId = ownerId;
            return this;
        }

        /**
         * @param ownerId AWS account identifier that created the file system.
         * 
         * @return builder
         * 
         */
        public Builder ownerId(String ownerId) {
            return ownerId(Output.of(ownerId));
        }

        /**
         * @param preferredFileServerIp The IP address of the primary, or preferred, file server.
         * 
         * @return builder
         * 
         */
        public Builder preferredFileServerIp(@Nullable Output<String> preferredFileServerIp) {
            $.preferredFileServerIp = preferredFileServerIp;
            return this;
        }

        /**
         * @param preferredFileServerIp The IP address of the primary, or preferred, file server.
         * 
         * @return builder
         * 
         */
        public Builder preferredFileServerIp(String preferredFileServerIp) {
            return preferredFileServerIp(Output.of(preferredFileServerIp));
        }

        /**
         * @param preferredSubnetId Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder preferredSubnetId(@Nullable Output<String> preferredSubnetId) {
            $.preferredSubnetId = preferredSubnetId;
            return this;
        }

        /**
         * @param preferredSubnetId Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder preferredSubnetId(String preferredSubnetId) {
            return preferredSubnetId(Output.of(preferredSubnetId));
        }

        /**
         * @param remoteAdministrationEndpoint For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
         * 
         * @return builder
         * 
         */
        public Builder remoteAdministrationEndpoint(@Nullable Output<String> remoteAdministrationEndpoint) {
            $.remoteAdministrationEndpoint = remoteAdministrationEndpoint;
            return this;
        }

        /**
         * @param remoteAdministrationEndpoint For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
         * 
         * @return builder
         * 
         */
        public Builder remoteAdministrationEndpoint(String remoteAdministrationEndpoint) {
            return remoteAdministrationEndpoint(Output.of(remoteAdministrationEndpoint));
        }

        /**
         * @param securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param selfManagedActiveDirectory Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
         * 
         * @return builder
         * 
         */
        public Builder selfManagedActiveDirectory(@Nullable Output<WindowsFileSystemSelfManagedActiveDirectoryArgs> selfManagedActiveDirectory) {
            $.selfManagedActiveDirectory = selfManagedActiveDirectory;
            return this;
        }

        /**
         * @param selfManagedActiveDirectory Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
         * 
         * @return builder
         * 
         */
        public Builder selfManagedActiveDirectory(WindowsFileSystemSelfManagedActiveDirectoryArgs selfManagedActiveDirectory) {
            return selfManagedActiveDirectory(Output.of(selfManagedActiveDirectory));
        }

        /**
         * @param skipFinalBackup When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalBackup(@Nullable Output<Boolean> skipFinalBackup) {
            $.skipFinalBackup = skipFinalBackup;
            return this;
        }

        /**
         * @param skipFinalBackup When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalBackup(Boolean skipFinalBackup) {
            return skipFinalBackup(Output.of(skipFinalBackup));
        }

        /**
         * @param storageCapacity Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacity(@Nullable Output<Integer> storageCapacity) {
            $.storageCapacity = storageCapacity;
            return this;
        }

        /**
         * @param storageCapacity Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacity(Integer storageCapacity) {
            return storageCapacity(Output.of(storageCapacity));
        }

        /**
         * @param storageType Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
         * 
         * @return builder
         * 
         */
        public Builder storageType(@Nullable Output<String> storageType) {
            $.storageType = storageType;
            return this;
        }

        /**
         * @param storageType Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
         * 
         * @return builder
         * 
         */
        public Builder storageType(String storageType) {
            return storageType(Output.of(storageType));
        }

        /**
         * @param subnetIds A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        /**
         * @param tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param throughputCapacity Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder throughputCapacity(@Nullable Output<Integer> throughputCapacity) {
            $.throughputCapacity = throughputCapacity;
            return this;
        }

        /**
         * @param throughputCapacity Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder throughputCapacity(Integer throughputCapacity) {
            return throughputCapacity(Output.of(throughputCapacity));
        }

        /**
         * @param vpcId Identifier of the Virtual Private Cloud for the file system.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId Identifier of the Virtual Private Cloud for the file system.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        /**
         * @param weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
         * 
         * @return builder
         * 
         */
        public Builder weeklyMaintenanceStartTime(@Nullable Output<String> weeklyMaintenanceStartTime) {
            $.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        /**
         * @param weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
         * 
         * @return builder
         * 
         */
        public Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            return weeklyMaintenanceStartTime(Output.of(weeklyMaintenanceStartTime));
        }

        public WindowsFileSystemState build() {
            return $;
        }
    }

}
