// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx.inputs;

import com.pulumi.aws.fsx.inputs.OpenZfsFileSystemDiskIopsConfigurationArgs;
import com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class OpenZfsFileSystemState extends com.pulumi.resources.ResourceArgs {

    public static final OpenZfsFileSystemState Empty = new OpenZfsFileSystemState();

    /**
     * Amazon Resource Name of the file system.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name of the file system.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     * 
     */
    @Import(name="automaticBackupRetentionDays")
    private @Nullable Output<Integer> automaticBackupRetentionDays;

    /**
     * @return The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     * 
     */
    public Optional<Output<Integer>> automaticBackupRetentionDays() {
        return Optional.ofNullable(this.automaticBackupRetentionDays);
    }

    /**
     * The ID of the source backup to create the filesystem from.
     * 
     */
    @Import(name="backupId")
    private @Nullable Output<String> backupId;

    /**
     * @return The ID of the source backup to create the filesystem from.
     * 
     */
    public Optional<Output<String>> backupId() {
        return Optional.ofNullable(this.backupId);
    }

    /**
     * A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
     * 
     */
    @Import(name="copyTagsToBackups")
    private @Nullable Output<Boolean> copyTagsToBackups;

    /**
     * @return A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToBackups() {
        return Optional.ofNullable(this.copyTagsToBackups);
    }

    /**
     * A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     * 
     */
    @Import(name="copyTagsToVolumes")
    private @Nullable Output<Boolean> copyTagsToVolumes;

    /**
     * @return A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToVolumes() {
        return Optional.ofNullable(this.copyTagsToVolumes);
    }

    /**
     * A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     * 
     */
    @Import(name="dailyAutomaticBackupStartTime")
    private @Nullable Output<String> dailyAutomaticBackupStartTime;

    /**
     * @return A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     * 
     */
    public Optional<Output<String>> dailyAutomaticBackupStartTime() {
        return Optional.ofNullable(this.dailyAutomaticBackupStartTime);
    }

    /**
     * The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
     * 
     */
    @Import(name="deploymentType")
    private @Nullable Output<String> deploymentType;

    /**
     * @return The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
     * 
     */
    public Optional<Output<String>> deploymentType() {
        return Optional.ofNullable(this.deploymentType);
    }

    /**
     * The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See Disk Iops Configuration below.
     * 
     */
    @Import(name="diskIopsConfiguration")
    private @Nullable Output<OpenZfsFileSystemDiskIopsConfigurationArgs> diskIopsConfiguration;

    /**
     * @return The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See Disk Iops Configuration below.
     * 
     */
    public Optional<Output<OpenZfsFileSystemDiskIopsConfigurationArgs>> diskIopsConfiguration() {
        return Optional.ofNullable(this.diskIopsConfiguration);
    }

    /**
     * DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
     * 
     */
    @Import(name="dnsName")
    private @Nullable Output<String> dnsName;

    /**
     * @return DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
     * 
     */
    public Optional<Output<String>> dnsName() {
        return Optional.ofNullable(this.dnsName);
    }

    /**
     * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
     * 
     */
    @Import(name="endpointIpAddressRange")
    private @Nullable Output<String> endpointIpAddressRange;

    /**
     * @return (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
     * 
     */
    public Optional<Output<String>> endpointIpAddressRange() {
        return Optional.ofNullable(this.endpointIpAddressRange);
    }

    /**
     * ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
     * 
     */
    @Import(name="networkInterfaceIds")
    private @Nullable Output<List<String>> networkInterfaceIds;

    /**
     * @return Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
     * 
     */
    public Optional<Output<List<String>>> networkInterfaceIds() {
        return Optional.ofNullable(this.networkInterfaceIds);
    }

    /**
     * AWS account identifier that created the file system.
     * 
     */
    @Import(name="ownerId")
    private @Nullable Output<String> ownerId;

    /**
     * @return AWS account identifier that created the file system.
     * 
     */
    public Optional<Output<String>> ownerId() {
        return Optional.ofNullable(this.ownerId);
    }

    /**
     * (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     * 
     */
    @Import(name="preferredSubnetId")
    private @Nullable Output<String> preferredSubnetId;

    /**
     * @return (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     * 
     */
    public Optional<Output<String>> preferredSubnetId() {
        return Optional.ofNullable(this.preferredSubnetId);
    }

    /**
     * The configuration for the root volume of the file system. All other volumes are children or the root volume. See Root Volume Configuration below.
     * 
     */
    @Import(name="rootVolumeConfiguration")
    private @Nullable Output<OpenZfsFileSystemRootVolumeConfigurationArgs> rootVolumeConfiguration;

    /**
     * @return The configuration for the root volume of the file system. All other volumes are children or the root volume. See Root Volume Configuration below.
     * 
     */
    public Optional<Output<OpenZfsFileSystemRootVolumeConfigurationArgs>> rootVolumeConfiguration() {
        return Optional.ofNullable(this.rootVolumeConfiguration);
    }

    /**
     * Identifier of the root volume, e.g., `fsvol-12345678`
     * 
     */
    @Import(name="rootVolumeId")
    private @Nullable Output<String> rootVolumeId;

    /**
     * @return Identifier of the root volume, e.g., `fsvol-12345678`
     * 
     */
    public Optional<Output<String>> rootVolumeId() {
        return Optional.ofNullable(this.rootVolumeId);
    }

    /**
     * (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC&#39;s default route table.
     * 
     */
    @Import(name="routeTableIds")
    private @Nullable Output<List<String>> routeTableIds;

    /**
     * @return (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC&#39;s default route table.
     * 
     */
    public Optional<Output<List<String>>> routeTableIds() {
        return Optional.ofNullable(this.routeTableIds);
    }

    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
     * 
     */
    @Import(name="storageCapacity")
    private @Nullable Output<Integer> storageCapacity;

    /**
     * @return The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
     * 
     */
    public Optional<Output<Integer>> storageCapacity() {
        return Optional.ofNullable(this.storageCapacity);
    }

    /**
     * The filesystem storage type. Only `SSD` is supported.
     * 
     */
    @Import(name="storageType")
    private @Nullable Output<String> storageType;

    /**
     * @return The filesystem storage type. Only `SSD` is supported.
     * 
     */
    public Optional<Output<String>> storageType() {
        return Optional.ofNullable(this.storageType);
    }

    /**
     * A list of IDs for the subnets that the file system will be accessible from.
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<String> subnetIds;

    /**
     * @return A list of IDs for the subnets that the file system will be accessible from.
     * 
     */
    public Optional<Output<String>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
     * 
     */
    @Import(name="throughputCapacity")
    private @Nullable Output<Integer> throughputCapacity;

    /**
     * @return Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
     * 
     */
    public Optional<Output<Integer>> throughputCapacity() {
        return Optional.ofNullable(this.throughputCapacity);
    }

    /**
     * Identifier of the Virtual Private Cloud for the file system.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<String> vpcId;

    /**
     * @return Identifier of the Virtual Private Cloud for the file system.
     * 
     */
    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    /**
     * The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     * 
     */
    @Import(name="weeklyMaintenanceStartTime")
    private @Nullable Output<String> weeklyMaintenanceStartTime;

    /**
     * @return The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     * 
     */
    public Optional<Output<String>> weeklyMaintenanceStartTime() {
        return Optional.ofNullable(this.weeklyMaintenanceStartTime);
    }

    private OpenZfsFileSystemState() {}

    private OpenZfsFileSystemState(OpenZfsFileSystemState $) {
        this.arn = $.arn;
        this.automaticBackupRetentionDays = $.automaticBackupRetentionDays;
        this.backupId = $.backupId;
        this.copyTagsToBackups = $.copyTagsToBackups;
        this.copyTagsToVolumes = $.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = $.dailyAutomaticBackupStartTime;
        this.deploymentType = $.deploymentType;
        this.diskIopsConfiguration = $.diskIopsConfiguration;
        this.dnsName = $.dnsName;
        this.endpointIpAddressRange = $.endpointIpAddressRange;
        this.kmsKeyId = $.kmsKeyId;
        this.networkInterfaceIds = $.networkInterfaceIds;
        this.ownerId = $.ownerId;
        this.preferredSubnetId = $.preferredSubnetId;
        this.rootVolumeConfiguration = $.rootVolumeConfiguration;
        this.rootVolumeId = $.rootVolumeId;
        this.routeTableIds = $.routeTableIds;
        this.securityGroupIds = $.securityGroupIds;
        this.storageCapacity = $.storageCapacity;
        this.storageType = $.storageType;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.throughputCapacity = $.throughputCapacity;
        this.vpcId = $.vpcId;
        this.weeklyMaintenanceStartTime = $.weeklyMaintenanceStartTime;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(OpenZfsFileSystemState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private OpenZfsFileSystemState $;

        public Builder() {
            $ = new OpenZfsFileSystemState();
        }

        public Builder(OpenZfsFileSystemState defaults) {
            $ = new OpenZfsFileSystemState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name of the file system.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name of the file system.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param automaticBackupRetentionDays The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
         * 
         * @return builder
         * 
         */
        public Builder automaticBackupRetentionDays(@Nullable Output<Integer> automaticBackupRetentionDays) {
            $.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        /**
         * @param automaticBackupRetentionDays The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
         * 
         * @return builder
         * 
         */
        public Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            return automaticBackupRetentionDays(Output.of(automaticBackupRetentionDays));
        }

        /**
         * @param backupId The ID of the source backup to create the filesystem from.
         * 
         * @return builder
         * 
         */
        public Builder backupId(@Nullable Output<String> backupId) {
            $.backupId = backupId;
            return this;
        }

        /**
         * @param backupId The ID of the source backup to create the filesystem from.
         * 
         * @return builder
         * 
         */
        public Builder backupId(String backupId) {
            return backupId(Output.of(backupId));
        }

        /**
         * @param copyTagsToBackups A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToBackups(@Nullable Output<Boolean> copyTagsToBackups) {
            $.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        /**
         * @param copyTagsToBackups A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            return copyTagsToBackups(Output.of(copyTagsToBackups));
        }

        /**
         * @param copyTagsToVolumes A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToVolumes(@Nullable Output<Boolean> copyTagsToVolumes) {
            $.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        /**
         * @param copyTagsToVolumes A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            return copyTagsToVolumes(Output.of(copyTagsToVolumes));
        }

        /**
         * @param dailyAutomaticBackupStartTime A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
         * 
         * @return builder
         * 
         */
        public Builder dailyAutomaticBackupStartTime(@Nullable Output<String> dailyAutomaticBackupStartTime) {
            $.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        /**
         * @param dailyAutomaticBackupStartTime A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
         * 
         * @return builder
         * 
         */
        public Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            return dailyAutomaticBackupStartTime(Output.of(dailyAutomaticBackupStartTime));
        }

        /**
         * @param deploymentType The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder deploymentType(@Nullable Output<String> deploymentType) {
            $.deploymentType = deploymentType;
            return this;
        }

        /**
         * @param deploymentType The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
         * 
         * @return builder
         * 
         */
        public Builder deploymentType(String deploymentType) {
            return deploymentType(Output.of(deploymentType));
        }

        /**
         * @param diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See Disk Iops Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder diskIopsConfiguration(@Nullable Output<OpenZfsFileSystemDiskIopsConfigurationArgs> diskIopsConfiguration) {
            $.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        /**
         * @param diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See Disk Iops Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder diskIopsConfiguration(OpenZfsFileSystemDiskIopsConfigurationArgs diskIopsConfiguration) {
            return diskIopsConfiguration(Output.of(diskIopsConfiguration));
        }

        /**
         * @param dnsName DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
         * 
         * @return builder
         * 
         */
        public Builder dnsName(@Nullable Output<String> dnsName) {
            $.dnsName = dnsName;
            return this;
        }

        /**
         * @param dnsName DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
         * 
         * @return builder
         * 
         */
        public Builder dnsName(String dnsName) {
            return dnsName(Output.of(dnsName));
        }

        /**
         * @param endpointIpAddressRange (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
         * 
         * @return builder
         * 
         */
        public Builder endpointIpAddressRange(@Nullable Output<String> endpointIpAddressRange) {
            $.endpointIpAddressRange = endpointIpAddressRange;
            return this;
        }

        /**
         * @param endpointIpAddressRange (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
         * 
         * @return builder
         * 
         */
        public Builder endpointIpAddressRange(String endpointIpAddressRange) {
            return endpointIpAddressRange(Output.of(endpointIpAddressRange));
        }

        /**
         * @param kmsKeyId ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param networkInterfaceIds Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceIds(@Nullable Output<List<String>> networkInterfaceIds) {
            $.networkInterfaceIds = networkInterfaceIds;
            return this;
        }

        /**
         * @param networkInterfaceIds Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceIds(List<String> networkInterfaceIds) {
            return networkInterfaceIds(Output.of(networkInterfaceIds));
        }

        /**
         * @param networkInterfaceIds Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceIds(String... networkInterfaceIds) {
            return networkInterfaceIds(List.of(networkInterfaceIds));
        }

        /**
         * @param ownerId AWS account identifier that created the file system.
         * 
         * @return builder
         * 
         */
        public Builder ownerId(@Nullable Output<String> ownerId) {
            $.ownerId = ownerId;
            return this;
        }

        /**
         * @param ownerId AWS account identifier that created the file system.
         * 
         * @return builder
         * 
         */
        public Builder ownerId(String ownerId) {
            return ownerId(Output.of(ownerId));
        }

        /**
         * @param preferredSubnetId (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
         * 
         * @return builder
         * 
         */
        public Builder preferredSubnetId(@Nullable Output<String> preferredSubnetId) {
            $.preferredSubnetId = preferredSubnetId;
            return this;
        }

        /**
         * @param preferredSubnetId (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
         * 
         * @return builder
         * 
         */
        public Builder preferredSubnetId(String preferredSubnetId) {
            return preferredSubnetId(Output.of(preferredSubnetId));
        }

        /**
         * @param rootVolumeConfiguration The configuration for the root volume of the file system. All other volumes are children or the root volume. See Root Volume Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder rootVolumeConfiguration(@Nullable Output<OpenZfsFileSystemRootVolumeConfigurationArgs> rootVolumeConfiguration) {
            $.rootVolumeConfiguration = rootVolumeConfiguration;
            return this;
        }

        /**
         * @param rootVolumeConfiguration The configuration for the root volume of the file system. All other volumes are children or the root volume. See Root Volume Configuration below.
         * 
         * @return builder
         * 
         */
        public Builder rootVolumeConfiguration(OpenZfsFileSystemRootVolumeConfigurationArgs rootVolumeConfiguration) {
            return rootVolumeConfiguration(Output.of(rootVolumeConfiguration));
        }

        /**
         * @param rootVolumeId Identifier of the root volume, e.g., `fsvol-12345678`
         * 
         * @return builder
         * 
         */
        public Builder rootVolumeId(@Nullable Output<String> rootVolumeId) {
            $.rootVolumeId = rootVolumeId;
            return this;
        }

        /**
         * @param rootVolumeId Identifier of the root volume, e.g., `fsvol-12345678`
         * 
         * @return builder
         * 
         */
        public Builder rootVolumeId(String rootVolumeId) {
            return rootVolumeId(Output.of(rootVolumeId));
        }

        /**
         * @param routeTableIds (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC&#39;s default route table.
         * 
         * @return builder
         * 
         */
        public Builder routeTableIds(@Nullable Output<List<String>> routeTableIds) {
            $.routeTableIds = routeTableIds;
            return this;
        }

        /**
         * @param routeTableIds (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC&#39;s default route table.
         * 
         * @return builder
         * 
         */
        public Builder routeTableIds(List<String> routeTableIds) {
            return routeTableIds(Output.of(routeTableIds));
        }

        /**
         * @param routeTableIds (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC&#39;s default route table.
         * 
         * @return builder
         * 
         */
        public Builder routeTableIds(String... routeTableIds) {
            return routeTableIds(List.of(routeTableIds));
        }

        /**
         * @param securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param storageCapacity The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacity(@Nullable Output<Integer> storageCapacity) {
            $.storageCapacity = storageCapacity;
            return this;
        }

        /**
         * @param storageCapacity The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacity(Integer storageCapacity) {
            return storageCapacity(Output.of(storageCapacity));
        }

        /**
         * @param storageType The filesystem storage type. Only `SSD` is supported.
         * 
         * @return builder
         * 
         */
        public Builder storageType(@Nullable Output<String> storageType) {
            $.storageType = storageType;
            return this;
        }

        /**
         * @param storageType The filesystem storage type. Only `SSD` is supported.
         * 
         * @return builder
         * 
         */
        public Builder storageType(String storageType) {
            return storageType(Output.of(storageType));
        }

        /**
         * @param subnetIds A list of IDs for the subnets that the file system will be accessible from.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<String> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds A list of IDs for the subnets that the file system will be accessible from.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param throughputCapacity Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
         * 
         * @return builder
         * 
         */
        public Builder throughputCapacity(@Nullable Output<Integer> throughputCapacity) {
            $.throughputCapacity = throughputCapacity;
            return this;
        }

        /**
         * @param throughputCapacity Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
         * 
         * @return builder
         * 
         */
        public Builder throughputCapacity(Integer throughputCapacity) {
            return throughputCapacity(Output.of(throughputCapacity));
        }

        /**
         * @param vpcId Identifier of the Virtual Private Cloud for the file system.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId Identifier of the Virtual Private Cloud for the file system.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        /**
         * @param weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
         * 
         * @return builder
         * 
         */
        public Builder weeklyMaintenanceStartTime(@Nullable Output<String> weeklyMaintenanceStartTime) {
            $.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        /**
         * @param weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
         * 
         * @return builder
         * 
         */
        public Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            return weeklyMaintenanceStartTime(Output.of(weeklyMaintenanceStartTime));
        }

        public OpenZfsFileSystemState build() {
            return $;
        }
    }

}
