// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.fsx.WindowsFileSystemArgs;
import com.pulumi.aws.fsx.inputs.WindowsFileSystemState;
import com.pulumi.aws.fsx.outputs.WindowsFileSystemAuditLogConfiguration;
import com.pulumi.aws.fsx.outputs.WindowsFileSystemDiskIopsConfiguration;
import com.pulumi.aws.fsx.outputs.WindowsFileSystemSelfManagedActiveDirectory;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a FSx Windows File System. See the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) for more information.
 * 
 * &gt; **NOTE:** Either the `active_directory_id` argument or `self_managed_active_directory` configuration block must be specified.
 * 
 * ## Example Usage
 * ### Using AWS Directory Service
 * 
 * Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/fsx-aws-managed-ad.html).
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.WindowsFileSystem;
 * import com.pulumi.aws.fsx.WindowsFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new WindowsFileSystem(&#34;example&#34;, WindowsFileSystemArgs.builder()        
 *             .activeDirectoryId(aws_directory_service_directory.example().id())
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .storageCapacity(300)
 *             .subnetIds(aws_subnet.example().id())
 *             .throughputCapacity(1024)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Using a Self-Managed Microsoft Active Directory
 * 
 * Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html).
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.WindowsFileSystem;
 * import com.pulumi.aws.fsx.WindowsFileSystemArgs;
 * import com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new WindowsFileSystem(&#34;example&#34;, WindowsFileSystemArgs.builder()        
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .storageCapacity(300)
 *             .subnetIds(aws_subnet.example().id())
 *             .throughputCapacity(1024)
 *             .selfManagedActiveDirectory(WindowsFileSystemSelfManagedActiveDirectoryArgs.builder()
 *                 .dnsIps(                
 *                     &#34;10.0.0.111&#34;,
 *                     &#34;10.0.0.222&#34;)
 *                 .domainName(&#34;corp.example.com&#34;)
 *                 .password(&#34;avoid-plaintext-passwords&#34;)
 *                 .username(&#34;Admin&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:fsx/windowsFileSystem:WindowsFileSystem example fs-543ab12b1ca672f33
 * ```
 *  Certain resource arguments, like `security_group_ids` and the `self_managed_active_directory` configuation block `password`, do not have a FSx API method for reading the information after creation. If these arguments are set in the TODO configuration on an imported resource, TODO will always show a difference. To workaround this behavior, either omit the argument from the TODO configuration or use `ignore_changes` to hide the difference. For example:
 * 
 */
@ResourceType(type="aws:fsx/windowsFileSystem:WindowsFileSystem")
public class WindowsFileSystem extends com.pulumi.resources.CustomResource {
    /**
     * The ID for an existing Microsoft Active Directory instance that the file system should join when it&#39;s created. Cannot be specified with `self_managed_active_directory`.
     * 
     */
    @Export(name="activeDirectoryId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> activeDirectoryId;

    /**
     * @return The ID for an existing Microsoft Active Directory instance that the file system should join when it&#39;s created. Cannot be specified with `self_managed_active_directory`.
     * 
     */
    public Output<Optional<String>> activeDirectoryId() {
        return Codegen.optional(this.activeDirectoryId);
    }
    /**
     * An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     * 
     */
    @Export(name="aliases", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> aliases;

    /**
     * @return An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     * 
     */
    public Output<Optional<List<String>>> aliases() {
        return Codegen.optional(this.aliases);
    }
    /**
     * Amazon Resource Name of the file system.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name of the file system.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     * 
     */
    @Export(name="auditLogConfiguration", refs={WindowsFileSystemAuditLogConfiguration.class}, tree="[0]")
    private Output<WindowsFileSystemAuditLogConfiguration> auditLogConfiguration;

    /**
     * @return The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     * 
     */
    public Output<WindowsFileSystemAuditLogConfiguration> auditLogConfiguration() {
        return this.auditLogConfiguration;
    }
    /**
     * The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
     * 
     */
    @Export(name="automaticBackupRetentionDays", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> automaticBackupRetentionDays;

    /**
     * @return The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
     * 
     */
    public Output<Optional<Integer>> automaticBackupRetentionDays() {
        return Codegen.optional(this.automaticBackupRetentionDays);
    }
    /**
     * The ID of the source backup to create the filesystem from.
     * 
     */
    @Export(name="backupId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> backupId;

    /**
     * @return The ID of the source backup to create the filesystem from.
     * 
     */
    public Output<Optional<String>> backupId() {
        return Codegen.optional(this.backupId);
    }
    /**
     * A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
     * 
     */
    @Export(name="copyTagsToBackups", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> copyTagsToBackups;

    /**
     * @return A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> copyTagsToBackups() {
        return Codegen.optional(this.copyTagsToBackups);
    }
    /**
     * The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
     * 
     */
    @Export(name="dailyAutomaticBackupStartTime", refs={String.class}, tree="[0]")
    private Output<String> dailyAutomaticBackupStartTime;

    /**
     * @return The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
     * 
     */
    public Output<String> dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }
    /**
     * Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
     * 
     */
    @Export(name="deploymentType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> deploymentType;

    /**
     * @return Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
     * 
     */
    public Output<Optional<String>> deploymentType() {
        return Codegen.optional(this.deploymentType);
    }
    /**
     * The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     * 
     */
    @Export(name="diskIopsConfiguration", refs={WindowsFileSystemDiskIopsConfiguration.class}, tree="[0]")
    private Output<WindowsFileSystemDiskIopsConfiguration> diskIopsConfiguration;

    /**
     * @return The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     * 
     */
    public Output<WindowsFileSystemDiskIopsConfiguration> diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }
    /**
     * DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
     * 
     */
    @Export(name="dnsName", refs={String.class}, tree="[0]")
    private Output<String> dnsName;

    /**
     * @return DNS name for the file system, e.g., `fs-12345678.corp.example.com` (domain name matching the Active Directory domain name)
     * 
     */
    public Output<String> dnsName() {
        return this.dnsName;
    }
    /**
     * ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
     * 
     */
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyId;

    /**
     * @return ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
     * 
     */
    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }
    /**
     * Set of Elastic Network Interface identifiers from which the file system is accessible.
     * 
     */
    @Export(name="networkInterfaceIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> networkInterfaceIds;

    /**
     * @return Set of Elastic Network Interface identifiers from which the file system is accessible.
     * 
     */
    public Output<List<String>> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }
    /**
     * AWS account identifier that created the file system.
     * 
     */
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    /**
     * @return AWS account identifier that created the file system.
     * 
     */
    public Output<String> ownerId() {
        return this.ownerId;
    }
    /**
     * The IP address of the primary, or preferred, file server.
     * 
     */
    @Export(name="preferredFileServerIp", refs={String.class}, tree="[0]")
    private Output<String> preferredFileServerIp;

    /**
     * @return The IP address of the primary, or preferred, file server.
     * 
     */
    public Output<String> preferredFileServerIp() {
        return this.preferredFileServerIp;
    }
    /**
     * Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
     * 
     */
    @Export(name="preferredSubnetId", refs={String.class}, tree="[0]")
    private Output<String> preferredSubnetId;

    /**
     * @return Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
     * 
     */
    public Output<String> preferredSubnetId() {
        return this.preferredSubnetId;
    }
    /**
     * For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
     * 
     */
    @Export(name="remoteAdministrationEndpoint", refs={String.class}, tree="[0]")
    private Output<String> remoteAdministrationEndpoint;

    /**
     * @return For `MULTI_AZ_1` deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell. For `SINGLE_AZ_1` deployment types, this is the DNS name of the file system.
     * 
     */
    public Output<String> remoteAdministrationEndpoint() {
        return this.remoteAdministrationEndpoint;
    }
    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     * 
     */
    @Export(name="securityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> securityGroupIds;

    /**
     * @return A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     * 
     */
    public Output<Optional<List<String>>> securityGroupIds() {
        return Codegen.optional(this.securityGroupIds);
    }
    /**
     * Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     * 
     */
    @Export(name="selfManagedActiveDirectory", refs={WindowsFileSystemSelfManagedActiveDirectory.class}, tree="[0]")
    private Output</* @Nullable */ WindowsFileSystemSelfManagedActiveDirectory> selfManagedActiveDirectory;

    /**
     * @return Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     * 
     */
    public Output<Optional<WindowsFileSystemSelfManagedActiveDirectory>> selfManagedActiveDirectory() {
        return Codegen.optional(this.selfManagedActiveDirectory);
    }
    /**
     * When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     * 
     */
    @Export(name="skipFinalBackup", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> skipFinalBackup;

    /**
     * @return When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> skipFinalBackup() {
        return Codegen.optional(this.skipFinalBackup);
    }
    /**
     * Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
     * 
     */
    @Export(name="storageCapacity", refs={Integer.class}, tree="[0]")
    private Output<Integer> storageCapacity;

    /**
     * @return Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
     * 
     */
    public Output<Integer> storageCapacity() {
        return this.storageCapacity;
    }
    /**
     * Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
     * 
     */
    @Export(name="storageType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> storageType;

    /**
     * @return Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
     * 
     */
    public Output<Optional<String>> storageType() {
        return Codegen.optional(this.storageType);
    }
    /**
     * A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> subnetIds;

    /**
     * @return A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     * 
     */
    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }
    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="throughputCapacity", refs={Integer.class}, tree="[0]")
    private Output<Integer> throughputCapacity;

    /**
     * @return Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Integer> throughputCapacity() {
        return this.throughputCapacity;
    }
    /**
     * Identifier of the Virtual Private Cloud for the file system.
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return Identifier of the Virtual Private Cloud for the file system.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }
    /**
     * The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     * 
     */
    @Export(name="weeklyMaintenanceStartTime", refs={String.class}, tree="[0]")
    private Output<String> weeklyMaintenanceStartTime;

    /**
     * @return The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     * 
     */
    public Output<String> weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public WindowsFileSystem(String name) {
        this(name, WindowsFileSystemArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public WindowsFileSystem(String name, WindowsFileSystemArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public WindowsFileSystem(String name, WindowsFileSystemArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:fsx/windowsFileSystem:WindowsFileSystem", name, args == null ? WindowsFileSystemArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private WindowsFileSystem(String name, Output<String> id, @Nullable WindowsFileSystemState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:fsx/windowsFileSystem:WindowsFileSystem", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static WindowsFileSystem get(String name, Output<String> id, @Nullable WindowsFileSystemState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new WindowsFileSystem(name, id, state, options);
    }
}
