// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx;

import com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsArgs;
import com.pulumi.aws.fsx.inputs.OpenZfsVolumeOriginSnapshotArgs;
import com.pulumi.aws.fsx.inputs.OpenZfsVolumeUserAndGroupQuotaArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class OpenZfsVolumeArgs extends com.pulumi.resources.ResourceArgs {

    public static final OpenZfsVolumeArgs Empty = new OpenZfsVolumeArgs();

    /**
     * A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     * 
     */
    @Import(name="copyTagsToSnapshots")
    private @Nullable Output<Boolean> copyTagsToSnapshots;

    /**
     * @return A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToSnapshots() {
        return Optional.ofNullable(this.copyTagsToSnapshots);
    }

    /**
     * Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don&#39;t specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     * 
     */
    @Import(name="dataCompressionType")
    private @Nullable Output<String> dataCompressionType;

    /**
     * @return Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don&#39;t specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     * 
     */
    public Optional<Output<String>> dataCompressionType() {
        return Optional.ofNullable(this.dataCompressionType);
    }

    /**
     * The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
     * 
     */
    @Import(name="nfsExports")
    private @Nullable Output<OpenZfsVolumeNfsExportsArgs> nfsExports;

    /**
     * @return NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
     * 
     */
    public Optional<Output<OpenZfsVolumeNfsExportsArgs>> nfsExports() {
        return Optional.ofNullable(this.nfsExports);
    }

    /**
     * The ARN of the source snapshot to create the volume from.
     * 
     */
    @Import(name="originSnapshot")
    private @Nullable Output<OpenZfsVolumeOriginSnapshotArgs> originSnapshot;

    /**
     * @return The ARN of the source snapshot to create the volume from.
     * 
     */
    public Optional<Output<OpenZfsVolumeOriginSnapshotArgs>> originSnapshot() {
        return Optional.ofNullable(this.originSnapshot);
    }

    /**
     * The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
     * 
     */
    @Import(name="parentVolumeId", required=true)
    private Output<String> parentVolumeId;

    /**
     * @return The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
     * 
     */
    public Output<String> parentVolumeId() {
        return this.parentVolumeId;
    }

    /**
     * specifies whether the volume is read-only. Default is false.
     * 
     */
    @Import(name="readOnly")
    private @Nullable Output<Boolean> readOnly;

    /**
     * @return specifies whether the volume is read-only. Default is false.
     * 
     */
    public Optional<Output<Boolean>> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    /**
     * The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     * 
     */
    @Import(name="recordSizeKib")
    private @Nullable Output<Integer> recordSizeKib;

    /**
     * @return The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     * 
     */
    public Optional<Output<Integer>> recordSizeKib() {
        return Optional.ofNullable(this.recordSizeKib);
    }

    /**
     * The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
     * 
     */
    @Import(name="storageCapacityQuotaGib")
    private @Nullable Output<Integer> storageCapacityQuotaGib;

    /**
     * @return The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
     * 
     */
    public Optional<Output<Integer>> storageCapacityQuotaGib() {
        return Optional.ofNullable(this.storageCapacityQuotaGib);
    }

    /**
     * The amount of storage in gibibytes (GiB) to reserve from the parent volume.
     * 
     */
    @Import(name="storageCapacityReservationGib")
    private @Nullable Output<Integer> storageCapacityReservationGib;

    /**
     * @return The amount of storage in gibibytes (GiB) to reserve from the parent volume.
     * 
     */
    public Optional<Output<Integer>> storageCapacityReservationGib() {
        return Optional.ofNullable(this.storageCapacityReservationGib);
    }

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
     * 
     */
    @Import(name="userAndGroupQuotas")
    private @Nullable Output<List<OpenZfsVolumeUserAndGroupQuotaArgs>> userAndGroupQuotas;

    /**
     * @return Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
     * 
     */
    public Optional<Output<List<OpenZfsVolumeUserAndGroupQuotaArgs>>> userAndGroupQuotas() {
        return Optional.ofNullable(this.userAndGroupQuotas);
    }

    @Import(name="volumeType")
    private @Nullable Output<String> volumeType;

    public Optional<Output<String>> volumeType() {
        return Optional.ofNullable(this.volumeType);
    }

    private OpenZfsVolumeArgs() {}

    private OpenZfsVolumeArgs(OpenZfsVolumeArgs $) {
        this.copyTagsToSnapshots = $.copyTagsToSnapshots;
        this.dataCompressionType = $.dataCompressionType;
        this.name = $.name;
        this.nfsExports = $.nfsExports;
        this.originSnapshot = $.originSnapshot;
        this.parentVolumeId = $.parentVolumeId;
        this.readOnly = $.readOnly;
        this.recordSizeKib = $.recordSizeKib;
        this.storageCapacityQuotaGib = $.storageCapacityQuotaGib;
        this.storageCapacityReservationGib = $.storageCapacityReservationGib;
        this.tags = $.tags;
        this.userAndGroupQuotas = $.userAndGroupQuotas;
        this.volumeType = $.volumeType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(OpenZfsVolumeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private OpenZfsVolumeArgs $;

        public Builder() {
            $ = new OpenZfsVolumeArgs();
        }

        public Builder(OpenZfsVolumeArgs defaults) {
            $ = new OpenZfsVolumeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param copyTagsToSnapshots A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToSnapshots(@Nullable Output<Boolean> copyTagsToSnapshots) {
            $.copyTagsToSnapshots = copyTagsToSnapshots;
            return this;
        }

        /**
         * @param copyTagsToSnapshots A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToSnapshots(Boolean copyTagsToSnapshots) {
            return copyTagsToSnapshots(Output.of(copyTagsToSnapshots));
        }

        /**
         * @param dataCompressionType Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don&#39;t specify compression option will inherit from parent volume. This option on file system applies to the root volume.
         * 
         * @return builder
         * 
         */
        public Builder dataCompressionType(@Nullable Output<String> dataCompressionType) {
            $.dataCompressionType = dataCompressionType;
            return this;
        }

        /**
         * @param dataCompressionType Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don&#39;t specify compression option will inherit from parent volume. This option on file system applies to the root volume.
         * 
         * @return builder
         * 
         */
        public Builder dataCompressionType(String dataCompressionType) {
            return dataCompressionType(Output.of(dataCompressionType));
        }

        /**
         * @param name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param nfsExports NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
         * 
         * @return builder
         * 
         */
        public Builder nfsExports(@Nullable Output<OpenZfsVolumeNfsExportsArgs> nfsExports) {
            $.nfsExports = nfsExports;
            return this;
        }

        /**
         * @param nfsExports NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
         * 
         * @return builder
         * 
         */
        public Builder nfsExports(OpenZfsVolumeNfsExportsArgs nfsExports) {
            return nfsExports(Output.of(nfsExports));
        }

        /**
         * @param originSnapshot The ARN of the source snapshot to create the volume from.
         * 
         * @return builder
         * 
         */
        public Builder originSnapshot(@Nullable Output<OpenZfsVolumeOriginSnapshotArgs> originSnapshot) {
            $.originSnapshot = originSnapshot;
            return this;
        }

        /**
         * @param originSnapshot The ARN of the source snapshot to create the volume from.
         * 
         * @return builder
         * 
         */
        public Builder originSnapshot(OpenZfsVolumeOriginSnapshotArgs originSnapshot) {
            return originSnapshot(Output.of(originSnapshot));
        }

        /**
         * @param parentVolumeId The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
         * 
         * @return builder
         * 
         */
        public Builder parentVolumeId(Output<String> parentVolumeId) {
            $.parentVolumeId = parentVolumeId;
            return this;
        }

        /**
         * @param parentVolumeId The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
         * 
         * @return builder
         * 
         */
        public Builder parentVolumeId(String parentVolumeId) {
            return parentVolumeId(Output.of(parentVolumeId));
        }

        /**
         * @param readOnly specifies whether the volume is read-only. Default is false.
         * 
         * @return builder
         * 
         */
        public Builder readOnly(@Nullable Output<Boolean> readOnly) {
            $.readOnly = readOnly;
            return this;
        }

        /**
         * @param readOnly specifies whether the volume is read-only. Default is false.
         * 
         * @return builder
         * 
         */
        public Builder readOnly(Boolean readOnly) {
            return readOnly(Output.of(readOnly));
        }

        /**
         * @param recordSizeKib The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
         * 
         * @return builder
         * 
         */
        public Builder recordSizeKib(@Nullable Output<Integer> recordSizeKib) {
            $.recordSizeKib = recordSizeKib;
            return this;
        }

        /**
         * @param recordSizeKib The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
         * 
         * @return builder
         * 
         */
        public Builder recordSizeKib(Integer recordSizeKib) {
            return recordSizeKib(Output.of(recordSizeKib));
        }

        /**
         * @param storageCapacityQuotaGib The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacityQuotaGib(@Nullable Output<Integer> storageCapacityQuotaGib) {
            $.storageCapacityQuotaGib = storageCapacityQuotaGib;
            return this;
        }

        /**
         * @param storageCapacityQuotaGib The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacityQuotaGib(Integer storageCapacityQuotaGib) {
            return storageCapacityQuotaGib(Output.of(storageCapacityQuotaGib));
        }

        /**
         * @param storageCapacityReservationGib The amount of storage in gibibytes (GiB) to reserve from the parent volume.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacityReservationGib(@Nullable Output<Integer> storageCapacityReservationGib) {
            $.storageCapacityReservationGib = storageCapacityReservationGib;
            return this;
        }

        /**
         * @param storageCapacityReservationGib The amount of storage in gibibytes (GiB) to reserve from the parent volume.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacityReservationGib(Integer storageCapacityReservationGib) {
            return storageCapacityReservationGib(Output.of(storageCapacityReservationGib));
        }

        /**
         * @param tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param userAndGroupQuotas Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
         * 
         * @return builder
         * 
         */
        public Builder userAndGroupQuotas(@Nullable Output<List<OpenZfsVolumeUserAndGroupQuotaArgs>> userAndGroupQuotas) {
            $.userAndGroupQuotas = userAndGroupQuotas;
            return this;
        }

        /**
         * @param userAndGroupQuotas Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
         * 
         * @return builder
         * 
         */
        public Builder userAndGroupQuotas(List<OpenZfsVolumeUserAndGroupQuotaArgs> userAndGroupQuotas) {
            return userAndGroupQuotas(Output.of(userAndGroupQuotas));
        }

        /**
         * @param userAndGroupQuotas Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
         * 
         * @return builder
         * 
         */
        public Builder userAndGroupQuotas(OpenZfsVolumeUserAndGroupQuotaArgs... userAndGroupQuotas) {
            return userAndGroupQuotas(List.of(userAndGroupQuotas));
        }

        public Builder volumeType(@Nullable Output<String> volumeType) {
            $.volumeType = volumeType;
            return this;
        }

        public Builder volumeType(String volumeType) {
            return volumeType(Output.of(volumeType));
        }

        public OpenZfsVolumeArgs build() {
            $.parentVolumeId = Objects.requireNonNull($.parentVolumeId, "expected parameter 'parentVolumeId' to be non-null");
            return $;
        }
    }

}
