// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx;

import com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class OntapVolumeArgs extends com.pulumi.resources.ResourceArgs {

    public static final OntapVolumeArgs Empty = new OntapVolumeArgs();

    /**
     * Specifies the location in the storage virtual machine&#39;s namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     * 
     */
    @Import(name="junctionPath")
    private @Nullable Output<String> junctionPath;

    /**
     * @return Specifies the location in the storage virtual machine&#39;s namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     * 
     */
    public Optional<Output<String>> junctionPath() {
        return Optional.ofNullable(this.junctionPath);
    }

    /**
     * The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     * 
     */
    @Import(name="ontapVolumeType")
    private @Nullable Output<String> ontapVolumeType;

    /**
     * @return Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     * 
     */
    public Optional<Output<String>> ontapVolumeType() {
        return Optional.ofNullable(this.ontapVolumeType);
    }

    /**
     * Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     * 
     */
    @Import(name="securityStyle")
    private @Nullable Output<String> securityStyle;

    /**
     * @return Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     * 
     */
    public Optional<Output<String>> securityStyle() {
        return Optional.ofNullable(this.securityStyle);
    }

    /**
     * Specifies the size of the volume, in megabytes (MB), that you are creating.
     * 
     */
    @Import(name="sizeInMegabytes", required=true)
    private Output<Integer> sizeInMegabytes;

    /**
     * @return Specifies the size of the volume, in megabytes (MB), that you are creating.
     * 
     */
    public Output<Integer> sizeInMegabytes() {
        return this.sizeInMegabytes;
    }

    /**
     * When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     * 
     */
    @Import(name="skipFinalBackup")
    private @Nullable Output<Boolean> skipFinalBackup;

    /**
     * @return When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> skipFinalBackup() {
        return Optional.ofNullable(this.skipFinalBackup);
    }

    /**
     * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     * 
     */
    @Import(name="storageEfficiencyEnabled")
    private @Nullable Output<Boolean> storageEfficiencyEnabled;

    /**
     * @return Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     * 
     */
    public Optional<Output<Boolean>> storageEfficiencyEnabled() {
        return Optional.ofNullable(this.storageEfficiencyEnabled);
    }

    /**
     * Specifies the storage virtual machine in which to create the volume.
     * 
     */
    @Import(name="storageVirtualMachineId", required=true)
    private Output<String> storageVirtualMachineId;

    /**
     * @return Specifies the storage virtual machine in which to create the volume.
     * 
     */
    public Output<String> storageVirtualMachineId() {
        return this.storageVirtualMachineId;
    }

    /**
     * A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    @Import(name="tieringPolicy")
    private @Nullable Output<OntapVolumeTieringPolicyArgs> tieringPolicy;

    public Optional<Output<OntapVolumeTieringPolicyArgs>> tieringPolicy() {
        return Optional.ofNullable(this.tieringPolicy);
    }

    /**
     * The type of volume, currently the only valid value is `ONTAP`.
     * 
     */
    @Import(name="volumeType")
    private @Nullable Output<String> volumeType;

    /**
     * @return The type of volume, currently the only valid value is `ONTAP`.
     * 
     */
    public Optional<Output<String>> volumeType() {
        return Optional.ofNullable(this.volumeType);
    }

    private OntapVolumeArgs() {}

    private OntapVolumeArgs(OntapVolumeArgs $) {
        this.junctionPath = $.junctionPath;
        this.name = $.name;
        this.ontapVolumeType = $.ontapVolumeType;
        this.securityStyle = $.securityStyle;
        this.sizeInMegabytes = $.sizeInMegabytes;
        this.skipFinalBackup = $.skipFinalBackup;
        this.storageEfficiencyEnabled = $.storageEfficiencyEnabled;
        this.storageVirtualMachineId = $.storageVirtualMachineId;
        this.tags = $.tags;
        this.tieringPolicy = $.tieringPolicy;
        this.volumeType = $.volumeType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(OntapVolumeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private OntapVolumeArgs $;

        public Builder() {
            $ = new OntapVolumeArgs();
        }

        public Builder(OntapVolumeArgs defaults) {
            $ = new OntapVolumeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param junctionPath Specifies the location in the storage virtual machine&#39;s namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
         * 
         * @return builder
         * 
         */
        public Builder junctionPath(@Nullable Output<String> junctionPath) {
            $.junctionPath = junctionPath;
            return this;
        }

        /**
         * @param junctionPath Specifies the location in the storage virtual machine&#39;s namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
         * 
         * @return builder
         * 
         */
        public Builder junctionPath(String junctionPath) {
            return junctionPath(Output.of(junctionPath));
        }

        /**
         * @param name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param ontapVolumeType Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
         * 
         * @return builder
         * 
         */
        public Builder ontapVolumeType(@Nullable Output<String> ontapVolumeType) {
            $.ontapVolumeType = ontapVolumeType;
            return this;
        }

        /**
         * @param ontapVolumeType Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
         * 
         * @return builder
         * 
         */
        public Builder ontapVolumeType(String ontapVolumeType) {
            return ontapVolumeType(Output.of(ontapVolumeType));
        }

        /**
         * @param securityStyle Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
         * 
         * @return builder
         * 
         */
        public Builder securityStyle(@Nullable Output<String> securityStyle) {
            $.securityStyle = securityStyle;
            return this;
        }

        /**
         * @param securityStyle Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
         * 
         * @return builder
         * 
         */
        public Builder securityStyle(String securityStyle) {
            return securityStyle(Output.of(securityStyle));
        }

        /**
         * @param sizeInMegabytes Specifies the size of the volume, in megabytes (MB), that you are creating.
         * 
         * @return builder
         * 
         */
        public Builder sizeInMegabytes(Output<Integer> sizeInMegabytes) {
            $.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        /**
         * @param sizeInMegabytes Specifies the size of the volume, in megabytes (MB), that you are creating.
         * 
         * @return builder
         * 
         */
        public Builder sizeInMegabytes(Integer sizeInMegabytes) {
            return sizeInMegabytes(Output.of(sizeInMegabytes));
        }

        /**
         * @param skipFinalBackup When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalBackup(@Nullable Output<Boolean> skipFinalBackup) {
            $.skipFinalBackup = skipFinalBackup;
            return this;
        }

        /**
         * @param skipFinalBackup When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalBackup(Boolean skipFinalBackup) {
            return skipFinalBackup(Output.of(skipFinalBackup));
        }

        /**
         * @param storageEfficiencyEnabled Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
         * 
         * @return builder
         * 
         */
        public Builder storageEfficiencyEnabled(@Nullable Output<Boolean> storageEfficiencyEnabled) {
            $.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        /**
         * @param storageEfficiencyEnabled Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
         * 
         * @return builder
         * 
         */
        public Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            return storageEfficiencyEnabled(Output.of(storageEfficiencyEnabled));
        }

        /**
         * @param storageVirtualMachineId Specifies the storage virtual machine in which to create the volume.
         * 
         * @return builder
         * 
         */
        public Builder storageVirtualMachineId(Output<String> storageVirtualMachineId) {
            $.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        /**
         * @param storageVirtualMachineId Specifies the storage virtual machine in which to create the volume.
         * 
         * @return builder
         * 
         */
        public Builder storageVirtualMachineId(String storageVirtualMachineId) {
            return storageVirtualMachineId(Output.of(storageVirtualMachineId));
        }

        /**
         * @param tags A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public Builder tieringPolicy(@Nullable Output<OntapVolumeTieringPolicyArgs> tieringPolicy) {
            $.tieringPolicy = tieringPolicy;
            return this;
        }

        public Builder tieringPolicy(OntapVolumeTieringPolicyArgs tieringPolicy) {
            return tieringPolicy(Output.of(tieringPolicy));
        }

        /**
         * @param volumeType The type of volume, currently the only valid value is `ONTAP`.
         * 
         * @return builder
         * 
         */
        public Builder volumeType(@Nullable Output<String> volumeType) {
            $.volumeType = volumeType;
            return this;
        }

        /**
         * @param volumeType The type of volume, currently the only valid value is `ONTAP`.
         * 
         * @return builder
         * 
         */
        public Builder volumeType(String volumeType) {
            return volumeType(Output.of(volumeType));
        }

        public OntapVolumeArgs build() {
            $.sizeInMegabytes = Objects.requireNonNull($.sizeInMegabytes, "expected parameter 'sizeInMegabytes' to be non-null");
            $.storageVirtualMachineId = Objects.requireNonNull($.storageVirtualMachineId, "expected parameter 'storageVirtualMachineId' to be non-null");
            return $;
        }
    }

}
