// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx;

import com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs;
import com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FileCacheArgs extends com.pulumi.resources.ResourceArgs {

    public static final FileCacheArgs Empty = new FileCacheArgs();

    /**
     * A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     * 
     */
    @Import(name="copyTagsToDataRepositoryAssociations")
    private @Nullable Output<Boolean> copyTagsToDataRepositoryAssociations;

    /**
     * @return A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToDataRepositoryAssociations() {
        return Optional.ofNullable(this.copyTagsToDataRepositoryAssociations);
    }

    /**
     * See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can&#39;t link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     * 
     */
    @Import(name="dataRepositoryAssociations")
    private @Nullable Output<List<FileCacheDataRepositoryAssociationArgs>> dataRepositoryAssociations;

    /**
     * @return See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can&#39;t link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     * 
     */
    public Optional<Output<List<FileCacheDataRepositoryAssociationArgs>>> dataRepositoryAssociations() {
        return Optional.ofNullable(this.dataRepositoryAssociations);
    }

    /**
     * The type of cache that you&#39;re creating. The only supported value is `LUSTRE`.
     * 
     */
    @Import(name="fileCacheType", required=true)
    private Output<String> fileCacheType;

    /**
     * @return The type of cache that you&#39;re creating. The only supported value is `LUSTRE`.
     * 
     */
    public Output<String> fileCacheType() {
        return this.fileCacheType;
    }

    /**
     * The version for the type of cache that you&#39;re creating. The only supported value is `2.12`.
     * 
     */
    @Import(name="fileCacheTypeVersion", required=true)
    private Output<String> fileCacheTypeVersion;

    /**
     * @return The version for the type of cache that you&#39;re creating. The only supported value is `2.12`.
     * 
     */
    public Output<String> fileCacheTypeVersion() {
        return this.fileCacheTypeVersion;
    }

    /**
     * Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn&#39;t specified, the Amazon FSx-managed AWS KMS key for your account is used.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn&#39;t specified, the Amazon FSx-managed AWS KMS key for your account is used.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     * 
     */
    @Import(name="lustreConfigurations")
    private @Nullable Output<List<FileCacheLustreConfigurationArgs>> lustreConfigurations;

    /**
     * @return See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     * 
     */
    public Optional<Output<List<FileCacheLustreConfigurationArgs>>> lustreConfigurations() {
        return Optional.ofNullable(this.lustreConfigurations);
    }

    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     * 
     */
    @Import(name="storageCapacity", required=true)
    private Output<Integer> storageCapacity;

    /**
     * @return The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     * 
     */
    public Output<Integer> storageCapacity() {
        return this.storageCapacity;
    }

    /**
     * A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="subnetIds", required=true)
    private Output<List<String>> subnetIds;

    /**
     * @return A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }

    /**
     * A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private FileCacheArgs() {}

    private FileCacheArgs(FileCacheArgs $) {
        this.copyTagsToDataRepositoryAssociations = $.copyTagsToDataRepositoryAssociations;
        this.dataRepositoryAssociations = $.dataRepositoryAssociations;
        this.fileCacheType = $.fileCacheType;
        this.fileCacheTypeVersion = $.fileCacheTypeVersion;
        this.kmsKeyId = $.kmsKeyId;
        this.lustreConfigurations = $.lustreConfigurations;
        this.securityGroupIds = $.securityGroupIds;
        this.storageCapacity = $.storageCapacity;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FileCacheArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FileCacheArgs $;

        public Builder() {
            $ = new FileCacheArgs();
        }

        public Builder(FileCacheArgs defaults) {
            $ = new FileCacheArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param copyTagsToDataRepositoryAssociations A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToDataRepositoryAssociations(@Nullable Output<Boolean> copyTagsToDataRepositoryAssociations) {
            $.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
            return this;
        }

        /**
         * @param copyTagsToDataRepositoryAssociations A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            return copyTagsToDataRepositoryAssociations(Output.of(copyTagsToDataRepositoryAssociations));
        }

        /**
         * @param dataRepositoryAssociations See the `data_repository_association` configuration block. Max of 8.
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can&#39;t link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
         * 
         * @return builder
         * 
         */
        public Builder dataRepositoryAssociations(@Nullable Output<List<FileCacheDataRepositoryAssociationArgs>> dataRepositoryAssociations) {
            $.dataRepositoryAssociations = dataRepositoryAssociations;
            return this;
        }

        /**
         * @param dataRepositoryAssociations See the `data_repository_association` configuration block. Max of 8.
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can&#39;t link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
         * 
         * @return builder
         * 
         */
        public Builder dataRepositoryAssociations(List<FileCacheDataRepositoryAssociationArgs> dataRepositoryAssociations) {
            return dataRepositoryAssociations(Output.of(dataRepositoryAssociations));
        }

        /**
         * @param dataRepositoryAssociations See the `data_repository_association` configuration block. Max of 8.
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can&#39;t link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
         * 
         * @return builder
         * 
         */
        public Builder dataRepositoryAssociations(FileCacheDataRepositoryAssociationArgs... dataRepositoryAssociations) {
            return dataRepositoryAssociations(List.of(dataRepositoryAssociations));
        }

        /**
         * @param fileCacheType The type of cache that you&#39;re creating. The only supported value is `LUSTRE`.
         * 
         * @return builder
         * 
         */
        public Builder fileCacheType(Output<String> fileCacheType) {
            $.fileCacheType = fileCacheType;
            return this;
        }

        /**
         * @param fileCacheType The type of cache that you&#39;re creating. The only supported value is `LUSTRE`.
         * 
         * @return builder
         * 
         */
        public Builder fileCacheType(String fileCacheType) {
            return fileCacheType(Output.of(fileCacheType));
        }

        /**
         * @param fileCacheTypeVersion The version for the type of cache that you&#39;re creating. The only supported value is `2.12`.
         * 
         * @return builder
         * 
         */
        public Builder fileCacheTypeVersion(Output<String> fileCacheTypeVersion) {
            $.fileCacheTypeVersion = fileCacheTypeVersion;
            return this;
        }

        /**
         * @param fileCacheTypeVersion The version for the type of cache that you&#39;re creating. The only supported value is `2.12`.
         * 
         * @return builder
         * 
         */
        public Builder fileCacheTypeVersion(String fileCacheTypeVersion) {
            return fileCacheTypeVersion(Output.of(fileCacheTypeVersion));
        }

        /**
         * @param kmsKeyId Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn&#39;t specified, the Amazon FSx-managed AWS KMS key for your account is used.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn&#39;t specified, the Amazon FSx-managed AWS KMS key for your account is used.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param lustreConfigurations See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
         * 
         * @return builder
         * 
         */
        public Builder lustreConfigurations(@Nullable Output<List<FileCacheLustreConfigurationArgs>> lustreConfigurations) {
            $.lustreConfigurations = lustreConfigurations;
            return this;
        }

        /**
         * @param lustreConfigurations See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
         * 
         * @return builder
         * 
         */
        public Builder lustreConfigurations(List<FileCacheLustreConfigurationArgs> lustreConfigurations) {
            return lustreConfigurations(Output.of(lustreConfigurations));
        }

        /**
         * @param lustreConfigurations See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
         * 
         * @return builder
         * 
         */
        public Builder lustreConfigurations(FileCacheLustreConfigurationArgs... lustreConfigurations) {
            return lustreConfigurations(List.of(lustreConfigurations));
        }

        /**
         * @param securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param storageCapacity The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacity(Output<Integer> storageCapacity) {
            $.storageCapacity = storageCapacity;
            return this;
        }

        /**
         * @param storageCapacity The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
         * 
         * @return builder
         * 
         */
        public Builder storageCapacity(Integer storageCapacity) {
            return storageCapacity(Output.of(storageCapacity));
        }

        /**
         * @param subnetIds A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        /**
         * @param tags A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public FileCacheArgs build() {
            $.fileCacheType = Objects.requireNonNull($.fileCacheType, "expected parameter 'fileCacheType' to be non-null");
            $.fileCacheTypeVersion = Objects.requireNonNull($.fileCacheTypeVersion, "expected parameter 'fileCacheTypeVersion' to be non-null");
            $.storageCapacity = Objects.requireNonNull($.storageCapacity, "expected parameter 'storageCapacity' to be non-null");
            $.subnetIds = Objects.requireNonNull($.subnetIds, "expected parameter 'subnetIds' to be non-null");
            return $;
        }
    }

}
