// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fsx;

import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DataRepositoryAssociationArgs extends com.pulumi.resources.ResourceArgs {

    public static final DataRepositoryAssociationArgs Empty = new DataRepositoryAssociationArgs();

    /**
     * Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
     * 
     */
    @Import(name="batchImportMetaDataOnCreate")
    private @Nullable Output<Boolean> batchImportMetaDataOnCreate;

    /**
     * @return Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> batchImportMetaDataOnCreate() {
        return Optional.ofNullable(this.batchImportMetaDataOnCreate);
    }

    /**
     * The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
     * 
     */
    @Import(name="dataRepositoryPath", required=true)
    private Output<String> dataRepositoryPath;

    /**
     * @return The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
     * 
     */
    public Output<String> dataRepositoryPath() {
        return this.dataRepositoryPath;
    }

    /**
     * Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
     * 
     */
    @Import(name="deleteDataInFilesystem")
    private @Nullable Output<Boolean> deleteDataInFilesystem;

    /**
     * @return Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> deleteDataInFilesystem() {
        return Optional.ofNullable(this.deleteDataInFilesystem);
    }

    /**
     * The ID of the Amazon FSx file system to on which to create a data repository association.
     * 
     */
    @Import(name="fileSystemId", required=true)
    private Output<String> fileSystemId;

    /**
     * @return The ID of the Amazon FSx file system to on which to create a data repository association.
     * 
     */
    public Output<String> fileSystemId() {
        return this.fileSystemId;
    }

    /**
     * A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     * 
     */
    @Import(name="fileSystemPath", required=true)
    private Output<String> fileSystemPath;

    /**
     * @return A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     * 
     */
    public Output<String> fileSystemPath() {
        return this.fileSystemPath;
    }

    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     * 
     */
    @Import(name="importedFileChunkSize")
    private @Nullable Output<Integer> importedFileChunkSize;

    /**
     * @return For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     * 
     */
    public Optional<Output<Integer>> importedFileChunkSize() {
        return Optional.ofNullable(this.importedFileChunkSize);
    }

    /**
     * See the `s3` configuration block. Max of 1.
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     * 
     */
    @Import(name="s3")
    private @Nullable Output<DataRepositoryAssociationS3Args> s3;

    /**
     * @return See the `s3` configuration block. Max of 1.
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     * 
     */
    public Optional<Output<DataRepositoryAssociationS3Args>> s3() {
        return Optional.ofNullable(this.s3);
    }

    /**
     * A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private DataRepositoryAssociationArgs() {}

    private DataRepositoryAssociationArgs(DataRepositoryAssociationArgs $) {
        this.batchImportMetaDataOnCreate = $.batchImportMetaDataOnCreate;
        this.dataRepositoryPath = $.dataRepositoryPath;
        this.deleteDataInFilesystem = $.deleteDataInFilesystem;
        this.fileSystemId = $.fileSystemId;
        this.fileSystemPath = $.fileSystemPath;
        this.importedFileChunkSize = $.importedFileChunkSize;
        this.s3 = $.s3;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DataRepositoryAssociationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DataRepositoryAssociationArgs $;

        public Builder() {
            $ = new DataRepositoryAssociationArgs();
        }

        public Builder(DataRepositoryAssociationArgs defaults) {
            $ = new DataRepositoryAssociationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param batchImportMetaDataOnCreate Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder batchImportMetaDataOnCreate(@Nullable Output<Boolean> batchImportMetaDataOnCreate) {
            $.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
            return this;
        }

        /**
         * @param batchImportMetaDataOnCreate Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder batchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            return batchImportMetaDataOnCreate(Output.of(batchImportMetaDataOnCreate));
        }

        /**
         * @param dataRepositoryPath The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
         * 
         * @return builder
         * 
         */
        public Builder dataRepositoryPath(Output<String> dataRepositoryPath) {
            $.dataRepositoryPath = dataRepositoryPath;
            return this;
        }

        /**
         * @param dataRepositoryPath The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
         * 
         * @return builder
         * 
         */
        public Builder dataRepositoryPath(String dataRepositoryPath) {
            return dataRepositoryPath(Output.of(dataRepositoryPath));
        }

        /**
         * @param deleteDataInFilesystem Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder deleteDataInFilesystem(@Nullable Output<Boolean> deleteDataInFilesystem) {
            $.deleteDataInFilesystem = deleteDataInFilesystem;
            return this;
        }

        /**
         * @param deleteDataInFilesystem Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder deleteDataInFilesystem(Boolean deleteDataInFilesystem) {
            return deleteDataInFilesystem(Output.of(deleteDataInFilesystem));
        }

        /**
         * @param fileSystemId The ID of the Amazon FSx file system to on which to create a data repository association.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemId(Output<String> fileSystemId) {
            $.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * @param fileSystemId The ID of the Amazon FSx file system to on which to create a data repository association.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemId(String fileSystemId) {
            return fileSystemId(Output.of(fileSystemId));
        }

        /**
         * @param fileSystemPath A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemPath(Output<String> fileSystemPath) {
            $.fileSystemPath = fileSystemPath;
            return this;
        }

        /**
         * @param fileSystemPath A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemPath(String fileSystemPath) {
            return fileSystemPath(Output.of(fileSystemPath));
        }

        /**
         * @param importedFileChunkSize For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         * 
         * @return builder
         * 
         */
        public Builder importedFileChunkSize(@Nullable Output<Integer> importedFileChunkSize) {
            $.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        /**
         * @param importedFileChunkSize For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         * 
         * @return builder
         * 
         */
        public Builder importedFileChunkSize(Integer importedFileChunkSize) {
            return importedFileChunkSize(Output.of(importedFileChunkSize));
        }

        /**
         * @param s3 See the `s3` configuration block. Max of 1.
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         * 
         * @return builder
         * 
         */
        public Builder s3(@Nullable Output<DataRepositoryAssociationS3Args> s3) {
            $.s3 = s3;
            return this;
        }

        /**
         * @param s3 See the `s3` configuration block. Max of 1.
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         * 
         * @return builder
         * 
         */
        public Builder s3(DataRepositoryAssociationS3Args s3) {
            return s3(Output.of(s3));
        }

        /**
         * @param tags A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public DataRepositoryAssociationArgs build() {
            $.dataRepositoryPath = Objects.requireNonNull($.dataRepositoryPath, "expected parameter 'dataRepositoryPath' to be non-null");
            $.fileSystemId = Objects.requireNonNull($.fileSystemId, "expected parameter 'fileSystemId' to be non-null");
            $.fileSystemPath = Objects.requireNonNull($.fileSystemPath, "expected parameter 'fileSystemPath' to be non-null");
            return $;
        }
    }

}
