// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fms;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.fms.AdminAccountArgs;
import com.pulumi.aws.fms.inputs.AdminAccountState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a resource to associate/disassociate an AWS Firewall Manager administrator account. This operation must be performed in the `us-east-1` region.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fms.AdminAccount;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AdminAccount(&#34;example&#34;);
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Firewall Manager administrator account association using the account ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:fms/adminAccount:AdminAccount example 123456789012
 * ```
 * 
 */
@ResourceType(type="aws:fms/adminAccount:AdminAccount")
public class AdminAccount extends com.pulumi.resources.CustomResource {
    /**
     * The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall Manager administrator account. This can be an AWS Organizations master account or a member account. Defaults to the current account. Must be configured to perform drift detection.
     * 
     */
    @Export(name="accountId", refs={String.class}, tree="[0]")
    private Output<String> accountId;

    /**
     * @return The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall Manager administrator account. This can be an AWS Organizations master account or a member account. Defaults to the current account. Must be configured to perform drift detection.
     * 
     */
    public Output<String> accountId() {
        return this.accountId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AdminAccount(String name) {
        this(name, AdminAccountArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AdminAccount(String name, @Nullable AdminAccountArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AdminAccount(String name, @Nullable AdminAccountArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:fms/adminAccount:AdminAccount", name, args == null ? AdminAccountArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AdminAccount(String name, Output<String> id, @Nullable AdminAccountState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:fms/adminAccount:AdminAccount", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AdminAccount get(String name, Output<String> id, @Nullable AdminAccountState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AdminAccount(name, id, state, options);
    }
}
