// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.fis.outputs;

import com.pulumi.aws.fis.outputs.ExperimentTemplateActionParameter;
import com.pulumi.aws.fis.outputs.ExperimentTemplateActionTarget;
import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ExperimentTemplateAction {
    /**
     * @return ID of the action. To find out what actions are supported see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
     * 
     */
    private String actionId;
    /**
     * @return Description of the action.
     * 
     */
    private @Nullable String description;
    /**
     * @return Friendly name of the action.
     * 
     */
    private String name;
    /**
     * @return Parameter(s) for the action, if applicable. See below.
     * 
     */
    private @Nullable List<ExperimentTemplateActionParameter> parameters;
    /**
     * @return Set of action names that must complete before this action can be executed.
     * 
     */
    private @Nullable List<String> startAfters;
    /**
     * @return Action&#39;s target, if applicable. See below.
     * 
     */
    private @Nullable ExperimentTemplateActionTarget target;

    private ExperimentTemplateAction() {}
    /**
     * @return ID of the action. To find out what actions are supported see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
     * 
     */
    public String actionId() {
        return this.actionId;
    }
    /**
     * @return Description of the action.
     * 
     */
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }
    /**
     * @return Friendly name of the action.
     * 
     */
    public String name() {
        return this.name;
    }
    /**
     * @return Parameter(s) for the action, if applicable. See below.
     * 
     */
    public List<ExperimentTemplateActionParameter> parameters() {
        return this.parameters == null ? List.of() : this.parameters;
    }
    /**
     * @return Set of action names that must complete before this action can be executed.
     * 
     */
    public List<String> startAfters() {
        return this.startAfters == null ? List.of() : this.startAfters;
    }
    /**
     * @return Action&#39;s target, if applicable. See below.
     * 
     */
    public Optional<ExperimentTemplateActionTarget> target() {
        return Optional.ofNullable(this.target);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ExperimentTemplateAction defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String actionId;
        private @Nullable String description;
        private String name;
        private @Nullable List<ExperimentTemplateActionParameter> parameters;
        private @Nullable List<String> startAfters;
        private @Nullable ExperimentTemplateActionTarget target;
        public Builder() {}
        public Builder(ExperimentTemplateAction defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.actionId = defaults.actionId;
    	      this.description = defaults.description;
    	      this.name = defaults.name;
    	      this.parameters = defaults.parameters;
    	      this.startAfters = defaults.startAfters;
    	      this.target = defaults.target;
        }

        @CustomType.Setter
        public Builder actionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId);
            return this;
        }
        @CustomType.Setter
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }
        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }
        @CustomType.Setter
        public Builder parameters(@Nullable List<ExperimentTemplateActionParameter> parameters) {
            this.parameters = parameters;
            return this;
        }
        public Builder parameters(ExperimentTemplateActionParameter... parameters) {
            return parameters(List.of(parameters));
        }
        @CustomType.Setter
        public Builder startAfters(@Nullable List<String> startAfters) {
            this.startAfters = startAfters;
            return this;
        }
        public Builder startAfters(String... startAfters) {
            return startAfters(List.of(startAfters));
        }
        @CustomType.Setter
        public Builder target(@Nullable ExperimentTemplateActionTarget target) {
            this.target = target;
            return this;
        }
        public ExperimentTemplateAction build() {
            final var o = new ExperimentTemplateAction();
            o.actionId = actionId;
            o.description = description;
            o.name = name;
            o.parameters = parameters;
            o.startAfters = startAfters;
            o.target = target;
            return o;
        }
    }
}
