// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.finspace.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Double;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;

@CustomType
public final class KxClusterAutoScalingConfiguration {
    /**
     * @return Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
     * 
     */
    private String autoScalingMetric;
    /**
     * @return Highest number of nodes to scale. Cannot be greater than 5
     * 
     */
    private Integer maxNodeCount;
    /**
     * @return Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
     * 
     */
    private Double metricTarget;
    /**
     * @return Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
     * 
     */
    private Integer minNodeCount;
    /**
     * @return Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     * 
     */
    private Double scaleInCooldownSeconds;
    /**
     * @return Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     * 
     */
    private Double scaleOutCooldownSeconds;

    private KxClusterAutoScalingConfiguration() {}
    /**
     * @return Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
     * 
     */
    public String autoScalingMetric() {
        return this.autoScalingMetric;
    }
    /**
     * @return Highest number of nodes to scale. Cannot be greater than 5
     * 
     */
    public Integer maxNodeCount() {
        return this.maxNodeCount;
    }
    /**
     * @return Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
     * 
     */
    public Double metricTarget() {
        return this.metricTarget;
    }
    /**
     * @return Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
     * 
     */
    public Integer minNodeCount() {
        return this.minNodeCount;
    }
    /**
     * @return Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     * 
     */
    public Double scaleInCooldownSeconds() {
        return this.scaleInCooldownSeconds;
    }
    /**
     * @return Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     * 
     */
    public Double scaleOutCooldownSeconds() {
        return this.scaleOutCooldownSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KxClusterAutoScalingConfiguration defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String autoScalingMetric;
        private Integer maxNodeCount;
        private Double metricTarget;
        private Integer minNodeCount;
        private Double scaleInCooldownSeconds;
        private Double scaleOutCooldownSeconds;
        public Builder() {}
        public Builder(KxClusterAutoScalingConfiguration defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.autoScalingMetric = defaults.autoScalingMetric;
    	      this.maxNodeCount = defaults.maxNodeCount;
    	      this.metricTarget = defaults.metricTarget;
    	      this.minNodeCount = defaults.minNodeCount;
    	      this.scaleInCooldownSeconds = defaults.scaleInCooldownSeconds;
    	      this.scaleOutCooldownSeconds = defaults.scaleOutCooldownSeconds;
        }

        @CustomType.Setter
        public Builder autoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = Objects.requireNonNull(autoScalingMetric);
            return this;
        }
        @CustomType.Setter
        public Builder maxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = Objects.requireNonNull(maxNodeCount);
            return this;
        }
        @CustomType.Setter
        public Builder metricTarget(Double metricTarget) {
            this.metricTarget = Objects.requireNonNull(metricTarget);
            return this;
        }
        @CustomType.Setter
        public Builder minNodeCount(Integer minNodeCount) {
            this.minNodeCount = Objects.requireNonNull(minNodeCount);
            return this;
        }
        @CustomType.Setter
        public Builder scaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            this.scaleInCooldownSeconds = Objects.requireNonNull(scaleInCooldownSeconds);
            return this;
        }
        @CustomType.Setter
        public Builder scaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            this.scaleOutCooldownSeconds = Objects.requireNonNull(scaleOutCooldownSeconds);
            return this;
        }
        public KxClusterAutoScalingConfiguration build() {
            final var o = new KxClusterAutoScalingConfiguration();
            o.autoScalingMetric = autoScalingMetric;
            o.maxNodeCount = maxNodeCount;
            o.metricTarget = metricTarget;
            o.minNodeCount = minNodeCount;
            o.scaleInCooldownSeconds = scaleInCooldownSeconds;
            o.scaleOutCooldownSeconds = scaleOutCooldownSeconds;
            return o;
        }
    }
}
