// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.finspace.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Double;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;


public final class KxClusterAutoScalingConfigurationArgs extends com.pulumi.resources.ResourceArgs {

    public static final KxClusterAutoScalingConfigurationArgs Empty = new KxClusterAutoScalingConfigurationArgs();

    /**
     * Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
     * 
     */
    @Import(name="autoScalingMetric", required=true)
    private Output<String> autoScalingMetric;

    /**
     * @return Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
     * 
     */
    public Output<String> autoScalingMetric() {
        return this.autoScalingMetric;
    }

    /**
     * Highest number of nodes to scale. Cannot be greater than 5
     * 
     */
    @Import(name="maxNodeCount", required=true)
    private Output<Integer> maxNodeCount;

    /**
     * @return Highest number of nodes to scale. Cannot be greater than 5
     * 
     */
    public Output<Integer> maxNodeCount() {
        return this.maxNodeCount;
    }

    /**
     * Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
     * 
     */
    @Import(name="metricTarget", required=true)
    private Output<Double> metricTarget;

    /**
     * @return Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
     * 
     */
    public Output<Double> metricTarget() {
        return this.metricTarget;
    }

    /**
     * Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
     * 
     */
    @Import(name="minNodeCount", required=true)
    private Output<Integer> minNodeCount;

    /**
     * @return Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
     * 
     */
    public Output<Integer> minNodeCount() {
        return this.minNodeCount;
    }

    /**
     * Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     * 
     */
    @Import(name="scaleInCooldownSeconds", required=true)
    private Output<Double> scaleInCooldownSeconds;

    /**
     * @return Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     * 
     */
    public Output<Double> scaleInCooldownSeconds() {
        return this.scaleInCooldownSeconds;
    }

    /**
     * Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     * 
     */
    @Import(name="scaleOutCooldownSeconds", required=true)
    private Output<Double> scaleOutCooldownSeconds;

    /**
     * @return Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     * 
     */
    public Output<Double> scaleOutCooldownSeconds() {
        return this.scaleOutCooldownSeconds;
    }

    private KxClusterAutoScalingConfigurationArgs() {}

    private KxClusterAutoScalingConfigurationArgs(KxClusterAutoScalingConfigurationArgs $) {
        this.autoScalingMetric = $.autoScalingMetric;
        this.maxNodeCount = $.maxNodeCount;
        this.metricTarget = $.metricTarget;
        this.minNodeCount = $.minNodeCount;
        this.scaleInCooldownSeconds = $.scaleInCooldownSeconds;
        this.scaleOutCooldownSeconds = $.scaleOutCooldownSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(KxClusterAutoScalingConfigurationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private KxClusterAutoScalingConfigurationArgs $;

        public Builder() {
            $ = new KxClusterAutoScalingConfigurationArgs();
        }

        public Builder(KxClusterAutoScalingConfigurationArgs defaults) {
            $ = new KxClusterAutoScalingConfigurationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param autoScalingMetric Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingMetric(Output<String> autoScalingMetric) {
            $.autoScalingMetric = autoScalingMetric;
            return this;
        }

        /**
         * @param autoScalingMetric Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingMetric(String autoScalingMetric) {
            return autoScalingMetric(Output.of(autoScalingMetric));
        }

        /**
         * @param maxNodeCount Highest number of nodes to scale. Cannot be greater than 5
         * 
         * @return builder
         * 
         */
        public Builder maxNodeCount(Output<Integer> maxNodeCount) {
            $.maxNodeCount = maxNodeCount;
            return this;
        }

        /**
         * @param maxNodeCount Highest number of nodes to scale. Cannot be greater than 5
         * 
         * @return builder
         * 
         */
        public Builder maxNodeCount(Integer maxNodeCount) {
            return maxNodeCount(Output.of(maxNodeCount));
        }

        /**
         * @param metricTarget Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
         * 
         * @return builder
         * 
         */
        public Builder metricTarget(Output<Double> metricTarget) {
            $.metricTarget = metricTarget;
            return this;
        }

        /**
         * @param metricTarget Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
         * 
         * @return builder
         * 
         */
        public Builder metricTarget(Double metricTarget) {
            return metricTarget(Output.of(metricTarget));
        }

        /**
         * @param minNodeCount Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
         * 
         * @return builder
         * 
         */
        public Builder minNodeCount(Output<Integer> minNodeCount) {
            $.minNodeCount = minNodeCount;
            return this;
        }

        /**
         * @param minNodeCount Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
         * 
         * @return builder
         * 
         */
        public Builder minNodeCount(Integer minNodeCount) {
            return minNodeCount(Output.of(minNodeCount));
        }

        /**
         * @param scaleInCooldownSeconds Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
         * 
         * @return builder
         * 
         */
        public Builder scaleInCooldownSeconds(Output<Double> scaleInCooldownSeconds) {
            $.scaleInCooldownSeconds = scaleInCooldownSeconds;
            return this;
        }

        /**
         * @param scaleInCooldownSeconds Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
         * 
         * @return builder
         * 
         */
        public Builder scaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            return scaleInCooldownSeconds(Output.of(scaleInCooldownSeconds));
        }

        /**
         * @param scaleOutCooldownSeconds Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
         * 
         * @return builder
         * 
         */
        public Builder scaleOutCooldownSeconds(Output<Double> scaleOutCooldownSeconds) {
            $.scaleOutCooldownSeconds = scaleOutCooldownSeconds;
            return this;
        }

        /**
         * @param scaleOutCooldownSeconds Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
         * 
         * @return builder
         * 
         */
        public Builder scaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            return scaleOutCooldownSeconds(Output.of(scaleOutCooldownSeconds));
        }

        public KxClusterAutoScalingConfigurationArgs build() {
            $.autoScalingMetric = Objects.requireNonNull($.autoScalingMetric, "expected parameter 'autoScalingMetric' to be non-null");
            $.maxNodeCount = Objects.requireNonNull($.maxNodeCount, "expected parameter 'maxNodeCount' to be non-null");
            $.metricTarget = Objects.requireNonNull($.metricTarget, "expected parameter 'metricTarget' to be non-null");
            $.minNodeCount = Objects.requireNonNull($.minNodeCount, "expected parameter 'minNodeCount' to be non-null");
            $.scaleInCooldownSeconds = Objects.requireNonNull($.scaleInCooldownSeconds, "expected parameter 'scaleInCooldownSeconds' to be non-null");
            $.scaleOutCooldownSeconds = Objects.requireNonNull($.scaleOutCooldownSeconds, "expected parameter 'scaleOutCooldownSeconds' to be non-null");
            return $;
        }
    }

}
