// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.finspace;

import com.pulumi.aws.finspace.inputs.KxClusterAutoScalingConfigurationArgs;
import com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs;
import com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs;
import com.pulumi.aws.finspace.inputs.KxClusterCodeArgs;
import com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs;
import com.pulumi.aws.finspace.inputs.KxClusterSavedownStorageConfigurationArgs;
import com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class KxClusterArgs extends com.pulumi.resources.ResourceArgs {

    public static final KxClusterArgs Empty = new KxClusterArgs();

    /**
     * Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     * 
     */
    @Import(name="autoScalingConfiguration")
    private @Nullable Output<KxClusterAutoScalingConfigurationArgs> autoScalingConfiguration;

    /**
     * @return Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     * 
     */
    public Optional<Output<KxClusterAutoScalingConfigurationArgs>> autoScalingConfiguration() {
        return Optional.ofNullable(this.autoScalingConfiguration);
    }

    /**
     * The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     * 
     */
    @Import(name="availabilityZoneId")
    private @Nullable Output<String> availabilityZoneId;

    /**
     * @return The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     * 
     */
    public Optional<Output<String>> availabilityZoneId() {
        return Optional.ofNullable(this.availabilityZoneId);
    }

    /**
     * The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     * 
     */
    @Import(name="azMode", required=true)
    private Output<String> azMode;

    /**
     * @return The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     * 
     */
    public Output<String> azMode() {
        return this.azMode;
    }

    /**
     * Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     * 
     */
    @Import(name="cacheStorageConfigurations")
    private @Nullable Output<List<KxClusterCacheStorageConfigurationArgs>> cacheStorageConfigurations;

    /**
     * @return Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     * 
     */
    public Optional<Output<List<KxClusterCacheStorageConfigurationArgs>>> cacheStorageConfigurations() {
        return Optional.ofNullable(this.cacheStorageConfigurations);
    }

    /**
     * Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     * 
     */
    @Import(name="capacityConfiguration", required=true)
    private Output<KxClusterCapacityConfigurationArgs> capacityConfiguration;

    /**
     * @return Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     * 
     */
    public Output<KxClusterCapacityConfigurationArgs> capacityConfiguration() {
        return this.capacityConfiguration;
    }

    /**
     * Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     * 
     */
    @Import(name="code")
    private @Nullable Output<KxClusterCodeArgs> code;

    /**
     * @return Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     * 
     */
    public Optional<Output<KxClusterCodeArgs>> code() {
        return Optional.ofNullable(this.code);
    }

    /**
     * List of key-value pairs to make available inside the cluster.
     * 
     */
    @Import(name="commandLineArguments")
    private @Nullable Output<Map<String,String>> commandLineArguments;

    /**
     * @return List of key-value pairs to make available inside the cluster.
     * 
     */
    public Optional<Output<Map<String,String>>> commandLineArguments() {
        return Optional.ofNullable(this.commandLineArguments);
    }

    /**
     * KX database that will be available for querying. Defined below.
     * 
     */
    @Import(name="databases")
    private @Nullable Output<List<KxClusterDatabaseArgs>> databases;

    /**
     * @return KX database that will be available for querying. Defined below.
     * 
     */
    public Optional<Output<List<KxClusterDatabaseArgs>>> databases() {
        return Optional.ofNullable(this.databases);
    }

    /**
     * Description of the cluster.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the cluster.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Unique identifier for the KX environment.
     * 
     */
    @Import(name="environmentId", required=true)
    private Output<String> environmentId;

    /**
     * @return Unique identifier for the KX environment.
     * 
     */
    public Output<String> environmentId() {
        return this.environmentId;
    }

    /**
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     * 
     */
    @Import(name="executionRole")
    private @Nullable Output<String> executionRole;

    /**
     * @return An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     * 
     */
    public Optional<Output<String>> executionRole() {
        return Optional.ofNullable(this.executionRole);
    }

    /**
     * Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     * 
     */
    @Import(name="initializationScript")
    private @Nullable Output<String> initializationScript;

    /**
     * @return Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     * 
     */
    public Optional<Output<String>> initializationScript() {
        return Optional.ofNullable(this.initializationScript);
    }

    /**
     * Unique name for the cluster that you want to create.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Unique name for the cluster that you want to create.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Version of FinSpace Managed kdb to run.
     * 
     */
    @Import(name="releaseLabel", required=true)
    private Output<String> releaseLabel;

    /**
     * @return Version of FinSpace Managed kdb to run.
     * 
     */
    public Output<String> releaseLabel() {
        return this.releaseLabel;
    }

    /**
     * Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     * 
     */
    @Import(name="savedownStorageConfiguration")
    private @Nullable Output<KxClusterSavedownStorageConfigurationArgs> savedownStorageConfiguration;

    /**
     * @return Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     * 
     */
    public Optional<Output<KxClusterSavedownStorageConfigurationArgs>> savedownStorageConfiguration() {
        return Optional.ofNullable(this.savedownStorageConfiguration);
    }

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    /**
     * Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="vpcConfiguration", required=true)
    private Output<KxClusterVpcConfigurationArgs> vpcConfiguration;

    /**
     * @return Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<KxClusterVpcConfigurationArgs> vpcConfiguration() {
        return this.vpcConfiguration;
    }

    private KxClusterArgs() {}

    private KxClusterArgs(KxClusterArgs $) {
        this.autoScalingConfiguration = $.autoScalingConfiguration;
        this.availabilityZoneId = $.availabilityZoneId;
        this.azMode = $.azMode;
        this.cacheStorageConfigurations = $.cacheStorageConfigurations;
        this.capacityConfiguration = $.capacityConfiguration;
        this.code = $.code;
        this.commandLineArguments = $.commandLineArguments;
        this.databases = $.databases;
        this.description = $.description;
        this.environmentId = $.environmentId;
        this.executionRole = $.executionRole;
        this.initializationScript = $.initializationScript;
        this.name = $.name;
        this.releaseLabel = $.releaseLabel;
        this.savedownStorageConfiguration = $.savedownStorageConfiguration;
        this.tags = $.tags;
        this.type = $.type;
        this.vpcConfiguration = $.vpcConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(KxClusterArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private KxClusterArgs $;

        public Builder() {
            $ = new KxClusterArgs();
        }

        public Builder(KxClusterArgs defaults) {
            $ = new KxClusterArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param autoScalingConfiguration Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingConfiguration(@Nullable Output<KxClusterAutoScalingConfigurationArgs> autoScalingConfiguration) {
            $.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        /**
         * @param autoScalingConfiguration Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingConfiguration(KxClusterAutoScalingConfigurationArgs autoScalingConfiguration) {
            return autoScalingConfiguration(Output.of(autoScalingConfiguration));
        }

        /**
         * @param availabilityZoneId The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneId(@Nullable Output<String> availabilityZoneId) {
            $.availabilityZoneId = availabilityZoneId;
            return this;
        }

        /**
         * @param availabilityZoneId The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneId(String availabilityZoneId) {
            return availabilityZoneId(Output.of(availabilityZoneId));
        }

        /**
         * @param azMode The number of availability zones you want to assign per cluster. This can be one of the following:
         * * SINGLE - Assigns one availability zone per cluster.
         * * MULTI - Assigns all the availability zones per cluster.
         * 
         * @return builder
         * 
         */
        public Builder azMode(Output<String> azMode) {
            $.azMode = azMode;
            return this;
        }

        /**
         * @param azMode The number of availability zones you want to assign per cluster. This can be one of the following:
         * * SINGLE - Assigns one availability zone per cluster.
         * * MULTI - Assigns all the availability zones per cluster.
         * 
         * @return builder
         * 
         */
        public Builder azMode(String azMode) {
            return azMode(Output.of(azMode));
        }

        /**
         * @param cacheStorageConfigurations Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
         * 
         * @return builder
         * 
         */
        public Builder cacheStorageConfigurations(@Nullable Output<List<KxClusterCacheStorageConfigurationArgs>> cacheStorageConfigurations) {
            $.cacheStorageConfigurations = cacheStorageConfigurations;
            return this;
        }

        /**
         * @param cacheStorageConfigurations Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
         * 
         * @return builder
         * 
         */
        public Builder cacheStorageConfigurations(List<KxClusterCacheStorageConfigurationArgs> cacheStorageConfigurations) {
            return cacheStorageConfigurations(Output.of(cacheStorageConfigurations));
        }

        /**
         * @param cacheStorageConfigurations Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
         * 
         * @return builder
         * 
         */
        public Builder cacheStorageConfigurations(KxClusterCacheStorageConfigurationArgs... cacheStorageConfigurations) {
            return cacheStorageConfigurations(List.of(cacheStorageConfigurations));
        }

        /**
         * @param capacityConfiguration Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
         * 
         * @return builder
         * 
         */
        public Builder capacityConfiguration(Output<KxClusterCapacityConfigurationArgs> capacityConfiguration) {
            $.capacityConfiguration = capacityConfiguration;
            return this;
        }

        /**
         * @param capacityConfiguration Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
         * 
         * @return builder
         * 
         */
        public Builder capacityConfiguration(KxClusterCapacityConfigurationArgs capacityConfiguration) {
            return capacityConfiguration(Output.of(capacityConfiguration));
        }

        /**
         * @param code Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
         * 
         * @return builder
         * 
         */
        public Builder code(@Nullable Output<KxClusterCodeArgs> code) {
            $.code = code;
            return this;
        }

        /**
         * @param code Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
         * 
         * @return builder
         * 
         */
        public Builder code(KxClusterCodeArgs code) {
            return code(Output.of(code));
        }

        /**
         * @param commandLineArguments List of key-value pairs to make available inside the cluster.
         * 
         * @return builder
         * 
         */
        public Builder commandLineArguments(@Nullable Output<Map<String,String>> commandLineArguments) {
            $.commandLineArguments = commandLineArguments;
            return this;
        }

        /**
         * @param commandLineArguments List of key-value pairs to make available inside the cluster.
         * 
         * @return builder
         * 
         */
        public Builder commandLineArguments(Map<String,String> commandLineArguments) {
            return commandLineArguments(Output.of(commandLineArguments));
        }

        /**
         * @param databases KX database that will be available for querying. Defined below.
         * 
         * @return builder
         * 
         */
        public Builder databases(@Nullable Output<List<KxClusterDatabaseArgs>> databases) {
            $.databases = databases;
            return this;
        }

        /**
         * @param databases KX database that will be available for querying. Defined below.
         * 
         * @return builder
         * 
         */
        public Builder databases(List<KxClusterDatabaseArgs> databases) {
            return databases(Output.of(databases));
        }

        /**
         * @param databases KX database that will be available for querying. Defined below.
         * 
         * @return builder
         * 
         */
        public Builder databases(KxClusterDatabaseArgs... databases) {
            return databases(List.of(databases));
        }

        /**
         * @param description Description of the cluster.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the cluster.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param environmentId Unique identifier for the KX environment.
         * 
         * @return builder
         * 
         */
        public Builder environmentId(Output<String> environmentId) {
            $.environmentId = environmentId;
            return this;
        }

        /**
         * @param environmentId Unique identifier for the KX environment.
         * 
         * @return builder
         * 
         */
        public Builder environmentId(String environmentId) {
            return environmentId(Output.of(environmentId));
        }

        /**
         * @param executionRole An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
         * 
         * @return builder
         * 
         */
        public Builder executionRole(@Nullable Output<String> executionRole) {
            $.executionRole = executionRole;
            return this;
        }

        /**
         * @param executionRole An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
         * 
         * @return builder
         * 
         */
        public Builder executionRole(String executionRole) {
            return executionRole(Output.of(executionRole));
        }

        /**
         * @param initializationScript Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
         * 
         * @return builder
         * 
         */
        public Builder initializationScript(@Nullable Output<String> initializationScript) {
            $.initializationScript = initializationScript;
            return this;
        }

        /**
         * @param initializationScript Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
         * 
         * @return builder
         * 
         */
        public Builder initializationScript(String initializationScript) {
            return initializationScript(Output.of(initializationScript));
        }

        /**
         * @param name Unique name for the cluster that you want to create.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Unique name for the cluster that you want to create.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param releaseLabel Version of FinSpace Managed kdb to run.
         * 
         * @return builder
         * 
         */
        public Builder releaseLabel(Output<String> releaseLabel) {
            $.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * @param releaseLabel Version of FinSpace Managed kdb to run.
         * 
         * @return builder
         * 
         */
        public Builder releaseLabel(String releaseLabel) {
            return releaseLabel(Output.of(releaseLabel));
        }

        /**
         * @param savedownStorageConfiguration Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
         * 
         * @return builder
         * 
         */
        public Builder savedownStorageConfiguration(@Nullable Output<KxClusterSavedownStorageConfigurationArgs> savedownStorageConfiguration) {
            $.savedownStorageConfiguration = savedownStorageConfiguration;
            return this;
        }

        /**
         * @param savedownStorageConfiguration Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
         * 
         * @return builder
         * 
         */
        public Builder savedownStorageConfiguration(KxClusterSavedownStorageConfigurationArgs savedownStorageConfiguration) {
            return savedownStorageConfiguration(Output.of(savedownStorageConfiguration));
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param type Type of KDB database. The following types are available:
         * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
         * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
         * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of KDB database. The following types are available:
         * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
         * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
         * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param vpcConfiguration Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder vpcConfiguration(Output<KxClusterVpcConfigurationArgs> vpcConfiguration) {
            $.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * @param vpcConfiguration Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder vpcConfiguration(KxClusterVpcConfigurationArgs vpcConfiguration) {
            return vpcConfiguration(Output.of(vpcConfiguration));
        }

        public KxClusterArgs build() {
            $.azMode = Objects.requireNonNull($.azMode, "expected parameter 'azMode' to be non-null");
            $.capacityConfiguration = Objects.requireNonNull($.capacityConfiguration, "expected parameter 'capacityConfiguration' to be non-null");
            $.environmentId = Objects.requireNonNull($.environmentId, "expected parameter 'environmentId' to be non-null");
            $.releaseLabel = Objects.requireNonNull($.releaseLabel, "expected parameter 'releaseLabel' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            $.vpcConfiguration = Objects.requireNonNull($.vpcConfiguration, "expected parameter 'vpcConfiguration' to be non-null");
            return $;
        }
    }

}
