// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.finspace;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.finspace.KxClusterArgs;
import com.pulumi.aws.finspace.inputs.KxClusterState;
import com.pulumi.aws.finspace.outputs.KxClusterAutoScalingConfiguration;
import com.pulumi.aws.finspace.outputs.KxClusterCacheStorageConfiguration;
import com.pulumi.aws.finspace.outputs.KxClusterCapacityConfiguration;
import com.pulumi.aws.finspace.outputs.KxClusterCode;
import com.pulumi.aws.finspace.outputs.KxClusterDatabase;
import com.pulumi.aws.finspace.outputs.KxClusterSavedownStorageConfiguration;
import com.pulumi.aws.finspace.outputs.KxClusterVpcConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS FinSpace Kx Cluster.
 * 
 * ## Example Usage
 * ### Basic Usage
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxCluster;
 * import com.pulumi.aws.finspace.KxClusterArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new KxCluster(&#34;example&#34;, KxClusterArgs.builder()        
 *             .environmentId(aws_finspace_kx_environment.example().id())
 *             .type(&#34;HDB&#34;)
 *             .releaseLabel(&#34;1.0&#34;)
 *             .azMode(&#34;SINGLE&#34;)
 *             .availabilityZoneId(&#34;use1-az2&#34;)
 *             .capacityConfiguration(KxClusterCapacityConfigurationArgs.builder()
 *                 .nodeType(&#34;kx.s.2xlarge&#34;)
 *                 .nodeCount(2)
 *                 .build())
 *             .vpcConfiguration(KxClusterVpcConfigurationArgs.builder()
 *                 .vpcId(aws_vpc.test().id())
 *                 .securityGroupIds(aws_security_group.example().id())
 *                 .subnetIds(aws_subnet.example().id())
 *                 .ipAddressType(&#34;IP_V4&#34;)
 *                 .build())
 *             .cacheStorageConfigurations(KxClusterCacheStorageConfigurationArgs.builder()
 *                 .type(&#34;CACHE_1000&#34;)
 *                 .size(1200)
 *                 .build())
 *             .databases(KxClusterDatabaseArgs.builder()
 *                 .databaseName(aws_finspace_kx_database.example().name())
 *                 .cacheConfiguration(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .code(KxClusterCodeArgs.builder()
 *                 .s3Bucket(aws_s3_bucket.test().id())
 *                 .s3Key(aws_s3_object.object().key())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:
 * 
 * ```sh
 *  $ pulumi import aws:finspace/kxCluster:KxCluster example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-cluster
 * ```
 * 
 */
@ResourceType(type="aws:finspace/kxCluster:KxCluster")
public class KxCluster extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) identifier of the KX cluster.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) identifier of the KX cluster.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     * 
     */
    @Export(name="autoScalingConfiguration", refs={KxClusterAutoScalingConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ KxClusterAutoScalingConfiguration> autoScalingConfiguration;

    /**
     * @return Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     * 
     */
    public Output<Optional<KxClusterAutoScalingConfiguration>> autoScalingConfiguration() {
        return Codegen.optional(this.autoScalingConfiguration);
    }
    /**
     * The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     * 
     */
    @Export(name="availabilityZoneId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> availabilityZoneId;

    /**
     * @return The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     * 
     */
    public Output<Optional<String>> availabilityZoneId() {
        return Codegen.optional(this.availabilityZoneId);
    }
    /**
     * The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     * 
     */
    @Export(name="azMode", refs={String.class}, tree="[0]")
    private Output<String> azMode;

    /**
     * @return The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     * 
     */
    public Output<String> azMode() {
        return this.azMode;
    }
    /**
     * Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     * 
     */
    @Export(name="cacheStorageConfigurations", refs={List.class,KxClusterCacheStorageConfiguration.class}, tree="[0,1]")
    private Output</* @Nullable */ List<KxClusterCacheStorageConfiguration>> cacheStorageConfigurations;

    /**
     * @return Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     * 
     */
    public Output<Optional<List<KxClusterCacheStorageConfiguration>>> cacheStorageConfigurations() {
        return Codegen.optional(this.cacheStorageConfigurations);
    }
    /**
     * Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     * 
     */
    @Export(name="capacityConfiguration", refs={KxClusterCapacityConfiguration.class}, tree="[0]")
    private Output<KxClusterCapacityConfiguration> capacityConfiguration;

    /**
     * @return Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     * 
     */
    public Output<KxClusterCapacityConfiguration> capacityConfiguration() {
        return this.capacityConfiguration;
    }
    /**
     * Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     * 
     */
    @Export(name="code", refs={KxClusterCode.class}, tree="[0]")
    private Output</* @Nullable */ KxClusterCode> code;

    /**
     * @return Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     * 
     */
    public Output<Optional<KxClusterCode>> code() {
        return Codegen.optional(this.code);
    }
    /**
     * List of key-value pairs to make available inside the cluster.
     * 
     */
    @Export(name="commandLineArguments", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> commandLineArguments;

    /**
     * @return List of key-value pairs to make available inside the cluster.
     * 
     */
    public Output<Optional<Map<String,String>>> commandLineArguments() {
        return Codegen.optional(this.commandLineArguments);
    }
    /**
     * Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     * 
     */
    @Export(name="createdTimestamp", refs={String.class}, tree="[0]")
    private Output<String> createdTimestamp;

    /**
     * @return Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     * 
     */
    public Output<String> createdTimestamp() {
        return this.createdTimestamp;
    }
    /**
     * KX database that will be available for querying. Defined below.
     * 
     */
    @Export(name="databases", refs={List.class,KxClusterDatabase.class}, tree="[0,1]")
    private Output</* @Nullable */ List<KxClusterDatabase>> databases;

    /**
     * @return KX database that will be available for querying. Defined below.
     * 
     */
    public Output<Optional<List<KxClusterDatabase>>> databases() {
        return Codegen.optional(this.databases);
    }
    /**
     * Description of the cluster.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the cluster.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Unique identifier for the KX environment.
     * 
     */
    @Export(name="environmentId", refs={String.class}, tree="[0]")
    private Output<String> environmentId;

    /**
     * @return Unique identifier for the KX environment.
     * 
     */
    public Output<String> environmentId() {
        return this.environmentId;
    }
    /**
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     * 
     */
    @Export(name="executionRole", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> executionRole;

    /**
     * @return An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     * 
     */
    public Output<Optional<String>> executionRole() {
        return Codegen.optional(this.executionRole);
    }
    /**
     * Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     * 
     */
    @Export(name="initializationScript", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> initializationScript;

    /**
     * @return Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     * 
     */
    public Output<Optional<String>> initializationScript() {
        return Codegen.optional(this.initializationScript);
    }
    /**
     * Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     * 
     */
    @Export(name="lastModifiedTimestamp", refs={String.class}, tree="[0]")
    private Output<String> lastModifiedTimestamp;

    /**
     * @return Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     * 
     */
    public Output<String> lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }
    /**
     * Unique name for the cluster that you want to create.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Unique name for the cluster that you want to create.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Version of FinSpace Managed kdb to run.
     * 
     */
    @Export(name="releaseLabel", refs={String.class}, tree="[0]")
    private Output<String> releaseLabel;

    /**
     * @return Version of FinSpace Managed kdb to run.
     * 
     */
    public Output<String> releaseLabel() {
        return this.releaseLabel;
    }
    /**
     * Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     * 
     */
    @Export(name="savedownStorageConfiguration", refs={KxClusterSavedownStorageConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ KxClusterSavedownStorageConfiguration> savedownStorageConfiguration;

    /**
     * @return Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     * 
     */
    public Output<Optional<KxClusterSavedownStorageConfiguration>> savedownStorageConfiguration() {
        return Codegen.optional(this.savedownStorageConfiguration);
    }
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    public Output<String> status() {
        return this.status;
    }
    @Export(name="statusReason", refs={String.class}, tree="[0]")
    private Output<String> statusReason;

    public Output<String> statusReason() {
        return this.statusReason;
    }
    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     * 
     */
    public Output<String> type() {
        return this.type;
    }
    /**
     * Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="vpcConfiguration", refs={KxClusterVpcConfiguration.class}, tree="[0]")
    private Output<KxClusterVpcConfiguration> vpcConfiguration;

    /**
     * @return Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<KxClusterVpcConfiguration> vpcConfiguration() {
        return this.vpcConfiguration;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public KxCluster(String name) {
        this(name, KxClusterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public KxCluster(String name, KxClusterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public KxCluster(String name, KxClusterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:finspace/kxCluster:KxCluster", name, args == null ? KxClusterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private KxCluster(String name, Output<String> id, @Nullable KxClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:finspace/kxCluster:KxCluster", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static KxCluster get(String name, Output<String> id, @Nullable KxClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new KxCluster(name, id, state, options);
    }
}
