// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.evidently;

import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs;
import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LaunchArgs extends com.pulumi.resources.ResourceArgs {

    public static final LaunchArgs Empty = new LaunchArgs();

    /**
     * Specifies the description of the launch.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Specifies the description of the launch.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     * 
     */
    @Import(name="groups", required=true)
    private Output<List<LaunchGroupArgs>> groups;

    /**
     * @return One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     * 
     */
    public Output<List<LaunchGroupArgs>> groups() {
        return this.groups;
    }

    /**
     * One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     * 
     */
    @Import(name="metricMonitors")
    private @Nullable Output<List<LaunchMetricMonitorArgs>> metricMonitors;

    /**
     * @return One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     * 
     */
    public Optional<Output<List<LaunchMetricMonitorArgs>>> metricMonitors() {
        return Optional.ofNullable(this.metricMonitors);
    }

    /**
     * The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The name or ARN of the project that is to contain the new launch.
     * 
     */
    @Import(name="project", required=true)
    private Output<String> project;

    /**
     * @return The name or ARN of the project that is to contain the new launch.
     * 
     */
    public Output<String> project() {
        return this.project;
    }

    /**
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     * 
     */
    @Import(name="randomizationSalt")
    private @Nullable Output<String> randomizationSalt;

    /**
     * @return When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     * 
     */
    public Optional<Output<String>> randomizationSalt() {
        return Optional.ofNullable(this.randomizationSalt);
    }

    /**
     * A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     * 
     */
    @Import(name="scheduledSplitsConfig")
    private @Nullable Output<LaunchScheduledSplitsConfigArgs> scheduledSplitsConfig;

    /**
     * @return A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     * 
     */
    public Optional<Output<LaunchScheduledSplitsConfigArgs>> scheduledSplitsConfig() {
        return Optional.ofNullable(this.scheduledSplitsConfig);
    }

    /**
     * Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private LaunchArgs() {}

    private LaunchArgs(LaunchArgs $) {
        this.description = $.description;
        this.groups = $.groups;
        this.metricMonitors = $.metricMonitors;
        this.name = $.name;
        this.project = $.project;
        this.randomizationSalt = $.randomizationSalt;
        this.scheduledSplitsConfig = $.scheduledSplitsConfig;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LaunchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LaunchArgs $;

        public Builder() {
            $ = new LaunchArgs();
        }

        public Builder(LaunchArgs defaults) {
            $ = new LaunchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description Specifies the description of the launch.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Specifies the description of the launch.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param groups One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder groups(Output<List<LaunchGroupArgs>> groups) {
            $.groups = groups;
            return this;
        }

        /**
         * @param groups One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder groups(List<LaunchGroupArgs> groups) {
            return groups(Output.of(groups));
        }

        /**
         * @param groups One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder groups(LaunchGroupArgs... groups) {
            return groups(List.of(groups));
        }

        /**
         * @param metricMonitors One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder metricMonitors(@Nullable Output<List<LaunchMetricMonitorArgs>> metricMonitors) {
            $.metricMonitors = metricMonitors;
            return this;
        }

        /**
         * @param metricMonitors One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder metricMonitors(List<LaunchMetricMonitorArgs> metricMonitors) {
            return metricMonitors(Output.of(metricMonitors));
        }

        /**
         * @param metricMonitors One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder metricMonitors(LaunchMetricMonitorArgs... metricMonitors) {
            return metricMonitors(List.of(metricMonitors));
        }

        /**
         * @param name The name for the new launch. Minimum length of `1`. Maximum length of `127`.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name for the new launch. Minimum length of `1`. Maximum length of `127`.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param project The name or ARN of the project that is to contain the new launch.
         * 
         * @return builder
         * 
         */
        public Builder project(Output<String> project) {
            $.project = project;
            return this;
        }

        /**
         * @param project The name or ARN of the project that is to contain the new launch.
         * 
         * @return builder
         * 
         */
        public Builder project(String project) {
            return project(Output.of(project));
        }

        /**
         * @param randomizationSalt When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
         * 
         * @return builder
         * 
         */
        public Builder randomizationSalt(@Nullable Output<String> randomizationSalt) {
            $.randomizationSalt = randomizationSalt;
            return this;
        }

        /**
         * @param randomizationSalt When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
         * 
         * @return builder
         * 
         */
        public Builder randomizationSalt(String randomizationSalt) {
            return randomizationSalt(Output.of(randomizationSalt));
        }

        /**
         * @param scheduledSplitsConfig A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder scheduledSplitsConfig(@Nullable Output<LaunchScheduledSplitsConfigArgs> scheduledSplitsConfig) {
            $.scheduledSplitsConfig = scheduledSplitsConfig;
            return this;
        }

        /**
         * @param scheduledSplitsConfig A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs scheduledSplitsConfig) {
            return scheduledSplitsConfig(Output.of(scheduledSplitsConfig));
        }

        /**
         * @param tags Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public LaunchArgs build() {
            $.groups = Objects.requireNonNull($.groups, "expected parameter 'groups' to be non-null");
            $.project = Objects.requireNonNull($.project, "expected parameter 'project' to be non-null");
            return $;
        }
    }

}
