// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.evidently;

import com.pulumi.aws.evidently.inputs.FeatureVariationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FeatureArgs extends com.pulumi.resources.ResourceArgs {

    public static final FeatureArgs Empty = new FeatureArgs();

    /**
     * The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
     * 
     */
    @Import(name="defaultVariation")
    private @Nullable Output<String> defaultVariation;

    /**
     * @return The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
     * 
     */
    public Optional<Output<String>> defaultVariation() {
        return Optional.ofNullable(this.defaultVariation);
    }

    /**
     * Specifies the description of the feature.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Specifies the description of the feature.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     * 
     */
    @Import(name="entityOverrides")
    private @Nullable Output<Map<String,String>> entityOverrides;

    /**
     * @return Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     * 
     */
    public Optional<Output<Map<String,String>>> entityOverrides() {
        return Optional.ofNullable(this.entityOverrides);
    }

    /**
     * Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
     * 
     */
    @Import(name="evaluationStrategy")
    private @Nullable Output<String> evaluationStrategy;

    /**
     * @return Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
     * 
     */
    public Optional<Output<String>> evaluationStrategy() {
        return Optional.ofNullable(this.evaluationStrategy);
    }

    /**
     * The name for the new feature. Minimum length of `1`. Maximum length of `127`.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name for the new feature. Minimum length of `1`. Maximum length of `127`.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The name or ARN of the project that is to contain the new feature.
     * 
     */
    @Import(name="project", required=true)
    private Output<String> project;

    /**
     * @return The name or ARN of the project that is to contain the new feature.
     * 
     */
    public Output<String> project() {
        return this.project;
    }

    /**
     * Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * One or more blocks that contain the configuration of the feature&#39;s different variations. Detailed below
     * 
     */
    @Import(name="variations", required=true)
    private Output<List<FeatureVariationArgs>> variations;

    /**
     * @return One or more blocks that contain the configuration of the feature&#39;s different variations. Detailed below
     * 
     */
    public Output<List<FeatureVariationArgs>> variations() {
        return this.variations;
    }

    private FeatureArgs() {}

    private FeatureArgs(FeatureArgs $) {
        this.defaultVariation = $.defaultVariation;
        this.description = $.description;
        this.entityOverrides = $.entityOverrides;
        this.evaluationStrategy = $.evaluationStrategy;
        this.name = $.name;
        this.project = $.project;
        this.tags = $.tags;
        this.variations = $.variations;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FeatureArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FeatureArgs $;

        public Builder() {
            $ = new FeatureArgs();
        }

        public Builder(FeatureArgs defaults) {
            $ = new FeatureArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param defaultVariation The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
         * 
         * @return builder
         * 
         */
        public Builder defaultVariation(@Nullable Output<String> defaultVariation) {
            $.defaultVariation = defaultVariation;
            return this;
        }

        /**
         * @param defaultVariation The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature. This variation must also be listed in the `variations` structure. If you omit `default_variation`, the first variation listed in the `variations` structure is used as the default variation.
         * 
         * @return builder
         * 
         */
        public Builder defaultVariation(String defaultVariation) {
            return defaultVariation(Output.of(defaultVariation));
        }

        /**
         * @param description Specifies the description of the feature.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Specifies the description of the feature.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param entityOverrides Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
         * 
         * @return builder
         * 
         */
        public Builder entityOverrides(@Nullable Output<Map<String,String>> entityOverrides) {
            $.entityOverrides = entityOverrides;
            return this;
        }

        /**
         * @param entityOverrides Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
         * 
         * @return builder
         * 
         */
        public Builder entityOverrides(Map<String,String> entityOverrides) {
            return entityOverrides(Output.of(entityOverrides));
        }

        /**
         * @param evaluationStrategy Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
         * 
         * @return builder
         * 
         */
        public Builder evaluationStrategy(@Nullable Output<String> evaluationStrategy) {
            $.evaluationStrategy = evaluationStrategy;
            return this;
        }

        /**
         * @param evaluationStrategy Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
         * 
         * @return builder
         * 
         */
        public Builder evaluationStrategy(String evaluationStrategy) {
            return evaluationStrategy(Output.of(evaluationStrategy));
        }

        /**
         * @param name The name for the new feature. Minimum length of `1`. Maximum length of `127`.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name for the new feature. Minimum length of `1`. Maximum length of `127`.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param project The name or ARN of the project that is to contain the new feature.
         * 
         * @return builder
         * 
         */
        public Builder project(Output<String> project) {
            $.project = project;
            return this;
        }

        /**
         * @param project The name or ARN of the project that is to contain the new feature.
         * 
         * @return builder
         * 
         */
        public Builder project(String project) {
            return project(Output.of(project));
        }

        /**
         * @param tags Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Tags to apply to the feature. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param variations One or more blocks that contain the configuration of the feature&#39;s different variations. Detailed below
         * 
         * @return builder
         * 
         */
        public Builder variations(Output<List<FeatureVariationArgs>> variations) {
            $.variations = variations;
            return this;
        }

        /**
         * @param variations One or more blocks that contain the configuration of the feature&#39;s different variations. Detailed below
         * 
         * @return builder
         * 
         */
        public Builder variations(List<FeatureVariationArgs> variations) {
            return variations(Output.of(variations));
        }

        /**
         * @param variations One or more blocks that contain the configuration of the feature&#39;s different variations. Detailed below
         * 
         * @return builder
         * 
         */
        public Builder variations(FeatureVariationArgs... variations) {
            return variations(List.of(variations));
        }

        public FeatureArgs build() {
            $.project = Objects.requireNonNull($.project, "expected parameter 'project' to be non-null");
            $.variations = Objects.requireNonNull($.variations, "expected parameter 'variations' to be non-null");
            return $;
        }
    }

}
