// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emrserverless;

import com.pulumi.aws.emrserverless.inputs.ApplicationAutoStartConfigurationArgs;
import com.pulumi.aws.emrserverless.inputs.ApplicationAutoStopConfigurationArgs;
import com.pulumi.aws.emrserverless.inputs.ApplicationImageConfigurationArgs;
import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityArgs;
import com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs;
import com.pulumi.aws.emrserverless.inputs.ApplicationNetworkConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ApplicationArgs extends com.pulumi.resources.ResourceArgs {

    public static final ApplicationArgs Empty = new ApplicationArgs();

    /**
     * The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
     * 
     */
    @Import(name="architecture")
    private @Nullable Output<String> architecture;

    /**
     * @return The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
     * 
     */
    public Optional<Output<String>> architecture() {
        return Optional.ofNullable(this.architecture);
    }

    /**
     * The configuration for an application to automatically start on job submission.
     * 
     */
    @Import(name="autoStartConfiguration")
    private @Nullable Output<ApplicationAutoStartConfigurationArgs> autoStartConfiguration;

    /**
     * @return The configuration for an application to automatically start on job submission.
     * 
     */
    public Optional<Output<ApplicationAutoStartConfigurationArgs>> autoStartConfiguration() {
        return Optional.ofNullable(this.autoStartConfiguration);
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     * 
     */
    @Import(name="autoStopConfiguration")
    private @Nullable Output<ApplicationAutoStopConfigurationArgs> autoStopConfiguration;

    /**
     * @return The configuration for an application to automatically stop after a certain amount of time being idle.
     * 
     */
    public Optional<Output<ApplicationAutoStopConfigurationArgs>> autoStopConfiguration() {
        return Optional.ofNullable(this.autoStopConfiguration);
    }

    /**
     * The image configuration applied to all worker types.
     * 
     */
    @Import(name="imageConfiguration")
    private @Nullable Output<ApplicationImageConfigurationArgs> imageConfiguration;

    /**
     * @return The image configuration applied to all worker types.
     * 
     */
    public Optional<Output<ApplicationImageConfigurationArgs>> imageConfiguration() {
        return Optional.ofNullable(this.imageConfiguration);
    }

    /**
     * The capacity to initialize when the application is created.
     * 
     */
    @Import(name="initialCapacities")
    private @Nullable Output<List<ApplicationInitialCapacityArgs>> initialCapacities;

    /**
     * @return The capacity to initialize when the application is created.
     * 
     */
    public Optional<Output<List<ApplicationInitialCapacityArgs>>> initialCapacities() {
        return Optional.ofNullable(this.initialCapacities);
    }

    /**
     * The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     * 
     */
    @Import(name="maximumCapacity")
    private @Nullable Output<ApplicationMaximumCapacityArgs> maximumCapacity;

    /**
     * @return The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     * 
     */
    public Optional<Output<ApplicationMaximumCapacityArgs>> maximumCapacity() {
        return Optional.ofNullable(this.maximumCapacity);
    }

    /**
     * The name of the application.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the application.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The network configuration for customer VPC connectivity.
     * 
     */
    @Import(name="networkConfiguration")
    private @Nullable Output<ApplicationNetworkConfigurationArgs> networkConfiguration;

    /**
     * @return The network configuration for customer VPC connectivity.
     * 
     */
    public Optional<Output<ApplicationNetworkConfigurationArgs>> networkConfiguration() {
        return Optional.ofNullable(this.networkConfiguration);
    }

    /**
     * The EMR release version associated with the application.
     * 
     */
    @Import(name="releaseLabel", required=true)
    private Output<String> releaseLabel;

    /**
     * @return The EMR release version associated with the application.
     * 
     */
    public Output<String> releaseLabel() {
        return this.releaseLabel;
    }

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The type of application you want to start, such as `spark` or `hive`.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return The type of application you want to start, such as `spark` or `hive`.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    private ApplicationArgs() {}

    private ApplicationArgs(ApplicationArgs $) {
        this.architecture = $.architecture;
        this.autoStartConfiguration = $.autoStartConfiguration;
        this.autoStopConfiguration = $.autoStopConfiguration;
        this.imageConfiguration = $.imageConfiguration;
        this.initialCapacities = $.initialCapacities;
        this.maximumCapacity = $.maximumCapacity;
        this.name = $.name;
        this.networkConfiguration = $.networkConfiguration;
        this.releaseLabel = $.releaseLabel;
        this.tags = $.tags;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ApplicationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ApplicationArgs $;

        public Builder() {
            $ = new ApplicationArgs();
        }

        public Builder(ApplicationArgs defaults) {
            $ = new ApplicationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param architecture The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
         * 
         * @return builder
         * 
         */
        public Builder architecture(@Nullable Output<String> architecture) {
            $.architecture = architecture;
            return this;
        }

        /**
         * @param architecture The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
         * 
         * @return builder
         * 
         */
        public Builder architecture(String architecture) {
            return architecture(Output.of(architecture));
        }

        /**
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission.
         * 
         * @return builder
         * 
         */
        public Builder autoStartConfiguration(@Nullable Output<ApplicationAutoStartConfigurationArgs> autoStartConfiguration) {
            $.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        /**
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission.
         * 
         * @return builder
         * 
         */
        public Builder autoStartConfiguration(ApplicationAutoStartConfigurationArgs autoStartConfiguration) {
            return autoStartConfiguration(Output.of(autoStartConfiguration));
        }

        /**
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
         * 
         * @return builder
         * 
         */
        public Builder autoStopConfiguration(@Nullable Output<ApplicationAutoStopConfigurationArgs> autoStopConfiguration) {
            $.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        /**
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
         * 
         * @return builder
         * 
         */
        public Builder autoStopConfiguration(ApplicationAutoStopConfigurationArgs autoStopConfiguration) {
            return autoStopConfiguration(Output.of(autoStopConfiguration));
        }

        /**
         * @param imageConfiguration The image configuration applied to all worker types.
         * 
         * @return builder
         * 
         */
        public Builder imageConfiguration(@Nullable Output<ApplicationImageConfigurationArgs> imageConfiguration) {
            $.imageConfiguration = imageConfiguration;
            return this;
        }

        /**
         * @param imageConfiguration The image configuration applied to all worker types.
         * 
         * @return builder
         * 
         */
        public Builder imageConfiguration(ApplicationImageConfigurationArgs imageConfiguration) {
            return imageConfiguration(Output.of(imageConfiguration));
        }

        /**
         * @param initialCapacities The capacity to initialize when the application is created.
         * 
         * @return builder
         * 
         */
        public Builder initialCapacities(@Nullable Output<List<ApplicationInitialCapacityArgs>> initialCapacities) {
            $.initialCapacities = initialCapacities;
            return this;
        }

        /**
         * @param initialCapacities The capacity to initialize when the application is created.
         * 
         * @return builder
         * 
         */
        public Builder initialCapacities(List<ApplicationInitialCapacityArgs> initialCapacities) {
            return initialCapacities(Output.of(initialCapacities));
        }

        /**
         * @param initialCapacities The capacity to initialize when the application is created.
         * 
         * @return builder
         * 
         */
        public Builder initialCapacities(ApplicationInitialCapacityArgs... initialCapacities) {
            return initialCapacities(List.of(initialCapacities));
        }

        /**
         * @param maximumCapacity The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
         * 
         * @return builder
         * 
         */
        public Builder maximumCapacity(@Nullable Output<ApplicationMaximumCapacityArgs> maximumCapacity) {
            $.maximumCapacity = maximumCapacity;
            return this;
        }

        /**
         * @param maximumCapacity The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
         * 
         * @return builder
         * 
         */
        public Builder maximumCapacity(ApplicationMaximumCapacityArgs maximumCapacity) {
            return maximumCapacity(Output.of(maximumCapacity));
        }

        /**
         * @param name The name of the application.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the application.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param networkConfiguration The network configuration for customer VPC connectivity.
         * 
         * @return builder
         * 
         */
        public Builder networkConfiguration(@Nullable Output<ApplicationNetworkConfigurationArgs> networkConfiguration) {
            $.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * @param networkConfiguration The network configuration for customer VPC connectivity.
         * 
         * @return builder
         * 
         */
        public Builder networkConfiguration(ApplicationNetworkConfigurationArgs networkConfiguration) {
            return networkConfiguration(Output.of(networkConfiguration));
        }

        /**
         * @param releaseLabel The EMR release version associated with the application.
         * 
         * @return builder
         * 
         */
        public Builder releaseLabel(Output<String> releaseLabel) {
            $.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * @param releaseLabel The EMR release version associated with the application.
         * 
         * @return builder
         * 
         */
        public Builder releaseLabel(String releaseLabel) {
            return releaseLabel(Output.of(releaseLabel));
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param type The type of application you want to start, such as `spark` or `hive`.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The type of application you want to start, such as `spark` or `hive`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public ApplicationArgs build() {
            $.releaseLabel = Objects.requireNonNull($.releaseLabel, "expected parameter 'releaseLabel' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            return $;
        }
    }

}
