// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emrcontainers;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.emrcontainers.JobTemplateArgs;
import com.pulumi.aws.emrcontainers.inputs.JobTemplateState;
import com.pulumi.aws.emrcontainers.outputs.JobTemplateJobTemplateData;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an EMR Containers (EMR on EKS) Job Template.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emrcontainers.JobTemplate;
 * import com.pulumi.aws.emrcontainers.JobTemplateArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverArgs;
 * import com.pulumi.aws.emrcontainers.inputs.JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new JobTemplate(&#34;example&#34;, JobTemplateArgs.builder()        
 *             .jobTemplateData(JobTemplateJobTemplateDataArgs.builder()
 *                 .executionRoleArn(aws_iam_role.example().arn())
 *                 .releaseLabel(&#34;emr-6.10.0-latest&#34;)
 *                 .jobDriver(JobTemplateJobTemplateDataJobDriverArgs.builder()
 *                     .sparkSqlJobDriver(JobTemplateJobTemplateDataJobDriverSparkSqlJobDriverArgs.builder()
 *                         .entryPoint(&#34;default&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import EKS job templates using the `id`. For exampleterraform import {
 * 
 *  to = aws_emrcontainers_job_template.example
 * 
 *  id = &#34;a1b2c3d4e5f6g7h8i9j10k11l&#34; } Using `TODO import`, import EKS job templates using the `id`. For exampleconsole % TODO import aws_emrcontainers_job_template.example a1b2c3d4e5f6g7h8i9j10k11l
 * 
 */
@ResourceType(type="aws:emrcontainers/jobTemplate:JobTemplate")
public class JobTemplate extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the job template.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the job template.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The job template data which holds values of StartJobRun API request.
     * 
     */
    @Export(name="jobTemplateData", refs={JobTemplateJobTemplateData.class}, tree="[0]")
    private Output<JobTemplateJobTemplateData> jobTemplateData;

    /**
     * @return The job template data which holds values of StartJobRun API request.
     * 
     */
    public Output<JobTemplateJobTemplateData> jobTemplateData() {
        return this.jobTemplateData;
    }
    /**
     * The KMS key ARN used to encrypt the job template.
     * 
     */
    @Export(name="kmsKeyArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kmsKeyArn;

    /**
     * @return The KMS key ARN used to encrypt the job template.
     * 
     */
    public Output<Optional<String>> kmsKeyArn() {
        return Codegen.optional(this.kmsKeyArn);
    }
    /**
     * The specified name of the job template.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The specified name of the job template.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public JobTemplate(String name) {
        this(name, JobTemplateArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public JobTemplate(String name, JobTemplateArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public JobTemplate(String name, JobTemplateArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emrcontainers/jobTemplate:JobTemplate", name, args == null ? JobTemplateArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private JobTemplate(String name, Output<String> id, @Nullable JobTemplateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emrcontainers/jobTemplate:JobTemplate", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static JobTemplate get(String name, Output<String> id, @Nullable JobTemplateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new JobTemplate(name, id, state, options);
    }
}
