// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr.inputs;

import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs;
import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class InstanceFleetState extends com.pulumi.resources.ResourceArgs {

    public static final InstanceFleetState Empty = new InstanceFleetState();

    /**
     * ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     * 
     */
    @Import(name="clusterId")
    private @Nullable Output<String> clusterId;

    /**
     * @return ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     * 
     */
    public Optional<Output<String>> clusterId() {
        return Optional.ofNullable(this.clusterId);
    }

    /**
     * Configuration block for instance fleet
     * 
     */
    @Import(name="instanceTypeConfigs")
    private @Nullable Output<List<InstanceFleetInstanceTypeConfigArgs>> instanceTypeConfigs;

    /**
     * @return Configuration block for instance fleet
     * 
     */
    public Optional<Output<List<InstanceFleetInstanceTypeConfigArgs>>> instanceTypeConfigs() {
        return Optional.ofNullable(this.instanceTypeConfigs);
    }

    /**
     * Configuration block for launch specification
     * 
     */
    @Import(name="launchSpecifications")
    private @Nullable Output<InstanceFleetLaunchSpecificationsArgs> launchSpecifications;

    /**
     * @return Configuration block for launch specification
     * 
     */
    public Optional<Output<InstanceFleetLaunchSpecificationsArgs>> launchSpecifications() {
        return Optional.ofNullable(this.launchSpecifications);
    }

    /**
     * Friendly name given to the instance fleet.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Friendly name given to the instance fleet.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The number of On-Demand units that have been provisioned for the instance
     * fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might be less than or greater than TargetOnDemandCapacity.
     * 
     */
    @Import(name="provisionedOnDemandCapacity")
    private @Nullable Output<Integer> provisionedOnDemandCapacity;

    /**
     * @return The number of On-Demand units that have been provisioned for the instance
     * fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might be less than or greater than TargetOnDemandCapacity.
     * 
     */
    public Optional<Output<Integer>> provisionedOnDemandCapacity() {
        return Optional.ofNullable(this.provisionedOnDemandCapacity);
    }

    /**
     * The number of Spot units that have been provisioned for this instance fleet
     * to fulfill TargetSpotCapacity. This provisioned capacity might be less than or greater than TargetSpotCapacity.
     * 
     */
    @Import(name="provisionedSpotCapacity")
    private @Nullable Output<Integer> provisionedSpotCapacity;

    /**
     * @return The number of Spot units that have been provisioned for this instance fleet
     * to fulfill TargetSpotCapacity. This provisioned capacity might be less than or greater than TargetSpotCapacity.
     * 
     */
    public Optional<Output<Integer>> provisionedSpotCapacity() {
        return Optional.ofNullable(this.provisionedSpotCapacity);
    }

    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     * 
     */
    @Import(name="targetOnDemandCapacity")
    private @Nullable Output<Integer> targetOnDemandCapacity;

    /**
     * @return The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     * 
     */
    public Optional<Output<Integer>> targetOnDemandCapacity() {
        return Optional.ofNullable(this.targetOnDemandCapacity);
    }

    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     * 
     */
    @Import(name="targetSpotCapacity")
    private @Nullable Output<Integer> targetSpotCapacity;

    /**
     * @return The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     * 
     */
    public Optional<Output<Integer>> targetSpotCapacity() {
        return Optional.ofNullable(this.targetSpotCapacity);
    }

    private InstanceFleetState() {}

    private InstanceFleetState(InstanceFleetState $) {
        this.clusterId = $.clusterId;
        this.instanceTypeConfigs = $.instanceTypeConfigs;
        this.launchSpecifications = $.launchSpecifications;
        this.name = $.name;
        this.provisionedOnDemandCapacity = $.provisionedOnDemandCapacity;
        this.provisionedSpotCapacity = $.provisionedSpotCapacity;
        this.targetOnDemandCapacity = $.targetOnDemandCapacity;
        this.targetSpotCapacity = $.targetSpotCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(InstanceFleetState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private InstanceFleetState $;

        public Builder() {
            $ = new InstanceFleetState();
        }

        public Builder(InstanceFleetState defaults) {
            $ = new InstanceFleetState(Objects.requireNonNull(defaults));
        }

        /**
         * @param clusterId ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(@Nullable Output<String> clusterId) {
            $.clusterId = clusterId;
            return this;
        }

        /**
         * @param clusterId ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(String clusterId) {
            return clusterId(Output.of(clusterId));
        }

        /**
         * @param instanceTypeConfigs Configuration block for instance fleet
         * 
         * @return builder
         * 
         */
        public Builder instanceTypeConfigs(@Nullable Output<List<InstanceFleetInstanceTypeConfigArgs>> instanceTypeConfigs) {
            $.instanceTypeConfigs = instanceTypeConfigs;
            return this;
        }

        /**
         * @param instanceTypeConfigs Configuration block for instance fleet
         * 
         * @return builder
         * 
         */
        public Builder instanceTypeConfigs(List<InstanceFleetInstanceTypeConfigArgs> instanceTypeConfigs) {
            return instanceTypeConfigs(Output.of(instanceTypeConfigs));
        }

        /**
         * @param instanceTypeConfigs Configuration block for instance fleet
         * 
         * @return builder
         * 
         */
        public Builder instanceTypeConfigs(InstanceFleetInstanceTypeConfigArgs... instanceTypeConfigs) {
            return instanceTypeConfigs(List.of(instanceTypeConfigs));
        }

        /**
         * @param launchSpecifications Configuration block for launch specification
         * 
         * @return builder
         * 
         */
        public Builder launchSpecifications(@Nullable Output<InstanceFleetLaunchSpecificationsArgs> launchSpecifications) {
            $.launchSpecifications = launchSpecifications;
            return this;
        }

        /**
         * @param launchSpecifications Configuration block for launch specification
         * 
         * @return builder
         * 
         */
        public Builder launchSpecifications(InstanceFleetLaunchSpecificationsArgs launchSpecifications) {
            return launchSpecifications(Output.of(launchSpecifications));
        }

        /**
         * @param name Friendly name given to the instance fleet.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Friendly name given to the instance fleet.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param provisionedOnDemandCapacity The number of On-Demand units that have been provisioned for the instance
         * fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might be less than or greater than TargetOnDemandCapacity.
         * 
         * @return builder
         * 
         */
        public Builder provisionedOnDemandCapacity(@Nullable Output<Integer> provisionedOnDemandCapacity) {
            $.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
            return this;
        }

        /**
         * @param provisionedOnDemandCapacity The number of On-Demand units that have been provisioned for the instance
         * fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might be less than or greater than TargetOnDemandCapacity.
         * 
         * @return builder
         * 
         */
        public Builder provisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            return provisionedOnDemandCapacity(Output.of(provisionedOnDemandCapacity));
        }

        /**
         * @param provisionedSpotCapacity The number of Spot units that have been provisioned for this instance fleet
         * to fulfill TargetSpotCapacity. This provisioned capacity might be less than or greater than TargetSpotCapacity.
         * 
         * @return builder
         * 
         */
        public Builder provisionedSpotCapacity(@Nullable Output<Integer> provisionedSpotCapacity) {
            $.provisionedSpotCapacity = provisionedSpotCapacity;
            return this;
        }

        /**
         * @param provisionedSpotCapacity The number of Spot units that have been provisioned for this instance fleet
         * to fulfill TargetSpotCapacity. This provisioned capacity might be less than or greater than TargetSpotCapacity.
         * 
         * @return builder
         * 
         */
        public Builder provisionedSpotCapacity(Integer provisionedSpotCapacity) {
            return provisionedSpotCapacity(Output.of(provisionedSpotCapacity));
        }

        /**
         * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         * 
         * @return builder
         * 
         */
        public Builder targetOnDemandCapacity(@Nullable Output<Integer> targetOnDemandCapacity) {
            $.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        /**
         * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         * 
         * @return builder
         * 
         */
        public Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            return targetOnDemandCapacity(Output.of(targetOnDemandCapacity));
        }

        /**
         * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         * 
         * @return builder
         * 
         */
        public Builder targetSpotCapacity(@Nullable Output<Integer> targetSpotCapacity) {
            $.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        /**
         * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         * 
         * @return builder
         * 
         */
        public Builder targetSpotCapacity(Integer targetSpotCapacity) {
            return targetSpotCapacity(Output.of(targetSpotCapacity));
        }

        public InstanceFleetState build() {
            return $;
        }
    }

}
