// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterEc2AttributesArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterEc2AttributesArgs Empty = new ClusterEc2AttributesArgs();

    /**
     * String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
     * 
     */
    @Import(name="additionalMasterSecurityGroups")
    private @Nullable Output<String> additionalMasterSecurityGroups;

    /**
     * @return String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
     * 
     */
    public Optional<Output<String>> additionalMasterSecurityGroups() {
        return Optional.ofNullable(this.additionalMasterSecurityGroups);
    }

    /**
     * String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
     * 
     */
    @Import(name="additionalSlaveSecurityGroups")
    private @Nullable Output<String> additionalSlaveSecurityGroups;

    /**
     * @return String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
     * 
     */
    public Optional<Output<String>> additionalSlaveSecurityGroups() {
        return Optional.ofNullable(this.additionalSlaveSecurityGroups);
    }

    /**
     * Identifier of the Amazon EC2 EMR-Managed security group for the master node.
     * 
     */
    @Import(name="emrManagedMasterSecurityGroup")
    private @Nullable Output<String> emrManagedMasterSecurityGroup;

    /**
     * @return Identifier of the Amazon EC2 EMR-Managed security group for the master node.
     * 
     */
    public Optional<Output<String>> emrManagedMasterSecurityGroup() {
        return Optional.ofNullable(this.emrManagedMasterSecurityGroup);
    }

    /**
     * Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
     * 
     */
    @Import(name="emrManagedSlaveSecurityGroup")
    private @Nullable Output<String> emrManagedSlaveSecurityGroup;

    /**
     * @return Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
     * 
     */
    public Optional<Output<String>> emrManagedSlaveSecurityGroup() {
        return Optional.ofNullable(this.emrManagedSlaveSecurityGroup);
    }

    /**
     * Instance Profile for EC2 instances of the cluster assume this role.
     * 
     */
    @Import(name="instanceProfile", required=true)
    private Output<String> instanceProfile;

    /**
     * @return Instance Profile for EC2 instances of the cluster assume this role.
     * 
     */
    public Output<String> instanceProfile() {
        return this.instanceProfile;
    }

    /**
     * Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
     * 
     */
    @Import(name="keyName")
    private @Nullable Output<String> keyName;

    /**
     * @return Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
     * 
     */
    public Optional<Output<String>> keyName() {
        return Optional.ofNullable(this.keyName);
    }

    /**
     * Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
     * 
     */
    @Import(name="serviceAccessSecurityGroup")
    private @Nullable Output<String> serviceAccessSecurityGroup;

    /**
     * @return Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
     * 
     */
    public Optional<Output<String>> serviceAccessSecurityGroup() {
        return Optional.ofNullable(this.serviceAccessSecurityGroup);
    }

    /**
     * VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    /**
     * List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
     * 
     * &gt; **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<List<String>> subnetIds;

    /**
     * @return List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
     * 
     * &gt; **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
     * 
     */
    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    private ClusterEc2AttributesArgs() {}

    private ClusterEc2AttributesArgs(ClusterEc2AttributesArgs $) {
        this.additionalMasterSecurityGroups = $.additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = $.additionalSlaveSecurityGroups;
        this.emrManagedMasterSecurityGroup = $.emrManagedMasterSecurityGroup;
        this.emrManagedSlaveSecurityGroup = $.emrManagedSlaveSecurityGroup;
        this.instanceProfile = $.instanceProfile;
        this.keyName = $.keyName;
        this.serviceAccessSecurityGroup = $.serviceAccessSecurityGroup;
        this.subnetId = $.subnetId;
        this.subnetIds = $.subnetIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterEc2AttributesArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterEc2AttributesArgs $;

        public Builder() {
            $ = new ClusterEc2AttributesArgs();
        }

        public Builder(ClusterEc2AttributesArgs defaults) {
            $ = new ClusterEc2AttributesArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param additionalMasterSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
         * 
         * @return builder
         * 
         */
        public Builder additionalMasterSecurityGroups(@Nullable Output<String> additionalMasterSecurityGroups) {
            $.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
            return this;
        }

        /**
         * @param additionalMasterSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
         * 
         * @return builder
         * 
         */
        public Builder additionalMasterSecurityGroups(String additionalMasterSecurityGroups) {
            return additionalMasterSecurityGroups(Output.of(additionalMasterSecurityGroups));
        }

        /**
         * @param additionalSlaveSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
         * 
         * @return builder
         * 
         */
        public Builder additionalSlaveSecurityGroups(@Nullable Output<String> additionalSlaveSecurityGroups) {
            $.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
            return this;
        }

        /**
         * @param additionalSlaveSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
         * 
         * @return builder
         * 
         */
        public Builder additionalSlaveSecurityGroups(String additionalSlaveSecurityGroups) {
            return additionalSlaveSecurityGroups(Output.of(additionalSlaveSecurityGroups));
        }

        /**
         * @param emrManagedMasterSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the master node.
         * 
         * @return builder
         * 
         */
        public Builder emrManagedMasterSecurityGroup(@Nullable Output<String> emrManagedMasterSecurityGroup) {
            $.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        /**
         * @param emrManagedMasterSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the master node.
         * 
         * @return builder
         * 
         */
        public Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            return emrManagedMasterSecurityGroup(Output.of(emrManagedMasterSecurityGroup));
        }

        /**
         * @param emrManagedSlaveSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
         * 
         * @return builder
         * 
         */
        public Builder emrManagedSlaveSecurityGroup(@Nullable Output<String> emrManagedSlaveSecurityGroup) {
            $.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        /**
         * @param emrManagedSlaveSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
         * 
         * @return builder
         * 
         */
        public Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            return emrManagedSlaveSecurityGroup(Output.of(emrManagedSlaveSecurityGroup));
        }

        /**
         * @param instanceProfile Instance Profile for EC2 instances of the cluster assume this role.
         * 
         * @return builder
         * 
         */
        public Builder instanceProfile(Output<String> instanceProfile) {
            $.instanceProfile = instanceProfile;
            return this;
        }

        /**
         * @param instanceProfile Instance Profile for EC2 instances of the cluster assume this role.
         * 
         * @return builder
         * 
         */
        public Builder instanceProfile(String instanceProfile) {
            return instanceProfile(Output.of(instanceProfile));
        }

        /**
         * @param keyName Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
         * 
         * @return builder
         * 
         */
        public Builder keyName(@Nullable Output<String> keyName) {
            $.keyName = keyName;
            return this;
        }

        /**
         * @param keyName Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
         * 
         * @return builder
         * 
         */
        public Builder keyName(String keyName) {
            return keyName(Output.of(keyName));
        }

        /**
         * @param serviceAccessSecurityGroup Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
         * 
         * @return builder
         * 
         */
        public Builder serviceAccessSecurityGroup(@Nullable Output<String> serviceAccessSecurityGroup) {
            $.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        /**
         * @param serviceAccessSecurityGroup Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
         * 
         * @return builder
         * 
         */
        public Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            return serviceAccessSecurityGroup(Output.of(serviceAccessSecurityGroup));
        }

        /**
         * @param subnetId VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param subnetIds List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
         * 
         * &gt; **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
         * 
         * &gt; **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
         * 
         * &gt; **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        public ClusterEc2AttributesArgs build() {
            $.instanceProfile = Objects.requireNonNull($.instanceProfile, "expected parameter 'instanceProfile' to be non-null");
            return $;
        }
    }

}
