// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.emr.StudioArgs;
import com.pulumi.aws.emr.inputs.StudioState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Elastic MapReduce Studio.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Studio;
 * import com.pulumi.aws.emr.StudioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Studio(&#34;example&#34;, StudioArgs.builder()        
 *             .authMode(&#34;SSO&#34;)
 *             .defaultS3Location(String.format(&#34;s3://%s/test&#34;, aws_s3_bucket.test().bucket()))
 *             .engineSecurityGroupId(aws_security_group.test().id())
 *             .serviceRole(aws_iam_role.test().arn())
 *             .subnetIds(aws_subnet.test().id())
 *             .userRole(aws_iam_role.test().arn())
 *             .vpcId(aws_vpc.test().id())
 *             .workspaceSecurityGroupId(aws_security_group.test().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EMR studios using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:emr/studio:Studio studio es-123456ABCDEF
 * ```
 * 
 */
@ResourceType(type="aws:emr/studio:Studio")
public class Studio extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the studio.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the studio.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     * 
     */
    @Export(name="authMode", refs={String.class}, tree="[0]")
    private Output<String> authMode;

    /**
     * @return Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     * 
     */
    public Output<String> authMode() {
        return this.authMode;
    }
    /**
     * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     * 
     */
    @Export(name="defaultS3Location", refs={String.class}, tree="[0]")
    private Output<String> defaultS3Location;

    /**
     * @return The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     * 
     */
    public Output<String> defaultS3Location() {
        return this.defaultS3Location;
    }
    /**
     * A detailed description of the Amazon EMR Studio.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A detailed description of the Amazon EMR Studio.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     * 
     */
    @Export(name="engineSecurityGroupId", refs={String.class}, tree="[0]")
    private Output<String> engineSecurityGroupId;

    /**
     * @return The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     * 
     */
    public Output<String> engineSecurityGroupId() {
        return this.engineSecurityGroupId;
    }
    /**
     * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     * 
     */
    @Export(name="idpAuthUrl", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> idpAuthUrl;

    /**
     * @return The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     * 
     */
    public Output<Optional<String>> idpAuthUrl() {
        return Codegen.optional(this.idpAuthUrl);
    }
    /**
     * The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     * 
     */
    @Export(name="idpRelayStateParameterName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> idpRelayStateParameterName;

    /**
     * @return The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     * 
     */
    public Output<Optional<String>> idpRelayStateParameterName() {
        return Codegen.optional(this.idpRelayStateParameterName);
    }
    /**
     * A descriptive name for the Amazon EMR Studio.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A descriptive name for the Amazon EMR Studio.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     * 
     */
    @Export(name="serviceRole", refs={String.class}, tree="[0]")
    private Output<String> serviceRole;

    /**
     * @return The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     * 
     */
    public Output<String> serviceRole() {
        return this.serviceRole;
    }
    /**
     * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> subnetIds;

    /**
     * @return A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     * 
     */
    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }
    /**
     * list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The unique access URL of the Amazon EMR Studio.
     * 
     */
    @Export(name="url", refs={String.class}, tree="[0]")
    private Output<String> url;

    /**
     * @return The unique access URL of the Amazon EMR Studio.
     * 
     */
    public Output<String> url() {
        return this.url;
    }
    /**
     * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     * 
     */
    @Export(name="userRole", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> userRole;

    /**
     * @return The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     * 
     */
    public Output<Optional<String>> userRole() {
        return Codegen.optional(this.userRole);
    }
    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }
    /**
     * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="workspaceSecurityGroupId", refs={String.class}, tree="[0]")
    private Output<String> workspaceSecurityGroupId;

    /**
     * @return The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> workspaceSecurityGroupId() {
        return this.workspaceSecurityGroupId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Studio(String name) {
        this(name, StudioArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Studio(String name, StudioArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Studio(String name, StudioArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/studio:Studio", name, args == null ? StudioArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Studio(String name, Output<String> id, @Nullable StudioState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/studio:Studio", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Studio get(String name, Output<String> id, @Nullable StudioState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Studio(name, id, state, options);
    }
}
