// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.emr.SecurityConfigurationArgs;
import com.pulumi.aws.emr.inputs.SecurityConfigurationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage AWS EMR Security Configurations
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.SecurityConfiguration;
 * import com.pulumi.aws.emr.SecurityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var foo = new SecurityConfiguration(&#34;foo&#34;, SecurityConfigurationArgs.builder()        
 *             .configuration(&#34;&#34;&#34;
 * {
 *   &#34;EncryptionConfiguration&#34;: {
 *     &#34;AtRestEncryptionConfiguration&#34;: {
 *       &#34;S3EncryptionConfiguration&#34;: {
 *         &#34;EncryptionMode&#34;: &#34;SSE-S3&#34;
 *       },
 *       &#34;LocalDiskEncryptionConfiguration&#34;: {
 *         &#34;EncryptionKeyProviderType&#34;: &#34;AwsKms&#34;,
 *         &#34;AwsKmsKey&#34;: &#34;arn:aws:kms:us-west-2:187416307283:alias/my_emr_test_key&#34;
 *       }
 *     },
 *     &#34;EnableInTransitEncryption&#34;: false,
 *     &#34;EnableAtRestEncryption&#34;: true
 *   }
 * }
 * 
 *             &#34;&#34;&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EMR Security Configurations using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:emr/securityConfiguration:SecurityConfiguration sc example-sc-name
 * ```
 * 
 */
@ResourceType(type="aws:emr/securityConfiguration:SecurityConfiguration")
public class SecurityConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * A JSON formatted Security Configuration
     * 
     */
    @Export(name="configuration", refs={String.class}, tree="[0]")
    private Output<String> configuration;

    /**
     * @return A JSON formatted Security Configuration
     * 
     */
    public Output<String> configuration() {
        return this.configuration;
    }
    /**
     * Date the Security Configuration was created
     * 
     */
    @Export(name="creationDate", refs={String.class}, tree="[0]")
    private Output<String> creationDate;

    /**
     * @return Date the Security Configuration was created
     * 
     */
    public Output<String> creationDate() {
        return this.creationDate;
    }
    /**
     * The name of the EMR Security Configuration. By default generated by this provider.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the EMR Security Configuration. By default generated by this provider.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     * 
     */
    public Output<Optional<String>> namePrefix() {
        return Codegen.optional(this.namePrefix);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SecurityConfiguration(String name) {
        this(name, SecurityConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SecurityConfiguration(String name, SecurityConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SecurityConfiguration(String name, SecurityConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/securityConfiguration:SecurityConfiguration", name, args == null ? SecurityConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SecurityConfiguration(String name, Output<String> id, @Nullable SecurityConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/securityConfiguration:SecurityConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SecurityConfiguration get(String name, Output<String> id, @Nullable SecurityConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SecurityConfiguration(name, id, state, options);
    }
}
