// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.emr.ManagedScalingPolicyArgs;
import com.pulumi.aws.emr.inputs.ManagedScalingPolicyState;
import com.pulumi.aws.emr.outputs.ManagedScalingPolicyComputeLimit;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.ManagedScalingPolicy;
 * import com.pulumi.aws.emr.ManagedScalingPolicyArgs;
 * import com.pulumi.aws.emr.inputs.ManagedScalingPolicyComputeLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var sample = new Cluster(&#34;sample&#34;, ClusterArgs.builder()        
 *             .releaseLabel(&#34;emr-5.30.0&#34;)
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType(&#34;m4.large&#34;)
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType(&#34;c4.large&#34;)
 *                 .build())
 *             .build());
 * 
 *         var samplepolicy = new ManagedScalingPolicy(&#34;samplepolicy&#34;, ManagedScalingPolicyArgs.builder()        
 *             .clusterId(sample.id())
 *             .computeLimits(ManagedScalingPolicyComputeLimitArgs.builder()
 *                 .unitType(&#34;Instances&#34;)
 *                 .minimumCapacityUnits(2)
 *                 .maximumCapacityUnits(10)
 *                 .maximumOndemandCapacityUnits(2)
 *                 .maximumCoreCapacityUnits(10)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EMR Managed Scaling Policies using the EMR Cluster identifier. For example:
 * 
 * ```sh
 *  $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
 * ```
 * 
 */
@ResourceType(type="aws:emr/managedScalingPolicy:ManagedScalingPolicy")
public class ManagedScalingPolicy extends com.pulumi.resources.CustomResource {
    /**
     * ID of the EMR cluster
     * 
     */
    @Export(name="clusterId", refs={String.class}, tree="[0]")
    private Output<String> clusterId;

    /**
     * @return ID of the EMR cluster
     * 
     */
    public Output<String> clusterId() {
        return this.clusterId;
    }
    /**
     * Configuration block with compute limit settings. Described below.
     * 
     */
    @Export(name="computeLimits", refs={List.class,ManagedScalingPolicyComputeLimit.class}, tree="[0,1]")
    private Output<List<ManagedScalingPolicyComputeLimit>> computeLimits;

    /**
     * @return Configuration block with compute limit settings. Described below.
     * 
     */
    public Output<List<ManagedScalingPolicyComputeLimit>> computeLimits() {
        return this.computeLimits;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ManagedScalingPolicy(String name) {
        this(name, ManagedScalingPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ManagedScalingPolicy(String name, ManagedScalingPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ManagedScalingPolicy(String name, ManagedScalingPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/managedScalingPolicy:ManagedScalingPolicy", name, args == null ? ManagedScalingPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ManagedScalingPolicy(String name, Output<String> id, @Nullable ManagedScalingPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/managedScalingPolicy:ManagedScalingPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ManagedScalingPolicy get(String name, Output<String> id, @Nullable ManagedScalingPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ManagedScalingPolicy(name, id, state, options);
    }
}
