// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.emr.InstanceGroupArgs;
import com.pulumi.aws.emr.inputs.InstanceGroupState;
import com.pulumi.aws.emr.outputs.InstanceGroupEbsConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Elastic MapReduce Cluster Instance Group configuration.
 * See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/emr/) for more information.
 * 
 * &gt; **NOTE:** At this time, Instance Groups cannot be destroyed through the API nor
 * web interface. Instance Groups are destroyed when the EMR Cluster is destroyed.
 * this provider will resize any Instance Group to zero when destroying the resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceGroup;
 * import com.pulumi.aws.emr.InstanceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var task = new InstanceGroup(&#34;task&#34;, InstanceGroupArgs.builder()        
 *             .clusterId(aws_emr_cluster.tf-test-cluster().id())
 *             .instanceCount(1)
 *             .instanceType(&#34;m5.xlarge&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EMR task instance group using their EMR Cluster id and Instance Group id separated by a forward-slash `/`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:emr/instanceGroup:InstanceGroup task_group j-123456ABCDEF/ig-15EK4O09RZLNR
 * ```
 * 
 */
@ResourceType(type="aws:emr/instanceGroup:InstanceGroup")
public class InstanceGroup extends com.pulumi.resources.CustomResource {
    /**
     * The autoscaling policy document. This is a JSON formatted string. See [EMR Auto Scaling](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html)
     * 
     */
    @Export(name="autoscalingPolicy", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> autoscalingPolicy;

    /**
     * @return The autoscaling policy document. This is a JSON formatted string. See [EMR Auto Scaling](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html)
     * 
     */
    public Output<Optional<String>> autoscalingPolicy() {
        return Codegen.optional(this.autoscalingPolicy);
    }
    /**
     * If set, the bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     * 
     */
    @Export(name="bidPrice", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> bidPrice;

    /**
     * @return If set, the bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     * 
     */
    public Output<Optional<String>> bidPrice() {
        return Codegen.optional(this.bidPrice);
    }
    /**
     * ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     * 
     */
    @Export(name="clusterId", refs={String.class}, tree="[0]")
    private Output<String> clusterId;

    /**
     * @return ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     * 
     */
    public Output<String> clusterId() {
        return this.clusterId;
    }
    /**
     * A JSON string for supplying list of configurations specific to the EMR instance group. Note that this can only be changed when using EMR release 5.21 or later.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.InstanceGroup;
     * import com.pulumi.aws.emr.InstanceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         var task = new InstanceGroup(&#34;task&#34;, InstanceGroupArgs.builder()        
     *             .configurationsJson(&#34;&#34;&#34;
     * [
     * {
     * &#34;Classification&#34;: &#34;hadoop-env&#34;,
     * &#34;Configurations&#34;: [
     * {
     * &#34;Classification&#34;: &#34;export&#34;,
     * &#34;Properties&#34;: {
     * &#34;JAVA_HOME&#34;: &#34;/usr/lib/jvm/java-1.8.0&#34;
     * }
     * }
     * ],
     * &#34;Properties&#34;: {}
     * }
     * ]
     * 
     *             &#34;&#34;&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    @Export(name="configurationsJson", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> configurationsJson;

    /**
     * @return A JSON string for supplying list of configurations specific to the EMR instance group. Note that this can only be changed when using EMR release 5.21 or later.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.InstanceGroup;
     * import com.pulumi.aws.emr.InstanceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         var task = new InstanceGroup(&#34;task&#34;, InstanceGroupArgs.builder()        
     *             .configurationsJson(&#34;&#34;&#34;
     * [
     * {
     * &#34;Classification&#34;: &#34;hadoop-env&#34;,
     * &#34;Configurations&#34;: [
     * {
     * &#34;Classification&#34;: &#34;export&#34;,
     * &#34;Properties&#34;: {
     * &#34;JAVA_HOME&#34;: &#34;/usr/lib/jvm/java-1.8.0&#34;
     * }
     * }
     * ],
     * &#34;Properties&#34;: {}
     * }
     * ]
     * 
     *             &#34;&#34;&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public Output<Optional<String>> configurationsJson() {
        return Codegen.optional(this.configurationsJson);
    }
    /**
     * One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     * 
     */
    @Export(name="ebsConfigs", refs={List.class,InstanceGroupEbsConfig.class}, tree="[0,1]")
    private Output<List<InstanceGroupEbsConfig>> ebsConfigs;

    /**
     * @return One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     * 
     */
    public Output<List<InstanceGroupEbsConfig>> ebsConfigs() {
        return this.ebsConfigs;
    }
    /**
     * Indicates whether an Amazon EBS volume is EBS-optimized. Changing this forces a new resource to be created.
     * 
     */
    @Export(name="ebsOptimized", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> ebsOptimized;

    /**
     * @return Indicates whether an Amazon EBS volume is EBS-optimized. Changing this forces a new resource to be created.
     * 
     */
    public Output<Optional<Boolean>> ebsOptimized() {
        return Codegen.optional(this.ebsOptimized);
    }
    /**
     * target number of instances for the instance group. defaults to 0.
     * 
     */
    @Export(name="instanceCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> instanceCount;

    /**
     * @return target number of instances for the instance group. defaults to 0.
     * 
     */
    public Output<Integer> instanceCount() {
        return this.instanceCount;
    }
    /**
     * The EC2 instance type for all instances in the instance group. Changing this forces a new resource to be created.
     * 
     */
    @Export(name="instanceType", refs={String.class}, tree="[0]")
    private Output<String> instanceType;

    /**
     * @return The EC2 instance type for all instances in the instance group. Changing this forces a new resource to be created.
     * 
     */
    public Output<String> instanceType() {
        return this.instanceType;
    }
    /**
     * Human friendly name given to the instance group. Changing this forces a new resource to be created.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Human friendly name given to the instance group. Changing this forces a new resource to be created.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The number of instances currently running in this instance group.
     * 
     */
    @Export(name="runningInstanceCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> runningInstanceCount;

    /**
     * @return The number of instances currently running in this instance group.
     * 
     */
    public Output<Integer> runningInstanceCount() {
        return this.runningInstanceCount;
    }
    /**
     * The current status of the instance group.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The current status of the instance group.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public InstanceGroup(String name) {
        this(name, InstanceGroupArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public InstanceGroup(String name, InstanceGroupArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public InstanceGroup(String name, InstanceGroupArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/instanceGroup:InstanceGroup", name, args == null ? InstanceGroupArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private InstanceGroup(String name, Output<String> id, @Nullable InstanceGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/instanceGroup:InstanceGroup", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static InstanceGroup get(String name, Output<String> id, @Nullable InstanceGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new InstanceGroup(name, id, state, options);
    }
}
