// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr;

import com.pulumi.aws.emr.inputs.ClusterAutoTerminationPolicyArgs;
import com.pulumi.aws.emr.inputs.ClusterBootstrapActionArgs;
import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs;
import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
import com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs;
import com.pulumi.aws.emr.inputs.ClusterKerberosAttributesArgs;
import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs;
import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
import com.pulumi.aws.emr.inputs.ClusterPlacementGroupConfigArgs;
import com.pulumi.aws.emr.inputs.ClusterStepArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterArgs Empty = new ClusterArgs();

    /**
     * JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
     * 
     */
    @Import(name="additionalInfo")
    private @Nullable Output<String> additionalInfo;

    /**
     * @return JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
     * 
     */
    public Optional<Output<String>> additionalInfo() {
        return Optional.ofNullable(this.additionalInfo);
    }

    /**
     * A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     * 
     */
    @Import(name="applications")
    private @Nullable Output<List<String>> applications;

    /**
     * @return A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     * 
     */
    public Optional<Output<List<String>>> applications() {
        return Optional.ofNullable(this.applications);
    }

    /**
     * An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
     * 
     */
    @Import(name="autoTerminationPolicy")
    private @Nullable Output<ClusterAutoTerminationPolicyArgs> autoTerminationPolicy;

    /**
     * @return An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
     * 
     */
    public Optional<Output<ClusterAutoTerminationPolicyArgs>> autoTerminationPolicy() {
        return Optional.ofNullable(this.autoTerminationPolicy);
    }

    /**
     * IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     * 
     */
    @Import(name="autoscalingRole")
    private @Nullable Output<String> autoscalingRole;

    /**
     * @return IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
     * 
     */
    public Optional<Output<String>> autoscalingRole() {
        return Optional.ofNullable(this.autoscalingRole);
    }

    /**
     * Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     * 
     */
    @Import(name="bootstrapActions")
    private @Nullable Output<List<ClusterBootstrapActionArgs>> bootstrapActions;

    /**
     * @return Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
     * 
     */
    public Optional<Output<List<ClusterBootstrapActionArgs>>> bootstrapActions() {
        return Optional.ofNullable(this.bootstrapActions);
    }

    /**
     * List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
     * 
     */
    @Import(name="configurations")
    private @Nullable Output<String> configurations;

    /**
     * @return List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
     * 
     */
    public Optional<Output<String>> configurations() {
        return Optional.ofNullable(this.configurations);
    }

    /**
     * JSON string for supplying list of configurations for the EMR cluster.
     * 
     * &gt; **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `&#34;Configurations&#34;: []`.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.Cluster;
     * import com.pulumi.aws.emr.ClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         var cluster = new Cluster(&#34;cluster&#34;, ClusterArgs.builder()        
     *             .configurationsJson(&#34;&#34;&#34;
     * [
     * {
     * &#34;Classification&#34;: &#34;hadoop-env&#34;,
     * &#34;Configurations&#34;: [
     * {
     * &#34;Classification&#34;: &#34;export&#34;,
     * &#34;Properties&#34;: {
     * &#34;JAVA_HOME&#34;: &#34;/usr/lib/jvm/java-1.8.0&#34;
     * }
     * }
     * ],
     * &#34;Properties&#34;: {}
     * }
     * ]
     * 
     *             &#34;&#34;&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    @Import(name="configurationsJson")
    private @Nullable Output<String> configurationsJson;

    /**
     * @return JSON string for supplying list of configurations for the EMR cluster.
     * 
     * &gt; **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `&#34;Configurations&#34;: []`.
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.Cluster;
     * import com.pulumi.aws.emr.ClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         var cluster = new Cluster(&#34;cluster&#34;, ClusterArgs.builder()        
     *             .configurationsJson(&#34;&#34;&#34;
     * [
     * {
     * &#34;Classification&#34;: &#34;hadoop-env&#34;,
     * &#34;Configurations&#34;: [
     * {
     * &#34;Classification&#34;: &#34;export&#34;,
     * &#34;Properties&#34;: {
     * &#34;JAVA_HOME&#34;: &#34;/usr/lib/jvm/java-1.8.0&#34;
     * }
     * }
     * ],
     * &#34;Properties&#34;: {}
     * }
     * ]
     * 
     *             &#34;&#34;&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public Optional<Output<String>> configurationsJson() {
        return Optional.ofNullable(this.configurationsJson);
    }

    /**
     * Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
     * 
     */
    @Import(name="coreInstanceFleet")
    private @Nullable Output<ClusterCoreInstanceFleetArgs> coreInstanceFleet;

    /**
     * @return Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
     * 
     */
    public Optional<Output<ClusterCoreInstanceFleetArgs>> coreInstanceFleet() {
        return Optional.ofNullable(this.coreInstanceFleet);
    }

    /**
     * Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
     * 
     */
    @Import(name="coreInstanceGroup")
    private @Nullable Output<ClusterCoreInstanceGroupArgs> coreInstanceGroup;

    /**
     * @return Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
     * 
     */
    public Optional<Output<ClusterCoreInstanceGroupArgs>> coreInstanceGroup() {
        return Optional.ofNullable(this.coreInstanceGroup);
    }

    /**
     * Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
     * 
     */
    @Import(name="customAmiId")
    private @Nullable Output<String> customAmiId;

    /**
     * @return Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
     * 
     */
    public Optional<Output<String>> customAmiId() {
        return Optional.ofNullable(this.customAmiId);
    }

    /**
     * Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
     * 
     */
    @Import(name="ebsRootVolumeSize")
    private @Nullable Output<Integer> ebsRootVolumeSize;

    /**
     * @return Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
     * 
     */
    public Optional<Output<Integer>> ebsRootVolumeSize() {
        return Optional.ofNullable(this.ebsRootVolumeSize);
    }

    /**
     * Attributes for the EC2 instances running the job flow. See below.
     * 
     */
    @Import(name="ec2Attributes")
    private @Nullable Output<ClusterEc2AttributesArgs> ec2Attributes;

    /**
     * @return Attributes for the EC2 instances running the job flow. See below.
     * 
     */
    public Optional<Output<ClusterEc2AttributesArgs>> ec2Attributes() {
        return Optional.ofNullable(this.ec2Attributes);
    }

    /**
     * Switch on/off run cluster with no steps or when all steps are complete (default is on)
     * 
     */
    @Import(name="keepJobFlowAliveWhenNoSteps")
    private @Nullable Output<Boolean> keepJobFlowAliveWhenNoSteps;

    /**
     * @return Switch on/off run cluster with no steps or when all steps are complete (default is on)
     * 
     */
    public Optional<Output<Boolean>> keepJobFlowAliveWhenNoSteps() {
        return Optional.ofNullable(this.keepJobFlowAliveWhenNoSteps);
    }

    /**
     * Kerberos configuration for the cluster. See below.
     * 
     */
    @Import(name="kerberosAttributes")
    private @Nullable Output<ClusterKerberosAttributesArgs> kerberosAttributes;

    /**
     * @return Kerberos configuration for the cluster. See below.
     * 
     */
    public Optional<Output<ClusterKerberosAttributesArgs>> kerberosAttributes() {
        return Optional.ofNullable(this.kerberosAttributes);
    }

    /**
     * List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     * 
     */
    @Import(name="listStepsStates")
    private @Nullable Output<List<String>> listStepsStates;

    /**
     * @return List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
     * 
     */
    public Optional<Output<List<String>>> listStepsStates() {
        return Optional.ofNullable(this.listStepsStates);
    }

    /**
     * AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     * 
     */
    @Import(name="logEncryptionKmsKeyId")
    private @Nullable Output<String> logEncryptionKmsKeyId;

    /**
     * @return AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     * 
     */
    public Optional<Output<String>> logEncryptionKmsKeyId() {
        return Optional.ofNullable(this.logEncryptionKmsKeyId);
    }

    /**
     * S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
     * 
     */
    @Import(name="logUri")
    private @Nullable Output<String> logUri;

    /**
     * @return S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
     * 
     */
    public Optional<Output<String>> logUri() {
        return Optional.ofNullable(this.logUri);
    }

    /**
     * Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
     * 
     */
    @Import(name="masterInstanceFleet")
    private @Nullable Output<ClusterMasterInstanceFleetArgs> masterInstanceFleet;

    /**
     * @return Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
     * 
     */
    public Optional<Output<ClusterMasterInstanceFleetArgs>> masterInstanceFleet() {
        return Optional.ofNullable(this.masterInstanceFleet);
    }

    /**
     * Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
     * 
     */
    @Import(name="masterInstanceGroup")
    private @Nullable Output<ClusterMasterInstanceGroupArgs> masterInstanceGroup;

    /**
     * @return Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
     * 
     */
    public Optional<Output<ClusterMasterInstanceGroupArgs>> masterInstanceGroup() {
        return Optional.ofNullable(this.masterInstanceGroup);
    }

    /**
     * Name of the job flow.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the job flow.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The specified placement group configuration for an Amazon EMR cluster.
     * 
     */
    @Import(name="placementGroupConfigs")
    private @Nullable Output<List<ClusterPlacementGroupConfigArgs>> placementGroupConfigs;

    /**
     * @return The specified placement group configuration for an Amazon EMR cluster.
     * 
     */
    public Optional<Output<List<ClusterPlacementGroupConfigArgs>>> placementGroupConfigs() {
        return Optional.ofNullable(this.placementGroupConfigs);
    }

    /**
     * Release label for the Amazon EMR release.
     * 
     */
    @Import(name="releaseLabel", required=true)
    private Output<String> releaseLabel;

    /**
     * @return Release label for the Amazon EMR release.
     * 
     */
    public Output<String> releaseLabel() {
        return this.releaseLabel;
    }

    /**
     * Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
     * 
     */
    @Import(name="scaleDownBehavior")
    private @Nullable Output<String> scaleDownBehavior;

    /**
     * @return Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
     * 
     */
    public Optional<Output<String>> scaleDownBehavior() {
        return Optional.ofNullable(this.scaleDownBehavior);
    }

    /**
     * Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
     * 
     */
    @Import(name="securityConfiguration")
    private @Nullable Output<String> securityConfiguration;

    /**
     * @return Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
     * 
     */
    public Optional<Output<String>> securityConfiguration() {
        return Optional.ofNullable(this.securityConfiguration);
    }

    /**
     * IAM role that will be assumed by the Amazon EMR service to access AWS resources.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="serviceRole", required=true)
    private Output<String> serviceRole;

    /**
     * @return IAM role that will be assumed by the Amazon EMR service to access AWS resources.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> serviceRole() {
        return this.serviceRole;
    }

    /**
     * Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
     * 
     */
    @Import(name="stepConcurrencyLevel")
    private @Nullable Output<Integer> stepConcurrencyLevel;

    /**
     * @return Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
     * 
     */
    public Optional<Output<Integer>> stepConcurrencyLevel() {
        return Optional.ofNullable(this.stepConcurrencyLevel);
    }

    /**
     * List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     * 
     */
    @Import(name="steps")
    private @Nullable Output<List<ClusterStepArgs>> steps;

    /**
     * @return List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
     * 
     */
    public Optional<Output<List<ClusterStepArgs>>> steps() {
        return Optional.ofNullable(this.steps);
    }

    /**
     * list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
     * 
     */
    @Import(name="terminationProtection")
    private @Nullable Output<Boolean> terminationProtection;

    /**
     * @return Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
     * 
     */
    public Optional<Output<Boolean>> terminationProtection() {
        return Optional.ofNullable(this.terminationProtection);
    }

    /**
     * Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
     * 
     */
    @Import(name="visibleToAllUsers")
    private @Nullable Output<Boolean> visibleToAllUsers;

    /**
     * @return Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
     * 
     */
    public Optional<Output<Boolean>> visibleToAllUsers() {
        return Optional.ofNullable(this.visibleToAllUsers);
    }

    private ClusterArgs() {}

    private ClusterArgs(ClusterArgs $) {
        this.additionalInfo = $.additionalInfo;
        this.applications = $.applications;
        this.autoTerminationPolicy = $.autoTerminationPolicy;
        this.autoscalingRole = $.autoscalingRole;
        this.bootstrapActions = $.bootstrapActions;
        this.configurations = $.configurations;
        this.configurationsJson = $.configurationsJson;
        this.coreInstanceFleet = $.coreInstanceFleet;
        this.coreInstanceGroup = $.coreInstanceGroup;
        this.customAmiId = $.customAmiId;
        this.ebsRootVolumeSize = $.ebsRootVolumeSize;
        this.ec2Attributes = $.ec2Attributes;
        this.keepJobFlowAliveWhenNoSteps = $.keepJobFlowAliveWhenNoSteps;
        this.kerberosAttributes = $.kerberosAttributes;
        this.listStepsStates = $.listStepsStates;
        this.logEncryptionKmsKeyId = $.logEncryptionKmsKeyId;
        this.logUri = $.logUri;
        this.masterInstanceFleet = $.masterInstanceFleet;
        this.masterInstanceGroup = $.masterInstanceGroup;
        this.name = $.name;
        this.placementGroupConfigs = $.placementGroupConfigs;
        this.releaseLabel = $.releaseLabel;
        this.scaleDownBehavior = $.scaleDownBehavior;
        this.securityConfiguration = $.securityConfiguration;
        this.serviceRole = $.serviceRole;
        this.stepConcurrencyLevel = $.stepConcurrencyLevel;
        this.steps = $.steps;
        this.tags = $.tags;
        this.terminationProtection = $.terminationProtection;
        this.visibleToAllUsers = $.visibleToAllUsers;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterArgs $;

        public Builder() {
            $ = new ClusterArgs();
        }

        public Builder(ClusterArgs defaults) {
            $ = new ClusterArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param additionalInfo JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
         * 
         * @return builder
         * 
         */
        public Builder additionalInfo(@Nullable Output<String> additionalInfo) {
            $.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * @param additionalInfo JSON string for selecting additional features such as adding proxy information. Note: Currently there is no API to retrieve the value of this argument after EMR cluster creation from provider, therefore the provider cannot detect drift from the actual EMR cluster if its value is changed outside the provider.
         * 
         * @return builder
         * 
         */
        public Builder additionalInfo(String additionalInfo) {
            return additionalInfo(Output.of(additionalInfo));
        }

        /**
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
         * 
         * @return builder
         * 
         */
        public Builder applications(@Nullable Output<List<String>> applications) {
            $.applications = applications;
            return this;
        }

        /**
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
         * 
         * @return builder
         * 
         */
        public Builder applications(List<String> applications) {
            return applications(Output.of(applications));
        }

        /**
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
         * 
         * @return builder
         * 
         */
        public Builder applications(String... applications) {
            return applications(List.of(applications));
        }

        /**
         * @param autoTerminationPolicy An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
         * 
         * @return builder
         * 
         */
        public Builder autoTerminationPolicy(@Nullable Output<ClusterAutoTerminationPolicyArgs> autoTerminationPolicy) {
            $.autoTerminationPolicy = autoTerminationPolicy;
            return this;
        }

        /**
         * @param autoTerminationPolicy An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. See Auto Termination Policy Below.
         * 
         * @return builder
         * 
         */
        public Builder autoTerminationPolicy(ClusterAutoTerminationPolicyArgs autoTerminationPolicy) {
            return autoTerminationPolicy(Output.of(autoTerminationPolicy));
        }

        /**
         * @param autoscalingRole IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
         * 
         * @return builder
         * 
         */
        public Builder autoscalingRole(@Nullable Output<String> autoscalingRole) {
            $.autoscalingRole = autoscalingRole;
            return this;
        }

        /**
         * @param autoscalingRole IAM role for automatic scaling policies. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.
         * 
         * @return builder
         * 
         */
        public Builder autoscalingRole(String autoscalingRole) {
            return autoscalingRole(Output.of(autoscalingRole));
        }

        /**
         * @param bootstrapActions Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapActions(@Nullable Output<List<ClusterBootstrapActionArgs>> bootstrapActions) {
            $.bootstrapActions = bootstrapActions;
            return this;
        }

        /**
         * @param bootstrapActions Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapActions(List<ClusterBootstrapActionArgs> bootstrapActions) {
            return bootstrapActions(Output.of(bootstrapActions));
        }

        /**
         * @param bootstrapActions Ordered list of bootstrap actions that will be run before Hadoop is started on the cluster nodes. See below.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapActions(ClusterBootstrapActionArgs... bootstrapActions) {
            return bootstrapActions(List.of(bootstrapActions));
        }

        /**
         * @param configurations List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder configurations(@Nullable Output<String> configurations) {
            $.configurations = configurations;
            return this;
        }

        /**
         * @param configurations List of configurations supplied for the EMR cluster you are creating. Supply a configuration object for applications to override their default configuration. See [AWS Documentation](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder configurations(String configurations) {
            return configurations(Output.of(configurations));
        }

        /**
         * @param configurationsJson JSON string for supplying list of configurations for the EMR cluster.
         * 
         * &gt; **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `&#34;Configurations&#34;: []`.
         * ```java
         * package generated_program;
         * 
         * import com.pulumi.Context;
         * import com.pulumi.Pulumi;
         * import com.pulumi.core.Output;
         * import com.pulumi.aws.emr.Cluster;
         * import com.pulumi.aws.emr.ClusterArgs;
         * import java.util.List;
         * import java.util.ArrayList;
         * import java.util.Map;
         * import java.io.File;
         * import java.nio.file.Files;
         * import java.nio.file.Paths;
         * 
         * public class App {
         *     public static void main(String[] args) {
         *         Pulumi.run(App::stack);
         *     }
         * 
         *     public static void stack(Context ctx) {
         *         var cluster = new Cluster(&#34;cluster&#34;, ClusterArgs.builder()        
         *             .configurationsJson(&#34;&#34;&#34;
         * [
         * {
         * &#34;Classification&#34;: &#34;hadoop-env&#34;,
         * &#34;Configurations&#34;: [
         * {
         * &#34;Classification&#34;: &#34;export&#34;,
         * &#34;Properties&#34;: {
         * &#34;JAVA_HOME&#34;: &#34;/usr/lib/jvm/java-1.8.0&#34;
         * }
         * }
         * ],
         * &#34;Properties&#34;: {}
         * }
         * ]
         * 
         *             &#34;&#34;&#34;)
         *             .build());
         * 
         *     }
         * }
         * ```
         * 
         * @return builder
         * 
         */
        public Builder configurationsJson(@Nullable Output<String> configurationsJson) {
            $.configurationsJson = configurationsJson;
            return this;
        }

        /**
         * @param configurationsJson JSON string for supplying list of configurations for the EMR cluster.
         * 
         * &gt; **NOTE on `configurations_json`:** If the `Configurations` value is empty then you should skip the `Configurations` field instead of providing an empty list as a value, `&#34;Configurations&#34;: []`.
         * ```java
         * package generated_program;
         * 
         * import com.pulumi.Context;
         * import com.pulumi.Pulumi;
         * import com.pulumi.core.Output;
         * import com.pulumi.aws.emr.Cluster;
         * import com.pulumi.aws.emr.ClusterArgs;
         * import java.util.List;
         * import java.util.ArrayList;
         * import java.util.Map;
         * import java.io.File;
         * import java.nio.file.Files;
         * import java.nio.file.Paths;
         * 
         * public class App {
         *     public static void main(String[] args) {
         *         Pulumi.run(App::stack);
         *     }
         * 
         *     public static void stack(Context ctx) {
         *         var cluster = new Cluster(&#34;cluster&#34;, ClusterArgs.builder()        
         *             .configurationsJson(&#34;&#34;&#34;
         * [
         * {
         * &#34;Classification&#34;: &#34;hadoop-env&#34;,
         * &#34;Configurations&#34;: [
         * {
         * &#34;Classification&#34;: &#34;export&#34;,
         * &#34;Properties&#34;: {
         * &#34;JAVA_HOME&#34;: &#34;/usr/lib/jvm/java-1.8.0&#34;
         * }
         * }
         * ],
         * &#34;Properties&#34;: {}
         * }
         * ]
         * 
         *             &#34;&#34;&#34;)
         *             .build());
         * 
         *     }
         * }
         * ```
         * 
         * @return builder
         * 
         */
        public Builder configurationsJson(String configurationsJson) {
            return configurationsJson(Output.of(configurationsJson));
        }

        /**
         * @param coreInstanceFleet Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder coreInstanceFleet(@Nullable Output<ClusterCoreInstanceFleetArgs> coreInstanceFleet) {
            $.coreInstanceFleet = coreInstanceFleet;
            return this;
        }

        /**
         * @param coreInstanceFleet Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the core node type. Cannot be specified if any `core_instance_group` configuration blocks are set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder coreInstanceFleet(ClusterCoreInstanceFleetArgs coreInstanceFleet) {
            return coreInstanceFleet(Output.of(coreInstanceFleet));
        }

        /**
         * @param coreInstanceGroup Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
         * 
         * @return builder
         * 
         */
        public Builder coreInstanceGroup(@Nullable Output<ClusterCoreInstanceGroupArgs> coreInstanceGroup) {
            $.coreInstanceGroup = coreInstanceGroup;
            return this;
        }

        /**
         * @param coreInstanceGroup Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [core node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-core).
         * 
         * @return builder
         * 
         */
        public Builder coreInstanceGroup(ClusterCoreInstanceGroupArgs coreInstanceGroup) {
            return coreInstanceGroup(Output.of(coreInstanceGroup));
        }

        /**
         * @param customAmiId Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
         * 
         * @return builder
         * 
         */
        public Builder customAmiId(@Nullable Output<String> customAmiId) {
            $.customAmiId = customAmiId;
            return this;
        }

        /**
         * @param customAmiId Custom Amazon Linux AMI for the cluster (instead of an EMR-owned AMI). Available in Amazon EMR version 5.7.0 and later.
         * 
         * @return builder
         * 
         */
        public Builder customAmiId(String customAmiId) {
            return customAmiId(Output.of(customAmiId));
        }

        /**
         * @param ebsRootVolumeSize Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
         * 
         * @return builder
         * 
         */
        public Builder ebsRootVolumeSize(@Nullable Output<Integer> ebsRootVolumeSize) {
            $.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        /**
         * @param ebsRootVolumeSize Size in GiB of the EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
         * 
         * @return builder
         * 
         */
        public Builder ebsRootVolumeSize(Integer ebsRootVolumeSize) {
            return ebsRootVolumeSize(Output.of(ebsRootVolumeSize));
        }

        /**
         * @param ec2Attributes Attributes for the EC2 instances running the job flow. See below.
         * 
         * @return builder
         * 
         */
        public Builder ec2Attributes(@Nullable Output<ClusterEc2AttributesArgs> ec2Attributes) {
            $.ec2Attributes = ec2Attributes;
            return this;
        }

        /**
         * @param ec2Attributes Attributes for the EC2 instances running the job flow. See below.
         * 
         * @return builder
         * 
         */
        public Builder ec2Attributes(ClusterEc2AttributesArgs ec2Attributes) {
            return ec2Attributes(Output.of(ec2Attributes));
        }

        /**
         * @param keepJobFlowAliveWhenNoSteps Switch on/off run cluster with no steps or when all steps are complete (default is on)
         * 
         * @return builder
         * 
         */
        public Builder keepJobFlowAliveWhenNoSteps(@Nullable Output<Boolean> keepJobFlowAliveWhenNoSteps) {
            $.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
            return this;
        }

        /**
         * @param keepJobFlowAliveWhenNoSteps Switch on/off run cluster with no steps or when all steps are complete (default is on)
         * 
         * @return builder
         * 
         */
        public Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            return keepJobFlowAliveWhenNoSteps(Output.of(keepJobFlowAliveWhenNoSteps));
        }

        /**
         * @param kerberosAttributes Kerberos configuration for the cluster. See below.
         * 
         * @return builder
         * 
         */
        public Builder kerberosAttributes(@Nullable Output<ClusterKerberosAttributesArgs> kerberosAttributes) {
            $.kerberosAttributes = kerberosAttributes;
            return this;
        }

        /**
         * @param kerberosAttributes Kerberos configuration for the cluster. See below.
         * 
         * @return builder
         * 
         */
        public Builder kerberosAttributes(ClusterKerberosAttributesArgs kerberosAttributes) {
            return kerberosAttributes(Output.of(kerberosAttributes));
        }

        /**
         * @param listStepsStates List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
         * 
         * @return builder
         * 
         */
        public Builder listStepsStates(@Nullable Output<List<String>> listStepsStates) {
            $.listStepsStates = listStepsStates;
            return this;
        }

        /**
         * @param listStepsStates List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
         * 
         * @return builder
         * 
         */
        public Builder listStepsStates(List<String> listStepsStates) {
            return listStepsStates(Output.of(listStepsStates));
        }

        /**
         * @param listStepsStates List of [step states](https://docs.aws.amazon.com/emr/latest/APIReference/API_StepStatus.html) used to filter returned steps
         * 
         * @return builder
         * 
         */
        public Builder listStepsStates(String... listStepsStates) {
            return listStepsStates(List.of(listStepsStates));
        }

        /**
         * @param logEncryptionKmsKeyId AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
         * 
         * @return builder
         * 
         */
        public Builder logEncryptionKmsKeyId(@Nullable Output<String> logEncryptionKmsKeyId) {
            $.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
            return this;
        }

        /**
         * @param logEncryptionKmsKeyId AWS KMS customer master key (CMK) key ID or arn used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
         * 
         * @return builder
         * 
         */
        public Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            return logEncryptionKmsKeyId(Output.of(logEncryptionKmsKeyId));
        }

        /**
         * @param logUri S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
         * 
         * @return builder
         * 
         */
        public Builder logUri(@Nullable Output<String> logUri) {
            $.logUri = logUri;
            return this;
        }

        /**
         * @param logUri S3 bucket to write the log files of the job flow. If a value is not provided, logs are not created.
         * 
         * @return builder
         * 
         */
        public Builder logUri(String logUri) {
            return logUri(Output.of(logUri));
        }

        /**
         * @param masterInstanceFleet Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder masterInstanceFleet(@Nullable Output<ClusterMasterInstanceFleetArgs> masterInstanceFleet) {
            $.masterInstanceFleet = masterInstanceFleet;
            return this;
        }

        /**
         * @param masterInstanceFleet Configuration block to use an [Instance Fleet](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html) for the master node type. Cannot be specified if any `master_instance_group` configuration blocks are set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder masterInstanceFleet(ClusterMasterInstanceFleetArgs masterInstanceFleet) {
            return masterInstanceFleet(Output.of(masterInstanceFleet));
        }

        /**
         * @param masterInstanceGroup Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
         * 
         * @return builder
         * 
         */
        public Builder masterInstanceGroup(@Nullable Output<ClusterMasterInstanceGroupArgs> masterInstanceGroup) {
            $.masterInstanceGroup = masterInstanceGroup;
            return this;
        }

        /**
         * @param masterInstanceGroup Configuration block to use an [Instance Group](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-group-configuration.html#emr-plan-instance-groups) for the [master node type](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-master-core-task-nodes.html#emr-plan-master).
         * 
         * @return builder
         * 
         */
        public Builder masterInstanceGroup(ClusterMasterInstanceGroupArgs masterInstanceGroup) {
            return masterInstanceGroup(Output.of(masterInstanceGroup));
        }

        /**
         * @param name Name of the job flow.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the job flow.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param placementGroupConfigs The specified placement group configuration for an Amazon EMR cluster.
         * 
         * @return builder
         * 
         */
        public Builder placementGroupConfigs(@Nullable Output<List<ClusterPlacementGroupConfigArgs>> placementGroupConfigs) {
            $.placementGroupConfigs = placementGroupConfigs;
            return this;
        }

        /**
         * @param placementGroupConfigs The specified placement group configuration for an Amazon EMR cluster.
         * 
         * @return builder
         * 
         */
        public Builder placementGroupConfigs(List<ClusterPlacementGroupConfigArgs> placementGroupConfigs) {
            return placementGroupConfigs(Output.of(placementGroupConfigs));
        }

        /**
         * @param placementGroupConfigs The specified placement group configuration for an Amazon EMR cluster.
         * 
         * @return builder
         * 
         */
        public Builder placementGroupConfigs(ClusterPlacementGroupConfigArgs... placementGroupConfigs) {
            return placementGroupConfigs(List.of(placementGroupConfigs));
        }

        /**
         * @param releaseLabel Release label for the Amazon EMR release.
         * 
         * @return builder
         * 
         */
        public Builder releaseLabel(Output<String> releaseLabel) {
            $.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * @param releaseLabel Release label for the Amazon EMR release.
         * 
         * @return builder
         * 
         */
        public Builder releaseLabel(String releaseLabel) {
            return releaseLabel(Output.of(releaseLabel));
        }

        /**
         * @param scaleDownBehavior Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
         * 
         * @return builder
         * 
         */
        public Builder scaleDownBehavior(@Nullable Output<String> scaleDownBehavior) {
            $.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        /**
         * @param scaleDownBehavior Way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an `instance group` is resized.
         * 
         * @return builder
         * 
         */
        public Builder scaleDownBehavior(String scaleDownBehavior) {
            return scaleDownBehavior(Output.of(scaleDownBehavior));
        }

        /**
         * @param securityConfiguration Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
         * 
         * @return builder
         * 
         */
        public Builder securityConfiguration(@Nullable Output<String> securityConfiguration) {
            $.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * @param securityConfiguration Security configuration name to attach to the EMR cluster. Only valid for EMR clusters with `release_label` 4.8.0 or greater.
         * 
         * @return builder
         * 
         */
        public Builder securityConfiguration(String securityConfiguration) {
            return securityConfiguration(Output.of(securityConfiguration));
        }

        /**
         * @param serviceRole IAM role that will be assumed by the Amazon EMR service to access AWS resources.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder serviceRole(Output<String> serviceRole) {
            $.serviceRole = serviceRole;
            return this;
        }

        /**
         * @param serviceRole IAM role that will be assumed by the Amazon EMR service to access AWS resources.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder serviceRole(String serviceRole) {
            return serviceRole(Output.of(serviceRole));
        }

        /**
         * @param stepConcurrencyLevel Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
         * 
         * @return builder
         * 
         */
        public Builder stepConcurrencyLevel(@Nullable Output<Integer> stepConcurrencyLevel) {
            $.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        /**
         * @param stepConcurrencyLevel Number of steps that can be executed concurrently. You can specify a maximum of 256 steps. Only valid for EMR clusters with `release_label` 5.28.0 or greater (default is 1).
         * 
         * @return builder
         * 
         */
        public Builder stepConcurrencyLevel(Integer stepConcurrencyLevel) {
            return stepConcurrencyLevel(Output.of(stepConcurrencyLevel));
        }

        /**
         * @param steps List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
         * 
         * @return builder
         * 
         */
        public Builder steps(@Nullable Output<List<ClusterStepArgs>> steps) {
            $.steps = steps;
            return this;
        }

        /**
         * @param steps List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
         * 
         * @return builder
         * 
         */
        public Builder steps(List<ClusterStepArgs> steps) {
            return steps(Output.of(steps));
        }

        /**
         * @param steps List of steps to run when creating the cluster. See below. It is highly recommended to utilize the lifecycle resource options block with `ignoreChanges` if other steps are being managed outside of this provider.
         * 
         * @return builder
         * 
         */
        public Builder steps(ClusterStepArgs... steps) {
            return steps(List.of(steps));
        }

        /**
         * @param tags list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param terminationProtection Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
         * 
         * @return builder
         * 
         */
        public Builder terminationProtection(@Nullable Output<Boolean> terminationProtection) {
            $.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * @param terminationProtection Switch on/off termination protection (default is `false`, except when using multiple master nodes). Before attempting to destroy the resource when termination protection is enabled, this configuration must be applied with its value set to `false`.
         * 
         * @return builder
         * 
         */
        public Builder terminationProtection(Boolean terminationProtection) {
            return terminationProtection(Output.of(terminationProtection));
        }

        /**
         * @param visibleToAllUsers Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
         * 
         * @return builder
         * 
         */
        public Builder visibleToAllUsers(@Nullable Output<Boolean> visibleToAllUsers) {
            $.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        /**
         * @param visibleToAllUsers Whether the job flow is visible to all IAM users of the AWS account associated with the job flow. Default value is `true`.
         * 
         * @return builder
         * 
         */
        public Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            return visibleToAllUsers(Output.of(visibleToAllUsers));
        }

        public ClusterArgs build() {
            $.releaseLabel = Objects.requireNonNull($.releaseLabel, "expected parameter 'releaseLabel' to be non-null");
            $.serviceRole = Objects.requireNonNull($.serviceRole, "expected parameter 'serviceRole' to be non-null");
            return $;
        }
    }

}
