// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.emr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationState;
import com.pulumi.aws.emr.outputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS EMR block public access configuration. This region level security configuration restricts the launch of EMR clusters that have associated security groups permitting public access on unspecified ports. See the [EMR Block Public Access Configuration](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-block-public-access.html) documentation for further information.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration(&#34;example&#34;, BlockPublicAccessConfigurationArgs.builder()        
 *             .blockPublicSecurityGroupRules(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Default Configuration
 * 
 * By default, each AWS region is equipped with a block public access configuration that prevents EMR clusters from being launched if they have security group rules permitting public access on any port except for port 22. The default configuration can be managed using this resource.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration(&#34;example&#34;, BlockPublicAccessConfigurationArgs.builder()        
 *             .blockPublicSecurityGroupRules(true)
 *             .permittedPublicSecurityGroupRuleRanges(BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                 .maxRange(22)
 *                 .minRange(22)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * &gt; **NOTE:** If an `aws.emr.BlockPublicAccessConfiguration` resource is destroyed, the configuration will reset to this default configuration.
 * ### Multiple Permitted Public Security Group Rule Ranges
 * 
 * The resource permits specification of multiple `permitted_public_security_group_rule_range` blocks.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration(&#34;example&#34;, BlockPublicAccessConfigurationArgs.builder()        
 *             .blockPublicSecurityGroupRules(true)
 *             .permittedPublicSecurityGroupRuleRanges(            
 *                 BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                     .maxRange(22)
 *                     .minRange(22)
 *                     .build(),
 *                 BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
 *                     .maxRange(101)
 *                     .minRange(100)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Disabling Block Public Access
 * 
 * To permit EMR clusters to be launched in the configured region regardless of associated security group rules, the Block Public Access feature can be disabled using this resource.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.BlockPublicAccessConfiguration;
 * import com.pulumi.aws.emr.BlockPublicAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BlockPublicAccessConfiguration(&#34;example&#34;, BlockPublicAccessConfigurationArgs.builder()        
 *             .blockPublicSecurityGroupRules(false)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import the current EMR Block Public Access Configuration. For example:
 * 
 * ```sh
 *  $ pulumi import aws:emr/blockPublicAccessConfiguration:BlockPublicAccessConfiguration example current
 * ```
 * 
 */
@ResourceType(type="aws:emr/blockPublicAccessConfiguration:BlockPublicAccessConfiguration")
public class BlockPublicAccessConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Enable or disable EMR Block Public Access.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="blockPublicSecurityGroupRules", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> blockPublicSecurityGroupRules;

    /**
     * @return Enable or disable EMR Block Public Access.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Boolean> blockPublicSecurityGroupRules() {
        return this.blockPublicSecurityGroupRules;
    }
    /**
     * Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     * 
     */
    @Export(name="permittedPublicSecurityGroupRuleRanges", refs={List.class,BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange.class}, tree="[0,1]")
    private Output</* @Nullable */ List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange>> permittedPublicSecurityGroupRuleRanges;

    /**
     * @return Configuration block for defining permitted public security group rule port ranges. Can be defined multiple times per resource. Only valid if `block_public_security_group_rules` is set to `true`.
     * 
     */
    public Output<Optional<List<BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRange>>> permittedPublicSecurityGroupRuleRanges() {
        return Codegen.optional(this.permittedPublicSecurityGroupRuleRanges);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public BlockPublicAccessConfiguration(String name) {
        this(name, BlockPublicAccessConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public BlockPublicAccessConfiguration(String name, BlockPublicAccessConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public BlockPublicAccessConfiguration(String name, BlockPublicAccessConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/blockPublicAccessConfiguration:BlockPublicAccessConfiguration", name, args == null ? BlockPublicAccessConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private BlockPublicAccessConfiguration(String name, Output<String> id, @Nullable BlockPublicAccessConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:emr/blockPublicAccessConfiguration:BlockPublicAccessConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static BlockPublicAccessConfiguration get(String name, Output<String> id, @Nullable BlockPublicAccessConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new BlockPublicAccessConfiguration(name, id, state, options);
    }
}
