// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elb;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.elb.SslNegotiationPolicyArgs;
import com.pulumi.aws.elb.inputs.SslNegotiationPolicyState;
import com.pulumi.aws.elb.outputs.SslNegotiationPolicyAttribute;
import com.pulumi.core.Alias;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a load balancer SSL negotiation policy, which allows an ELB to control the ciphers and protocols that are supported during SSL negotiations between a client and a load balancer.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.SslNegotiationPolicy;
 * import com.pulumi.aws.elb.SslNegotiationPolicyArgs;
 * import com.pulumi.aws.elb.inputs.SslNegotiationPolicyAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer(&#34;lb&#34;, LoadBalancerArgs.builder()        
 *             .availabilityZones(&#34;us-east-1a&#34;)
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol(&#34;https&#34;)
 *                 .lbPort(443)
 *                 .lbProtocol(&#34;https&#34;)
 *                 .sslCertificateId(&#34;arn:aws:iam::123456789012:server-certificate/certName&#34;)
 *                 .build())
 *             .build());
 * 
 *         var foo = new SslNegotiationPolicy(&#34;foo&#34;, SslNegotiationPolicyArgs.builder()        
 *             .loadBalancer(lb.id())
 *             .lbPort(443)
 *             .attributes(            
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;Protocol-TLSv1&#34;)
 *                     .value(&#34;false&#34;)
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;Protocol-TLSv1.1&#34;)
 *                     .value(&#34;false&#34;)
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;Protocol-TLSv1.2&#34;)
 *                     .value(&#34;true&#34;)
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;Server-Defined-Cipher-Order&#34;)
 *                     .value(&#34;true&#34;)
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;ECDHE-RSA-AES128-GCM-SHA256&#34;)
 *                     .value(&#34;true&#34;)
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;AES128-GCM-SHA256&#34;)
 *                     .value(&#34;true&#34;)
 *                     .build(),
 *                 SslNegotiationPolicyAttributeArgs.builder()
 *                     .name(&#34;EDH-RSA-DES-CBC3-SHA&#34;)
 *                     .value(&#34;false&#34;)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:elb/sslNegotiationPolicy:SslNegotiationPolicy")
public class SslNegotiationPolicy extends com.pulumi.resources.CustomResource {
    /**
     * An SSL Negotiation policy attribute. Each has two properties:
     * 
     */
    @Export(name="attributes", refs={List.class,SslNegotiationPolicyAttribute.class}, tree="[0,1]")
    private Output</* @Nullable */ List<SslNegotiationPolicyAttribute>> attributes;

    /**
     * @return An SSL Negotiation policy attribute. Each has two properties:
     * 
     */
    public Output<Optional<List<SslNegotiationPolicyAttribute>>> attributes() {
        return Codegen.optional(this.attributes);
    }
    /**
     * The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     * 
     */
    @Export(name="lbPort", refs={Integer.class}, tree="[0]")
    private Output<Integer> lbPort;

    /**
     * @return The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     * 
     */
    public Output<Integer> lbPort() {
        return this.lbPort;
    }
    /**
     * The load balancer to which the policy
     * should be attached.
     * 
     */
    @Export(name="loadBalancer", refs={String.class}, tree="[0]")
    private Output<String> loadBalancer;

    /**
     * @return The load balancer to which the policy
     * should be attached.
     * 
     */
    public Output<String> loadBalancer() {
        return this.loadBalancer;
    }
    /**
     * The name of the attribute
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the attribute
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     * 
     * To set your attributes, please see the [AWS Elastic Load Balancing Developer Guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-policy-table.html) for a listing of the supported SSL protocols, SSL options, and SSL ciphers.
     * 
     * &gt; **NOTE:** The AWS documentation references Server Order Preference, which the AWS Elastic Load Balancing API refers to as `Server-Defined-Cipher-Order`. If you wish to set Server Order Preference, use this value instead.
     * 
     */
    @Export(name="triggers", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> triggers;

    /**
     * @return Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     * 
     * To set your attributes, please see the [AWS Elastic Load Balancing Developer Guide](http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-policy-table.html) for a listing of the supported SSL protocols, SSL options, and SSL ciphers.
     * 
     * &gt; **NOTE:** The AWS documentation references Server Order Preference, which the AWS Elastic Load Balancing API refers to as `Server-Defined-Cipher-Order`. If you wish to set Server Order Preference, use this value instead.
     * 
     */
    public Output<Optional<Map<String,String>>> triggers() {
        return Codegen.optional(this.triggers);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SslNegotiationPolicy(String name) {
        this(name, SslNegotiationPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SslNegotiationPolicy(String name, SslNegotiationPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SslNegotiationPolicy(String name, SslNegotiationPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elb/sslNegotiationPolicy:SslNegotiationPolicy", name, args == null ? SslNegotiationPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SslNegotiationPolicy(String name, Output<String> id, @Nullable SslNegotiationPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elb/sslNegotiationPolicy:SslNegotiationPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .aliases(List.of(
                Output.of(Alias.builder().type("aws:elasticloadbalancing/sslNegotiationPolicy:SslNegotiationPolicy").build())
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SslNegotiationPolicy get(String name, Output<String> id, @Nullable SslNegotiationPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SslNegotiationPolicy(name, id, state, options);
    }
}
