// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elb;

import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs;
import com.pulumi.aws.elb.inputs.LoadBalancerHealthCheckArgs;
import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LoadBalancerArgs extends com.pulumi.resources.ResourceArgs {

    public static final LoadBalancerArgs Empty = new LoadBalancerArgs();

    /**
     * An Access Logs block. Access Logs documented below.
     * 
     */
    @Import(name="accessLogs")
    private @Nullable Output<LoadBalancerAccessLogsArgs> accessLogs;

    /**
     * @return An Access Logs block. Access Logs documented below.
     * 
     */
    public Optional<Output<LoadBalancerAccessLogsArgs>> accessLogs() {
        return Optional.ofNullable(this.accessLogs);
    }

    /**
     * The AZ&#39;s to serve traffic in.
     * 
     */
    @Import(name="availabilityZones")
    private @Nullable Output<List<String>> availabilityZones;

    /**
     * @return The AZ&#39;s to serve traffic in.
     * 
     */
    public Optional<Output<List<String>>> availabilityZones() {
        return Optional.ofNullable(this.availabilityZones);
    }

    /**
     * Boolean to enable connection draining. Default: `false`
     * 
     */
    @Import(name="connectionDraining")
    private @Nullable Output<Boolean> connectionDraining;

    /**
     * @return Boolean to enable connection draining. Default: `false`
     * 
     */
    public Optional<Output<Boolean>> connectionDraining() {
        return Optional.ofNullable(this.connectionDraining);
    }

    /**
     * The time in seconds to allow for connections to drain. Default: `300`
     * 
     */
    @Import(name="connectionDrainingTimeout")
    private @Nullable Output<Integer> connectionDrainingTimeout;

    /**
     * @return The time in seconds to allow for connections to drain. Default: `300`
     * 
     */
    public Optional<Output<Integer>> connectionDrainingTimeout() {
        return Optional.ofNullable(this.connectionDrainingTimeout);
    }

    /**
     * Enable cross-zone load balancing. Default: `true`
     * 
     */
    @Import(name="crossZoneLoadBalancing")
    private @Nullable Output<Boolean> crossZoneLoadBalancing;

    /**
     * @return Enable cross-zone load balancing. Default: `true`
     * 
     */
    public Optional<Output<Boolean>> crossZoneLoadBalancing() {
        return Optional.ofNullable(this.crossZoneLoadBalancing);
    }

    /**
     * Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     * 
     */
    @Import(name="desyncMitigationMode")
    private @Nullable Output<String> desyncMitigationMode;

    /**
     * @return Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     * 
     */
    public Optional<Output<String>> desyncMitigationMode() {
        return Optional.ofNullable(this.desyncMitigationMode);
    }

    /**
     * A health_check block. Health Check documented below.
     * 
     */
    @Import(name="healthCheck")
    private @Nullable Output<LoadBalancerHealthCheckArgs> healthCheck;

    /**
     * @return A health_check block. Health Check documented below.
     * 
     */
    public Optional<Output<LoadBalancerHealthCheckArgs>> healthCheck() {
        return Optional.ofNullable(this.healthCheck);
    }

    /**
     * The time in seconds that the connection is allowed to be idle. Default: `60`
     * 
     */
    @Import(name="idleTimeout")
    private @Nullable Output<Integer> idleTimeout;

    /**
     * @return The time in seconds that the connection is allowed to be idle. Default: `60`
     * 
     */
    public Optional<Output<Integer>> idleTimeout() {
        return Optional.ofNullable(this.idleTimeout);
    }

    /**
     * A list of instance ids to place in the ELB pool.
     * 
     */
    @Import(name="instances")
    private @Nullable Output<List<String>> instances;

    /**
     * @return A list of instance ids to place in the ELB pool.
     * 
     */
    public Optional<Output<List<String>>> instances() {
        return Optional.ofNullable(this.instances);
    }

    /**
     * If true, ELB will be an internal ELB.
     * 
     */
    @Import(name="internal")
    private @Nullable Output<Boolean> internal;

    /**
     * @return If true, ELB will be an internal ELB.
     * 
     */
    public Optional<Output<Boolean>> internal() {
        return Optional.ofNullable(this.internal);
    }

    /**
     * A list of listener blocks. Listeners documented below.
     * 
     */
    @Import(name="listeners", required=true)
    private Output<List<LoadBalancerListenerArgs>> listeners;

    /**
     * @return A list of listener blocks. Listeners documented below.
     * 
     */
    public Output<List<LoadBalancerListenerArgs>> listeners() {
        return this.listeners;
    }

    /**
     * The name of the ELB. By default generated by this provider.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the ELB. By default generated by this provider.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     * 
     */
    @Import(name="namePrefix")
    private @Nullable Output<String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     * 
     */
    public Optional<Output<String>> namePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    /**
     * A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     * 
     */
    @Import(name="securityGroups")
    private @Nullable Output<List<String>> securityGroups;

    /**
     * @return A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     * 
     */
    public Optional<Output<List<String>>> securityGroups() {
        return Optional.ofNullable(this.securityGroups);
    }

    /**
     * The name of the security group that you can use as
     * part of your inbound rules for your load balancer&#39;s back-end application
     * instances. Use this for Classic or Default VPC only.
     * 
     */
    @Import(name="sourceSecurityGroup")
    private @Nullable Output<String> sourceSecurityGroup;

    /**
     * @return The name of the security group that you can use as
     * part of your inbound rules for your load balancer&#39;s back-end application
     * instances. Use this for Classic or Default VPC only.
     * 
     */
    public Optional<Output<String>> sourceSecurityGroup() {
        return Optional.ofNullable(this.sourceSecurityGroup);
    }

    /**
     * A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     * 
     */
    @Import(name="subnets")
    private @Nullable Output<List<String>> subnets;

    /**
     * @return A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     * 
     */
    public Optional<Output<List<String>>> subnets() {
        return Optional.ofNullable(this.subnets);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private LoadBalancerArgs() {}

    private LoadBalancerArgs(LoadBalancerArgs $) {
        this.accessLogs = $.accessLogs;
        this.availabilityZones = $.availabilityZones;
        this.connectionDraining = $.connectionDraining;
        this.connectionDrainingTimeout = $.connectionDrainingTimeout;
        this.crossZoneLoadBalancing = $.crossZoneLoadBalancing;
        this.desyncMitigationMode = $.desyncMitigationMode;
        this.healthCheck = $.healthCheck;
        this.idleTimeout = $.idleTimeout;
        this.instances = $.instances;
        this.internal = $.internal;
        this.listeners = $.listeners;
        this.name = $.name;
        this.namePrefix = $.namePrefix;
        this.securityGroups = $.securityGroups;
        this.sourceSecurityGroup = $.sourceSecurityGroup;
        this.subnets = $.subnets;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LoadBalancerArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LoadBalancerArgs $;

        public Builder() {
            $ = new LoadBalancerArgs();
        }

        public Builder(LoadBalancerArgs defaults) {
            $ = new LoadBalancerArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessLogs An Access Logs block. Access Logs documented below.
         * 
         * @return builder
         * 
         */
        public Builder accessLogs(@Nullable Output<LoadBalancerAccessLogsArgs> accessLogs) {
            $.accessLogs = accessLogs;
            return this;
        }

        /**
         * @param accessLogs An Access Logs block. Access Logs documented below.
         * 
         * @return builder
         * 
         */
        public Builder accessLogs(LoadBalancerAccessLogsArgs accessLogs) {
            return accessLogs(Output.of(accessLogs));
        }

        /**
         * @param availabilityZones The AZ&#39;s to serve traffic in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(@Nullable Output<List<String>> availabilityZones) {
            $.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * @param availabilityZones The AZ&#39;s to serve traffic in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(List<String> availabilityZones) {
            return availabilityZones(Output.of(availabilityZones));
        }

        /**
         * @param availabilityZones The AZ&#39;s to serve traffic in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(String... availabilityZones) {
            return availabilityZones(List.of(availabilityZones));
        }

        /**
         * @param connectionDraining Boolean to enable connection draining. Default: `false`
         * 
         * @return builder
         * 
         */
        public Builder connectionDraining(@Nullable Output<Boolean> connectionDraining) {
            $.connectionDraining = connectionDraining;
            return this;
        }

        /**
         * @param connectionDraining Boolean to enable connection draining. Default: `false`
         * 
         * @return builder
         * 
         */
        public Builder connectionDraining(Boolean connectionDraining) {
            return connectionDraining(Output.of(connectionDraining));
        }

        /**
         * @param connectionDrainingTimeout The time in seconds to allow for connections to drain. Default: `300`
         * 
         * @return builder
         * 
         */
        public Builder connectionDrainingTimeout(@Nullable Output<Integer> connectionDrainingTimeout) {
            $.connectionDrainingTimeout = connectionDrainingTimeout;
            return this;
        }

        /**
         * @param connectionDrainingTimeout The time in seconds to allow for connections to drain. Default: `300`
         * 
         * @return builder
         * 
         */
        public Builder connectionDrainingTimeout(Integer connectionDrainingTimeout) {
            return connectionDrainingTimeout(Output.of(connectionDrainingTimeout));
        }

        /**
         * @param crossZoneLoadBalancing Enable cross-zone load balancing. Default: `true`
         * 
         * @return builder
         * 
         */
        public Builder crossZoneLoadBalancing(@Nullable Output<Boolean> crossZoneLoadBalancing) {
            $.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        /**
         * @param crossZoneLoadBalancing Enable cross-zone load balancing. Default: `true`
         * 
         * @return builder
         * 
         */
        public Builder crossZoneLoadBalancing(Boolean crossZoneLoadBalancing) {
            return crossZoneLoadBalancing(Output.of(crossZoneLoadBalancing));
        }

        /**
         * @param desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
         * 
         * @return builder
         * 
         */
        public Builder desyncMitigationMode(@Nullable Output<String> desyncMitigationMode) {
            $.desyncMitigationMode = desyncMitigationMode;
            return this;
        }

        /**
         * @param desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
         * 
         * @return builder
         * 
         */
        public Builder desyncMitigationMode(String desyncMitigationMode) {
            return desyncMitigationMode(Output.of(desyncMitigationMode));
        }

        /**
         * @param healthCheck A health_check block. Health Check documented below.
         * 
         * @return builder
         * 
         */
        public Builder healthCheck(@Nullable Output<LoadBalancerHealthCheckArgs> healthCheck) {
            $.healthCheck = healthCheck;
            return this;
        }

        /**
         * @param healthCheck A health_check block. Health Check documented below.
         * 
         * @return builder
         * 
         */
        public Builder healthCheck(LoadBalancerHealthCheckArgs healthCheck) {
            return healthCheck(Output.of(healthCheck));
        }

        /**
         * @param idleTimeout The time in seconds that the connection is allowed to be idle. Default: `60`
         * 
         * @return builder
         * 
         */
        public Builder idleTimeout(@Nullable Output<Integer> idleTimeout) {
            $.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * @param idleTimeout The time in seconds that the connection is allowed to be idle. Default: `60`
         * 
         * @return builder
         * 
         */
        public Builder idleTimeout(Integer idleTimeout) {
            return idleTimeout(Output.of(idleTimeout));
        }

        /**
         * @param instances A list of instance ids to place in the ELB pool.
         * 
         * @return builder
         * 
         */
        public Builder instances(@Nullable Output<List<String>> instances) {
            $.instances = instances;
            return this;
        }

        /**
         * @param instances A list of instance ids to place in the ELB pool.
         * 
         * @return builder
         * 
         */
        public Builder instances(List<String> instances) {
            return instances(Output.of(instances));
        }

        /**
         * @param instances A list of instance ids to place in the ELB pool.
         * 
         * @return builder
         * 
         */
        public Builder instances(String... instances) {
            return instances(List.of(instances));
        }

        /**
         * @param internal If true, ELB will be an internal ELB.
         * 
         * @return builder
         * 
         */
        public Builder internal(@Nullable Output<Boolean> internal) {
            $.internal = internal;
            return this;
        }

        /**
         * @param internal If true, ELB will be an internal ELB.
         * 
         * @return builder
         * 
         */
        public Builder internal(Boolean internal) {
            return internal(Output.of(internal));
        }

        /**
         * @param listeners A list of listener blocks. Listeners documented below.
         * 
         * @return builder
         * 
         */
        public Builder listeners(Output<List<LoadBalancerListenerArgs>> listeners) {
            $.listeners = listeners;
            return this;
        }

        /**
         * @param listeners A list of listener blocks. Listeners documented below.
         * 
         * @return builder
         * 
         */
        public Builder listeners(List<LoadBalancerListenerArgs> listeners) {
            return listeners(Output.of(listeners));
        }

        /**
         * @param listeners A list of listener blocks. Listeners documented below.
         * 
         * @return builder
         * 
         */
        public Builder listeners(LoadBalancerListenerArgs... listeners) {
            return listeners(List.of(listeners));
        }

        /**
         * @param name The name of the ELB. By default generated by this provider.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the ELB. By default generated by this provider.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param namePrefix Creates a unique name beginning with the specified
         * prefix. Conflicts with `name`.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(@Nullable Output<String> namePrefix) {
            $.namePrefix = namePrefix;
            return this;
        }

        /**
         * @param namePrefix Creates a unique name beginning with the specified
         * prefix. Conflicts with `name`.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(String namePrefix) {
            return namePrefix(Output.of(namePrefix));
        }

        /**
         * @param securityGroups A list of security group IDs to assign to the ELB.
         * Only valid if creating an ELB within a VPC
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(@Nullable Output<List<String>> securityGroups) {
            $.securityGroups = securityGroups;
            return this;
        }

        /**
         * @param securityGroups A list of security group IDs to assign to the ELB.
         * Only valid if creating an ELB within a VPC
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(List<String> securityGroups) {
            return securityGroups(Output.of(securityGroups));
        }

        /**
         * @param securityGroups A list of security group IDs to assign to the ELB.
         * Only valid if creating an ELB within a VPC
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(String... securityGroups) {
            return securityGroups(List.of(securityGroups));
        }

        /**
         * @param sourceSecurityGroup The name of the security group that you can use as
         * part of your inbound rules for your load balancer&#39;s back-end application
         * instances. Use this for Classic or Default VPC only.
         * 
         * @return builder
         * 
         */
        public Builder sourceSecurityGroup(@Nullable Output<String> sourceSecurityGroup) {
            $.sourceSecurityGroup = sourceSecurityGroup;
            return this;
        }

        /**
         * @param sourceSecurityGroup The name of the security group that you can use as
         * part of your inbound rules for your load balancer&#39;s back-end application
         * instances. Use this for Classic or Default VPC only.
         * 
         * @return builder
         * 
         */
        public Builder sourceSecurityGroup(String sourceSecurityGroup) {
            return sourceSecurityGroup(Output.of(sourceSecurityGroup));
        }

        /**
         * @param subnets A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
         * 
         * @return builder
         * 
         */
        public Builder subnets(@Nullable Output<List<String>> subnets) {
            $.subnets = subnets;
            return this;
        }

        /**
         * @param subnets A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
         * 
         * @return builder
         * 
         */
        public Builder subnets(List<String> subnets) {
            return subnets(Output.of(subnets));
        }

        /**
         * @param subnets A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
         * 
         * @return builder
         * 
         */
        public Builder subnets(String... subnets) {
            return subnets(List.of(subnets));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * Exactly one of `availability_zones` or `subnets` must be specified: this
         * determines if the ELB exists in a VPC or in EC2-classic.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * Exactly one of `availability_zones` or `subnets` must be specified: this
         * determines if the ELB exists in a VPC or in EC2-classic.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public LoadBalancerArgs build() {
            $.listeners = Objects.requireNonNull($.listeners, "expected parameter 'listeners' to be non-null");
            return $;
        }
    }

}
