// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elb;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.elb.AppCookieStickinessPolicyArgs;
import com.pulumi.aws.elb.inputs.AppCookieStickinessPolicyState;
import com.pulumi.core.Alias;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides an application cookie stickiness policy, which allows an ELB to wed its sticky cookie&#39;s expiration to a cookie generated by your application.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.AppCookieStickinessPolicy;
 * import com.pulumi.aws.elb.AppCookieStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer(&#34;lb&#34;, LoadBalancerArgs.builder()        
 *             .availabilityZones(&#34;us-east-1a&#34;)
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol(&#34;http&#34;)
 *                 .lbPort(80)
 *                 .lbProtocol(&#34;http&#34;)
 *                 .build())
 *             .build());
 * 
 *         var foo = new AppCookieStickinessPolicy(&#34;foo&#34;, AppCookieStickinessPolicyArgs.builder()        
 *             .loadBalancer(lb.name())
 *             .lbPort(80)
 *             .cookieName(&#34;MyAppCookie&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import application cookie stickiness policies using the ELB name, port, and policy name separated by colons (`:`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy example my-elb:80:my-policy
 * ```
 * 
 */
@ResourceType(type="aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy")
public class AppCookieStickinessPolicy extends com.pulumi.resources.CustomResource {
    /**
     * Application cookie whose lifetime the ELB&#39;s cookie should follow.
     * 
     */
    @Export(name="cookieName", refs={String.class}, tree="[0]")
    private Output<String> cookieName;

    /**
     * @return Application cookie whose lifetime the ELB&#39;s cookie should follow.
     * 
     */
    public Output<String> cookieName() {
        return this.cookieName;
    }
    /**
     * Load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     * 
     */
    @Export(name="lbPort", refs={Integer.class}, tree="[0]")
    private Output<Integer> lbPort;

    /**
     * @return Load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     * 
     */
    public Output<Integer> lbPort() {
        return this.lbPort;
    }
    /**
     * Name of load balancer to which the policy
     * should be attached.
     * 
     */
    @Export(name="loadBalancer", refs={String.class}, tree="[0]")
    private Output<String> loadBalancer;

    /**
     * @return Name of load balancer to which the policy
     * should be attached.
     * 
     */
    public Output<String> loadBalancer() {
        return this.loadBalancer;
    }
    /**
     * Name of the stickiness policy.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the stickiness policy.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AppCookieStickinessPolicy(String name) {
        this(name, AppCookieStickinessPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AppCookieStickinessPolicy(String name, AppCookieStickinessPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AppCookieStickinessPolicy(String name, AppCookieStickinessPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy", name, args == null ? AppCookieStickinessPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AppCookieStickinessPolicy(String name, Output<String> id, @Nullable AppCookieStickinessPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .aliases(List.of(
                Output.of(Alias.builder().type("aws:elasticloadbalancing/appCookieStickinessPolicy:AppCookieStickinessPolicy").build())
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AppCookieStickinessPolicy get(String name, Output<String> id, @Nullable AppCookieStickinessPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AppCookieStickinessPolicy(name, id, state, options);
    }
}
