// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elastictranscoder;

import com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigArgs;
import com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigPermissionArgs;
import com.pulumi.aws.elastictranscoder.inputs.PipelineNotificationsArgs;
import com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs;
import com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigPermissionArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PipelineArgs extends com.pulumi.resources.ResourceArgs {

    public static final PipelineArgs Empty = new PipelineArgs();

    /**
     * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     * 
     */
    @Import(name="awsKmsKeyArn")
    private @Nullable Output<String> awsKmsKeyArn;

    /**
     * @return The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     * 
     */
    public Optional<Output<String>> awsKmsKeyArn() {
        return Optional.ofNullable(this.awsKmsKeyArn);
    }

    /**
     * The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
     * 
     */
    @Import(name="contentConfig")
    private @Nullable Output<PipelineContentConfigArgs> contentConfig;

    /**
     * @return The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
     * 
     */
    public Optional<Output<PipelineContentConfigArgs>> contentConfig() {
        return Optional.ofNullable(this.contentConfig);
    }

    /**
     * The permissions for the `content_config` object. (documented below)
     * 
     */
    @Import(name="contentConfigPermissions")
    private @Nullable Output<List<PipelineContentConfigPermissionArgs>> contentConfigPermissions;

    /**
     * @return The permissions for the `content_config` object. (documented below)
     * 
     */
    public Optional<Output<List<PipelineContentConfigPermissionArgs>>> contentConfigPermissions() {
        return Optional.ofNullable(this.contentConfigPermissions);
    }

    /**
     * The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
     * 
     */
    @Import(name="inputBucket", required=true)
    private Output<String> inputBucket;

    /**
     * @return The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
     * 
     */
    public Output<String> inputBucket() {
        return this.inputBucket;
    }

    /**
     * The name of the pipeline. Maximum 40 characters
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the pipeline. Maximum 40 characters
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
     * 
     */
    @Import(name="notifications")
    private @Nullable Output<PipelineNotificationsArgs> notifications;

    /**
     * @return The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
     * 
     */
    public Optional<Output<PipelineNotificationsArgs>> notifications() {
        return Optional.ofNullable(this.notifications);
    }

    /**
     * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
     * 
     */
    @Import(name="outputBucket")
    private @Nullable Output<String> outputBucket;

    /**
     * @return The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
     * 
     */
    public Optional<Output<String>> outputBucket() {
        return Optional.ofNullable(this.outputBucket);
    }

    /**
     * The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
     * 
     */
    @Import(name="role", required=true)
    private Output<String> role;

    /**
     * @return The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
     * 
     */
    public Output<String> role() {
        return this.role;
    }

    /**
     * The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
     * 
     */
    @Import(name="thumbnailConfig")
    private @Nullable Output<PipelineThumbnailConfigArgs> thumbnailConfig;

    /**
     * @return The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
     * 
     */
    public Optional<Output<PipelineThumbnailConfigArgs>> thumbnailConfig() {
        return Optional.ofNullable(this.thumbnailConfig);
    }

    /**
     * The permissions for the `thumbnail_config` object. (documented below)
     * 
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     * 
     */
    @Import(name="thumbnailConfigPermissions")
    private @Nullable Output<List<PipelineThumbnailConfigPermissionArgs>> thumbnailConfigPermissions;

    /**
     * @return The permissions for the `thumbnail_config` object. (documented below)
     * 
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     * 
     */
    public Optional<Output<List<PipelineThumbnailConfigPermissionArgs>>> thumbnailConfigPermissions() {
        return Optional.ofNullable(this.thumbnailConfigPermissions);
    }

    private PipelineArgs() {}

    private PipelineArgs(PipelineArgs $) {
        this.awsKmsKeyArn = $.awsKmsKeyArn;
        this.contentConfig = $.contentConfig;
        this.contentConfigPermissions = $.contentConfigPermissions;
        this.inputBucket = $.inputBucket;
        this.name = $.name;
        this.notifications = $.notifications;
        this.outputBucket = $.outputBucket;
        this.role = $.role;
        this.thumbnailConfig = $.thumbnailConfig;
        this.thumbnailConfigPermissions = $.thumbnailConfigPermissions;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PipelineArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PipelineArgs $;

        public Builder() {
            $ = new PipelineArgs();
        }

        public Builder(PipelineArgs defaults) {
            $ = new PipelineArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param awsKmsKeyArn The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
         * 
         * @return builder
         * 
         */
        public Builder awsKmsKeyArn(@Nullable Output<String> awsKmsKeyArn) {
            $.awsKmsKeyArn = awsKmsKeyArn;
            return this;
        }

        /**
         * @param awsKmsKeyArn The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
         * 
         * @return builder
         * 
         */
        public Builder awsKmsKeyArn(String awsKmsKeyArn) {
            return awsKmsKeyArn(Output.of(awsKmsKeyArn));
        }

        /**
         * @param contentConfig The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder contentConfig(@Nullable Output<PipelineContentConfigArgs> contentConfig) {
            $.contentConfig = contentConfig;
            return this;
        }

        /**
         * @param contentConfig The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder contentConfig(PipelineContentConfigArgs contentConfig) {
            return contentConfig(Output.of(contentConfig));
        }

        /**
         * @param contentConfigPermissions The permissions for the `content_config` object. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder contentConfigPermissions(@Nullable Output<List<PipelineContentConfigPermissionArgs>> contentConfigPermissions) {
            $.contentConfigPermissions = contentConfigPermissions;
            return this;
        }

        /**
         * @param contentConfigPermissions The permissions for the `content_config` object. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder contentConfigPermissions(List<PipelineContentConfigPermissionArgs> contentConfigPermissions) {
            return contentConfigPermissions(Output.of(contentConfigPermissions));
        }

        /**
         * @param contentConfigPermissions The permissions for the `content_config` object. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder contentConfigPermissions(PipelineContentConfigPermissionArgs... contentConfigPermissions) {
            return contentConfigPermissions(List.of(contentConfigPermissions));
        }

        /**
         * @param inputBucket The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
         * 
         * @return builder
         * 
         */
        public Builder inputBucket(Output<String> inputBucket) {
            $.inputBucket = inputBucket;
            return this;
        }

        /**
         * @param inputBucket The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
         * 
         * @return builder
         * 
         */
        public Builder inputBucket(String inputBucket) {
            return inputBucket(Output.of(inputBucket));
        }

        /**
         * @param name The name of the pipeline. Maximum 40 characters
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the pipeline. Maximum 40 characters
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param notifications The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder notifications(@Nullable Output<PipelineNotificationsArgs> notifications) {
            $.notifications = notifications;
            return this;
        }

        /**
         * @param notifications The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder notifications(PipelineNotificationsArgs notifications) {
            return notifications(Output.of(notifications));
        }

        /**
         * @param outputBucket The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
         * 
         * @return builder
         * 
         */
        public Builder outputBucket(@Nullable Output<String> outputBucket) {
            $.outputBucket = outputBucket;
            return this;
        }

        /**
         * @param outputBucket The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
         * 
         * @return builder
         * 
         */
        public Builder outputBucket(String outputBucket) {
            return outputBucket(Output.of(outputBucket));
        }

        /**
         * @param role The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
         * 
         * @return builder
         * 
         */
        public Builder role(Output<String> role) {
            $.role = role;
            return this;
        }

        /**
         * @param role The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
         * 
         * @return builder
         * 
         */
        public Builder role(String role) {
            return role(Output.of(role));
        }

        /**
         * @param thumbnailConfig The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder thumbnailConfig(@Nullable Output<PipelineThumbnailConfigArgs> thumbnailConfig) {
            $.thumbnailConfig = thumbnailConfig;
            return this;
        }

        /**
         * @param thumbnailConfig The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
         * 
         * @return builder
         * 
         */
        public Builder thumbnailConfig(PipelineThumbnailConfigArgs thumbnailConfig) {
            return thumbnailConfig(Output.of(thumbnailConfig));
        }

        /**
         * @param thumbnailConfigPermissions The permissions for the `thumbnail_config` object. (documented below)
         * 
         * The `content_config` object specifies information about the Amazon S3 bucket in
         * which you want Elastic Transcoder to save transcoded files and playlists: which
         * bucket to use, and the storage class that you want to assign to the files. If
         * you specify values for `content_config`, you must also specify values for
         * `thumbnail_config`. If you specify values for `content_config` and
         * `thumbnail_config`, omit the `output_bucket` object.
         * 
         * @return builder
         * 
         */
        public Builder thumbnailConfigPermissions(@Nullable Output<List<PipelineThumbnailConfigPermissionArgs>> thumbnailConfigPermissions) {
            $.thumbnailConfigPermissions = thumbnailConfigPermissions;
            return this;
        }

        /**
         * @param thumbnailConfigPermissions The permissions for the `thumbnail_config` object. (documented below)
         * 
         * The `content_config` object specifies information about the Amazon S3 bucket in
         * which you want Elastic Transcoder to save transcoded files and playlists: which
         * bucket to use, and the storage class that you want to assign to the files. If
         * you specify values for `content_config`, you must also specify values for
         * `thumbnail_config`. If you specify values for `content_config` and
         * `thumbnail_config`, omit the `output_bucket` object.
         * 
         * @return builder
         * 
         */
        public Builder thumbnailConfigPermissions(List<PipelineThumbnailConfigPermissionArgs> thumbnailConfigPermissions) {
            return thumbnailConfigPermissions(Output.of(thumbnailConfigPermissions));
        }

        /**
         * @param thumbnailConfigPermissions The permissions for the `thumbnail_config` object. (documented below)
         * 
         * The `content_config` object specifies information about the Amazon S3 bucket in
         * which you want Elastic Transcoder to save transcoded files and playlists: which
         * bucket to use, and the storage class that you want to assign to the files. If
         * you specify values for `content_config`, you must also specify values for
         * `thumbnail_config`. If you specify values for `content_config` and
         * `thumbnail_config`, omit the `output_bucket` object.
         * 
         * @return builder
         * 
         */
        public Builder thumbnailConfigPermissions(PipelineThumbnailConfigPermissionArgs... thumbnailConfigPermissions) {
            return thumbnailConfigPermissions(List.of(thumbnailConfigPermissions));
        }

        public PipelineArgs build() {
            $.inputBucket = Objects.requireNonNull($.inputBucket, "expected parameter 'inputBucket' to be non-null");
            $.role = Objects.requireNonNull($.role, "expected parameter 'role' to be non-null");
            return $;
        }
    }

}
