// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticsearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainLogPublishingOption {
    /**
     * @return ARN of the Cloudwatch log group to which log needs to be published.
     * 
     */
    private String cloudwatchLogGroupArn;
    /**
     * @return Whether given log publishing option is enabled or not.
     * 
     */
    private @Nullable Boolean enabled;
    /**
     * @return Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
     * 
     */
    private String logType;

    private DomainLogPublishingOption() {}
    /**
     * @return ARN of the Cloudwatch log group to which log needs to be published.
     * 
     */
    public String cloudwatchLogGroupArn() {
        return this.cloudwatchLogGroupArn;
    }
    /**
     * @return Whether given log publishing option is enabled or not.
     * 
     */
    public Optional<Boolean> enabled() {
        return Optional.ofNullable(this.enabled);
    }
    /**
     * @return Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
     * 
     */
    public String logType() {
        return this.logType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainLogPublishingOption defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String cloudwatchLogGroupArn;
        private @Nullable Boolean enabled;
        private String logType;
        public Builder() {}
        public Builder(DomainLogPublishingOption defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.cloudwatchLogGroupArn = defaults.cloudwatchLogGroupArn;
    	      this.enabled = defaults.enabled;
    	      this.logType = defaults.logType;
        }

        @CustomType.Setter
        public Builder cloudwatchLogGroupArn(String cloudwatchLogGroupArn) {
            this.cloudwatchLogGroupArn = Objects.requireNonNull(cloudwatchLogGroupArn);
            return this;
        }
        @CustomType.Setter
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }
        @CustomType.Setter
        public Builder logType(String logType) {
            this.logType = Objects.requireNonNull(logType);
            return this;
        }
        public DomainLogPublishingOption build() {
            final var o = new DomainLogPublishingOption();
            o.cloudwatchLogGroupArn = cloudwatchLogGroupArn;
            o.enabled = enabled;
            o.logType = logType;
            return o;
        }
    }
}
