// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticsearch.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DomainEbsOptions {
    /**
     * @return Whether EBS volumes are attached to data nodes in the domain.
     * 
     */
    private Boolean ebsEnabled;
    /**
     * @return Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
     * 
     */
    private @Nullable Integer iops;
    /**
     * @return Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
     * 
     */
    private @Nullable Integer throughput;
    /**
     * @return Size of EBS volumes attached to data nodes (in GiB).
     * 
     */
    private @Nullable Integer volumeSize;
    /**
     * @return Type of EBS volumes attached to data nodes.
     * 
     */
    private @Nullable String volumeType;

    private DomainEbsOptions() {}
    /**
     * @return Whether EBS volumes are attached to data nodes in the domain.
     * 
     */
    public Boolean ebsEnabled() {
        return this.ebsEnabled;
    }
    /**
     * @return Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
     * 
     */
    public Optional<Integer> iops() {
        return Optional.ofNullable(this.iops);
    }
    /**
     * @return Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
     * 
     */
    public Optional<Integer> throughput() {
        return Optional.ofNullable(this.throughput);
    }
    /**
     * @return Size of EBS volumes attached to data nodes (in GiB).
     * 
     */
    public Optional<Integer> volumeSize() {
        return Optional.ofNullable(this.volumeSize);
    }
    /**
     * @return Type of EBS volumes attached to data nodes.
     * 
     */
    public Optional<String> volumeType() {
        return Optional.ofNullable(this.volumeType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DomainEbsOptions defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private Boolean ebsEnabled;
        private @Nullable Integer iops;
        private @Nullable Integer throughput;
        private @Nullable Integer volumeSize;
        private @Nullable String volumeType;
        public Builder() {}
        public Builder(DomainEbsOptions defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.ebsEnabled = defaults.ebsEnabled;
    	      this.iops = defaults.iops;
    	      this.throughput = defaults.throughput;
    	      this.volumeSize = defaults.volumeSize;
    	      this.volumeType = defaults.volumeType;
        }

        @CustomType.Setter
        public Builder ebsEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = Objects.requireNonNull(ebsEnabled);
            return this;
        }
        @CustomType.Setter
        public Builder iops(@Nullable Integer iops) {
            this.iops = iops;
            return this;
        }
        @CustomType.Setter
        public Builder throughput(@Nullable Integer throughput) {
            this.throughput = throughput;
            return this;
        }
        @CustomType.Setter
        public Builder volumeSize(@Nullable Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }
        @CustomType.Setter
        public Builder volumeType(@Nullable String volumeType) {
            this.volumeType = volumeType;
            return this;
        }
        public DomainEbsOptions build() {
            final var o = new DomainEbsOptions();
            o.ebsEnabled = ebsEnabled;
            o.iops = iops;
            o.throughput = throughput;
            o.volumeSize = volumeSize;
            o.volumeType = volumeType;
            return o;
        }
    }
}
