// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticbeanstalk;

import com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EnvironmentArgs extends com.pulumi.resources.ResourceArgs {

    public static final EnvironmentArgs Empty = new EnvironmentArgs();

    /**
     * Name of the application that contains the version
     * to be deployed
     * 
     */
    @Import(name="application", required=true)
    private Output<String> application;

    /**
     * @return Name of the application that contains the version
     * to be deployed
     * 
     */
    public Output<String> application() {
        return this.application;
    }

    /**
     * Prefix to use for the fully qualified DNS name of
     * the Environment.
     * 
     */
    @Import(name="cnamePrefix")
    private @Nullable Output<String> cnamePrefix;

    /**
     * @return Prefix to use for the fully qualified DNS name of
     * the Environment.
     * 
     */
    public Optional<Output<String>> cnamePrefix() {
        return Optional.ofNullable(this.cnamePrefix);
    }

    /**
     * Short description of the Environment
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Short description of the Environment
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * A unique name for this Environment. This name is used
     * in the application URL
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return A unique name for this Environment. This name is used
     * in the application URL
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
     * to use in deployment
     * 
     */
    @Import(name="platformArn")
    private @Nullable Output<String> platformArn;

    /**
     * @return The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
     * to use in deployment
     * 
     */
    public Optional<Output<String>> platformArn() {
        return Optional.ofNullable(this.platformArn);
    }

    /**
     * The time between polling the AWS API to
     * check if changes have been applied. Use this to adjust the rate of API calls
     * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
     * use the default behavior, which is an exponential backoff
     * 
     */
    @Import(name="pollInterval")
    private @Nullable Output<String> pollInterval;

    /**
     * @return The time between polling the AWS API to
     * check if changes have been applied. Use this to adjust the rate of API calls
     * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
     * use the default behavior, which is an exponential backoff
     * 
     */
    public Optional<Output<String>> pollInterval() {
        return Optional.ofNullable(this.pollInterval);
    }

    /**
     * Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     * 
     */
    @Import(name="settings")
    private @Nullable Output<List<EnvironmentSettingArgs>> settings;

    /**
     * @return Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     * 
     */
    public Optional<Output<List<EnvironmentSettingArgs>>> settings() {
        return Optional.ofNullable(this.settings);
    }

    /**
     * A solution stack to base your environment
     * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
     * 
     */
    @Import(name="solutionStackName")
    private @Nullable Output<String> solutionStackName;

    /**
     * @return A solution stack to base your environment
     * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
     * 
     */
    public Optional<Output<String>> solutionStackName() {
        return Optional.ofNullable(this.solutionStackName);
    }

    /**
     * A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The name of the Elastic Beanstalk Configuration
     * template to use in deployment
     * 
     */
    @Import(name="templateName")
    private @Nullable Output<String> templateName;

    /**
     * @return The name of the Elastic Beanstalk Configuration
     * template to use in deployment
     * 
     */
    public Optional<Output<String>> templateName() {
        return Optional.ofNullable(this.templateName);
    }

    /**
     * Elastic Beanstalk Environment tier. Valid values are `Worker`
     * or `WebServer`. If tier is left blank `WebServer` will be used.
     * 
     */
    @Import(name="tier")
    private @Nullable Output<String> tier;

    /**
     * @return Elastic Beanstalk Environment tier. Valid values are `Worker`
     * or `WebServer`. If tier is left blank `WebServer` will be used.
     * 
     */
    public Optional<Output<String>> tier() {
        return Optional.ofNullable(this.tier);
    }

    /**
     * The name of the Elastic Beanstalk Application Version
     * to use in deployment.
     * 
     */
    @Import(name="version")
    private @Nullable Output<String> version;

    /**
     * @return The name of the Elastic Beanstalk Application Version
     * to use in deployment.
     * 
     */
    public Optional<Output<String>> version() {
        return Optional.ofNullable(this.version);
    }

    /**
     * The maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
     * wait for an Elastic Beanstalk Environment to be in a ready state before timing
     * out.
     * 
     */
    @Import(name="waitForReadyTimeout")
    private @Nullable Output<String> waitForReadyTimeout;

    /**
     * @return The maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
     * wait for an Elastic Beanstalk Environment to be in a ready state before timing
     * out.
     * 
     */
    public Optional<Output<String>> waitForReadyTimeout() {
        return Optional.ofNullable(this.waitForReadyTimeout);
    }

    private EnvironmentArgs() {}

    private EnvironmentArgs(EnvironmentArgs $) {
        this.application = $.application;
        this.cnamePrefix = $.cnamePrefix;
        this.description = $.description;
        this.name = $.name;
        this.platformArn = $.platformArn;
        this.pollInterval = $.pollInterval;
        this.settings = $.settings;
        this.solutionStackName = $.solutionStackName;
        this.tags = $.tags;
        this.templateName = $.templateName;
        this.tier = $.tier;
        this.version = $.version;
        this.waitForReadyTimeout = $.waitForReadyTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EnvironmentArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EnvironmentArgs $;

        public Builder() {
            $ = new EnvironmentArgs();
        }

        public Builder(EnvironmentArgs defaults) {
            $ = new EnvironmentArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param application Name of the application that contains the version
         * to be deployed
         * 
         * @return builder
         * 
         */
        public Builder application(Output<String> application) {
            $.application = application;
            return this;
        }

        /**
         * @param application Name of the application that contains the version
         * to be deployed
         * 
         * @return builder
         * 
         */
        public Builder application(String application) {
            return application(Output.of(application));
        }

        /**
         * @param cnamePrefix Prefix to use for the fully qualified DNS name of
         * the Environment.
         * 
         * @return builder
         * 
         */
        public Builder cnamePrefix(@Nullable Output<String> cnamePrefix) {
            $.cnamePrefix = cnamePrefix;
            return this;
        }

        /**
         * @param cnamePrefix Prefix to use for the fully qualified DNS name of
         * the Environment.
         * 
         * @return builder
         * 
         */
        public Builder cnamePrefix(String cnamePrefix) {
            return cnamePrefix(Output.of(cnamePrefix));
        }

        /**
         * @param description Short description of the Environment
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Short description of the Environment
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param name A unique name for this Environment. This name is used
         * in the application URL
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name A unique name for this Environment. This name is used
         * in the application URL
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param platformArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
         * to use in deployment
         * 
         * @return builder
         * 
         */
        public Builder platformArn(@Nullable Output<String> platformArn) {
            $.platformArn = platformArn;
            return this;
        }

        /**
         * @param platformArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
         * to use in deployment
         * 
         * @return builder
         * 
         */
        public Builder platformArn(String platformArn) {
            return platformArn(Output.of(platformArn));
        }

        /**
         * @param pollInterval The time between polling the AWS API to
         * check if changes have been applied. Use this to adjust the rate of API calls
         * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
         * use the default behavior, which is an exponential backoff
         * 
         * @return builder
         * 
         */
        public Builder pollInterval(@Nullable Output<String> pollInterval) {
            $.pollInterval = pollInterval;
            return this;
        }

        /**
         * @param pollInterval The time between polling the AWS API to
         * check if changes have been applied. Use this to adjust the rate of API calls
         * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
         * use the default behavior, which is an exponential backoff
         * 
         * @return builder
         * 
         */
        public Builder pollInterval(String pollInterval) {
            return pollInterval(Output.of(pollInterval));
        }

        /**
         * @param settings Option settings to configure the new Environment. These
         * override specific values that are set as defaults. The format is detailed
         * below in Option Settings
         * 
         * @return builder
         * 
         */
        public Builder settings(@Nullable Output<List<EnvironmentSettingArgs>> settings) {
            $.settings = settings;
            return this;
        }

        /**
         * @param settings Option settings to configure the new Environment. These
         * override specific values that are set as defaults. The format is detailed
         * below in Option Settings
         * 
         * @return builder
         * 
         */
        public Builder settings(List<EnvironmentSettingArgs> settings) {
            return settings(Output.of(settings));
        }

        /**
         * @param settings Option settings to configure the new Environment. These
         * override specific values that are set as defaults. The format is detailed
         * below in Option Settings
         * 
         * @return builder
         * 
         */
        public Builder settings(EnvironmentSettingArgs... settings) {
            return settings(List.of(settings));
        }

        /**
         * @param solutionStackName A solution stack to base your environment
         * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
         * 
         * @return builder
         * 
         */
        public Builder solutionStackName(@Nullable Output<String> solutionStackName) {
            $.solutionStackName = solutionStackName;
            return this;
        }

        /**
         * @param solutionStackName A solution stack to base your environment
         * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
         * 
         * @return builder
         * 
         */
        public Builder solutionStackName(String solutionStackName) {
            return solutionStackName(Output.of(solutionStackName));
        }

        /**
         * @param tags A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param templateName The name of the Elastic Beanstalk Configuration
         * template to use in deployment
         * 
         * @return builder
         * 
         */
        public Builder templateName(@Nullable Output<String> templateName) {
            $.templateName = templateName;
            return this;
        }

        /**
         * @param templateName The name of the Elastic Beanstalk Configuration
         * template to use in deployment
         * 
         * @return builder
         * 
         */
        public Builder templateName(String templateName) {
            return templateName(Output.of(templateName));
        }

        /**
         * @param tier Elastic Beanstalk Environment tier. Valid values are `Worker`
         * or `WebServer`. If tier is left blank `WebServer` will be used.
         * 
         * @return builder
         * 
         */
        public Builder tier(@Nullable Output<String> tier) {
            $.tier = tier;
            return this;
        }

        /**
         * @param tier Elastic Beanstalk Environment tier. Valid values are `Worker`
         * or `WebServer`. If tier is left blank `WebServer` will be used.
         * 
         * @return builder
         * 
         */
        public Builder tier(String tier) {
            return tier(Output.of(tier));
        }

        /**
         * @param version The name of the Elastic Beanstalk Application Version
         * to use in deployment.
         * 
         * @return builder
         * 
         */
        public Builder version(@Nullable Output<String> version) {
            $.version = version;
            return this;
        }

        /**
         * @param version The name of the Elastic Beanstalk Application Version
         * to use in deployment.
         * 
         * @return builder
         * 
         */
        public Builder version(String version) {
            return version(Output.of(version));
        }

        /**
         * @param waitForReadyTimeout The maximum
         * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
         * wait for an Elastic Beanstalk Environment to be in a ready state before timing
         * out.
         * 
         * @return builder
         * 
         */
        public Builder waitForReadyTimeout(@Nullable Output<String> waitForReadyTimeout) {
            $.waitForReadyTimeout = waitForReadyTimeout;
            return this;
        }

        /**
         * @param waitForReadyTimeout The maximum
         * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
         * wait for an Elastic Beanstalk Environment to be in a ready state before timing
         * out.
         * 
         * @return builder
         * 
         */
        public Builder waitForReadyTimeout(String waitForReadyTimeout) {
            return waitForReadyTimeout(Output.of(waitForReadyTimeout));
        }

        public EnvironmentArgs build() {
            $.application = Objects.requireNonNull($.application, "expected parameter 'application' to be non-null");
            return $;
        }
    }

}
