// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticache.inputs;

import com.pulumi.aws.elasticache.inputs.ClusterCacheNodeArgs;
import com.pulumi.aws.elasticache.inputs.ClusterLogDeliveryConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterState Empty = new ClusterState();

    /**
     * Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information.](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information.](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * The ARN of the created ElastiCache Cluster.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The ARN of the created ElastiCache Cluster.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
     * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
     * Defaults to `true`.
     * 
     */
    @Import(name="autoMinorVersionUpgrade")
    private @Nullable Output<String> autoMinorVersionUpgrade;

    /**
     * @return Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
     * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
     * Defaults to `true`.
     * 
     */
    public Optional<Output<String>> autoMinorVersionUpgrade() {
        return Optional.ofNullable(this.autoMinorVersionUpgrade);
    }

    /**
     * Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster&#39;s region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
     * 
     */
    @Import(name="azMode")
    private @Nullable Output<String> azMode;

    /**
     * @return Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster&#39;s region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
     * 
     */
    public Optional<Output<String>> azMode() {
        return Optional.ofNullable(this.azMode);
    }

    /**
     * List of node objects including `id`, `address`, `port` and `availability_zone`.
     * 
     */
    @Import(name="cacheNodes")
    private @Nullable Output<List<ClusterCacheNodeArgs>> cacheNodes;

    /**
     * @return List of node objects including `id`, `address`, `port` and `availability_zone`.
     * 
     */
    public Optional<Output<List<ClusterCacheNodeArgs>>> cacheNodes() {
        return Optional.ofNullable(this.cacheNodes);
    }

    /**
     * (Memcached only) DNS name of the cache cluster without the port appended.
     * 
     */
    @Import(name="clusterAddress")
    private @Nullable Output<String> clusterAddress;

    /**
     * @return (Memcached only) DNS name of the cache cluster without the port appended.
     * 
     */
    public Optional<Output<String>> clusterAddress() {
        return Optional.ofNullable(this.clusterAddress);
    }

    /**
     * Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
     * 
     */
    @Import(name="clusterId")
    private @Nullable Output<String> clusterId;

    /**
     * @return Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
     * 
     */
    public Optional<Output<String>> clusterId() {
        return Optional.ofNullable(this.clusterId);
    }

    /**
     * (Memcached only) Configuration endpoint to allow host discovery.
     * 
     */
    @Import(name="configurationEndpoint")
    private @Nullable Output<String> configurationEndpoint;

    /**
     * @return (Memcached only) Configuration endpoint to allow host discovery.
     * 
     */
    public Optional<Output<String>> configurationEndpoint() {
        return Optional.ofNullable(this.configurationEndpoint);
    }

    /**
     * Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * Version number of the cache engine to be used.
     * If not set, defaults to the latest version.
     * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
     * When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * Otherwise, specify the full version desired, e.g., `5.0.6`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return Version number of the cache engine to be used.
     * If not set, defaults to the latest version.
     * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
     * When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * Otherwise, specify the full version desired, e.g., `5.0.6`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
     * 
     */
    @Import(name="engineVersionActual")
    private @Nullable Output<String> engineVersionActual;

    /**
     * @return Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
     * 
     */
    public Optional<Output<String>> engineVersionActual() {
        return Optional.ofNullable(this.engineVersionActual);
    }

    /**
     * Name of your final cluster snapshot. If omitted, no final snapshot will be made.
     * 
     */
    @Import(name="finalSnapshotIdentifier")
    private @Nullable Output<String> finalSnapshotIdentifier;

    /**
     * @return Name of your final cluster snapshot. If omitted, no final snapshot will be made.
     * 
     */
    public Optional<Output<String>> finalSnapshotIdentifier() {
        return Optional.ofNullable(this.finalSnapshotIdentifier);
    }

    /**
     * The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
     * 
     */
    @Import(name="ipDiscovery")
    private @Nullable Output<String> ipDiscovery;

    /**
     * @return The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
     * 
     */
    public Optional<Output<String>> ipDiscovery() {
        return Optional.ofNullable(this.ipDiscovery);
    }

    /**
     * Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html). See Log Delivery Configuration below for more details.
     * 
     */
    @Import(name="logDeliveryConfigurations")
    private @Nullable Output<List<ClusterLogDeliveryConfigurationArgs>> logDeliveryConfigurations;

    /**
     * @return Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html). See Log Delivery Configuration below for more details.
     * 
     */
    public Optional<Output<List<ClusterLogDeliveryConfigurationArgs>>> logDeliveryConfigurations() {
        return Optional.ofNullable(this.logDeliveryConfigurations);
    }

    /**
     * Specifies the weekly time range for when maintenance
     * on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
     * The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
     * 
     */
    @Import(name="maintenanceWindow")
    private @Nullable Output<String> maintenanceWindow;

    /**
     * @return Specifies the weekly time range for when maintenance
     * on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
     * The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
     * 
     */
    public Optional<Output<String>> maintenanceWindow() {
        return Optional.ofNullable(this.maintenanceWindow);
    }

    /**
     * The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
     * 
     */
    @Import(name="networkType")
    private @Nullable Output<String> networkType;

    /**
     * @return The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
     * 
     */
    public Optional<Output<String>> networkType() {
        return Optional.ofNullable(this.networkType);
    }

    /**
     * The instance class used. See AWS documentation for information on [supported node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/nodes-select-size.html). For Memcached, changing this value will re-create the resource.
     * 
     */
    @Import(name="nodeType")
    private @Nullable Output<String> nodeType;

    /**
     * @return The instance class used. See AWS documentation for information on [supported node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/nodes-select-size.html). For Memcached, changing this value will re-create the resource.
     * 
     */
    public Optional<Output<String>> nodeType() {
        return Optional.ofNullable(this.nodeType);
    }

    /**
     * ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
     * 
     */
    @Import(name="notificationTopicArn")
    private @Nullable Output<String> notificationTopicArn;

    /**
     * @return ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
     * 
     */
    public Optional<Output<String>> notificationTopicArn() {
        return Optional.ofNullable(this.notificationTopicArn);
    }

    /**
     * The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
     * 
     */
    @Import(name="numCacheNodes")
    private @Nullable Output<Integer> numCacheNodes;

    /**
     * @return The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
     * 
     */
    public Optional<Output<Integer>> numCacheNodes() {
        return Optional.ofNullable(this.numCacheNodes);
    }

    /**
     * Specify the outpost mode that will apply to the cache cluster creation. Valid values are `&#34;single-outpost&#34;` and `&#34;cross-outpost&#34;`, however AWS currently only supports `&#34;single-outpost&#34;` mode.
     * 
     */
    @Import(name="outpostMode")
    private @Nullable Output<String> outpostMode;

    /**
     * @return Specify the outpost mode that will apply to the cache cluster creation. Valid values are `&#34;single-outpost&#34;` and `&#34;cross-outpost&#34;`, however AWS currently only supports `&#34;single-outpost&#34;` mode.
     * 
     */
    public Optional<Output<String>> outpostMode() {
        return Optional.ofNullable(this.outpostMode);
    }

    /**
     * The name of the parameter group to associate with this cache cluster.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="parameterGroupName")
    private @Nullable Output<String> parameterGroupName;

    /**
     * @return The name of the parameter group to associate with this cache cluster.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<String>> parameterGroupName() {
        return Optional.ofNullable(this.parameterGroupName);
    }

    /**
     * The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
     * 
     */
    @Import(name="preferredAvailabilityZones")
    private @Nullable Output<List<String>> preferredAvailabilityZones;

    /**
     * @return List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
     * 
     */
    public Optional<Output<List<String>>> preferredAvailabilityZones() {
        return Optional.ofNullable(this.preferredAvailabilityZones);
    }

    /**
     * The outpost ARN in which the cache cluster will be created.
     * 
     */
    @Import(name="preferredOutpostArn")
    private @Nullable Output<String> preferredOutpostArn;

    /**
     * @return The outpost ARN in which the cache cluster will be created.
     * 
     */
    public Optional<Output<String>> preferredOutpostArn() {
        return Optional.ofNullable(this.preferredOutpostArn);
    }

    /**
     * ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
     * 
     */
    @Import(name="replicationGroupId")
    private @Nullable Output<String> replicationGroupId;

    /**
     * @return ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
     * 
     */
    public Optional<Output<String>> replicationGroupId() {
        return Optional.ofNullable(this.replicationGroupId);
    }

    /**
     * One or more VPC security groups associated with the cache cluster
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return One or more VPC security groups associated with the cache cluster
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
     * 
     */
    @Import(name="snapshotArns")
    private @Nullable Output<String> snapshotArns;

    /**
     * @return Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
     * 
     */
    public Optional<Output<String>> snapshotArns() {
        return Optional.ofNullable(this.snapshotArns);
    }

    /**
     * Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
     * 
     */
    @Import(name="snapshotName")
    private @Nullable Output<String> snapshotName;

    /**
     * @return Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
     * 
     */
    public Optional<Output<String>> snapshotName() {
        return Optional.ofNullable(this.snapshotName);
    }

    /**
     * Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
     * 
     */
    @Import(name="snapshotRetentionLimit")
    private @Nullable Output<Integer> snapshotRetentionLimit;

    /**
     * @return Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
     * 
     */
    public Optional<Output<Integer>> snapshotRetentionLimit() {
        return Optional.ofNullable(this.snapshotRetentionLimit);
    }

    /**
     * Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
     * 
     */
    @Import(name="snapshotWindow")
    private @Nullable Output<String> snapshotWindow;

    /**
     * @return Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
     * 
     */
    public Optional<Output<String>> snapshotWindow() {
        return Optional.ofNullable(this.snapshotWindow);
    }

    /**
     * Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource.
     * 
     */
    @Import(name="subnetGroupName")
    private @Nullable Output<String> subnetGroupName;

    /**
     * @return Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource.
     * 
     */
    public Optional<Output<String>> subnetGroupName() {
        return Optional.ofNullable(this.subnetGroupName);
    }

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Enable encryption in-transit. Supported only with Memcached versions `1.6.12` and later, running in a VPC. See the [ElastiCache in-transit encryption](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/in-transit-encryption-mc.html) documentation for more details.
     * 
     */
    @Import(name="transitEncryptionEnabled")
    private @Nullable Output<Boolean> transitEncryptionEnabled;

    /**
     * @return Enable encryption in-transit. Supported only with Memcached versions `1.6.12` and later, running in a VPC. See the [ElastiCache in-transit encryption](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/in-transit-encryption-mc.html) documentation for more details.
     * 
     */
    public Optional<Output<Boolean>> transitEncryptionEnabled() {
        return Optional.ofNullable(this.transitEncryptionEnabled);
    }

    private ClusterState() {}

    private ClusterState(ClusterState $) {
        this.applyImmediately = $.applyImmediately;
        this.arn = $.arn;
        this.autoMinorVersionUpgrade = $.autoMinorVersionUpgrade;
        this.availabilityZone = $.availabilityZone;
        this.azMode = $.azMode;
        this.cacheNodes = $.cacheNodes;
        this.clusterAddress = $.clusterAddress;
        this.clusterId = $.clusterId;
        this.configurationEndpoint = $.configurationEndpoint;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.engineVersionActual = $.engineVersionActual;
        this.finalSnapshotIdentifier = $.finalSnapshotIdentifier;
        this.ipDiscovery = $.ipDiscovery;
        this.logDeliveryConfigurations = $.logDeliveryConfigurations;
        this.maintenanceWindow = $.maintenanceWindow;
        this.networkType = $.networkType;
        this.nodeType = $.nodeType;
        this.notificationTopicArn = $.notificationTopicArn;
        this.numCacheNodes = $.numCacheNodes;
        this.outpostMode = $.outpostMode;
        this.parameterGroupName = $.parameterGroupName;
        this.port = $.port;
        this.preferredAvailabilityZones = $.preferredAvailabilityZones;
        this.preferredOutpostArn = $.preferredOutpostArn;
        this.replicationGroupId = $.replicationGroupId;
        this.securityGroupIds = $.securityGroupIds;
        this.snapshotArns = $.snapshotArns;
        this.snapshotName = $.snapshotName;
        this.snapshotRetentionLimit = $.snapshotRetentionLimit;
        this.snapshotWindow = $.snapshotWindow;
        this.subnetGroupName = $.subnetGroupName;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.transitEncryptionEnabled = $.transitEncryptionEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterState $;

        public Builder() {
            $ = new ClusterState();
        }

        public Builder(ClusterState defaults) {
            $ = new ClusterState(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information.](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Whether any database modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon ElastiCache Documentation for more information.](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheCluster.html).
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param arn The ARN of the created ElastiCache Cluster.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The ARN of the created ElastiCache Cluster.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param autoMinorVersionUpgrade Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
         * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
         * Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(@Nullable Output<String> autoMinorVersionUpgrade) {
            $.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * @param autoMinorVersionUpgrade Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
         * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
         * Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(String autoMinorVersionUpgrade) {
            return autoMinorVersionUpgrade(Output.of(autoMinorVersionUpgrade));
        }

        /**
         * @param availabilityZone Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param azMode Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster&#39;s region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
         * 
         * @return builder
         * 
         */
        public Builder azMode(@Nullable Output<String> azMode) {
            $.azMode = azMode;
            return this;
        }

        /**
         * @param azMode Whether the nodes in this Memcached node group are created in a single Availability Zone or created across multiple Availability Zones in the cluster&#39;s region. Valid values for this parameter are `single-az` or `cross-az`, default is `single-az`. If you want to choose `cross-az`, `num_cache_nodes` must be greater than `1`.
         * 
         * @return builder
         * 
         */
        public Builder azMode(String azMode) {
            return azMode(Output.of(azMode));
        }

        /**
         * @param cacheNodes List of node objects including `id`, `address`, `port` and `availability_zone`.
         * 
         * @return builder
         * 
         */
        public Builder cacheNodes(@Nullable Output<List<ClusterCacheNodeArgs>> cacheNodes) {
            $.cacheNodes = cacheNodes;
            return this;
        }

        /**
         * @param cacheNodes List of node objects including `id`, `address`, `port` and `availability_zone`.
         * 
         * @return builder
         * 
         */
        public Builder cacheNodes(List<ClusterCacheNodeArgs> cacheNodes) {
            return cacheNodes(Output.of(cacheNodes));
        }

        /**
         * @param cacheNodes List of node objects including `id`, `address`, `port` and `availability_zone`.
         * 
         * @return builder
         * 
         */
        public Builder cacheNodes(ClusterCacheNodeArgs... cacheNodes) {
            return cacheNodes(List.of(cacheNodes));
        }

        /**
         * @param clusterAddress (Memcached only) DNS name of the cache cluster without the port appended.
         * 
         * @return builder
         * 
         */
        public Builder clusterAddress(@Nullable Output<String> clusterAddress) {
            $.clusterAddress = clusterAddress;
            return this;
        }

        /**
         * @param clusterAddress (Memcached only) DNS name of the cache cluster without the port appended.
         * 
         * @return builder
         * 
         */
        public Builder clusterAddress(String clusterAddress) {
            return clusterAddress(Output.of(clusterAddress));
        }

        /**
         * @param clusterId Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(@Nullable Output<String> clusterId) {
            $.clusterId = clusterId;
            return this;
        }

        /**
         * @param clusterId Group identifier. ElastiCache converts this name to lowercase. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(String clusterId) {
            return clusterId(Output.of(clusterId));
        }

        /**
         * @param configurationEndpoint (Memcached only) Configuration endpoint to allow host discovery.
         * 
         * @return builder
         * 
         */
        public Builder configurationEndpoint(@Nullable Output<String> configurationEndpoint) {
            $.configurationEndpoint = configurationEndpoint;
            return this;
        }

        /**
         * @param configurationEndpoint (Memcached only) Configuration endpoint to allow host discovery.
         * 
         * @return builder
         * 
         */
        public Builder configurationEndpoint(String configurationEndpoint) {
            return configurationEndpoint(Output.of(configurationEndpoint));
        }

        /**
         * @param engine Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion Version number of the cache engine to be used.
         * If not set, defaults to the latest version.
         * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
         * When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
         * When the version is 6, the major and minor version can be set, e.g., `6.2`,
         * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
         * Otherwise, specify the full version desired, e.g., `5.0.6`.
         * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion Version number of the cache engine to be used.
         * If not set, defaults to the latest version.
         * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
         * When `engine` is `redis` and the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
         * When the version is 6, the major and minor version can be set, e.g., `6.2`,
         * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
         * Otherwise, specify the full version desired, e.g., `5.0.6`.
         * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param engineVersionActual Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
         * 
         * @return builder
         * 
         */
        public Builder engineVersionActual(@Nullable Output<String> engineVersionActual) {
            $.engineVersionActual = engineVersionActual;
            return this;
        }

        /**
         * @param engineVersionActual Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
         * 
         * @return builder
         * 
         */
        public Builder engineVersionActual(String engineVersionActual) {
            return engineVersionActual(Output.of(engineVersionActual));
        }

        /**
         * @param finalSnapshotIdentifier Name of your final cluster snapshot. If omitted, no final snapshot will be made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(@Nullable Output<String> finalSnapshotIdentifier) {
            $.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        /**
         * @param finalSnapshotIdentifier Name of your final cluster snapshot. If omitted, no final snapshot will be made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            return finalSnapshotIdentifier(Output.of(finalSnapshotIdentifier));
        }

        /**
         * @param ipDiscovery The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
         * 
         * @return builder
         * 
         */
        public Builder ipDiscovery(@Nullable Output<String> ipDiscovery) {
            $.ipDiscovery = ipDiscovery;
            return this;
        }

        /**
         * @param ipDiscovery The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
         * 
         * @return builder
         * 
         */
        public Builder ipDiscovery(String ipDiscovery) {
            return ipDiscovery(Output.of(ipDiscovery));
        }

        /**
         * @param logDeliveryConfigurations Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html). See Log Delivery Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder logDeliveryConfigurations(@Nullable Output<List<ClusterLogDeliveryConfigurationArgs>> logDeliveryConfigurations) {
            $.logDeliveryConfigurations = logDeliveryConfigurations;
            return this;
        }

        /**
         * @param logDeliveryConfigurations Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html). See Log Delivery Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder logDeliveryConfigurations(List<ClusterLogDeliveryConfigurationArgs> logDeliveryConfigurations) {
            return logDeliveryConfigurations(Output.of(logDeliveryConfigurations));
        }

        /**
         * @param logDeliveryConfigurations Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html). See Log Delivery Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder logDeliveryConfigurations(ClusterLogDeliveryConfigurationArgs... logDeliveryConfigurations) {
            return logDeliveryConfigurations(List.of(logDeliveryConfigurations));
        }

        /**
         * @param maintenanceWindow Specifies the weekly time range for when maintenance
         * on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
         * The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceWindow(@Nullable Output<String> maintenanceWindow) {
            $.maintenanceWindow = maintenanceWindow;
            return this;
        }

        /**
         * @param maintenanceWindow Specifies the weekly time range for when maintenance
         * on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC).
         * The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceWindow(String maintenanceWindow) {
            return maintenanceWindow(Output.of(maintenanceWindow));
        }

        /**
         * @param networkType The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
         * 
         * @return builder
         * 
         */
        public Builder networkType(@Nullable Output<String> networkType) {
            $.networkType = networkType;
            return this;
        }

        /**
         * @param networkType The IP versions for cache cluster connections. IPv6 is supported with Redis engine `6.2` onword or Memcached version `1.6.6` for all [Nitro system](https://aws.amazon.com/ec2/nitro/) instances. Valid values are `ipv4`, `ipv6` or `dual_stack`.
         * 
         * @return builder
         * 
         */
        public Builder networkType(String networkType) {
            return networkType(Output.of(networkType));
        }

        /**
         * @param nodeType The instance class used. See AWS documentation for information on [supported node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/nodes-select-size.html). For Memcached, changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder nodeType(@Nullable Output<String> nodeType) {
            $.nodeType = nodeType;
            return this;
        }

        /**
         * @param nodeType The instance class used. See AWS documentation for information on [supported node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/nodes-select-size.html). For Memcached, changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder nodeType(String nodeType) {
            return nodeType(Output.of(nodeType));
        }

        /**
         * @param notificationTopicArn ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
         * 
         * @return builder
         * 
         */
        public Builder notificationTopicArn(@Nullable Output<String> notificationTopicArn) {
            $.notificationTopicArn = notificationTopicArn;
            return this;
        }

        /**
         * @param notificationTopicArn ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`.
         * 
         * @return builder
         * 
         */
        public Builder notificationTopicArn(String notificationTopicArn) {
            return notificationTopicArn(Output.of(notificationTopicArn));
        }

        /**
         * @param numCacheNodes The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
         * 
         * @return builder
         * 
         */
        public Builder numCacheNodes(@Nullable Output<Integer> numCacheNodes) {
            $.numCacheNodes = numCacheNodes;
            return this;
        }

        /**
         * @param numCacheNodes The initial number of cache nodes that the cache cluster will have. For Redis, this value must be 1. For Memcached, this value must be between 1 and 40. If this number is reduced on subsequent runs, the highest numbered nodes will be removed.
         * 
         * @return builder
         * 
         */
        public Builder numCacheNodes(Integer numCacheNodes) {
            return numCacheNodes(Output.of(numCacheNodes));
        }

        /**
         * @param outpostMode Specify the outpost mode that will apply to the cache cluster creation. Valid values are `&#34;single-outpost&#34;` and `&#34;cross-outpost&#34;`, however AWS currently only supports `&#34;single-outpost&#34;` mode.
         * 
         * @return builder
         * 
         */
        public Builder outpostMode(@Nullable Output<String> outpostMode) {
            $.outpostMode = outpostMode;
            return this;
        }

        /**
         * @param outpostMode Specify the outpost mode that will apply to the cache cluster creation. Valid values are `&#34;single-outpost&#34;` and `&#34;cross-outpost&#34;`, however AWS currently only supports `&#34;single-outpost&#34;` mode.
         * 
         * @return builder
         * 
         */
        public Builder outpostMode(String outpostMode) {
            return outpostMode(Output.of(outpostMode));
        }

        /**
         * @param parameterGroupName The name of the parameter group to associate with this cache cluster.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder parameterGroupName(@Nullable Output<String> parameterGroupName) {
            $.parameterGroupName = parameterGroupName;
            return this;
        }

        /**
         * @param parameterGroupName The name of the parameter group to associate with this cache cluster.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder parameterGroupName(String parameterGroupName) {
            return parameterGroupName(Output.of(parameterGroupName));
        }

        /**
         * @param port The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredAvailabilityZones List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
         * 
         * @return builder
         * 
         */
        public Builder preferredAvailabilityZones(@Nullable Output<List<String>> preferredAvailabilityZones) {
            $.preferredAvailabilityZones = preferredAvailabilityZones;
            return this;
        }

        /**
         * @param preferredAvailabilityZones List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
         * 
         * @return builder
         * 
         */
        public Builder preferredAvailabilityZones(List<String> preferredAvailabilityZones) {
            return preferredAvailabilityZones(Output.of(preferredAvailabilityZones));
        }

        /**
         * @param preferredAvailabilityZones List of the Availability Zones in which cache nodes are created. If you are creating your cluster in an Amazon VPC you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group. The number of Availability Zones listed must equal the value of `num_cache_nodes`. If you want all the nodes in the same Availability Zone, use `availability_zone` instead, or repeat the Availability Zone multiple times in the list. Default: System chosen Availability Zones. Detecting drift of existing node availability zone is not currently supported. Updating this argument by itself to migrate existing node availability zones is not currently supported and will show a perpetual difference.
         * 
         * @return builder
         * 
         */
        public Builder preferredAvailabilityZones(String... preferredAvailabilityZones) {
            return preferredAvailabilityZones(List.of(preferredAvailabilityZones));
        }

        /**
         * @param preferredOutpostArn The outpost ARN in which the cache cluster will be created.
         * 
         * @return builder
         * 
         */
        public Builder preferredOutpostArn(@Nullable Output<String> preferredOutpostArn) {
            $.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        /**
         * @param preferredOutpostArn The outpost ARN in which the cache cluster will be created.
         * 
         * @return builder
         * 
         */
        public Builder preferredOutpostArn(String preferredOutpostArn) {
            return preferredOutpostArn(Output.of(preferredOutpostArn));
        }

        /**
         * @param replicationGroupId ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
         * 
         * @return builder
         * 
         */
        public Builder replicationGroupId(@Nullable Output<String> replicationGroupId) {
            $.replicationGroupId = replicationGroupId;
            return this;
        }

        /**
         * @param replicationGroupId ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
         * 
         * @return builder
         * 
         */
        public Builder replicationGroupId(String replicationGroupId) {
            return replicationGroupId(Output.of(replicationGroupId));
        }

        /**
         * @param securityGroupIds One or more VPC security groups associated with the cache cluster
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds One or more VPC security groups associated with the cache cluster
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds One or more VPC security groups associated with the cache cluster
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param snapshotArns Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
         * 
         * @return builder
         * 
         */
        public Builder snapshotArns(@Nullable Output<String> snapshotArns) {
            $.snapshotArns = snapshotArns;
            return this;
        }

        /**
         * @param snapshotArns Single-element string list containing an Amazon Resource Name (ARN) of a Redis RDB snapshot file stored in Amazon S3. The object name cannot contain any commas. Changing `snapshot_arns` forces a new resource.
         * 
         * @return builder
         * 
         */
        public Builder snapshotArns(String snapshotArns) {
            return snapshotArns(Output.of(snapshotArns));
        }

        /**
         * @param snapshotName Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
         * 
         * @return builder
         * 
         */
        public Builder snapshotName(@Nullable Output<String> snapshotName) {
            $.snapshotName = snapshotName;
            return this;
        }

        /**
         * @param snapshotName Name of a snapshot from which to restore data into the new node group. Changing `snapshot_name` forces a new resource.
         * 
         * @return builder
         * 
         */
        public Builder snapshotName(String snapshotName) {
            return snapshotName(Output.of(snapshotName));
        }

        /**
         * @param snapshotRetentionLimit Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
         * 
         * @return builder
         * 
         */
        public Builder snapshotRetentionLimit(@Nullable Output<Integer> snapshotRetentionLimit) {
            $.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        /**
         * @param snapshotRetentionLimit Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
         * 
         * @return builder
         * 
         */
        public Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            return snapshotRetentionLimit(Output.of(snapshotRetentionLimit));
        }

        /**
         * @param snapshotWindow Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
         * 
         * @return builder
         * 
         */
        public Builder snapshotWindow(@Nullable Output<String> snapshotWindow) {
            $.snapshotWindow = snapshotWindow;
            return this;
        }

        /**
         * @param snapshotWindow Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. Example: 05:00-09:00
         * 
         * @return builder
         * 
         */
        public Builder snapshotWindow(String snapshotWindow) {
            return snapshotWindow(Output.of(snapshotWindow));
        }

        /**
         * @param subnetGroupName Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder subnetGroupName(@Nullable Output<String> subnetGroupName) {
            $.subnetGroupName = subnetGroupName;
            return this;
        }

        /**
         * @param subnetGroupName Name of the subnet group to be used for the cache cluster. Changing this value will re-create the resource.
         * 
         * @return builder
         * 
         */
        public Builder subnetGroupName(String subnetGroupName) {
            return subnetGroupName(Output.of(subnetGroupName));
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param transitEncryptionEnabled Enable encryption in-transit. Supported only with Memcached versions `1.6.12` and later, running in a VPC. See the [ElastiCache in-transit encryption](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/in-transit-encryption-mc.html) documentation for more details.
         * 
         * @return builder
         * 
         */
        public Builder transitEncryptionEnabled(@Nullable Output<Boolean> transitEncryptionEnabled) {
            $.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * @param transitEncryptionEnabled Enable encryption in-transit. Supported only with Memcached versions `1.6.12` and later, running in a VPC. See the [ElastiCache in-transit encryption](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/in-transit-encryption-mc.html) documentation for more details.
         * 
         * @return builder
         * 
         */
        public Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            return transitEncryptionEnabled(Output.of(transitEncryptionEnabled));
        }

        public ClusterState build() {
            return $;
        }
    }

}
