// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticache;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.elasticache.UserGroupAssociationArgs;
import com.pulumi.aws.elasticache.inputs.UserGroupAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Associate an existing ElastiCache user and an existing user group.
 * 
 * &gt; **NOTE:** The provider will detect changes in the `aws.elasticache.UserGroup` since `aws.elasticache.UserGroupAssociation` changes the user IDs associated with the user group. You can ignore these changes with the `ignore_changes` option as shown in the example.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import com.pulumi.aws.elasticache.UserGroupAssociation;
 * import com.pulumi.aws.elasticache.UserGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var default_ = new User(&#34;default&#34;, UserArgs.builder()        
 *             .userId(&#34;defaultUserID&#34;)
 *             .userName(&#34;default&#34;)
 *             .accessString(&#34;on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember&#34;)
 *             .engine(&#34;REDIS&#34;)
 *             .passwords(&#34;password123456789&#34;)
 *             .build());
 * 
 *         var exampleUserGroup = new UserGroup(&#34;exampleUserGroup&#34;, UserGroupArgs.builder()        
 *             .engine(&#34;REDIS&#34;)
 *             .userGroupId(&#34;userGroupId&#34;)
 *             .userIds(default_.userId())
 *             .build());
 * 
 *         var exampleUser = new User(&#34;exampleUser&#34;, UserArgs.builder()        
 *             .userId(&#34;exampleUserID&#34;)
 *             .userName(&#34;exampleuser&#34;)
 *             .accessString(&#34;on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember&#34;)
 *             .engine(&#34;REDIS&#34;)
 *             .passwords(&#34;password123456789&#34;)
 *             .build());
 * 
 *         var exampleUserGroupAssociation = new UserGroupAssociation(&#34;exampleUserGroupAssociation&#34;, UserGroupAssociationArgs.builder()        
 *             .userGroupId(exampleUserGroup.userGroupId())
 *             .userId(exampleUser.userId())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ElastiCache user group associations using the `user_group_id` and `user_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:elasticache/userGroupAssociation:UserGroupAssociation example userGoupId1,userId
 * ```
 * 
 */
@ResourceType(type="aws:elasticache/userGroupAssociation:UserGroupAssociation")
public class UserGroupAssociation extends com.pulumi.resources.CustomResource {
    /**
     * ID of the user group.
     * 
     */
    @Export(name="userGroupId", refs={String.class}, tree="[0]")
    private Output<String> userGroupId;

    /**
     * @return ID of the user group.
     * 
     */
    public Output<String> userGroupId() {
        return this.userGroupId;
    }
    /**
     * ID of the user to associated with the user group.
     * 
     */
    @Export(name="userId", refs={String.class}, tree="[0]")
    private Output<String> userId;

    /**
     * @return ID of the user to associated with the user group.
     * 
     */
    public Output<String> userId() {
        return this.userId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public UserGroupAssociation(String name) {
        this(name, UserGroupAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public UserGroupAssociation(String name, UserGroupAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public UserGroupAssociation(String name, UserGroupAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elasticache/userGroupAssociation:UserGroupAssociation", name, args == null ? UserGroupAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private UserGroupAssociation(String name, Output<String> id, @Nullable UserGroupAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elasticache/userGroupAssociation:UserGroupAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static UserGroupAssociation get(String name, Output<String> id, @Nullable UserGroupAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new UserGroupAssociation(name, id, state, options);
    }
}
