// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticache;

import com.pulumi.aws.elasticache.inputs.UserAuthenticationModeArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class UserArgs extends com.pulumi.resources.ResourceArgs {

    public static final UserArgs Empty = new UserArgs();

    /**
     * Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
     * 
     */
    @Import(name="accessString", required=true)
    private Output<String> accessString;

    /**
     * @return Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
     * 
     */
    public Output<String> accessString() {
        return this.accessString;
    }

    /**
     * Denotes the user&#39;s authentication properties. Detailed below.
     * 
     */
    @Import(name="authenticationMode")
    private @Nullable Output<UserAuthenticationModeArgs> authenticationMode;

    /**
     * @return Denotes the user&#39;s authentication properties. Detailed below.
     * 
     */
    public Optional<Output<UserAuthenticationModeArgs>> authenticationMode() {
        return Optional.ofNullable(this.authenticationMode);
    }

    /**
     * The current supported value is `REDIS`.
     * 
     */
    @Import(name="engine", required=true)
    private Output<String> engine;

    /**
     * @return The current supported value is `REDIS`.
     * 
     */
    public Output<String> engine() {
        return this.engine;
    }

    /**
     * Indicates a password is not required for this user.
     * 
     */
    @Import(name="noPasswordRequired")
    private @Nullable Output<Boolean> noPasswordRequired;

    /**
     * @return Indicates a password is not required for this user.
     * 
     */
    public Optional<Output<Boolean>> noPasswordRequired() {
        return Optional.ofNullable(this.noPasswordRequired);
    }

    /**
     * Passwords used for this user. You can create up to two passwords for each user.
     * 
     */
    @Import(name="passwords")
    private @Nullable Output<List<String>> passwords;

    /**
     * @return Passwords used for this user. You can create up to two passwords for each user.
     * 
     */
    public Optional<Output<List<String>>> passwords() {
        return Optional.ofNullable(this.passwords);
    }

    /**
     * A list of tags to be added to this resource. A tag is a key-value pair.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A list of tags to be added to this resource. A tag is a key-value pair.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The ID of the user.
     * 
     */
    @Import(name="userId", required=true)
    private Output<String> userId;

    /**
     * @return The ID of the user.
     * 
     */
    public Output<String> userId() {
        return this.userId;
    }

    /**
     * The username of the user.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="userName", required=true)
    private Output<String> userName;

    /**
     * @return The username of the user.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> userName() {
        return this.userName;
    }

    private UserArgs() {}

    private UserArgs(UserArgs $) {
        this.accessString = $.accessString;
        this.authenticationMode = $.authenticationMode;
        this.engine = $.engine;
        this.noPasswordRequired = $.noPasswordRequired;
        this.passwords = $.passwords;
        this.tags = $.tags;
        this.userId = $.userId;
        this.userName = $.userName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(UserArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private UserArgs $;

        public Builder() {
            $ = new UserArgs();
        }

        public Builder(UserArgs defaults) {
            $ = new UserArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessString Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
         * 
         * @return builder
         * 
         */
        public Builder accessString(Output<String> accessString) {
            $.accessString = accessString;
            return this;
        }

        /**
         * @param accessString Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
         * 
         * @return builder
         * 
         */
        public Builder accessString(String accessString) {
            return accessString(Output.of(accessString));
        }

        /**
         * @param authenticationMode Denotes the user&#39;s authentication properties. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder authenticationMode(@Nullable Output<UserAuthenticationModeArgs> authenticationMode) {
            $.authenticationMode = authenticationMode;
            return this;
        }

        /**
         * @param authenticationMode Denotes the user&#39;s authentication properties. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder authenticationMode(UserAuthenticationModeArgs authenticationMode) {
            return authenticationMode(Output.of(authenticationMode));
        }

        /**
         * @param engine The current supported value is `REDIS`.
         * 
         * @return builder
         * 
         */
        public Builder engine(Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine The current supported value is `REDIS`.
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param noPasswordRequired Indicates a password is not required for this user.
         * 
         * @return builder
         * 
         */
        public Builder noPasswordRequired(@Nullable Output<Boolean> noPasswordRequired) {
            $.noPasswordRequired = noPasswordRequired;
            return this;
        }

        /**
         * @param noPasswordRequired Indicates a password is not required for this user.
         * 
         * @return builder
         * 
         */
        public Builder noPasswordRequired(Boolean noPasswordRequired) {
            return noPasswordRequired(Output.of(noPasswordRequired));
        }

        /**
         * @param passwords Passwords used for this user. You can create up to two passwords for each user.
         * 
         * @return builder
         * 
         */
        public Builder passwords(@Nullable Output<List<String>> passwords) {
            $.passwords = passwords;
            return this;
        }

        /**
         * @param passwords Passwords used for this user. You can create up to two passwords for each user.
         * 
         * @return builder
         * 
         */
        public Builder passwords(List<String> passwords) {
            return passwords(Output.of(passwords));
        }

        /**
         * @param passwords Passwords used for this user. You can create up to two passwords for each user.
         * 
         * @return builder
         * 
         */
        public Builder passwords(String... passwords) {
            return passwords(List.of(passwords));
        }

        /**
         * @param tags A list of tags to be added to this resource. A tag is a key-value pair.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A list of tags to be added to this resource. A tag is a key-value pair.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param userId The ID of the user.
         * 
         * @return builder
         * 
         */
        public Builder userId(Output<String> userId) {
            $.userId = userId;
            return this;
        }

        /**
         * @param userId The ID of the user.
         * 
         * @return builder
         * 
         */
        public Builder userId(String userId) {
            return userId(Output.of(userId));
        }

        /**
         * @param userName The username of the user.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder userName(Output<String> userName) {
            $.userName = userName;
            return this;
        }

        /**
         * @param userName The username of the user.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder userName(String userName) {
            return userName(Output.of(userName));
        }

        public UserArgs build() {
            $.accessString = Objects.requireNonNull($.accessString, "expected parameter 'accessString' to be non-null");
            $.engine = Objects.requireNonNull($.engine, "expected parameter 'engine' to be non-null");
            $.userId = Objects.requireNonNull($.userId, "expected parameter 'userId' to be non-null");
            $.userName = Objects.requireNonNull($.userName, "expected parameter 'userName' to be non-null");
            return $;
        }
    }

}
