// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticache;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.elasticache.UserArgs;
import com.pulumi.aws.elasticache.inputs.UserState;
import com.pulumi.aws.elasticache.outputs.UserAuthenticationMode;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an ElastiCache user resource.
 * 
 * &gt; **Note:** All arguments including the username and passwords will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new User(&#34;test&#34;, UserArgs.builder()        
 *             .accessString(&#34;on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember&#34;)
 *             .engine(&#34;REDIS&#34;)
 *             .passwords(&#34;password123456789&#34;)
 *             .userId(&#34;testUserId&#34;)
 *             .userName(&#34;testUserName&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.inputs.UserAuthenticationModeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new User(&#34;test&#34;, UserArgs.builder()        
 *             .accessString(&#34;on ~* +@all&#34;)
 *             .authenticationMode(UserAuthenticationModeArgs.builder()
 *                 .type(&#34;iam&#34;)
 *                 .build())
 *             .engine(&#34;REDIS&#34;)
 *             .userId(&#34;testUserId&#34;)
 *             .userName(&#34;testUserName&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.inputs.UserAuthenticationModeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new User(&#34;test&#34;, UserArgs.builder()        
 *             .accessString(&#34;on ~* +@all&#34;)
 *             .authenticationMode(UserAuthenticationModeArgs.builder()
 *                 .passwords(                
 *                     &#34;password1&#34;,
 *                     &#34;password2&#34;)
 *                 .type(&#34;password&#34;)
 *                 .build())
 *             .engine(&#34;REDIS&#34;)
 *             .userId(&#34;testUserId&#34;)
 *             .userName(&#34;testUserName&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ElastiCache users using the `user_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:elasticache/user:User my_user userId1
 * ```
 * 
 */
@ResourceType(type="aws:elasticache/user:User")
public class User extends com.pulumi.resources.CustomResource {
    /**
     * Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
     * 
     */
    @Export(name="accessString", refs={String.class}, tree="[0]")
    private Output<String> accessString;

    /**
     * @return Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
     * 
     */
    public Output<String> accessString() {
        return this.accessString;
    }
    /**
     * The ARN of the created ElastiCache User.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the created ElastiCache User.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Denotes the user&#39;s authentication properties. Detailed below.
     * 
     */
    @Export(name="authenticationMode", refs={UserAuthenticationMode.class}, tree="[0]")
    private Output<UserAuthenticationMode> authenticationMode;

    /**
     * @return Denotes the user&#39;s authentication properties. Detailed below.
     * 
     */
    public Output<UserAuthenticationMode> authenticationMode() {
        return this.authenticationMode;
    }
    /**
     * The current supported value is `REDIS`.
     * 
     */
    @Export(name="engine", refs={String.class}, tree="[0]")
    private Output<String> engine;

    /**
     * @return The current supported value is `REDIS`.
     * 
     */
    public Output<String> engine() {
        return this.engine;
    }
    /**
     * Indicates a password is not required for this user.
     * 
     */
    @Export(name="noPasswordRequired", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> noPasswordRequired;

    /**
     * @return Indicates a password is not required for this user.
     * 
     */
    public Output<Optional<Boolean>> noPasswordRequired() {
        return Codegen.optional(this.noPasswordRequired);
    }
    /**
     * Passwords used for this user. You can create up to two passwords for each user.
     * 
     */
    @Export(name="passwords", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> passwords;

    /**
     * @return Passwords used for this user. You can create up to two passwords for each user.
     * 
     */
    public Output<Optional<List<String>>> passwords() {
        return Codegen.optional(this.passwords);
    }
    /**
     * A list of tags to be added to this resource. A tag is a key-value pair.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A list of tags to be added to this resource. A tag is a key-value pair.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The ID of the user.
     * 
     */
    @Export(name="userId", refs={String.class}, tree="[0]")
    private Output<String> userId;

    /**
     * @return The ID of the user.
     * 
     */
    public Output<String> userId() {
        return this.userId;
    }
    /**
     * The username of the user.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="userName", refs={String.class}, tree="[0]")
    private Output<String> userName;

    /**
     * @return The username of the user.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> userName() {
        return this.userName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public User(String name) {
        this(name, UserArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public User(String name, UserArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public User(String name, UserArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elasticache/user:User", name, args == null ? UserArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private User(String name, Output<String> id, @Nullable UserState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elasticache/user:User", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "passwords"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static User get(String name, Output<String> id, @Nullable UserState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new User(name, id, state, options);
    }
}
