// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticache;

import com.pulumi.aws.elasticache.inputs.ReplicationGroupLogDeliveryConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ReplicationGroupArgs extends com.pulumi.resources.ResourceArgs {

    public static final ReplicationGroupArgs Empty = new ReplicationGroupArgs();

    /**
     * Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * Whether to enable encryption at rest.
     * 
     */
    @Import(name="atRestEncryptionEnabled")
    private @Nullable Output<Boolean> atRestEncryptionEnabled;

    /**
     * @return Whether to enable encryption at rest.
     * 
     */
    public Optional<Output<Boolean>> atRestEncryptionEnabled() {
        return Optional.ofNullable(this.atRestEncryptionEnabled);
    }

    /**
     * Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
     * 
     */
    @Import(name="authToken")
    private @Nullable Output<String> authToken;

    /**
     * @return Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
     * 
     */
    public Optional<Output<String>> authToken() {
        return Optional.ofNullable(this.authToken);
    }

    /**
     * Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
     * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
     * Defaults to `true`.
     * 
     */
    @Import(name="autoMinorVersionUpgrade")
    private @Nullable Output<Boolean> autoMinorVersionUpgrade;

    /**
     * @return Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
     * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
     * Defaults to `true`.
     * 
     */
    public Optional<Output<Boolean>> autoMinorVersionUpgrade() {
        return Optional.ofNullable(this.autoMinorVersionUpgrade);
    }

    /**
     * Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
     * 
     */
    @Import(name="automaticFailoverEnabled")
    private @Nullable Output<Boolean> automaticFailoverEnabled;

    /**
     * @return Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> automaticFailoverEnabled() {
        return Optional.ofNullable(this.automaticFailoverEnabled);
    }

    /**
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
     * 
     */
    @Import(name="dataTieringEnabled")
    private @Nullable Output<Boolean> dataTieringEnabled;

    /**
     * @return Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
     * 
     */
    public Optional<Output<Boolean>> dataTieringEnabled() {
        return Optional.ofNullable(this.dataTieringEnabled);
    }

    /**
     * User-created description for the replication group. Must not be empty.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return User-created description for the replication group. Must not be empty.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Name of the cache engine to be used for the clusters in this replication group. The only valid value is `redis`.
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return Name of the cache engine to be used for the clusters in this replication group. The only valid value is `redis`.
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * Version number of the cache engine to be used for the cache clusters in this replication group.
     * If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * If the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * Otherwise, specify the full version desired, e.g., `5.0.6`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return Version number of the cache engine to be used for the cache clusters in this replication group.
     * If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * If the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * Otherwise, specify the full version desired, e.g., `5.0.6`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
     * 
     */
    @Import(name="finalSnapshotIdentifier")
    private @Nullable Output<String> finalSnapshotIdentifier;

    /**
     * @return The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
     * 
     */
    public Optional<Output<String>> finalSnapshotIdentifier() {
        return Optional.ofNullable(this.finalSnapshotIdentifier);
    }

    /**
     * The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
     * 
     */
    @Import(name="globalReplicationGroupId")
    private @Nullable Output<String> globalReplicationGroupId;

    /**
     * @return The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
     * 
     */
    public Optional<Output<String>> globalReplicationGroupId() {
        return Optional.ofNullable(this.globalReplicationGroupId);
    }

    /**
     * The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
     * 
     */
    @Import(name="logDeliveryConfigurations")
    private @Nullable Output<List<ReplicationGroupLogDeliveryConfigurationArgs>> logDeliveryConfigurations;

    /**
     * @return Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
     * 
     */
    public Optional<Output<List<ReplicationGroupLogDeliveryConfigurationArgs>>> logDeliveryConfigurations() {
        return Optional.ofNullable(this.logDeliveryConfigurations);
    }

    /**
     * Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
     * 
     */
    @Import(name="maintenanceWindow")
    private @Nullable Output<String> maintenanceWindow;

    /**
     * @return Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
     * 
     */
    public Optional<Output<String>> maintenanceWindow() {
        return Optional.ofNullable(this.maintenanceWindow);
    }

    /**
     * Specifies whether to enable Multi-AZ Support for the replication group. If `true`, `automatic_failover_enabled` must also be enabled. Defaults to `false`.
     * 
     */
    @Import(name="multiAzEnabled")
    private @Nullable Output<Boolean> multiAzEnabled;

    /**
     * @return Specifies whether to enable Multi-AZ Support for the replication group. If `true`, `automatic_failover_enabled` must also be enabled. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> multiAzEnabled() {
        return Optional.ofNullable(this.multiAzEnabled);
    }

    /**
     * Instance class to be used. See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). Required unless `global_replication_group_id` is set. Cannot be set if `global_replication_group_id` is set.
     * 
     */
    @Import(name="nodeType")
    private @Nullable Output<String> nodeType;

    /**
     * @return Instance class to be used. See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). Required unless `global_replication_group_id` is set. Cannot be set if `global_replication_group_id` is set.
     * 
     */
    public Optional<Output<String>> nodeType() {
        return Optional.ofNullable(this.nodeType);
    }

    /**
     * ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
     * 
     */
    @Import(name="notificationTopicArn")
    private @Nullable Output<String> notificationTopicArn;

    /**
     * @return ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
     * 
     */
    public Optional<Output<String>> notificationTopicArn() {
        return Optional.ofNullable(this.notificationTopicArn);
    }

    /**
     * Number of cache clusters (primary and replicas) this replication group will have. If Multi-AZ is enabled, the value of this parameter must be at least 2. Updates will occur before other modifications. Conflicts with `num_node_groups`. Defaults to `1`.
     * 
     */
    @Import(name="numCacheClusters")
    private @Nullable Output<Integer> numCacheClusters;

    /**
     * @return Number of cache clusters (primary and replicas) this replication group will have. If Multi-AZ is enabled, the value of this parameter must be at least 2. Updates will occur before other modifications. Conflicts with `num_node_groups`. Defaults to `1`.
     * 
     */
    public Optional<Output<Integer>> numCacheClusters() {
        return Optional.ofNullable(this.numCacheClusters);
    }

    /**
     * Number of node groups (shards) for this Redis replication group.
     * Changing this number will trigger a resizing operation before other settings modifications.
     * 
     */
    @Import(name="numNodeGroups")
    private @Nullable Output<Integer> numNodeGroups;

    /**
     * @return Number of node groups (shards) for this Redis replication group.
     * Changing this number will trigger a resizing operation before other settings modifications.
     * 
     */
    public Optional<Output<Integer>> numNodeGroups() {
        return Optional.ofNullable(this.numNodeGroups);
    }

    /**
     * Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable &#34;cluster mode&#34;, i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
     * 
     */
    @Import(name="parameterGroupName")
    private @Nullable Output<String> parameterGroupName;

    /**
     * @return Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable &#34;cluster mode&#34;, i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
     * 
     */
    public Optional<Output<String>> parameterGroupName() {
        return Optional.ofNullable(this.parameterGroupName);
    }

    /**
     * Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * List of EC2 availability zones in which the replication group&#39;s cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
     * 
     */
    @Import(name="preferredCacheClusterAzs")
    private @Nullable Output<List<String>> preferredCacheClusterAzs;

    /**
     * @return List of EC2 availability zones in which the replication group&#39;s cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
     * 
     */
    public Optional<Output<List<String>>> preferredCacheClusterAzs() {
        return Optional.ofNullable(this.preferredCacheClusterAzs);
    }

    /**
     * Number of replica nodes in each node group.
     * Changing this number will trigger a resizing operation before other settings modifications.
     * Valid values are 0 to 5.
     * 
     */
    @Import(name="replicasPerNodeGroup")
    private @Nullable Output<Integer> replicasPerNodeGroup;

    /**
     * @return Number of replica nodes in each node group.
     * Changing this number will trigger a resizing operation before other settings modifications.
     * Valid values are 0 to 5.
     * 
     */
    public Optional<Output<Integer>> replicasPerNodeGroup() {
        return Optional.ofNullable(this.replicasPerNodeGroup);
    }

    /**
     * Replication group identifier. This parameter is stored as a lowercase string.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="replicationGroupId")
    private @Nullable Output<String> replicationGroupId;

    /**
     * @return Replication group identifier. This parameter is stored as a lowercase string.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<String>> replicationGroupId() {
        return Optional.ofNullable(this.replicationGroupId);
    }

    /**
     * One or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return One or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * List of cache security group names to associate with this replication group.
     * 
     */
    @Import(name="securityGroupNames")
    private @Nullable Output<List<String>> securityGroupNames;

    /**
     * @return List of cache security group names to associate with this replication group.
     * 
     */
    public Optional<Output<List<String>>> securityGroupNames() {
        return Optional.ofNullable(this.securityGroupNames);
    }

    /**
     * List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
     * 
     */
    @Import(name="snapshotArns")
    private @Nullable Output<List<String>> snapshotArns;

    /**
     * @return List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
     * 
     */
    public Optional<Output<List<String>>> snapshotArns() {
        return Optional.ofNullable(this.snapshotArns);
    }

    /**
     * Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
     * 
     */
    @Import(name="snapshotName")
    private @Nullable Output<String> snapshotName;

    /**
     * @return Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
     * 
     */
    public Optional<Output<String>> snapshotName() {
        return Optional.ofNullable(this.snapshotName);
    }

    /**
     * Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
     * 
     */
    @Import(name="snapshotRetentionLimit")
    private @Nullable Output<Integer> snapshotRetentionLimit;

    /**
     * @return Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
     * 
     */
    public Optional<Output<Integer>> snapshotRetentionLimit() {
        return Optional.ofNullable(this.snapshotRetentionLimit);
    }

    /**
     * Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
     * 
     */
    @Import(name="snapshotWindow")
    private @Nullable Output<String> snapshotWindow;

    /**
     * @return Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
     * 
     */
    public Optional<Output<String>> snapshotWindow() {
        return Optional.ofNullable(this.snapshotWindow);
    }

    /**
     * Name of the cache subnet group to be used for the replication group.
     * 
     */
    @Import(name="subnetGroupName")
    private @Nullable Output<String> subnetGroupName;

    /**
     * @return Name of the cache subnet group to be used for the replication group.
     * 
     */
    public Optional<Output<String>> subnetGroupName() {
        return Optional.ofNullable(this.subnetGroupName);
    }

    /**
     * Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Whether to enable encryption in transit.
     * 
     */
    @Import(name="transitEncryptionEnabled")
    private @Nullable Output<Boolean> transitEncryptionEnabled;

    /**
     * @return Whether to enable encryption in transit.
     * 
     */
    public Optional<Output<Boolean>> transitEncryptionEnabled() {
        return Optional.ofNullable(this.transitEncryptionEnabled);
    }

    /**
     * User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
     * 
     */
    @Import(name="userGroupIds")
    private @Nullable Output<List<String>> userGroupIds;

    /**
     * @return User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
     * 
     */
    public Optional<Output<List<String>>> userGroupIds() {
        return Optional.ofNullable(this.userGroupIds);
    }

    private ReplicationGroupArgs() {}

    private ReplicationGroupArgs(ReplicationGroupArgs $) {
        this.applyImmediately = $.applyImmediately;
        this.atRestEncryptionEnabled = $.atRestEncryptionEnabled;
        this.authToken = $.authToken;
        this.autoMinorVersionUpgrade = $.autoMinorVersionUpgrade;
        this.automaticFailoverEnabled = $.automaticFailoverEnabled;
        this.dataTieringEnabled = $.dataTieringEnabled;
        this.description = $.description;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.finalSnapshotIdentifier = $.finalSnapshotIdentifier;
        this.globalReplicationGroupId = $.globalReplicationGroupId;
        this.kmsKeyId = $.kmsKeyId;
        this.logDeliveryConfigurations = $.logDeliveryConfigurations;
        this.maintenanceWindow = $.maintenanceWindow;
        this.multiAzEnabled = $.multiAzEnabled;
        this.nodeType = $.nodeType;
        this.notificationTopicArn = $.notificationTopicArn;
        this.numCacheClusters = $.numCacheClusters;
        this.numNodeGroups = $.numNodeGroups;
        this.parameterGroupName = $.parameterGroupName;
        this.port = $.port;
        this.preferredCacheClusterAzs = $.preferredCacheClusterAzs;
        this.replicasPerNodeGroup = $.replicasPerNodeGroup;
        this.replicationGroupId = $.replicationGroupId;
        this.securityGroupIds = $.securityGroupIds;
        this.securityGroupNames = $.securityGroupNames;
        this.snapshotArns = $.snapshotArns;
        this.snapshotName = $.snapshotName;
        this.snapshotRetentionLimit = $.snapshotRetentionLimit;
        this.snapshotWindow = $.snapshotWindow;
        this.subnetGroupName = $.subnetGroupName;
        this.tags = $.tags;
        this.transitEncryptionEnabled = $.transitEncryptionEnabled;
        this.userGroupIds = $.userGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ReplicationGroupArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ReplicationGroupArgs $;

        public Builder() {
            $ = new ReplicationGroupArgs();
        }

        public Builder(ReplicationGroupArgs defaults) {
            $ = new ReplicationGroupArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param atRestEncryptionEnabled Whether to enable encryption at rest.
         * 
         * @return builder
         * 
         */
        public Builder atRestEncryptionEnabled(@Nullable Output<Boolean> atRestEncryptionEnabled) {
            $.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        /**
         * @param atRestEncryptionEnabled Whether to enable encryption at rest.
         * 
         * @return builder
         * 
         */
        public Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            return atRestEncryptionEnabled(Output.of(atRestEncryptionEnabled));
        }

        /**
         * @param authToken Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
         * 
         * @return builder
         * 
         */
        public Builder authToken(@Nullable Output<String> authToken) {
            $.authToken = authToken;
            return this;
        }

        /**
         * @param authToken Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
         * 
         * @return builder
         * 
         */
        public Builder authToken(String authToken) {
            return authToken(Output.of(authToken));
        }

        /**
         * @param autoMinorVersionUpgrade Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
         * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
         * Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(@Nullable Output<Boolean> autoMinorVersionUpgrade) {
            $.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * @param autoMinorVersionUpgrade Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
         * Only supported for engine type `&#34;redis&#34;` and if the engine version is 6 or higher.
         * Defaults to `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            return autoMinorVersionUpgrade(Output.of(autoMinorVersionUpgrade));
        }

        /**
         * @param automaticFailoverEnabled Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder automaticFailoverEnabled(@Nullable Output<Boolean> automaticFailoverEnabled) {
            $.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        /**
         * @param automaticFailoverEnabled Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            return automaticFailoverEnabled(Output.of(automaticFailoverEnabled));
        }

        /**
         * @param dataTieringEnabled Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
         * 
         * @return builder
         * 
         */
        public Builder dataTieringEnabled(@Nullable Output<Boolean> dataTieringEnabled) {
            $.dataTieringEnabled = dataTieringEnabled;
            return this;
        }

        /**
         * @param dataTieringEnabled Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
         * 
         * @return builder
         * 
         */
        public Builder dataTieringEnabled(Boolean dataTieringEnabled) {
            return dataTieringEnabled(Output.of(dataTieringEnabled));
        }

        /**
         * @param description User-created description for the replication group. Must not be empty.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description User-created description for the replication group. Must not be empty.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param engine Name of the cache engine to be used for the clusters in this replication group. The only valid value is `redis`.
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine Name of the cache engine to be used for the clusters in this replication group. The only valid value is `redis`.
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion Version number of the cache engine to be used for the cache clusters in this replication group.
         * If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
         * If the version is 6, the major and minor version can be set, e.g., `6.2`,
         * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
         * Otherwise, specify the full version desired, e.g., `5.0.6`.
         * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion Version number of the cache engine to be used for the cache clusters in this replication group.
         * If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
         * If the version is 6, the major and minor version can be set, e.g., `6.2`,
         * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
         * Otherwise, specify the full version desired, e.g., `5.0.6`.
         * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param finalSnapshotIdentifier The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(@Nullable Output<String> finalSnapshotIdentifier) {
            $.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        /**
         * @param finalSnapshotIdentifier The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            return finalSnapshotIdentifier(Output.of(finalSnapshotIdentifier));
        }

        /**
         * @param globalReplicationGroupId The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
         * 
         * @return builder
         * 
         */
        public Builder globalReplicationGroupId(@Nullable Output<String> globalReplicationGroupId) {
            $.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        /**
         * @param globalReplicationGroupId The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
         * 
         * @return builder
         * 
         */
        public Builder globalReplicationGroupId(String globalReplicationGroupId) {
            return globalReplicationGroupId(Output.of(globalReplicationGroupId));
        }

        /**
         * @param kmsKeyId The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param logDeliveryConfigurations Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder logDeliveryConfigurations(@Nullable Output<List<ReplicationGroupLogDeliveryConfigurationArgs>> logDeliveryConfigurations) {
            $.logDeliveryConfigurations = logDeliveryConfigurations;
            return this;
        }

        /**
         * @param logDeliveryConfigurations Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder logDeliveryConfigurations(List<ReplicationGroupLogDeliveryConfigurationArgs> logDeliveryConfigurations) {
            return logDeliveryConfigurations(Output.of(logDeliveryConfigurations));
        }

        /**
         * @param logDeliveryConfigurations Specifies the destination and format of Redis [SLOWLOG](https://redis.io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder logDeliveryConfigurations(ReplicationGroupLogDeliveryConfigurationArgs... logDeliveryConfigurations) {
            return logDeliveryConfigurations(List.of(logDeliveryConfigurations));
        }

        /**
         * @param maintenanceWindow Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
         * 
         * @return builder
         * 
         */
        public Builder maintenanceWindow(@Nullable Output<String> maintenanceWindow) {
            $.maintenanceWindow = maintenanceWindow;
            return this;
        }

        /**
         * @param maintenanceWindow Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
         * 
         * @return builder
         * 
         */
        public Builder maintenanceWindow(String maintenanceWindow) {
            return maintenanceWindow(Output.of(maintenanceWindow));
        }

        /**
         * @param multiAzEnabled Specifies whether to enable Multi-AZ Support for the replication group. If `true`, `automatic_failover_enabled` must also be enabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder multiAzEnabled(@Nullable Output<Boolean> multiAzEnabled) {
            $.multiAzEnabled = multiAzEnabled;
            return this;
        }

        /**
         * @param multiAzEnabled Specifies whether to enable Multi-AZ Support for the replication group. If `true`, `automatic_failover_enabled` must also be enabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder multiAzEnabled(Boolean multiAzEnabled) {
            return multiAzEnabled(Output.of(multiAzEnabled));
        }

        /**
         * @param nodeType Instance class to be used. See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). Required unless `global_replication_group_id` is set. Cannot be set if `global_replication_group_id` is set.
         * 
         * @return builder
         * 
         */
        public Builder nodeType(@Nullable Output<String> nodeType) {
            $.nodeType = nodeType;
            return this;
        }

        /**
         * @param nodeType Instance class to be used. See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). Required unless `global_replication_group_id` is set. Cannot be set if `global_replication_group_id` is set.
         * 
         * @return builder
         * 
         */
        public Builder nodeType(String nodeType) {
            return nodeType(Output.of(nodeType));
        }

        /**
         * @param notificationTopicArn ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
         * 
         * @return builder
         * 
         */
        public Builder notificationTopicArn(@Nullable Output<String> notificationTopicArn) {
            $.notificationTopicArn = notificationTopicArn;
            return this;
        }

        /**
         * @param notificationTopicArn ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
         * 
         * @return builder
         * 
         */
        public Builder notificationTopicArn(String notificationTopicArn) {
            return notificationTopicArn(Output.of(notificationTopicArn));
        }

        /**
         * @param numCacheClusters Number of cache clusters (primary and replicas) this replication group will have. If Multi-AZ is enabled, the value of this parameter must be at least 2. Updates will occur before other modifications. Conflicts with `num_node_groups`. Defaults to `1`.
         * 
         * @return builder
         * 
         */
        public Builder numCacheClusters(@Nullable Output<Integer> numCacheClusters) {
            $.numCacheClusters = numCacheClusters;
            return this;
        }

        /**
         * @param numCacheClusters Number of cache clusters (primary and replicas) this replication group will have. If Multi-AZ is enabled, the value of this parameter must be at least 2. Updates will occur before other modifications. Conflicts with `num_node_groups`. Defaults to `1`.
         * 
         * @return builder
         * 
         */
        public Builder numCacheClusters(Integer numCacheClusters) {
            return numCacheClusters(Output.of(numCacheClusters));
        }

        /**
         * @param numNodeGroups Number of node groups (shards) for this Redis replication group.
         * Changing this number will trigger a resizing operation before other settings modifications.
         * 
         * @return builder
         * 
         */
        public Builder numNodeGroups(@Nullable Output<Integer> numNodeGroups) {
            $.numNodeGroups = numNodeGroups;
            return this;
        }

        /**
         * @param numNodeGroups Number of node groups (shards) for this Redis replication group.
         * Changing this number will trigger a resizing operation before other settings modifications.
         * 
         * @return builder
         * 
         */
        public Builder numNodeGroups(Integer numNodeGroups) {
            return numNodeGroups(Output.of(numNodeGroups));
        }

        /**
         * @param parameterGroupName Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable &#34;cluster mode&#34;, i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
         * 
         * @return builder
         * 
         */
        public Builder parameterGroupName(@Nullable Output<String> parameterGroupName) {
            $.parameterGroupName = parameterGroupName;
            return this;
        }

        /**
         * @param parameterGroupName Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable &#34;cluster mode&#34;, i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
         * 
         * @return builder
         * 
         */
        public Builder parameterGroupName(String parameterGroupName) {
            return parameterGroupName(Output.of(parameterGroupName));
        }

        /**
         * @param port Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredCacheClusterAzs List of EC2 availability zones in which the replication group&#39;s cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
         * 
         * @return builder
         * 
         */
        public Builder preferredCacheClusterAzs(@Nullable Output<List<String>> preferredCacheClusterAzs) {
            $.preferredCacheClusterAzs = preferredCacheClusterAzs;
            return this;
        }

        /**
         * @param preferredCacheClusterAzs List of EC2 availability zones in which the replication group&#39;s cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
         * 
         * @return builder
         * 
         */
        public Builder preferredCacheClusterAzs(List<String> preferredCacheClusterAzs) {
            return preferredCacheClusterAzs(Output.of(preferredCacheClusterAzs));
        }

        /**
         * @param preferredCacheClusterAzs List of EC2 availability zones in which the replication group&#39;s cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
         * 
         * @return builder
         * 
         */
        public Builder preferredCacheClusterAzs(String... preferredCacheClusterAzs) {
            return preferredCacheClusterAzs(List.of(preferredCacheClusterAzs));
        }

        /**
         * @param replicasPerNodeGroup Number of replica nodes in each node group.
         * Changing this number will trigger a resizing operation before other settings modifications.
         * Valid values are 0 to 5.
         * 
         * @return builder
         * 
         */
        public Builder replicasPerNodeGroup(@Nullable Output<Integer> replicasPerNodeGroup) {
            $.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        /**
         * @param replicasPerNodeGroup Number of replica nodes in each node group.
         * Changing this number will trigger a resizing operation before other settings modifications.
         * Valid values are 0 to 5.
         * 
         * @return builder
         * 
         */
        public Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            return replicasPerNodeGroup(Output.of(replicasPerNodeGroup));
        }

        /**
         * @param replicationGroupId Replication group identifier. This parameter is stored as a lowercase string.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder replicationGroupId(@Nullable Output<String> replicationGroupId) {
            $.replicationGroupId = replicationGroupId;
            return this;
        }

        /**
         * @param replicationGroupId Replication group identifier. This parameter is stored as a lowercase string.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder replicationGroupId(String replicationGroupId) {
            return replicationGroupId(Output.of(replicationGroupId));
        }

        /**
         * @param securityGroupIds One or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds One or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds One or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param securityGroupNames List of cache security group names to associate with this replication group.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupNames(@Nullable Output<List<String>> securityGroupNames) {
            $.securityGroupNames = securityGroupNames;
            return this;
        }

        /**
         * @param securityGroupNames List of cache security group names to associate with this replication group.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupNames(List<String> securityGroupNames) {
            return securityGroupNames(Output.of(securityGroupNames));
        }

        /**
         * @param securityGroupNames List of cache security group names to associate with this replication group.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupNames(String... securityGroupNames) {
            return securityGroupNames(List.of(securityGroupNames));
        }

        /**
         * @param snapshotArns List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
         * 
         * @return builder
         * 
         */
        public Builder snapshotArns(@Nullable Output<List<String>> snapshotArns) {
            $.snapshotArns = snapshotArns;
            return this;
        }

        /**
         * @param snapshotArns List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
         * 
         * @return builder
         * 
         */
        public Builder snapshotArns(List<String> snapshotArns) {
            return snapshotArns(Output.of(snapshotArns));
        }

        /**
         * @param snapshotArns List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
         * 
         * @return builder
         * 
         */
        public Builder snapshotArns(String... snapshotArns) {
            return snapshotArns(List.of(snapshotArns));
        }

        /**
         * @param snapshotName Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
         * 
         * @return builder
         * 
         */
        public Builder snapshotName(@Nullable Output<String> snapshotName) {
            $.snapshotName = snapshotName;
            return this;
        }

        /**
         * @param snapshotName Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
         * 
         * @return builder
         * 
         */
        public Builder snapshotName(String snapshotName) {
            return snapshotName(Output.of(snapshotName));
        }

        /**
         * @param snapshotRetentionLimit Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
         * 
         * @return builder
         * 
         */
        public Builder snapshotRetentionLimit(@Nullable Output<Integer> snapshotRetentionLimit) {
            $.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        /**
         * @param snapshotRetentionLimit Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
         * 
         * @return builder
         * 
         */
        public Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            return snapshotRetentionLimit(Output.of(snapshotRetentionLimit));
        }

        /**
         * @param snapshotWindow Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
         * 
         * @return builder
         * 
         */
        public Builder snapshotWindow(@Nullable Output<String> snapshotWindow) {
            $.snapshotWindow = snapshotWindow;
            return this;
        }

        /**
         * @param snapshotWindow Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
         * 
         * @return builder
         * 
         */
        public Builder snapshotWindow(String snapshotWindow) {
            return snapshotWindow(Output.of(snapshotWindow));
        }

        /**
         * @param subnetGroupName Name of the cache subnet group to be used for the replication group.
         * 
         * @return builder
         * 
         */
        public Builder subnetGroupName(@Nullable Output<String> subnetGroupName) {
            $.subnetGroupName = subnetGroupName;
            return this;
        }

        /**
         * @param subnetGroupName Name of the cache subnet group to be used for the replication group.
         * 
         * @return builder
         * 
         */
        public Builder subnetGroupName(String subnetGroupName) {
            return subnetGroupName(Output.of(subnetGroupName));
        }

        /**
         * @param tags Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param transitEncryptionEnabled Whether to enable encryption in transit.
         * 
         * @return builder
         * 
         */
        public Builder transitEncryptionEnabled(@Nullable Output<Boolean> transitEncryptionEnabled) {
            $.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * @param transitEncryptionEnabled Whether to enable encryption in transit.
         * 
         * @return builder
         * 
         */
        public Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            return transitEncryptionEnabled(Output.of(transitEncryptionEnabled));
        }

        /**
         * @param userGroupIds User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
         * 
         * @return builder
         * 
         */
        public Builder userGroupIds(@Nullable Output<List<String>> userGroupIds) {
            $.userGroupIds = userGroupIds;
            return this;
        }

        /**
         * @param userGroupIds User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
         * 
         * @return builder
         * 
         */
        public Builder userGroupIds(List<String> userGroupIds) {
            return userGroupIds(Output.of(userGroupIds));
        }

        /**
         * @param userGroupIds User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
         * 
         * @return builder
         * 
         */
        public Builder userGroupIds(String... userGroupIds) {
            return userGroupIds(List.of(userGroupIds));
        }

        public ReplicationGroupArgs build() {
            return $;
        }
    }

}
