// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.elasticache;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
import com.pulumi.aws.elasticache.inputs.GlobalReplicationGroupState;
import com.pulumi.aws.elasticache.outputs.GlobalReplicationGroupGlobalNodeGroup;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an ElastiCache Global Replication Group resource, which manages replication between two or more Replication Groups in different regions. For more information, see the [ElastiCache User Guide](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
 * 
 * ## Example Usage
 * ### Global replication group with one secondary replication group
 * 
 * The global replication group depends on the primary group existing. Secondary replication groups depend on the global replication group. the provider dependency management will handle this transparently using resource value references.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup(&#34;primary&#34;, ReplicationGroupArgs.builder()        
 *             .description(&#34;primary replication group&#34;)
 *             .engine(&#34;redis&#34;)
 *             .engineVersion(&#34;5.0.6&#34;)
 *             .nodeType(&#34;cache.m5.large&#34;)
 *             .numCacheClusters(1)
 *             .build());
 * 
 *         var example = new GlobalReplicationGroup(&#34;example&#34;, GlobalReplicationGroupArgs.builder()        
 *             .globalReplicationGroupIdSuffix(&#34;example&#34;)
 *             .primaryReplicationGroupId(primary.id())
 *             .build());
 * 
 *         var secondary = new ReplicationGroup(&#34;secondary&#34;, ReplicationGroupArgs.builder()        
 *             .description(&#34;secondary replication group&#34;)
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 * 
 *     }
 * }
 * ```
 * ### Managing Redis Engine Versions
 * 
 * The initial Redis version is determined by the version set on the primary replication group.
 * However, once it is part of a Global Replication Group,
 * the Global Replication Group manages the version of all member replication groups.
 * 
 * The member replication groups must have `lifecycle.ignore_changes[engine_version]` set,
 * or the provider will always return a diff.
 * 
 * In this example,
 * the primary replication group will be created with Redis 6.0,
 * and then upgraded to Redis 6.2 once added to the Global Replication Group.
 * The secondary replication group will be created with Redis 6.2.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup(&#34;primary&#34;, ReplicationGroupArgs.builder()        
 *             .description(&#34;primary replication group&#34;)
 *             .engine(&#34;redis&#34;)
 *             .engineVersion(&#34;6.0&#34;)
 *             .nodeType(&#34;cache.m5.large&#34;)
 *             .numCacheClusters(1)
 *             .build());
 * 
 *         var example = new GlobalReplicationGroup(&#34;example&#34;, GlobalReplicationGroupArgs.builder()        
 *             .globalReplicationGroupIdSuffix(&#34;example&#34;)
 *             .primaryReplicationGroupId(primary.id())
 *             .engineVersion(&#34;6.2&#34;)
 *             .build());
 * 
 *         var secondary = new ReplicationGroup(&#34;secondary&#34;, ReplicationGroupArgs.builder()        
 *             .description(&#34;secondary replication group&#34;)
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ElastiCache Global Replication Groups using the `global_replication_group_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:elasticache/globalReplicationGroup:GlobalReplicationGroup my_global_replication_group okuqm-global-replication-group-1
 * ```
 * 
 */
@ResourceType(type="aws:elasticache/globalReplicationGroup:GlobalReplicationGroup")
public class GlobalReplicationGroup extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the ElastiCache Global Replication Group.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the ElastiCache Global Replication Group.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * A flag that indicate whether the encryption at rest is enabled.
     * 
     */
    @Export(name="atRestEncryptionEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> atRestEncryptionEnabled;

    /**
     * @return A flag that indicate whether the encryption at rest is enabled.
     * 
     */
    public Output<Boolean> atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }
    /**
     * A flag that indicate whether AuthToken (password) is enabled.
     * 
     */
    @Export(name="authTokenEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> authTokenEnabled;

    /**
     * @return A flag that indicate whether AuthToken (password) is enabled.
     * 
     */
    public Output<Boolean> authTokenEnabled() {
        return this.authTokenEnabled;
    }
    /**
     * Specifies whether read-only replicas will be automatically promoted to read/write primary if the existing primary fails.
     * When creating, by default the Global Replication Group inherits the automatic failover setting of the primary replication group.
     * 
     */
    @Export(name="automaticFailoverEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> automaticFailoverEnabled;

    /**
     * @return Specifies whether read-only replicas will be automatically promoted to read/write primary if the existing primary fails.
     * When creating, by default the Global Replication Group inherits the automatic failover setting of the primary replication group.
     * 
     */
    public Output<Boolean> automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }
    /**
     * The instance class used.
     * See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html)
     * and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
     * When creating, by default the Global Replication Group inherits the node type of the primary replication group.
     * 
     */
    @Export(name="cacheNodeType", refs={String.class}, tree="[0]")
    private Output<String> cacheNodeType;

    /**
     * @return The instance class used.
     * See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html)
     * and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
     * When creating, by default the Global Replication Group inherits the node type of the primary replication group.
     * 
     */
    public Output<String> cacheNodeType() {
        return this.cacheNodeType;
    }
    /**
     * Indicates whether the Global Datastore is cluster enabled.
     * 
     */
    @Export(name="clusterEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> clusterEnabled;

    /**
     * @return Indicates whether the Global Datastore is cluster enabled.
     * 
     */
    public Output<Boolean> clusterEnabled() {
        return this.clusterEnabled;
    }
    /**
     * The name of the cache engine to be used for the clusters in this global replication group.
     * 
     */
    @Export(name="engine", refs={String.class}, tree="[0]")
    private Output<String> engine;

    /**
     * @return The name of the cache engine to be used for the clusters in this global replication group.
     * 
     */
    public Output<String> engine() {
        return this.engine;
    }
    /**
     * Redis version to use for the Global Replication Group.
     * When creating, by default the Global Replication Group inherits the version of the primary replication group.
     * If a version is specified, the Global Replication Group and all member replication groups will be upgraded to this version.
     * Cannot be downgraded without replacing the Global Replication Group and all member replication groups.
     * When the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     * 
     */
    @Export(name="engineVersion", refs={String.class}, tree="[0]")
    private Output<String> engineVersion;

    /**
     * @return Redis version to use for the Global Replication Group.
     * When creating, by default the Global Replication Group inherits the version of the primary replication group.
     * If a version is specified, the Global Replication Group and all member replication groups will be upgraded to this version.
     * Cannot be downgraded without replacing the Global Replication Group and all member replication groups.
     * When the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     * 
     */
    public Output<String> engineVersion() {
        return this.engineVersion;
    }
    /**
     * The full version number of the cache engine running on the members of this global replication group.
     * 
     */
    @Export(name="engineVersionActual", refs={String.class}, tree="[0]")
    private Output<String> engineVersionActual;

    /**
     * @return The full version number of the cache engine running on the members of this global replication group.
     * 
     */
    public Output<String> engineVersionActual() {
        return this.engineVersionActual;
    }
    /**
     * Set of node groups (shards) on the global replication group.
     * Has the values:
     * 
     */
    @Export(name="globalNodeGroups", refs={List.class,GlobalReplicationGroupGlobalNodeGroup.class}, tree="[0,1]")
    private Output<List<GlobalReplicationGroupGlobalNodeGroup>> globalNodeGroups;

    /**
     * @return Set of node groups (shards) on the global replication group.
     * Has the values:
     * 
     */
    public Output<List<GlobalReplicationGroupGlobalNodeGroup>> globalNodeGroups() {
        return this.globalNodeGroups;
    }
    /**
     * A user-created description for the global replication group.
     * 
     */
    @Export(name="globalReplicationGroupDescription", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> globalReplicationGroupDescription;

    /**
     * @return A user-created description for the global replication group.
     * 
     */
    public Output<Optional<String>> globalReplicationGroupDescription() {
        return Codegen.optional(this.globalReplicationGroupDescription);
    }
    /**
     * The full ID of the global replication group.
     * 
     */
    @Export(name="globalReplicationGroupId", refs={String.class}, tree="[0]")
    private Output<String> globalReplicationGroupId;

    /**
     * @return The full ID of the global replication group.
     * 
     */
    public Output<String> globalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }
    /**
     * The suffix name of a Global Datastore. If `global_replication_group_id_suffix` is changed, creates a new resource.
     * 
     */
    @Export(name="globalReplicationGroupIdSuffix", refs={String.class}, tree="[0]")
    private Output<String> globalReplicationGroupIdSuffix;

    /**
     * @return The suffix name of a Global Datastore. If `global_replication_group_id_suffix` is changed, creates a new resource.
     * 
     */
    public Output<String> globalReplicationGroupIdSuffix() {
        return this.globalReplicationGroupIdSuffix;
    }
    /**
     * The number of node groups (shards) on the global replication group.
     * 
     */
    @Export(name="numNodeGroups", refs={Integer.class}, tree="[0]")
    private Output<Integer> numNodeGroups;

    /**
     * @return The number of node groups (shards) on the global replication group.
     * 
     */
    public Output<Integer> numNodeGroups() {
        return this.numNodeGroups;
    }
    /**
     * An ElastiCache Parameter Group to use for the Global Replication Group.
     * Required when upgrading a major engine version, but will be ignored if left configured after the upgrade is complete.
     * Specifying without a major version upgrade will fail.
     * Note that ElastiCache creates a copy of this parameter group for each member replication group.
     * 
     */
    @Export(name="parameterGroupName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> parameterGroupName;

    /**
     * @return An ElastiCache Parameter Group to use for the Global Replication Group.
     * Required when upgrading a major engine version, but will be ignored if left configured after the upgrade is complete.
     * Specifying without a major version upgrade will fail.
     * Note that ElastiCache creates a copy of this parameter group for each member replication group.
     * 
     */
    public Output<Optional<String>> parameterGroupName() {
        return Codegen.optional(this.parameterGroupName);
    }
    /**
     * The ID of the primary cluster that accepts writes and will replicate updates to the secondary cluster. If `primary_replication_group_id` is changed, creates a new resource.
     * 
     */
    @Export(name="primaryReplicationGroupId", refs={String.class}, tree="[0]")
    private Output<String> primaryReplicationGroupId;

    /**
     * @return The ID of the primary cluster that accepts writes and will replicate updates to the secondary cluster. If `primary_replication_group_id` is changed, creates a new resource.
     * 
     */
    public Output<String> primaryReplicationGroupId() {
        return this.primaryReplicationGroupId;
    }
    /**
     * A flag that indicates whether the encryption in transit is enabled.
     * 
     */
    @Export(name="transitEncryptionEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> transitEncryptionEnabled;

    /**
     * @return A flag that indicates whether the encryption in transit is enabled.
     * 
     */
    public Output<Boolean> transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public GlobalReplicationGroup(String name) {
        this(name, GlobalReplicationGroupArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public GlobalReplicationGroup(String name, GlobalReplicationGroupArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public GlobalReplicationGroup(String name, GlobalReplicationGroupArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elasticache/globalReplicationGroup:GlobalReplicationGroup", name, args == null ? GlobalReplicationGroupArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private GlobalReplicationGroup(String name, Output<String> id, @Nullable GlobalReplicationGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:elasticache/globalReplicationGroup:GlobalReplicationGroup", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static GlobalReplicationGroup get(String name, Output<String> id, @Nullable GlobalReplicationGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new GlobalReplicationGroup(name, id, state, options);
    }
}
