// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.eks.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class NodeGroupRemoteAccessArgs extends com.pulumi.resources.ResourceArgs {

    public static final NodeGroupRemoteAccessArgs Empty = new NodeGroupRemoteAccessArgs();

    /**
     * EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
     * 
     */
    @Import(name="ec2SshKey")
    private @Nullable Output<String> ec2SshKey;

    /**
     * @return EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
     * 
     */
    public Optional<Output<String>> ec2SshKey() {
        return Optional.ofNullable(this.ec2SshKey);
    }

    /**
     * Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
     * 
     */
    @Import(name="sourceSecurityGroupIds")
    private @Nullable Output<List<String>> sourceSecurityGroupIds;

    /**
     * @return Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
     * 
     */
    public Optional<Output<List<String>>> sourceSecurityGroupIds() {
        return Optional.ofNullable(this.sourceSecurityGroupIds);
    }

    private NodeGroupRemoteAccessArgs() {}

    private NodeGroupRemoteAccessArgs(NodeGroupRemoteAccessArgs $) {
        this.ec2SshKey = $.ec2SshKey;
        this.sourceSecurityGroupIds = $.sourceSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(NodeGroupRemoteAccessArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private NodeGroupRemoteAccessArgs $;

        public Builder() {
            $ = new NodeGroupRemoteAccessArgs();
        }

        public Builder(NodeGroupRemoteAccessArgs defaults) {
            $ = new NodeGroupRemoteAccessArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param ec2SshKey EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
         * 
         * @return builder
         * 
         */
        public Builder ec2SshKey(@Nullable Output<String> ec2SshKey) {
            $.ec2SshKey = ec2SshKey;
            return this;
        }

        /**
         * @param ec2SshKey EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
         * 
         * @return builder
         * 
         */
        public Builder ec2SshKey(String ec2SshKey) {
            return ec2SshKey(Output.of(ec2SshKey));
        }

        /**
         * @param sourceSecurityGroupIds Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
         * 
         * @return builder
         * 
         */
        public Builder sourceSecurityGroupIds(@Nullable Output<List<String>> sourceSecurityGroupIds) {
            $.sourceSecurityGroupIds = sourceSecurityGroupIds;
            return this;
        }

        /**
         * @param sourceSecurityGroupIds Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
         * 
         * @return builder
         * 
         */
        public Builder sourceSecurityGroupIds(List<String> sourceSecurityGroupIds) {
            return sourceSecurityGroupIds(Output.of(sourceSecurityGroupIds));
        }

        /**
         * @param sourceSecurityGroupIds Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
         * 
         * @return builder
         * 
         */
        public Builder sourceSecurityGroupIds(String... sourceSecurityGroupIds) {
            return sourceSecurityGroupIds(List.of(sourceSecurityGroupIds));
        }

        public NodeGroupRemoteAccessArgs build() {
            return $;
        }
    }

}
