// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.eks.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class IdentityProviderConfigOidcArgs extends com.pulumi.resources.ResourceArgs {

    public static final IdentityProviderConfigOidcArgs Empty = new IdentityProviderConfigOidcArgs();

    /**
     * Client ID for the OpenID Connect identity provider.
     * 
     */
    @Import(name="clientId", required=true)
    private Output<String> clientId;

    /**
     * @return Client ID for the OpenID Connect identity provider.
     * 
     */
    public Output<String> clientId() {
        return this.clientId;
    }

    /**
     * The JWT claim that the provider will use to return groups.
     * 
     */
    @Import(name="groupsClaim")
    private @Nullable Output<String> groupsClaim;

    /**
     * @return The JWT claim that the provider will use to return groups.
     * 
     */
    public Optional<Output<String>> groupsClaim() {
        return Optional.ofNullable(this.groupsClaim);
    }

    /**
     * A prefix that is prepended to group claims e.g., `oidc:`.
     * 
     */
    @Import(name="groupsPrefix")
    private @Nullable Output<String> groupsPrefix;

    /**
     * @return A prefix that is prepended to group claims e.g., `oidc:`.
     * 
     */
    public Optional<Output<String>> groupsPrefix() {
        return Optional.ofNullable(this.groupsPrefix);
    }

    /**
     * The name of the identity provider config.
     * 
     */
    @Import(name="identityProviderConfigName", required=true)
    private Output<String> identityProviderConfigName;

    /**
     * @return The name of the identity provider config.
     * 
     */
    public Output<String> identityProviderConfigName() {
        return this.identityProviderConfigName;
    }

    /**
     * Issuer URL for the OpenID Connect identity provider.
     * 
     */
    @Import(name="issuerUrl", required=true)
    private Output<String> issuerUrl;

    /**
     * @return Issuer URL for the OpenID Connect identity provider.
     * 
     */
    public Output<String> issuerUrl() {
        return this.issuerUrl;
    }

    /**
     * The key value pairs that describe required claims in the identity token.
     * 
     */
    @Import(name="requiredClaims")
    private @Nullable Output<Map<String,String>> requiredClaims;

    /**
     * @return The key value pairs that describe required claims in the identity token.
     * 
     */
    public Optional<Output<Map<String,String>>> requiredClaims() {
        return Optional.ofNullable(this.requiredClaims);
    }

    /**
     * The JWT claim that the provider will use as the username.
     * 
     */
    @Import(name="usernameClaim")
    private @Nullable Output<String> usernameClaim;

    /**
     * @return The JWT claim that the provider will use as the username.
     * 
     */
    public Optional<Output<String>> usernameClaim() {
        return Optional.ofNullable(this.usernameClaim);
    }

    /**
     * A prefix that is prepended to username claims.
     * 
     */
    @Import(name="usernamePrefix")
    private @Nullable Output<String> usernamePrefix;

    /**
     * @return A prefix that is prepended to username claims.
     * 
     */
    public Optional<Output<String>> usernamePrefix() {
        return Optional.ofNullable(this.usernamePrefix);
    }

    private IdentityProviderConfigOidcArgs() {}

    private IdentityProviderConfigOidcArgs(IdentityProviderConfigOidcArgs $) {
        this.clientId = $.clientId;
        this.groupsClaim = $.groupsClaim;
        this.groupsPrefix = $.groupsPrefix;
        this.identityProviderConfigName = $.identityProviderConfigName;
        this.issuerUrl = $.issuerUrl;
        this.requiredClaims = $.requiredClaims;
        this.usernameClaim = $.usernameClaim;
        this.usernamePrefix = $.usernamePrefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IdentityProviderConfigOidcArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IdentityProviderConfigOidcArgs $;

        public Builder() {
            $ = new IdentityProviderConfigOidcArgs();
        }

        public Builder(IdentityProviderConfigOidcArgs defaults) {
            $ = new IdentityProviderConfigOidcArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param clientId Client ID for the OpenID Connect identity provider.
         * 
         * @return builder
         * 
         */
        public Builder clientId(Output<String> clientId) {
            $.clientId = clientId;
            return this;
        }

        /**
         * @param clientId Client ID for the OpenID Connect identity provider.
         * 
         * @return builder
         * 
         */
        public Builder clientId(String clientId) {
            return clientId(Output.of(clientId));
        }

        /**
         * @param groupsClaim The JWT claim that the provider will use to return groups.
         * 
         * @return builder
         * 
         */
        public Builder groupsClaim(@Nullable Output<String> groupsClaim) {
            $.groupsClaim = groupsClaim;
            return this;
        }

        /**
         * @param groupsClaim The JWT claim that the provider will use to return groups.
         * 
         * @return builder
         * 
         */
        public Builder groupsClaim(String groupsClaim) {
            return groupsClaim(Output.of(groupsClaim));
        }

        /**
         * @param groupsPrefix A prefix that is prepended to group claims e.g., `oidc:`.
         * 
         * @return builder
         * 
         */
        public Builder groupsPrefix(@Nullable Output<String> groupsPrefix) {
            $.groupsPrefix = groupsPrefix;
            return this;
        }

        /**
         * @param groupsPrefix A prefix that is prepended to group claims e.g., `oidc:`.
         * 
         * @return builder
         * 
         */
        public Builder groupsPrefix(String groupsPrefix) {
            return groupsPrefix(Output.of(groupsPrefix));
        }

        /**
         * @param identityProviderConfigName The name of the identity provider config.
         * 
         * @return builder
         * 
         */
        public Builder identityProviderConfigName(Output<String> identityProviderConfigName) {
            $.identityProviderConfigName = identityProviderConfigName;
            return this;
        }

        /**
         * @param identityProviderConfigName The name of the identity provider config.
         * 
         * @return builder
         * 
         */
        public Builder identityProviderConfigName(String identityProviderConfigName) {
            return identityProviderConfigName(Output.of(identityProviderConfigName));
        }

        /**
         * @param issuerUrl Issuer URL for the OpenID Connect identity provider.
         * 
         * @return builder
         * 
         */
        public Builder issuerUrl(Output<String> issuerUrl) {
            $.issuerUrl = issuerUrl;
            return this;
        }

        /**
         * @param issuerUrl Issuer URL for the OpenID Connect identity provider.
         * 
         * @return builder
         * 
         */
        public Builder issuerUrl(String issuerUrl) {
            return issuerUrl(Output.of(issuerUrl));
        }

        /**
         * @param requiredClaims The key value pairs that describe required claims in the identity token.
         * 
         * @return builder
         * 
         */
        public Builder requiredClaims(@Nullable Output<Map<String,String>> requiredClaims) {
            $.requiredClaims = requiredClaims;
            return this;
        }

        /**
         * @param requiredClaims The key value pairs that describe required claims in the identity token.
         * 
         * @return builder
         * 
         */
        public Builder requiredClaims(Map<String,String> requiredClaims) {
            return requiredClaims(Output.of(requiredClaims));
        }

        /**
         * @param usernameClaim The JWT claim that the provider will use as the username.
         * 
         * @return builder
         * 
         */
        public Builder usernameClaim(@Nullable Output<String> usernameClaim) {
            $.usernameClaim = usernameClaim;
            return this;
        }

        /**
         * @param usernameClaim The JWT claim that the provider will use as the username.
         * 
         * @return builder
         * 
         */
        public Builder usernameClaim(String usernameClaim) {
            return usernameClaim(Output.of(usernameClaim));
        }

        /**
         * @param usernamePrefix A prefix that is prepended to username claims.
         * 
         * @return builder
         * 
         */
        public Builder usernamePrefix(@Nullable Output<String> usernamePrefix) {
            $.usernamePrefix = usernamePrefix;
            return this;
        }

        /**
         * @param usernamePrefix A prefix that is prepended to username claims.
         * 
         * @return builder
         * 
         */
        public Builder usernamePrefix(String usernamePrefix) {
            return usernamePrefix(Output.of(usernamePrefix));
        }

        public IdentityProviderConfigOidcArgs build() {
            $.clientId = Objects.requireNonNull($.clientId, "expected parameter 'clientId' to be non-null");
            $.identityProviderConfigName = Objects.requireNonNull($.identityProviderConfigName, "expected parameter 'identityProviderConfigName' to be non-null");
            $.issuerUrl = Objects.requireNonNull($.issuerUrl, "expected parameter 'issuerUrl' to be non-null");
            return $;
        }
    }

}
